<?php

use Core\Librerias\Module;
$modules = new Module();
?>

<div class="sidebar sidebar-style-2" data-background-color="blue">
    <div class="sidebar-wrapper scrollbar scrollbar-inner">
        <div class="sidebar-content">
            <ul class="nav nav-primary">
                <?php foreach ($modules->getAllowedModules($_SESSION['user_data']['emp_id']) as $module) : ?>
                    <?php if (!$modules->countHaveSubMenu($_SESSION['user_data']['emp_id'], $module['module_id'])) : ?>
                        <li class="nav-item <?= activo_menu($module['module_id']); ?>">
                            <a href="<?= ruta_base() . $module['module_id']; ?>">
                                <i class="fa fa-<?= $module['icon']; ?>"></i>
                                <p> <?= $module['name_lang_key']; ?></p>
                            </a>
                        </li>
                    <?php else : ?>
                        <li class="nav-item  text-white">
                            <a data-toggle="collapse" href="#<?= $module['module_id']; ?>">
                                <i class="fa fa-<?= $module['icon']; ?>"></i>
                                <p><?= $module['name_lang_key']; ?></p>
                                <span class="caret"></span>
                            </a>
                            <div class="collapse" id="<?= $module['module_id']; ?>">
                                <ul class="nav nav-collapse">
                                    <?php foreach ($modules->getAllowedSubModules($_SESSION['user_data']['emp_id'], $module['module_id']) as $s_module) : ?>
                                        <li>
                                            <a href="<?= ruta_base() . $module['module_id'] . '/' . $s_module['module_id']; ?>">
                                                <span class="sub-item"><?= $s_module['name_lang_key']; ?></span>
                                            </a>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        </li>
                    <?php endif; ?>
                <?php endforeach; ?>
            </ul>
        </div>
    </div>
</div>
