<div id="appModalPrecioGenerico">
    <div class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" id="modal-precio-global">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header" style="border: 0px ;">
                    <h5 class="modal-title">Obtener Precio</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <input id="producto_cos_generico" type="text" class="form-control" placeholder="Buscar productos" @keyup="obtenerPrecioProducto">
                    <section class="card" :class="cargando">
                        <div class="list-group list-group-messages list-group-flush">
                            <div class="list-group-item unread" v-for="row in productos" @click="seleccionarProducto(row)">
                                <div class="list-group-item-figure">
                                    <a href="#" class="user-avatar">
                                        <div class="avatar">
                                            <img v-if="row.imagen" :src="row.imagen" alt="Producto" class="avatar-img rounded-circle">
                                            <span v-else class="avatar-title rounded-circle border border-white bg-info">{{ row.nombre.charAt() }}</span>
                                        </div>
                                    </a>
                                </div>
                                <div class="list-group-item-body pl-3 pl-md-4">
                                    <div class="row">
                                        <div class="col-12 col-lg-10">
                                            <h5 class="list-group-item-title">
                                                {{ row.descripcion }}
                                            </h5>
                                            <p class="list-group-item-text text-truncate"> Fabricante: {{ row.fabricante }}</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>

                    <div id="view_datos_producto" v-if="Object.keys(precios).length > 0">
                        <div class="row">
                            <div class="col text-center">
                                <span class="text-muted">{{ producto }}</span>
                            </div>
                        </div>
                        <table class="table table-sm table-striped">
                            <thead>
                                <tr>
                                    <th>Divisa</th>
                                    <th class="text-right">Precio</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr v-for="row in precios">
                                    <td>{{ row.divisa.nombre }}</td>
                                    <td class="text-right">{{ row.precio }}</td>
                                </tr>
                            </tbody>
                        </table>

                        <table class="table table-sm table-striped">
                            <thead>
                                <tr>
                                    <th>Almacen</th>
                                    <th class="text-right">Cantidad</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr v-for="row in almacenes">
                                    <td>{{ row.nombre }}</td>
                                    <td class="text-right">{{ row.cantidad }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="appModalIDGenerico">
    <div class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" id="modal_id_producto">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header" style="border: 0px ;">
                    <h5 class="modal-title">Buscar Producto</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <input id="producto_cos_generico" type="text" class="form-control" placeholder="Buscar productos" @keyup="obtenerPrecioProducto">
                    <section class="card" :class="cargando">
                        <div class="list-group list-group-messages list-group-flush">
                            <div class="list-group-item unread" v-for="row in productos" @click="seleccionarProducto(row)">
                                <div class="list-group-item-figure">
                                    <a href="#" class="user-avatar">
                                        <div class="avatar">
                                            <img v-if="row.imagen" :src="row.imagen" alt="Producto" class="avatar-img rounded-circle">
                                            <span v-else class="avatar-title rounded-circle border border-white bg-info">{{ row.nombre.charAt() }}</span>
                                        </div>
                                    </a>
                                </div>
                                <div class="list-group-item-body pl-3 pl-md-4">
                                    <div class="row">
                                        <div class="col-12 col-lg-10">
                                            <h5 class="list-group-item-title">
                                                {{ row.descripcion }}
                                            </h5>
                                            <p class="list-group-item-text text-truncate"> Fabricante: {{ row.fabricante }}</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    new Vue({
        el: '#appModalPrecioGenerico',
        data: {
            buscar: '',
            producto: '',
            productos: [],
            precios: [],
            almacenes: [],
            cargando: ''
        },
        mounted() {
            var self = this;
            $('#modal-precio-global').on('shown.bs.modal', function() {
                $('#producto_cos_generico').trigger('focus')
            });
            $('#modal-precio-global').on('hidden.bs.modal', function(e) {
                self.almacenes = [];
                self.productos = [];
                self.precios = [];
            })
        },
        methods: {
            seleccionarProducto(producto) {
                document.getElementById('producto_cos_generico').value = '';
                this.productos = [];
                this.producto = producto.descripcion;
                axios.get('generico/obtenerProductoDetallado/' + Number(producto.id)).then(response => {
                    console.log(response.data);
                    this.almacenes = response.data.almacenes;
                    this.precios = response.data.precios
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = '';
                });
            },
            obtenerPrecioProducto(event) {
                this.cargando = 'is-loading is-loading-lg';
                if (event.target.value) {
                    axios.get('generico/obtenerPrecioProducto', {
                        params: {
                            buscar: event.target.value
                        }
                    }).then(response => {
                        this.productos = response.data;
                    }).catch(e => notificacion()).finally(() => {
                        this.cargando = '';
                    });
                }
            }
        }
    });
    new Vue({
        el: '#appModalIDGenerico',
        data: {
            buscar: '',
            producto: '',
            productos: [],
            precios: [],
            almacenes: [],
            cargando: ''
        },
        mounted() {
            var self = this;
            $('#modal-precio-global').on('shown.bs.modal', function() {
                $('#producto_cos_generico').trigger('focus')
            });
            $('#modal-precio-global').on('hidden.bs.modal', function(e) {
                self.almacenes = [];
                self.productos = [];
                self.precios = [];
            })
        },
        methods: {
            seleccionarProducto(producto) {
                document.getElementById('producto_cos_generico').value = '';
                this.productos = [];
                this.producto = producto.descripcion;
                location.href = baseURL +'productos/editar/'+ Number(producto.id);
            },
            obtenerPrecioProducto(event) {
                this.cargando = 'is-loading is-loading-lg';
                if (event.target.value) {
                    axios.get('generico/obtenerPrecioProducto', {
                        params: {
                            buscar: event.target.value
                        }
                    }).then(response => {
                        this.productos = response.data;
                    }).catch(e => notificacion()).finally(() => {
                        this.cargando = '';
                    });
                }
            }
        }
    });
</script>


</div>
</div>
</div>
</div>


</body>

</html>

<script src="https://maps.googleapis.com/maps/api/js?key=<?= constant('KEY_MAP_GOOGLE') ?>&callback=initMap&v=weekly" defer></script>
<script>
    function initialize() {
        // Creating map object
        if ($('#txtLat').length && $('#txtLng').length) {

            let lat=document.getElementById('txtLat').value;
            let lng=document.getElementById('txtLng').value;

            var map = new google.maps.Map(document.getElementById('map_canvas'), {
                zoom: 12,
                center: new google.maps.LatLng(lat, lng),
                mapTypeId: google.maps.MapTypeId.ROADMAP
            });

            // creates a draggable marker to the given coords
            var vMarker = new google.maps.Marker({
                position: new google.maps.LatLng(lat, lng),
                draggable: true
            });

            google.maps.event.addListener(vMarker, 'dragend', function(evt) {
                $("#txtLat").val(evt.latLng.lat().toFixed(6));
                $("#txtLng").val(evt.latLng.lng().toFixed(6));

                map.panTo(evt.latLng);
            });

            // centers the map on markers coords
            map.setCenter(vMarker.position);

            // adds the marker on the map
            vMarker.setMap(map);
        } else {

        }
        
         if ($('#lat').length && $('#long').length) {

            let lat = document.getElementById('lat').value;
            let lng = document.getElementById('long').value;

            var map = new google.maps.Map(document.getElementById('map_c'), {
                zoom: 12,
                center: new google.maps.LatLng(lat, lng),
                mapTypeId: google.maps.MapTypeId.ROADMAP
            });

            // creates a draggable marker to the given coords
            var vMarker = new google.maps.Marker({
                position: new google.maps.LatLng(lat, lng),
                draggable: true
            });

            google.maps.event.addListener(vMarker, 'dragend', function(evt) {
                $("#lat").val(evt.latLng.lat().toFixed(6));
                $("#long").val(evt.latLng.lng().toFixed(6));

                map.panTo(evt.latLng);
            });

            // centers the map on markers coords
            map.setCenter(vMarker.position);

            // adds the marker on the map
            vMarker.setMap(map);
        } else {

        }

    }

    window.onload = initialize;
</script>