new Vue({
    el: '#AppWoocommerce',
    data: {
        pedidos: [],
        productos: [],
        clientes: [],
        loader_pedidos: false,
        loader_productos: false,
        loader_clientes: false,
        loader_convertir_pedido: false,
        dataForm: { 'id': '', 'fecha': new Date().toISOString().substr(0, 10), 'almacen': '', 'divisa': '', 'serie': '' },
        errorForm: [],
        pedido_actual: [],
        divisa: '',
        mostrar:false
    },
    created() {
        this.obtenerProductos();
        this.obtenerPedidos();
        this.obtenerClientes();
    },
    methods: {
        obtenerPedidos() {
            this.loader_pedidos = true;
            axios.get('woocommerce/obtenerPedidos', {
                params: {
                    estatus: 'on-hold'
                }
            }).then(response => {
                $("#tabla_pedidos").DataTable().destroy();
                if (response.data.errors == null) {
                    this.divisa = response.data.divisa;
                    this.pedidos = response.data.pedidos;
                   
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia pedidos', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => {
                notificacion('fa fa-ban', '', 'Error al cargar pedidos', 'danger');
            }).finally(() => {
                this.loader_pedidos = false;
                $("#tabla_pedidos").DataTable({
                    pageLength: 50,
                    "aoColumnDefs": [
                        { 'bSortable': false, 'aTargets': [6, 7] },
                        { 'searchable': false, 'targets': [6, 7] }
                    ]
                });
            });
        },
        obtenerProductos() {
            this.loader_productos = true;
            axios.get('woocommerce/obtenerProductos').then(response => {
                $("#tabla_productos").DataTable().destroy();
                if (response.data.errors == null) {
                    this.divisa = response.data.divisa;
                    this.productos = response.data.productos;
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia productos', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => {
                notificacion('fa fa-ban', '', 'Error al cargar productos', 'danger');
            }).finally(() => {
                this.loader_productos = false;
                $("#tabla_productos").DataTable({
                    pageLength: 50,
                    "aoColumnDefs": [
                        { 'bSortable': false, 'aTargets': [5, 6] },
                        { 'searchable': false, 'targets': [5, 6] }
                    ]
                });
            });
        },
        obtenerClientes() {
            this.loader_clientes = true;
            axios.get('woocommerce/obtenerClientes').then(response => {
                $("#tabla_clientes").DataTable().destroy();
                if (response.data.errors == null) {
                    this.clientes = response.data.clientes;
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia clientes', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => {
                notificacion('fa fa-ban', '', 'Error al cargar clientes', 'danger');
            }).finally(() => {
                this.loader_clientes = false;
                $("#tabla_clientes").DataTable({
                    pageLength: 50
                });
            });
        },
        resetearFormulario() {
            document.getElementById('modal_form_convertir').reset();
            this.dataForm.id = '';
            this.dataForm.fecha = new Date().toISOString().substr(0, 10);
            this.dataForm.almacen = '';
            this.dataForm.divisa = '';
            this.dataForm.serie = '';
            this.errorForm = [];
        },
        modalGuardar(id) {
            this.resetearFormulario();
            this.dataForm.id = id;
            $('#modal_convertir').modal('show');
        },
        guardarConvertir(id) {
            this.loader_convertir_pedido = true;
            axios({
                method: 'post',
                url: 'woocommerce/convertirADocumentoPedido',
                data: this.dataForm,
                transformRequest: serializar(),
            }).then(response => {
                if (response.data.errors == null) {
                    location.href = response.data;
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => {
                notificacion('fa fa-ban', '', 'Error al procesar pedido', 'danger');
            }).finally(() => {
                this.loader_convertir_pedido = false;
            });
        },
        verPedido(id) {
            this.pedido_actual = this.pedidos[id];
             for (let ie = 0; ie< this.pedido_actual.meta_data.length; ie++) {
               if(this.pedido_actual.meta_data[ie].key=='BinancePay_status'){
                   this.mostrar=true;
               }else{
                    this.mostrar=false;
               }
             }
            $('#modal_detalles_pedido').modal('show');
        },
        publicarProducto(id, event) {

            status = event.target.className;
            event.target.disabled = true;
            event.target.className = 'loader loader-success';

            axios('woocommerce/publicarProducto', {
                params: {
                    id: id
                }
            }).then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        if (status == 'btn btn-icon btn-round fas fa-eye') {
                            notificacion('fas fa-eye-slash', 'Privado', 'Articulo privado', 'warning');
                            event.target.className = 'btn btn-icon btn-round fas fa-eye-slash';
                        } else {
                            notificacion('fa fa-check', 'Publico', 'Articulo publicado', 'success');
                            event.target.className = 'btn btn-icon btn-round fas fa-eye';
                        }
                    }
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => {
                notificacion('fa fa-ban', '', 'Error al sincronizar', 'danger');
            }).finally(() => {
                event.target.disabled = false;
            });
        },
        sincronizarPedido(id, event) {
            event.target.disabled = true;
            event.target.className = 'loader loader-success';
            axios('woocommerce/sincronizarPedido', {
                params: {
                    id: id
                }
            }).then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        notificacion('fa fa-check', '', 'Sincronizacion exitosa', 'success');
                    }
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => {
                notificacion('fa fa-ban', '', 'Error al sincronizar', 'danger');
            }).finally(() => {
                event.target.disabled = false;
                event.target.className = 'btn btn-icon btn-round fas fa-sync-alt';
            });
        },
        moneda(num, div_locale_, div_simbolo_, decimal_ = 2) {
            let monto_ = convertir_a_float(String(num).toString());
            return monedaMoneda(monto_, div_locale_, div_simbolo_, decimal_);
        },
        decimal(num, div_locale_, decimal_ = 2) {
            let monto_ = convertir_a_float(String(num).toString());
            return monedaDecimal(monto_, div_locale_, decimal_);
        },
    }
});