moment.locale('es', {
    months: 'Enero_Febrero_Marzo_Abril_Mayo_Junio_Julio_Agosto_Septiembre_Octubre_Noviembre_Diciembre'.split('_'),
    monthsShort: 'Enero._Feb._Mar_Abr._May_Jun_Jul._Ago_Sept._Oct._Nov._Dec.'.split('_'),
    weekdays: 'Domingo_Lunes_Martes_Miercoles_Jueves_Viernes_Sabado'.split('_'),
    weekdaysShort: 'Dom._Lun._Mar._Mier._Jue._Vier._Sab.'.split('_'),
    weekdaysMin: 'Do_Lu_Ma_Mi_Ju_Vi_Sa'.split('_'),
});

var fecha = new Date();

Vue.component('v-select', VueSelect.VueSelect)

new Vue({
    el: '#appVentasCaja',
    data: {
        anio: fecha.getFullYear(),
        facturasPagas: [],
        facturasNoPagas: [],
        facturasAnuladas: [],
        notasdeentregaPagas: [],
        t_notasdeentregaNoPagas: 0,
        notasdeentregaNoPagas: [],
        notasdeentregaAnuladas: [],
        ordenesPagas: [],
        ordenesPendientes: [],
        ordenesAnuladas: [],
        clientes: [],
        clienteEncontrado: true,
        dataForm: {
            'ruta': '',
            'cli_tipodoc': '',
            'cli_dni': '',
            'cli_razon_social': '',
            'cli_fecha_nac': '',
            'cli_email': '',
            'cli_telefono': '',
            'cli_telefono_2': '',
            'cli_direccion': '',
            'cli_contribuyente': '',
            'cli_estatus': '',
            'cli_fecha_reg': '',
            'cli_genero': '',
            'cli_paisid': '',
            'cli_estado': '',
            'cli_ciudad': '',
            'cli_codpostal': '',
            'cli_descuento': '',
            'cli_razonsocial': '',
            'cli_natural': true,
            'cli_grupid': '',
            'cli_observaciones': ''
        },
        errorForm: [],
        cargando: false,
        cargando_tabla: '',
        icon_buscador: 'fa fa-search',
        selected_cli: [],
        titulo: '',
        cierres_del_dia: {
            positivo: [],
            negativo: [],
        },
        total_divisas_p: [],
        total_divisas_n: []
    },
    created() {
        this.obtenerNotasdeEntrega();
    },
    methods: {
        obtenerFacturas() {
            this.cargando_tabla = 'is-loading is-loading-lg';
            if ($.fn.DataTable.isDataTable('#table_facturas_pagadas')) {
                $('#table_facturas_pagadas, #table_facturas_pendientes, #table_facturas_anuladas').DataTable().destroy();
            }
            axios.get('ventascaja/obtenerFacturas', {
                params: {
                    anio: this.anio
                }
            }).then(response => {
                this.facturasPagas = response.data.pagas;
                this.facturasNoPagas = response.data.pendientes;
                this.facturasAnuladas = response.data.anuladas;
                this.t_notasdeentregaNoPagas = response.data.n_pendientes;
                this.t_pedidosNoPagas = response.data.p_pendientes;
                this.t_presupuestosNoPagas = response.data.pr_pendientes;
            }).catch(e => notificacion()).finally(() => {
                this.cargando_tabla = '';
                $('#table_facturas_pagadas').DataTable({
                    "order": [[0, "desc"]],
                    "footerCallback": function (row, data, start, end, display) {
                        var api = this.api(),
                            data;

                        pageTotal = api
                            .column(2, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                    }
                });
                $('#table_facturas_pendientes').DataTable({
                    "order": [[0, "desc"]],
                    "footerCallback": function (row, data, start, end, display) {
                        var api = this.api(),
                            data;

                        pageTotal = api
                            .column(4, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(4).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                        pageTotal = api
                            .column(3, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(3).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                        pageTotal = api
                            .column(2, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                    }
                });
                $('#table_facturas_anuladas').DataTable({
                    "order": [[0, "desc"]],
                    "footerCallback": function (row, data, start, end, display) {
                        var api = this.api(),
                            data;

                        pageTotal = api
                            .column(4, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(4).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                        pageTotal = api
                            .column(3, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(3).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                        pageTotal = api
                            .column(2, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                    }
                });
            });
        },
        obtenerNotasdeEntrega() {
            this.cargando_tabla = 'is-loading is-loading-lg';
            if ($.fn.DataTable.isDataTable('#table_notasdeentrega_pagadas')) {
                $('#table_notasdeentrega_pagadas, #table_notasdeentrega_pendientes, #table_notasdeentrega_anuladas').DataTable().destroy();
            }
            axios.get('ventascaja/obtenerNotasdeEntregaAnuales', {
                params: {
                    anio: this.anio
                }
            }).then(response => {
                this.notasdeentregaPagas = response.data.pagas;
                this.notasdeentregaNoPagas = response.data.pendientes;
                this.notasdeentregaAnuladas = response.data.anuladas;
                this.t_notasdeentregaNoPagas = this.notasdeentregaNoPagas.length;
            }).catch(e => notificacion()).finally(() => {
                this.cargando_tabla = '';
                $('#table_notasdeentrega_pagadas').DataTable({
                    "order": [[0, "desc"]],
                    "footerCallback": function (row, data, start, end, display) {
                        var api = this.api(),
                            data;

                        pageTotal = api
                            .column(2, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                    }
                });
                $('#table_notasdeentrega_pendientes').DataTable({
                    "order": [[0, "desc"]],
                    "footerCallback": function (row, data, start, end, display) {
                        var api = this.api(),
                            data;

                        pageTotal = api
                            .column(4, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(4).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                        pageTotal = api
                            .column(3, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(3).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                        pageTotal = api
                            .column(2, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                    }
                });
                $('#table_notasdeentrega_anuladas').DataTable({
                    "order": [[0, "desc"]],
                    "footerCallback": function (row, data, start, end, display) {
                        var api = this.api(),
                            data;

                        pageTotal = api
                            .column(4, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(4).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                        pageTotal = api
                            .column(3, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(3).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                        pageTotal = api
                            .column(2, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                    }
                });
            });
        },
        obtenerOrdenesdeEntrega() {
            this.cargando_tabla = 'is-loading is-loading-lg';
            if ($.fn.DataTable.isDataTable('#table_ordenes_pagadas')) {
                $('#table_ordenes_pagadas, #table_ordenes_pendientes, #table_ordenes_anuladas').DataTable().destroy();
            }
            axios.get('ventascaja/obtenerOrdenesdeEntregaAnuales', {
                params: {
                    anio: this.anio
                }
            }).then(response => {
                this.ordenesPagas = response.data.pagas;
                this.ordenesPendientes = response.data.pendientes;
                this.ordenesAnuladas = response.data.anuladas;
            }).catch(e => notificacion()).finally(() => {
                this.cargando_tabla = '';
                $('#table_ordenes_pagadas').DataTable({
                    "order": [[0, "desc"]],
                    "footerCallback": function (row, data, start, end, display) {
                        var api = this.api(),
                            data;

                        pageTotal = api
                            .column(2, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                    }
                });
                $('#table_ordenes_pendientes').DataTable({
                    "order": [[0, "desc"]],
                    "footerCallback": function (row, data, start, end, display) {
                        var api = this.api(),
                            data;

                        pageTotal = api
                            .column(4, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(4).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                        pageTotal = api
                            .column(3, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(3).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                        pageTotal = api
                            .column(2, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                    }
                });
                $('#table_ordenes_anuladas').DataTable({
                    "order": [[0, "desc"]],
                    "footerCallback": function (row, data, start, end, display) {
                        var api = this.api(),
                            data;

                        pageTotal = api
                            .column(4, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(4).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                        pageTotal = api
                            .column(3, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(3).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                        pageTotal = api
                            .column(2, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                    }
                });
            });
        },
        modal_buscar_cliente(ruta) {
            this.clientes = [];
            this.selected_cli = '';
            this.dataForm.ruta = ruta;
            this.errorForm = [];
            $('#modal_buscar_cliente').modal('show');
            $('#modal_buscar_cliente').on('shown.bs.modal', function () {
                $('#tututut > div > div > input').trigger('focus')
            });
        },
        guardarCliente() {

            this.errorForm = [];

            if (!this.dataForm.cli_tipodoc)
                this.errorForm.push('El campo Tipo de Documento es obligatorio.');
            if (!this.dataForm.cli_telefono)
                this.errorForm.push('El campo Teléfono es obligatorio.');
            if (!this.dataForm.cli_direccion)
                this.errorForm.push('El campo Dirección es obligatorio.');
            if (!this.dataForm.cli_dni)
                this.errorForm.push('El campo Número de Documento es obligatorio.');
            if (!this.dataForm.cli_razon_social)
                this.errorForm.push('El campo Razón Social es obligatorio.');
            if (this.dataForm.cli_email) {
                if (!validaEmail(this.dataForm.cli_email))
                    this.errorForm.push('El Correo Electrónico debe tener un formato válido.');
            }

            if (this.errorForm.length == 0) {
                this.cargando = true;
                axios({
                    method: 'post',
                    url: 'ventascaja/guardarCliente',
                    data: this.dataForm,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        location.href = response.data;
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                });
            }
        },
        onSearch(search, loading) {
            if (search) {
                loading(true);
                this.search(loading, search, this);
            }
        },
        search: _.debounce((loading, search, vm) => {
            axios.get('notadecredito/buscarCliente', {
                params: {
                    'buscar': search
                }
            }).then(response => {
                if (response.data.length > 0) {
                    vm.clientes = response.data;
                    vm.clienteEncontrado = true;
                } else {
                    vm.clientes = [];
                    if (!isNaN(search)) {
                        vm.dataForm.cli_dni = search;
                    } else {
                        vm.dataForm.cli_dni = '';
                    }
                    vm.clienteEncontrado = false;
                }
            }).catch(e => notificacion()).finally(() => {
                loading(false);
            });
        }, 350),
        redireccionarANuevaFactura() {
            location.href = baseURL + this.dataForm.ruta + '/nuevaFactura/' + this.selected_cli.id;
        },
        obtenerCierreDelDia() {
            axios.get('ventascaja/obtenerCierreDelDia').then(response => {
                this.cierres_del_dia.positivo = response.data.cierre_positivo;
                this.cierres_del_dia.negativo = response.data.cierre_negativo;
                this.total_divisas_p = response.data.total_divisas_p;
                this.total_divisas_n = response.data.total_divisas_n;
            }).catch(e => notificacion()).finally(() => {
                this.cargando_tabla = '';
            });
        },
        moneda(num, div_locale, div_simbolo, decimal = 2) {
            return monedaMoneda(num, div_locale, div_simbolo, decimal);
        },
        decimal(num, div_locale, decimal = 2) {
            return monedaDecimal(num, div_locale, decimal);
        },
        fechaNormal(value) {
            return moment(value).format('DD/MM/YYYY, h:mm A');
        }
    }
});