new Vue({
    el: '#appTarifas',
    data: {
        titulo: '',
        accion: '',
        tarifas: [],
        dataForm: { 'id': '', 'codigo': '', 'aplicar': '', 'maxpvp': false, 'mincoste': false, 'nombre': '', 'valorx': 0, 'valory': 0 },
        errorForm: {},
        cargando: false,
    },
    created() {
        this.obtenerTarifas();
    },
    methods: {
        obtenerTarifas() {
            axios.get('tarifas/obtenerTarifas').then(response => {
                this.tarifas = response.data;
            }).catch(e => notificacion());
        },
        resetearFormulario() {
            document.getElementById('modal_form_tarifas').reset();
            this.dataForm.id = '';
            this.dataForm.codigo = '';
            this.dataForm.aplicar = '';
            this.dataForm.maxpvp = false;
            this.dataForm.mincoste = false;
            this.dataForm.nombre = '';
            this.dataForm.valorx = 0;
            this.dataForm.valory = 0;
        },
        modalTarifas() {
            this.resetearFormulario();
            this.titulo = 'Guardar tarifa';
            this.accion = 'Guardar';
            $('#modal_tarifas').modal('show');
            $('#modal_tarifas').on('shown.bs.modal', function () {
                $('#codigo').trigger('focus');
            });
        },
        ver(id, codigo, aplicar, maxpvp, mincoste, nombre, valorx, valory) {
            this.dataForm.id = id;
            this.dataForm.codigo = codigo;
            this.dataForm.aplicar = aplicar;
            this.dataForm.maxpvp = (maxpvp == 0) ? false : true;
            this.dataForm.mincoste = (mincoste == 0) ? false : true;
            this.dataForm.nombre = nombre;
            this.dataForm.valorx = valorx;
            this.dataForm.valory = valory;
            this.titulo = 'Editar tarifa';
            this.accion = 'Actualizar';
            $('#modal_tarifas').modal('show');
        },
        guardarEditar() {

            this.errorForm = [];

            if (!this.dataForm.codigo)
                this.errorForm.push('El campo Código es obligatorio.');
            if (!this.dataForm.aplicar)
                this.errorForm.push('El campo Fórmula es obligatorio.');
            if (!this.dataForm.nombre)
                this.errorForm.push('El campo Nombre es obligatorio.');

            if (this.errorForm.length == 0) {
                this.cargando = true;
                axios({
                    method: 'post',
                    url: 'tarifas/guardar',
                    data: this.dataForm,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            this.obtenerTarifas();
                            this.resetearFormulario();
                            $('#modal_tarifas').modal('hide');
                            notificacion('fa fa-check', '', 'Operación exitosa', 'success');
                        } else {
                            notificacion('fa fa-ban', 'Error', 'Error al Registrar', 'danger');
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => this.cargando = false);
            }
        },
        visible(id, etiqueta,visibl) {
            axios.get('tarifas/visible/' + Number(id)).then(response => {
                if (response.data == true) {
                    let eti = document.getElementById(etiqueta);
                    eti.className = (eti.className === 'fa fa-eye-slash') ? 'fa fa-eye' : 'fa fa-eye-slash';
                   visibl=(eti.className === 'fa fa-eye-slash')?0:1;
                    if(visibl==1){
                        notificacion('fa fa-check', '', 'Visible para el listado de productos', 'success');
                   }else{
                        notificacion('fa fa-times', '', 'No visible para el listado de productos', 'warning');
                   }
                   console.log(visibl)
                }
            }).catch(e => notificacion());
        },
        eliminar(id, nombre) {
            Swal.fire({
                title: 'Eliminar Tarifa',
                text: "¿Estás seguro de eliminar la tarifa " + nombre + "?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('tarifas/eliminar/' + Number(id)).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                this.obtenerTarifas();
                                notificacion('fa fa-trash', 'Tarifa eliminada', nombre.toUpperCase(), 'danger');
                            } else {
                                notificacion('fa fa-ban', 'Error al eliminar tarifa', nombre.toUpperCase(), 'warning');
                            }
                        } else {
                            let total_errores = response.data.errors.length;
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion());
                }
            });
        },
    },
});