new Vue({
    el: '#appSucursales',
    data: {
        titulo: '',
        accion: '',
        sucursales: [],
        zonas: [],
        dataForm: { 'idsu': '', 'nsu': '', 'dsu': '', 'tsu': '', 'csu': '', 'zsu': 1, 'dnisu': '', 'swsu': '' },
        errorForm: [],
        cargando: false,
    },
    created() {
        this.obtenerSucursales();
        this.obtenerZonas();
    },
    methods: {
        obtenerSucursales() {
            axios.get('sucursales/obtenerSucursales').then(response => {
                if (Array.isArray(response.data)) {
                    this.sucursales = response.data;
                }
            }).catch(e => notificacion());
        },
        obtenerZonas() {
            axios.get('zonas/obtenerZonas').then(response => {
                this.zonas = response.data;
            }).catch(e => notificacion());
        },
        resetearFormulario() {
            document.getElementById('modal_form_sucursal').reset();
            this.dataForm.idsu = '';
            this.dataForm.nsu = '';
            this.dataForm.dsu = '';
            this.dataForm.tsu = '';
            this.dataForm.csu = '';
            this.dataForm.zsu = 1;
            this.dataForm.dnisu = '';
            this.dataForm.swsu = '';
            this.errorForm = [];
        },
        modalSucursal() {
            this.resetearFormulario();
            this.titulo = 'Agregar Sucursal';
            this.accion = 'Guardar';
            $('#modalSucursal').modal('show');
            $('#modalSucursal').on('shown.bs.modal', function () {
                $('#dnisu').trigger('focus');
            });
        },
        ver(id, nombre, direccion, telefono, email, timezone, dni, sitio_web) {
            this.dataForm.idsu = id;
            this.dataForm.nsu = nombre;
            this.dataForm.dsu = direccion;
            this.dataForm.tsu = telefono;
            this.dataForm.csu = email;
            this.dataForm.zsu = timezone;
            this.dataForm.dnisu = dni;
            this.dataForm.swsu = sitio_web;
            this.titulo = 'Editar Sucursal';
            this.accion = 'Actualizar';
            $('#modalSucursal').modal('show');
        },
        guardarEditar() {

            if (!this.dataForm.nsu)
                this.errorForm.push('El campo Nombre es requerido.');
            if (!this.dataForm.dsu)
                this.errorForm.push('El campo Dirección es requerido.');
            if (!this.dataForm.tsu)
                this.errorForm.push('El campo Teléfono es requerido.');
            if (!this.dataForm.csu)
                this.errorForm.push('El campo Correo es requerido.');
            if (!this.dataForm.zsu)
                this.errorForm.push('El campo Zona Horaria es requerido.');
            if (!this.dataForm.dnisu)
                this.errorForm.push('El campo DNI es requerido.');

            if (this.errorForm.length == 0) {

                this.cargando = true;

                axios({
                    method: 'post',
                    url: 'sucursales/guardar',
                    data: this.dataForm,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            if (this.dataForm.idsu !== '') {
                                $('#modalSucursal').modal('hide');
                                notificacion('fa fa-edit', 'Actualizado', 'Sucursal actualizada correctamente', 'info');
                            } else {
                                notificacion('fa fa-check', 'Registrado', 'Sucursal registrada correctamente', 'success');
                            }
                            this.resetearFormulario();
                            this.obtenerSucursales();
                        } else {
                            notificacion('fa fa-ban', 'Error', 'Error en operación', 'danger');
                        }
                    } else {
                        this.errorForm = response.data.errors;
                    }
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                });
            }
        },
        eliminar(id, nombre) {
            Swal.fire({
                title: 'Eliminar sucursal',
                text: "¿Estás seguro de eliminar la sucursal " + nombre + " ?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('sucursales/eliminarSucursal', {
                        params: {
                            id: id
                        }
                    }).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                this.obtenerSucursales();
                                notificacion('fa fa-trash', 'Sucursal eliminada', nombre.toUpperCase(), 'danger');
                            } else {
                                notificacion('fa fa-ban', 'Error al eliminar sucursal', nombre.toUpperCase(), 'danger');
                            }
                        } else {
                            let total_errores = response.data.errors.length;
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion());
                }
            });
        },
    },
});