var appSeries = new Vue({
    el: '#appSeries',
    data: {
        titulo: '',
        accion: '',
        series: {},
        dataForm: { 'id': '', 'mascara': '0000000000', 'codigo': '', 'nombre': '', 'sucursal': '' },
        errorForm: [],
    },
    created() {
        this.obtenerSeries();
    },
    methods: {
        obtenerSeries() {
            axios.get('series/obtenerSeries').then(response => {
                this.series = response.data;
            }).catch(e => notificacion());
        },
        resetearFormulario() {
            document.getElementById('modal_form_serie').reset();
            this.dataForm.id = '';
            this.dataForm.mascara = '';
            this.dataForm.codigo = '';
            this.dataForm.nombre = '';
            this.dataForm.sucursal = '';
            this.errorForm = [];
        },
        modalGuardar() {
            this.resetearFormulario();
            this.titulo = 'Agregar Serie';
            this.accion = 'Guardar';
            $('#modal_serie').modal('show');
            $('#modal_serie').on('shown.bs.modal', function () {
                $('#sercodigo').trigger('focus');
            });
        },
        ver(id, nombre, codigo, mascara, sucursal) {
            this.errorForm = [];
            this.dataForm.id = id;
            this.dataForm.mascara = mascara;
            this.dataForm.codigo = codigo;
            this.dataForm.nombre = nombre;
            this.dataForm.sucursal = sucursal;
            this.titulo = 'Editar Serie';
            this.accion = 'Actualizar';
            $('#modal_serie').modal('show');
        },
        editarGuardar: function () {

            this.errorForm = [];

            if (this.dataForm.mascara) {
                if (String(this.dataForm.mascara).length > 15) {
                    this.errorForm.push('El campo Máscara no puede ser mayor a 15 dígitos de 0');
                } else {
                    if (Number(this.dataForm.mascara) > 0 || Number(this.dataForm.mascara) < 0) {
                        this.errorForm.push('La máscara no puede contener cifras mayor o menor que 0');
                    }
                }
            }
            if (!this.dataForm.codigo)
                this.errorForm.push('El campo Código es obligatorio.');
            if (!this.dataForm.nombre)
                this.errorForm.push('El campo Nombre es obligatorio.');
            if (!this.dataForm.sucursal)
                this.errorForm.push('El campo Sucursal es obligatorio.');

            if (this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'series/guardar',
                    data: this.dataForm,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            if (this.dataForm.id !== '') {
                                $('#modal_serie').modal('hide');
                                notificacion('fa fa-edit', 'Actualizado', 'Serie actualizada correctamente', 'info');
                            } else {
                                notificacion('fa fa-check', 'Registrado', 'Serie registrada correctamente', 'success');
                            }
                            this.obtenerSeries();
                            this.resetearFormulario();
                        }
                    } else {
                        let total_errores = response.data.errors.length;
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        eliminar(id, nombre) {
            Swal.fire({
                title: 'Eliminar Serie',
                text: "¿Estás seguro de querer eliminar la serie " + nombre + " ?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                confirmButtonText: 'Eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.value) {
                    axios.get('series/eliminar/' + id).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                this.obtenerSeries();
                                notificacion('fa fa-times', 'Serie eliminada', nombre.toUpperCase(), 'danger');
                            } else {
                                notificacion('fa fa-ban', 'Error al eliminar', nombre.toUpperCase(), 'danger');
                            }
                        } else {
                            let total_errores = response.data.errors.length;
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion());
                }
            });
        }
    }
});