moment.locale("es", {
  months: "Enero_Febrero_Marzo_Abril_Mayo_Junio_Julio_Agosto_Septiembre_Octubre_Noviembre_Diciembre".split("_"),
  monthsShort: "Enero._Feb._Mar_Abr._May_Jun_Jul._Ago_Sept._Oct._Nov._Dec.".split("_"),
  weekdays: "Domingo_Lunes_Martes_Miercoles_Jueves_Viernes_Sabado".split("_"),
  weekdaysShort: "Dom._Lun._Mar._Mier._Jue._Vier._Sab.".split("_"),
  weekdaysMin: "Do_Lu_Ma_Mi_Ju_Vi_Sa".split("_"),
  calendar: {
    sameDay: function () {
      return "[hoy a la" + (this.hours() !== 1 ? "s" : "") + "] LT";
    },
    nextDay: function () {
      return "[mañana a la" + (this.hours() !== 1 ? "s" : "") + "] LT";
    },
    nextWeek: function () {
      return "dddd [a la" + (this.hours() !== 1 ? "s" : "") + "] LT";
    },
    lastDay: function () {
      return "[ayer a la" + (this.hours() !== 1 ? "s" : "") + "] LT";
    },
    lastWeek: function () {
      return "[el] dddd [pasado a la" + (this.hours() !== 1 ? "s" : "") + "] LT";
    },
    sameElse: "L",
  },
  relativeTime: {
    future: "en %s",
    past: "hace %s",
    s: "unos segundos",
    ss: "%d segundos",
    m: "un minuto",
    mm: "%d minutos",
    h: "una hora",
    hh: "%d horas",
    d: "un día",
    dd: "%d días",
    M: "un mes",
    MM: "%d meses",
    y: "un año",
    yy: "%d años",
  },
});

var btn_pla = document.getElementById("btn_pla");
var edit_btn_pla = document.getElementById("edit_btn_pla");

new Vue({
  el: "#AppTableros",
  data: {
    id_tab: "",
    tableros: [],
    plantillas: [],
    incidencias: [],
    clientes: [],
    administradores: [],
    colores: ["#1abc9c", "#2ecc71", "#3498db", "#9b59b6", "#34495e", "#16a085", "#e67e22", "#e74c3c"],
    selectedColor: "",
    item_plantilla: [],
    itemEnEdicion: null,
    loader: "",
    btn_loader: "",
    categoria_edit: "",
    dataFormTablero: {
      id: "",
      nombre: "",
      color: "",
    },
    vencimientos: [],
    favorito: [],
    historico: [],
  },
  mounted() {
    var btn_st = document.getElementById("btn_st");
  },
  created() {
    this.obtenerFavorito();
    this.obtenerTableros();
    this.obtenerPlantillas();
    this.obtenerVencimientos();
  },
  methods: {
    async obtenerHistorico() {
      this.loader = "is-loading is-loading-lg";
      $("#tabla_historico").DataTable().destroy();
      await axios
        .get("servicios/obtenerHistorico")
        .then((response) => {
          this.historico = response.data;
        })
        .catch((e) => notificacion())
        .finally(() => {
          this.loader = "";
        });
      $("#tabla_historico").DataTable({
        order: [],
      });
    },
    async obtenerTableros() {
      this.loader = "is-loading is-loading-lg";
      await axios
        .get("servicios/obtenerTableros")
        .then((response) => {
          this.tableros = response.data;
        })
        .catch((e) => notificacion())
        .finally(() => {
          this.loader = "";
        });
    },
    async obtenerFavorito() {
      this.loader = "is-loading is-loading-lg";
      await axios
        .get("servicios/obtenerFavorito")
        .then((response) => {
          this.favorito = response.data;
        })
        .catch((e) => notificacion())
        .finally(() => {
          this.loader = "";
        });
    },
    modalTablero() {
      $("#modalTablero").modal("show");
      $("#modalTablero").on("shown.bs.modal", function (event) {
        $("#nombre").trigger("focus");
      });
    },
    guardarTablero() {
      if (this.dataFormTablero.nombre) {
        this.dataFormTablero.color = this.selectedColor;
        btn_st.disabled = false;
        btn_st.classList.add("is-loading");
        axios({
          method: "post",
          url: "servicios/guardarTablero",
          data: this.dataFormTablero,
        })
          .then((response) => {
            if (response.data.errors == null) {
              if (response.data !== false) {
                $("#modalTablero").modal("hide");
                location.href = response.data;
              } else {
                notificacion("fa fa-ban", "Error", "Error al Registrar", "danger");
              }
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => {
            notificacion();
          })
          .finally(() => {
            btn_st.disabled = true;
            btn_st.classList.remove("is-loading");
          });
      } else {
        btn_st.disabled = true;
      }
    },
    modalAdministrador(id) {
      axios
        .get("servicios/obtenerAdministrador/" + escape(id))
        .then((response) => {
          this.administradores = response.data;
        })
        .catch((e) => notificacion())
        .finally(() => {
          this.id_tab = id;
          this.clientes = [];
          document.getElementById("buscar_emp").value = "";
          $("#modalBuscarEmpleado").modal("show");
          $("#modalBuscarEmpleado").on("shown.bs.modal", function (event) {
            $("#buscar_emp").trigger("focus");
          });
        });
    },
    async obtenerVencimientos() {
      this.loader = "is-loading is-loading-lg";
      $("#tabla_vencimiento").DataTable().destroy();
      await axios
        .get("servicios/obtenerVencimientos")
        .then((response) => {
          this.vencimientos = response.data;
        })
        .catch((e) => notificacion())
        .finally(() => {
          this.loader = "";
          $("#tabla_vencimiento").DataTable({
            order: [],
          });
        });
    },
    guardarAdministrador(id) {
      axios
        .get("servicios/guardarAdministrador", {
          params: {
            id_tab: this.id_tab,
            id_emp: id,
          },
        })
        .then((response) => {
          if (response.data.errors == null) {
            if (response.data == true) {
              this.obtnerAdministradores();
              this.obtenerTableros();
            }
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion())
        .finally(() => {
          this.clientes = [];
          document.getElementById("buscar_emp").value = "";
        });
    },
    eliminarAdministrador(id) {
      axios
        .get("servicios/eliminarAdministrador/" + escape(id))
        .then((response) => {
          if (response.data.errors == null) {
            if (response.data == true) {
              this.obtnerAdministradores();
              this.obtenerTableros();
            }
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion())
        .finally(() => {});
    },
    obtnerAdministradores() {
      axios
        .get("servicios/obtenerAdministrador/" + escape(this.id_tab))
        .then((response) => {
          this.administradores = response.data;
        })
        .catch((e) => notificacion());
    },
    buscarEmpleados(event) {
      if (event.target.value) {
        if (event.target.value.length > 2) {
          key = event.keyCode;
          tecla = String.fromCharCode(key).toLowerCase();
          letras = "áéíóúabcdefghijklmnñopqrstuvwxyz";

          especiales = [8, 37, 39, 46];
          tecla_especial = false;

          if (key == especiales[0]) {
            tecla_especial = true;
          }

          if (letras.indexOf(tecla) !== -1 || tecla_especial) {
            this.buscar(event.target.value, this);
          }
        }
      } else {
        this.clientes = [];
      }
    },
    buscar: _.debounce((value, vm) => {
      axios
        .get("servicios/buscarEmpleados/" + value)
        .then((response) => {
          if (response.data.length > 0) {
            vm.clientes = response.data;
          }
        })
        .catch((e) => {
          notificacion();
        })
        .finally(() => {});
    }, 350),
    async obtenerPlantillas() {
      await axios
        .get("servicios/obtenerPlantillas")
        .then((response) => {
          this.plantillas = response.data;
        })
        .catch((e) => {
          notificacion();
        })
        .finally(() => {});
    },
    editModalPlantilla(cat) {
      this.categoria_edit = cat.id;
      document.getElementById("edit_item_plantilla").value='';
      document.getElementById("edit_categoria_plantilla").value = cat.categoria;
      this.item_plantilla = [];
      axios
        .get("servicios/obtenerPlantilla/" + cat.id)
        .then((response) => {
          if (response.data.length > 0) {
            this.item_plantilla = response.data;
          }
        })
        .catch((e) => {
          notificacion();
        })
        .finally(() => {
          $("#editModalPlantilla").modal("show");
        });
    },
    modalPlantilla() {
      this.item_plantilla = [];
      $("#modalPlantilla").modal("show");
      $("#modalPlantilla").on("shown.bs.modal", function (event) {
        $("#categoria_plantilla").trigger("focus");
      });
    },
    agregarItemPlantilla(event) {
      if (event.target.value) {
        if (this.itemEnEdicion == null) {
          this.item_plantilla.push({
            descripcion: event.target.value,
          });
        } else {
          this.item_plantilla[this.itemEnEdicion].descripcion = event.target.value;
        }
      }
      event.target.value = "";
      this.itemEnEdicion = null;
    },
    eliminarItemPlantilla(posicion) {
      this.item_plantilla.splice(posicion, 1);
    },
    editarItemPlant(posicion){
      document.getElementById("edit_item_plantilla").value = this.item_plantilla[posicion].descripcion;
      this.item_plantilla.splice(posicion, 1);
    },
    editarItemPlantilla(posicion) {
      this.itemEnEdicion = posicion;
      document.getElementById("item_plantilla").value = this.item_plantilla[posicion].descripcion;
      document.getElementById("item_plantilla").focus();
    },
    guardarPlantilla() {
      btn_pla.disabled = true;
      btn_pla.classList.add("is-loading");
      axios({
        method: "post",
        url: "servicios/guardarPlantilla",
        data: {
          categoria: document.getElementById("categoria_plantilla").value,
          items: this.item_plantilla,
        },
      })
        .then((response) => {
          if (response.data.errors == null) {
            if (response.data == true) {
              $("#modalPlantilla").modal("hide");
              this.item_plantilla = [];
              this.itemEnEdicion = null;
              this.obtenerPlantillas();
            }
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => {
          notificacion();
        })
        .finally(() => {
          btn_pla.disabled = false;
          btn_pla.classList.remove("is-loading");
        });
    },
    editarPlantilla() {
      edit_btn_pla.disabled = true;
      edit_btn_pla.classList.add("is-loading");
      axios({
        method: "post",
        url: "servicios/editarPlantilla",
        data: {
          id_cat: this.categoria_edit,
          categoria: document.getElementById("edit_categoria_plantilla").value,
          items: this.item_plantilla,
        },
      })
        .then((response) => {
          if (response.data !== false) {
            $("#editModalPlantilla").modal("hide");
            this.item_plantilla = [];
            this.itemEnEdicion = null;
            this.obtenerPlantillas();
          } else {
            notificacion("fa fa-ban", "Error", "Error al registrar plantilla", "danger");
          }
        })
        .catch((e) => {
          notificacion();
        })
        .finally(() => {
          edit_btn_pla.disabled = false;
          edit_btn_pla.classList.remove("is-loading");
        });
    },
    eliminarPlantilla(plantilla) {
      Swal.fire({
        title: "<strong>¿Eliminar Plantilla?</strong>",
        text: "¿Estás seguro que quieres eliminar la plantilla " + plantilla.categoria + " ?",
        showCloseButton: true,
        showCancelButton: true,
        cancelButtonColor: "#aaa",
        confirmButtonColor: "#3085d6",
        confirmButtonText: "Aceptar",
        cancelButtonText: "Cancelar",
      }).then((result) => {
        if (result.value) {
          axios
            .get("servicios/eliminarPlantilla/" + Number(plantilla.id))
            .then((response) => {
              if (response.data.errors == null) {
                if (response.data == true) {
                  notificacion("fa fa-trash", "Eliminado", "Plantilla eliminada", "danger");
                }
              } else {
                let total_errores = response.data.errors.length;
                for (let i = 0; i < total_errores; i++) {
                  notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
                }
              }
            })
            .catch((e) => notificacion());
        }
      });
    },
    eliminarTablero(tablero) {
      Swal.fire({
        title: "<strong>¿Eliminar Tablero?</strong>",
        text: "¿Estás seguro que quieres eliminar el tablero " + tablero.nombre + " ?",
        showCloseButton: true,
        showCancelButton: true,
        cancelButtonColor: "#aaa",
        confirmButtonColor: "#3085d6",
        confirmButtonText: "Aceptar",
        cancelButtonText: "Cancelar",
      }).then((result) => {
        if (result.value) {
          axios
            .get("servicios/eliminarTablero/" + tablero.id)
            .then((response) => {
              if (response.data.errors == null) {
                if (response.data == true) {
                  this.obtenerTableros();
                }
              } else {
                let total_errores = response.data.errors.length;
                for (let i = 0; i < total_errores; i++) {
                  notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
                }
              }
            })
            .catch((e) => notificacion());
        }
      });
    },
    upperCase: (value) => {
      return value.toUpperCase();
    },
    lowerCase: (value) => {
      return value.toLowerCase();
    },
    fechaCalendario: (value) => {
      return moment(value).calendar();
    },
    fechaNormal: (value) => {
      return moment(value).format("L");
    },
    relativeTime(value) {
      return moment(value).endOf("day").fromNow();
    },
  },
  mounted() {
    let board = document.getElementById("items");
    new Sortable(board, {
      group: "listas-crear",
      animation: 150,
      onUpdate: (evento) => {
        this.item_plantilla.splice(evento.newIndex, 0, this.item_plantilla.splice(evento.oldIndex, 1)[0]);
      },
    });
    let boards = document.getElementById("edit_items");
    new Sortable(boards, {
      group: "listas-editar",
      animation: 150,
      onUpdate: (evento) => {
        this.item_plantilla.splice(evento.newIndex, 0, this.item_plantilla.splice(evento.oldIndex, 1)[0]);
      },
    });
    $(function () {
      $("#tabla_incidencias").DataTable({
        order: [],
      });
    });
  },
  updated() {
    if (this.dataFormTablero.nombre == "") {
      btn_st.disabled = true;
    } else {
      btn_st.disabled = false;
    }
  },
});
