new Vue({
    el: '#AppProveedores',
    data: {
        proveedores: [],
        errorForm: [],
        cargando_tabla: ''
    },
    created() {
        this.obtenerProveedores();
    },
    methods: {
        obtenerProveedores() {
            this.cargando_tabla = 'is-loading is-loading-lg';
            $('#tabla_proveedores').DataTable().destroy();
            axios.get('proveedores/proveedores').then(response => {
                if (Array.isArray(response.data) && response.data.length > 0) {
                    this.proveedores = response.data;
                }
            }).catch(e => notificacion()).finally(() => {
                this.cargando_tabla = '';
                $('#tabla_proveedores').DataTable({
                    order: []
                });
            });
        },
        modificarEstatus(proveedor) {
            axios.get('proveedores/modificarEstatus/' + proveedor.id).then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        proveedor.estatus = !proveedor.estatus;
                        notificacion('fa fa-check', 'Actualizado', 'Estatus modificado correctamente', 'success');
                    }
                } else {
                    let total_errores = response.data.errors.length;
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        eliminar(proveedor) {
            Swal.fire({
                title: 'Eliminar Proveedor',
                text: "¿Estás seguro de querer eliminar el proveedor " + proveedor.nombre + " ?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('proveedores/eliminar/' + proveedor.id).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                this.obtenerProveedores();
                                notificacion('fa fa-trash', 'Proveedor eliminado', nombre.toUpperCase(), 'danger');
                            }
                        } else {
                            let total_errores = response.data.errors.length;
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion());
                }
            });
        },
        cliente(proveedor) {
            Swal.fire({
                title: 'Convertir Proveedor a Cliente',
                text: "¿Estás seguro de querer convertir al proveedor " + proveedor.nombre + " en Cliente?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                confirmButtonText: 'Aceptar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.value) {
                    axios.get('proveedores/cliente/' + proveedor.id).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                notificacion('fa fa-info', '', 'Proveedor convertido', 'info');
                            }
                        } else {
                            let total_errores = response.data.errors.length
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion());
                }
            });
        }
    }
});