new Vue({
    el: '#AppCrearProveedor',
    data: {
        dataForm: { 'id': '', 'codigo': '', 'nombre': '', 'razonsocial': '', 'tipoidfiscal': '', 'cifnif': '', 'personafisica': false, 'acreedor': false, 'idcontacto': '', 'telefono1': '', 'telefono2': '', 'email': '', 'web': '', 'serie': '', 'mpid': '', 'impid': '', 'subcuenta': '', 'regimeniva': '2', 'retencion': '', 'observaciones': '', 'pais': '', 'estado': '', 'ciudad': '', 'codigo_postal': '', 'direccion': '' },
        errorForm: [],
        cargando: false,
    },
    methods: {
        guardar() {

            this.errorForm = [];

            if (!this.dataForm.codigo)
                this.errorForm.push('El campo Código es obligatorio');
            if (!this.dataForm.nombre)
                this.errorForm.push('El campo Nombre es obligatorio');
            if (!this.dataForm.razonsocial)
                this.errorForm.push('El campo Razón Social es obligatorio');
            if (!this.dataForm.tipoidfiscal)
                this.errorForm.push('El campo Tipo Id Fiscal es obligatorio');
            if (!this.dataForm.cifnif)
                this.errorForm.push('El campo Número de Documento es obligatorio.');
            if (!this.dataForm.telefono1)
                this.errorForm.push('El campo Teléfono es obligatorio.');
            if (!this.dataForm.pais)
                this.errorForm.push('El campo País es obligatorio.');
            if (!this.dataForm.email) {
                this.errorForm.push('El Correo Electrónico es obligatorio.');
            } else if (!validaEmail(this.dataForm.email)) {
                this.errorForm.push('El Correo Electrónico debe tener un formato válido.');
            }

            if (this.errorForm.length == 0) {
                this.cargando = true;
                axios({
                    method: 'post',
                    url: 'proveedores/guardar',
                    data: this.dataForm,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            this.dataForm = { 'id': '', 'codigo': '', 'nombre': '', 'razonsocial': '', 'tipoidfiscal': '', 'cifnif': '', 'personafisica': false, 'acreedor': false, 'idcontacto': '', 'telefono1': '', 'telefono2': '', 'email': '', 'web': '', 'serie': '', 'mpid': '', 'impid': '', 'subcuenta': '', 'regimeniva': '2', 'retencion': '', 'observaciones': '', 'pais': '', 'estado': '', 'ciudad': '', 'codigo_postal': '', 'direccion': '' };
                            notificacion('fa fa-check', 'Registro', 'Registro exitoso', 'success');
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => this.cargando = false);
            }
        }
    }
});