var currentFocus;

new Vue({
    el: '#appPresupuestoVer',
    data: {
        id_factura: document.getElementById('id_fac').value,
        cliente: document.getElementById('id_cliente_fac').value,
        factura: [],
        formDocumentos: { 'id_factura': '', 'descripcion': '', 'documento': '' },
        documentos: [],
        articulosTotal: 0,
        descuento: 0,
        subtotal: 0,
        total: 0,
        neto: 0,
        iva: 0,
        divisa_predeterminada: '',
        almacen_predeterminado: '',
        serie_predeterminada: '',
        sucursal_predeterminada:'',
        productos: [],
        carrito: [],
        sucursales_empleado:[],
        series_empleado:[],
        cargando: false,
        errorForm: [],
        chequear_stock: false,
        observaciones: [],
        loader_correo: false,
        cargando_documento: false,
        toggleBarcode: true,
        money: {
            locale: '',
            decimal: '.',
            thousands: ',',
            prefix: '',
            suffix: '',
            precision: 2,
            masked: false /* doesn't work with directive */
        }
    },
    created() {
        axios.get('presupuestoeditar/obtenerFactura/' + this.id_factura).then(response => {
            this.money.locale = response.data.divisa.locale;
            this.money.prefix = response.data.divisa.symbol + ' ';
            this.money.decimal = response.data.divisa.decimal;
            this.money.thousands = response.data.divisa.thousands;
            this.money.precision = response.data.divisa.precision;
            this.factura = response.data.factura;

            this.obtenerSucursalesEmpleado();

            this.almacen_predeterminado = this.factura.id_almacen;
            this.sucursal_predeterminada = this.factura.sucursal;
            this.serie_predeterminada = this.factura.id_serie;
            this.divisa_predeterminada = this.factura.id_divisa;
            this.observaciones = this.factura.observaciones;
            this.articulosTotal = response.data.articulos_cantidad;
            this.subtotal = response.data.subtotal;
            this.descuento = response.data.descuento;
            this.neto = response.data.neto;
            this.iva = response.data.iva;
            this.total = response.data.total;
            this.carrito = response.data.data_carrito;
            this.obtenerDocumentos();
        });
    },
    methods: {
        obtenerSucursalesEmpleado(){
            axios
            .get("presupuesto/obtenerSucursalesEmpleado")
            .then((response) => {
              this.sucursales_empleado = response.data.sucursales;
              this.obtenerSeriesEmpleado();
            })
            .catch((e) => notificacion());
          },
          obtenerSeriesEmpleado(){
            axios
            .get("presupuesto/obtenerSeriesAlmacenesEmpleado/"+ this.sucursal_predeterminada)
            .then((response) => {
                this.series_empleado = response.data.series;
            })
            .catch((e) => notificacion());
          },
        predeterminarDivisa(event) {
            console.log('entre');
            axios.get('presupuestoeditar/predeterminarDivisa', {
                params: {
                    id_divisa: event.target.value,
                    id_factura: this.id_factura,
                    descuento: this.descuento
                }
            }).then(response => {
                if (response.data.errors == null) {
                    if (response.data.data_carrito !== null) {
                        this.money.locale = response.data.divisa.locale;
                        this.money.prefix = response.data.divisa.symbol + ' ';
                        this.money.decimal = response.data.divisa.decimal;
                        this.money.thousands = response.data.divisa.thousands;
                        this.money.precision = response.data.divisa.precision;
                        this.articulosTotal = response.data.data_carrito.articulos_cantidad;
                        this.subtotal = response.data.data_carrito.subtotal;
                        this.descuento = response.data.data_carrito.descuento;
                        this.neto = response.data.data_carrito.neto;
                        this.iva = response.data.data_carrito.iva;
                        this.total = response.data.data_carrito.total;
                        this.restante = response.data.data_carrito.total;
                        this.carrito = response.data.data_carrito.carrito;
                    }
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        focusBuuscar() {
            document.getElementById('buscador').focus();
        },
        buscarProducto(event) {
            if (this.almacen_predeterminado && this.divisa_predeterminada) {
                this.searchProductos(event.target.value, event, this);
            }
        },
        searchProductos: _.debounce((search, event, vm) => {
            if (vm.toggleBarcode == false) {

                currentFocus = 0;
                let a, b;
                var x = document.getElementsByClassName("autocomplete-items");

                for (var i = 0; i < x.length; i++) {
                    x[i].parentNode.removeChild(x[i]);
                }

                if (!search) {
                    return false;
                }

                axios.get('presupuestoeditar/buscarProducto', {
                    params: {
                        'divisa': vm.divisa_predeterminada,
                        'almacen': vm.almacen_predeterminado,
                        'buscar': search.trim(),
                        'id_factura': vm.id_factura,
                        'chequear_stock': vm.chequear_stock
                    }
                }).then(response => {
                    vm.productos = response.data;
                }).catch(e => {
                    notificacion();
                }).finally(() => {

                    currentFocus = -1;

                    a = document.createElement("div");
                    a.id = event.target.id + 'autocomplete-list';
                    a.classList.add('autocomplete-items');
                    event.target.parentNode.appendChild(a);

                    let self = vm;

                    vm.productos.forEach((item) => {

                        b = document.createElement("div");

                        if (item.imagen) {
                            b.innerHTML += "<img src='" + item.imagen + "' class='avatar-img rounded-circle' style='width: 50px; height: 50px; margin-right: 15px'>";
                        }

                        if (item.pro_descripcion.substr(0, search.length).toUpperCase() == search.toUpperCase()) {
                            b.innerHTML += "<strong>" + item.pro_descripcion.substr(0, search.length) + "</strong>";
                            b.innerHTML += "<span>" + item.pro_descripcion.substr(search.length) + "</span>";
                        } else {
                            b.innerHTML += "<strong>" + item.pro_descripcion + "</strong>";
                        }

                        b.innerHTML += "<small class='text-primary' style='margin-right: 5px'> stock: " + item.ps_cantidad + "</small> <br>";
                        b.innerHTML += "<small class='text-primary' style='margin-right: 10px'> fabricante: " + item.fabricante + "</small>";
                        b.innerHTML += "<input type='hidden' value='" + item.pro_id + "' data-almacen='" + item.id_almacen + "' data-name='" + item.pro_descripcion + "'>";

                        b.addEventListener("click", function (e) {

                            event.target.value = this.getElementsByTagName("input")[0].getAttribute('data-name');
                            let id_producto = this.getElementsByTagName("input")[0].value;
                            let id_almacen = this.getElementsByTagName("input")[0].getAttribute('data-almacen');

                            self.agregarProducto(id_producto, id_almacen);

                            for (var i = 0; i < x.length; i++) {
                                x[i].parentNode.removeChild(x[i]);
                            }
                        });

                        a.appendChild(b);

                    });
                });
            }
        }, 500),
        seleccionarProducto(event) {

            var x = document.getElementById(event.target.id + 'autocomplete-list');

            if (x) x = x.getElementsByTagName("div");

            if (event.key == 'ArrowDown') {
                currentFocus++;
                active(x);
            } else if (event.key == 'ArrowUp') {
                currentFocus--;
                active(x);
            } else if (event.key == 'Enter') {

                event.preventDefault();

                if (this.toggleBarcode == true) {
                    this.agregarProductoBarcode(event.target.value);
                    document.getElementById('buscador').value = '';
                } else {
                    if (currentFocus > -1) {
                        if (x) x[currentFocus].click();
                    }
                }
            }
        },
        agregarProducto(id_producto, id_almacen) {
            if (this.divisa_predeterminada && id_producto && id_almacen && this.cliente) {
                axios({
                    method: 'post',
                    url: 'presupuestoeditar/agregarProducto',
                    data: {
                        'id_factura': this.id_factura,
                        'id_producto': id_producto,
                        'id_almacen': id_almacen,
                        'id_divisa': this.divisa_predeterminada,
                        'descuento_global': this.descuento,
                        'chequear_stock': this.chequear_stock
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        this.articulosTotal = response.data.articulos_cantidad;
                        this.subtotal = response.data.subtotal;
                        this.descuento = response.data.descuento;
                        this.neto = response.data.neto;
                        this.iva = response.data.iva;
                        this.total = response.data.total;
                        this.carrito = response.data.carrito;
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => {
                    document.getElementById('buscador').value = '';
                });
            }
        },
        agregarProductoBarcode(producto) {
            if (this.divisa_predeterminada && this.cliente) {
                axios({
                    method: 'post',
                    url: 'presupuestoeditar/agregarProductoBarcode',
                    data: {
                        'id_factura': this.id_factura,
                        'producto': producto,
                        'id_almacen': this.almacen_predeterminado,
                        'id_divisa': this.divisa_predeterminada,
                        'descuento_global': this.descuento,
                        'chequear_stock': this.chequear_stock
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        this.articulosTotal = response.data.articulos_cantidad;
                        this.subtotal = response.data.subtotal;
                        this.descuento = response.data.descuento;
                        this.neto = response.data.neto;
                        this.iva = response.data.iva;
                        this.total = response.data.total;
                        this.carrito = response.data.carrito;
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        actualizarPrecio(unique, event) {
            let precio = convertir_a_float(event.target.value);
            if (event.target.value && precio > 0 && unique && this.cliente) {
                axios({
                    method: 'post',
                    url: 'presupuestoeditar/actualizarPrecio',
                    data: {
                        'id_cliente': this.cliente,
                        'unique': unique,
                        'precio': event.target.value,
                        'descuento_global': this.descuento,
                        'id_factura': this.id_factura
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        this.articulosTotal = response.data.articulos_cantidad;
                        this.subtotal = response.data.subtotal;
                        this.descuento = response.data.descuento;
                        this.neto = response.data.neto;
                        this.iva = response.data.iva;
                        this.total = response.data.total;
                        this.restante = response.data.total;
                        Object.keys(response.data.carrito).forEach((key, i) => {
                            this.carrito[key].neto = response.data.carrito[key].neto;
                            this.carrito[key].total = response.data.carrito[key].total;
                        });
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        actualizarCantidad(id_producto, event) {
            let cantidad = convertir_a_float(event.target.value);
            if (event.target.value && cantidad > 0 && this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'presupuestoeditar/actualizarCantidad',
                    data: {
                        'id_producto': id_producto,
                        'cantidad': event.target.value,
                        'descuento_global': this.descuento,
                        'id_factura': this.id_factura,
                        'chequear_stock': this.chequear_stock
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        this.articulosTotal = response.data.articulos_cantidad;
                        this.subtotal = response.data.subtotal;
                        this.descuento = response.data.descuento;
                        this.neto = response.data.neto;
                        this.iva = response.data.iva;
                        this.total = response.data.total;
                        Object.keys(response.data.carrito).forEach((key, i) => {
                            this.carrito[key].neto = response.data.carrito[key].neto;
                            this.carrito[key].total = response.data.carrito[key].total;
                        });
                    } else {
                        if (response.data.cantidad > 0) {
                            event.target.value = response.data.cantidad;
                        }
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        aplicarNuevoIva(unique, id_iva) {
            if (unique && id_iva && this.id_factura) {
                axios({
                    method: 'post',
                    url: 'presupuestoeditar/aplicarNuevoIva',
                    data: {
                        'unique': unique,
                        'id_iva': id_iva,
                        'descuento_global': this.descuento,
                        'id_factura': this.id_factura
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        this.articulosTotal = response.data.articulos_cantidad;
                        this.subtotal = response.data.subtotal;
                        this.descuento = response.data.descuento;
                        this.neto = response.data.neto;
                        this.iva = response.data.iva;
                        this.total = response.data.total;
                        this.restante = response.data.total;
                        this.carrito = response.data.carrito;
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            } else {
                let total_errores = this.errorForm.length
                for (let i = 0; i < total_errores; i++) {
                    notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                }
            }
        },
        aplicarDescuentoProducto(unique, event) {
            let descuento_ = convertir_a_float(event.target.value);
            if (unique && this.id_factura) {
                axios({
                    method: 'post',
                    url: 'presupuestoeditar/aplicarDescuentoProducto',
                    data: {
                        'unique': unique,
                        'descuento': descuento_,
                        'descuento_global': this.descuento,
                        'id_factura': this.id_factura
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        this.articulosTotal = response.data.articulos_cantidad;
                        this.subtotal = response.data.subtotal;
                        this.descuento = response.data.descuento;
                        this.neto = response.data.neto;
                        this.iva = response.data.iva;
                        this.total = response.data.total;
                        this.restante = response.data.total;
                        Object.keys(response.data.carrito).forEach((key, i) => {
                            this.carrito[key].neto = response.data.carrito[key].neto;
                            this.carrito[key].total = response.data.carrito[key].total;
                        });
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        aplicarDescuentoAdicional() {
            if (!isNaN(this.descuento) && this.descuento >= 0) {
                axios({
                    method: 'post',
                    url: 'presupuestoeditar/aplicarDescuentoAdicional',
                    data: {
                        'descuento': this.descuento,
                        'id_factura': this.id_factura
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        this.articulosTotal = response.data.articulos_cantidad;
                        this.subtotal = response.data.subtotal;
                        this.neto = response.data.neto;
                        this.iva = response.data.iva;
                        this.total = response.data.total;
                        this.restante = response.data.total;
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        eliminarProducto(unique) {
            if (this.id_factura && unique) {
                axios({
                    method: 'post',
                    url: 'presupuestoeditar/eliminarProducto',
                    data: {
                        'unique': unique,
                        'descuento_global': this.descuento,
                        'id_factura': this.id_factura
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        this.articulosTotal = response.data.articulos_cantidad;
                        this.subtotal = response.data.subtotal;
                        this.descuento = response.data.descuento;
                        this.neto = response.data.neto;
                        this.iva = response.data.iva;
                        this.total = response.data.total;
                        this.restante = response.data.total;
                        this.carrito = response.data.carrito;
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        actualizarDetalles() {

            this.errorForm = [];

            let dataFormClienteDetalle = {
                'id': this.cliente,
                'cli_tipodoc': document.getElementById('cli_tipodoc').value,
                'cli_dni': document.getElementById('cli_dni').value,
                'cli_razon_social': document.getElementById('cli_razon_social').value,
                'cli_fecha_nac': '',
                'cli_email': '',
                'cli_telefono': '',
                'cli_telefono_2': '',
                'cli_direccion': document.getElementById('cli_direccion').value,
                'cli_contribuyente': '',
                'cli_estatus': '',
                'cli_fecha_reg': '',
                'cli_genero': '',
                'cli_paisid': document.getElementById('cli_pais').value,
                'cli_estado': document.getElementById('cli_estado').value,
                'cli_ciudad': document.getElementById('cli_ciudad').value,
                'cli_codigopostal': document.getElementById('cli_codigopostal').value,
                'cli_descuento': '',
                'cli_razonsocial': '',
                'cli_natural': '',
                'cli_grupid': '',
                'cli_observaciones': ''
            };

            if (!dataFormClienteDetalle.cli_tipodoc)
                this.errorForm.push('El campo Tipo de Documento es obligatorio');
            if (!dataFormClienteDetalle.cli_dni)
                this.errorForm.push('El campo Número de Documento es obligatorio.');
            if (!dataFormClienteDetalle.cli_direccion)
                this.errorForm.push('El campo Dirección es obligatorio');
            if (!dataFormClienteDetalle.cli_razon_social)
                this.errorForm.push('El campo Razón Social es obligatorio.');

            if (this.errorForm.length == 0) {
                this.cargando = true;
                axios({
                    method: 'post',
                    url: 'presupuestoeditar/guardarDetallesCliente',
                    data: dataFormClienteDetalle,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            document.getElementById('cabecera_cliente').innerHTML = dataFormClienteDetalle.cli_razon_social + ' ' + dataFormClienteDetalle.cli_dni;
                            notificacion('fa fa-edit', '', 'Actualización exitosa', 'info');
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => this.cargando = false);
            } else {
                let total_errores = this.errorForm.length
                for (let i = 0; i < total_errores; i++) {
                    notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                }
            }
        },
        actualizarDescripcion(unique, event) {

            this.errorForm = [];

            if (!event.target.value)
                this.errorForm.push('La descripción no debe quedar vacia.');

            if (this.id_factura && this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'presupuestoeditar/actualizarDescripcion',
                    data: {
                        'unique': unique,
                        'descripcion': event.target.value,
                        id_factura: this.id_factura
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors) {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            } else {
                let total_errores = this.errorForm.length
                for (let i = 0; i < total_errores; i++) {
                    notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                }
            }
        },
        guardarFactura() {

            this.errorForm = [];

            if (this.carrito.length == 0)
                this.errorForm.push('No ha seleccionado algún producto para la compra');
            if (!this.serie_predeterminada)
                this.errorForm.push('Debe seleccionar una serie');
            if (!document.getElementById('fecha').value)
                this.errorForm.push('Debe seleccionar una fecha');

            if (this.id_factura && this.cliente && this.errorForm.length == 0) {
                this.cargando = true;
                axios({
                    method: 'post',
                    url: 'presupuestoeditar/ventaEnEsperaEditar',
                    data: {
                        'id_serie': this.serie_predeterminada,
                        'id_factura': this.id_factura,
                        'fecha': document.getElementById('fecha').value,
                        'observaciones': this.observaciones
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        location.href = response.data;
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => this.cargando = false);
            } else {
                let total_errores = this.errorForm.length
                for (let i = 0; i < total_errores; i++) {
                    notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                }
            }
        },
        actualizarEnvio() {

            this.errorForm = [];

            let dataFormClienteEnvio = {
                'id_factura': this.id_factura,
                'env_nombre_opcional': document.getElementById('env_nombre_opcional').value,
                'env_agencia_transporte': document.getElementById('env_agencia_transporte').value,
                'env_codigo_seguimiento': document.getElementById('env_codigo_seguimiento').value,
                'env_direccion': document.getElementById('env_direccion').value,
                'env_pais': document.getElementById('env_pais').value,
                'env_estado': document.getElementById('env_estado').value,
                'env_ciudad': document.getElementById('env_ciudad').value,
                'env_codigopostal': document.getElementById('env_codigopostal').value,
            };

            if (!dataFormClienteEnvio.env_agencia_transporte)
                this.errorForm.push('El campo Agencia de Tranporte es obligatorio.');
            if (!dataFormClienteEnvio.env_codigo_seguimiento)
                this.errorForm.push('El campo Código de Seguimiento es obligatorio.');
            if (!dataFormClienteEnvio.env_direccion)
                this.errorForm.push('El campo Dirección obligatorio.');
            if (!dataFormClienteEnvio.env_pais)
                this.errorForm.push('El campo País es obligatorio.');
            if (!dataFormClienteEnvio.env_estado)
                this.errorForm.push('El campo Estado es obligatorio.');
            if (!dataFormClienteEnvio.env_ciudad)
                this.errorForm.push('El campo Ciudad es obligatorio.');
            if (!dataFormClienteEnvio.env_codigopostal)
                this.errorForm.push('El campo Código Postal es obligatorio.');

            if (this.id_factura && this.cliente && this.errorForm.length == 0) {
                this.cargando = true;
                axios({
                    method: 'post',
                    url: 'presupuestoeditar/guardarEnvioCliente',
                    data: dataFormClienteEnvio,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data) {
                            document.getElementById('env_asegurado').checked = true;
                            notificacion('fa fa-info', '', 'Envío asegurado', 'info');
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => this.cargando = false);
            } else {
                let total_errores = this.errorForm.length
                for (let i = 0; i < total_errores; i++) {
                    notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                }
            }
        },
        modalCorreo() {
            $('#modal_correo').modal('show');
            $('#modal_correo').on('shown.bs.modal', function () {
                //$('#nombre_divisa').trigger('focus');
            });
        },
        enviarFactura() {

            this.errorForm = [];

            let dataFormEnviarFactura = {
                'id_factura': this.id_factura,
                'de': document.getElementById('cor_emailde').value,
                'para': document.getElementById('cor_emailpara').value,
                'copia': document.getElementById('cor_emailcopia').value,
                'firma': document.getElementById('cor_emailfirma').value,
            };

            if (!dataFormEnviarFactura.de) {
                this.errorForm.push('El campo De obligatorio.');
            } else if (!validaEmail(dataFormEnviarFactura.de)) {
                this.errorForm.push('El correo electrónico ' + dataFormEnviarFactura.de + ' no es valido.');
            }

            if (!dataFormEnviarFactura.para) {
                this.errorForm.push('El campo De obligatorio.');
            } else if (!validaEmail(dataFormEnviarFactura.para)) {
                this.errorForm.push('El correo electrónico ' + dataFormEnviarFactura.oara + ' no es valido.');
            }

            if (this.errorForm.length == 0) {

                this.loader_correo = true;

                axios({
                    method: 'post',
                    url: 'presupuestoeditar/eniviarFactura',
                    data: dataFormEnviarFactura,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data) {
                            notificacion('fa fa-check', 'Enviado', response.data, 'success');
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => this.loader_correo = false);
            } else {
                let total_errores = this.errorForm.length
                for (let i = 0; i < total_errores; i++) {
                    notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                }
            }
        },
        handleFileUpload() {
            this.formDocumentos.documento = this.$refs.file.files[0];
        },
        enviarDocumento() {

            this.errorForm = [];

            this.formDocumentos.id_factura = this.id_factura;

            if (!this.formDocumentos.descripcion)
                this.errorForm.push('El campo Descripción es obligatorio.');

            if (!this.formDocumentos.documento)
                this.errorForm.push('El Documento es obligatorio.');

            if (this.errorForm.length == 0) {
                this.cargando_documento = true;
                axios({
                    method: 'post',
                    url: 'presupuestoeditar/enviarDocumento',
                    data: this.formDocumentos,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data) {
                            this.obtenerDocumentos();
                            notificacion('fa fa-check', 'Enviado', response.data, 'success');
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => this.cargando_documento = false);
            } else {
                let total_errores = this.errorForm.length
                for (let i = 0; i < total_errores; i++) {
                    notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                }
            }
        },
        obtenerDocumentos() {
            axios.get('presupuestoeditar/obtnerDocumentos/' + this.id_factura).then(response => {
                this.documentos = response.data;
            });
        },
        modalConvertirDocumento() {
            $('#modal_convertir').modal({ show: true, backdrop: 'static', keyboard: false });
        },
        moneda(num, div_locale_, div_simbolo_, decimal_ = 2) {
            if (Object.keys(this.carrito).length > 0) {
                let monto_ = convertir_a_float(String(num).toString());
                return monedaMoneda(monto_, div_locale_, div_simbolo_, decimal_);
            }
        },
        decimal(num, div_locale_, decimal_ = 2) {
            if (Object.keys(this.carrito).length > 0) {
                let monto_ = convertir_a_float(String(num).toString());
                return monedaDecimal(monto_, div_locale_, decimal_);
            }
        },
        modal_whatsapp(){
            let mensaje=document.getElementById('nombEmpresa').value+' le recuerda que tiene '+document.getElementById('cant_pend').value+' facturas pendientes por un monto de '+document.getElementById('pagot').value;
            let mens=mensaje+', agradecemos que cumpla con sus compromisos de pago.';
            window.open('https://api.whatsapp.com/send?phone=+58'+document.getElementById('telcli').value+'&text='+mens);
        }
    }
});

function active(x) {

    if (!x) return false;

    for (var i = 0; i < x.length; i++) {
        x[i].classList.remove("autocomplete-active");
    }

    if (currentFocus >= x.length) currentFocus = 0;
    if (currentFocus < 0) currentFocus = (x.length - 1);

    x[currentFocus].classList.add("autocomplete-active");
}

function closeAllLists(elmnt) {
    let inp = document.getElementById("buscador");
    let x = document.getElementsByClassName("autocomplete-items");
    for (var i = 0; i < x.length; i++) {
        if (elmnt != x[i] && elmnt != inp) {
            x[i].parentNode.removeChild(x[i]);
        }
    }
}

document.addEventListener("click", function (e) {
    closeAllLists(e.target);
});