var currentFocus;
var fecha = new Date();

function padLeft(n) {
  return ("00" + n).slice(-2);
}
var mess = padLeft(fecha.getMonth() + 1)

let vue=new Vue({
  el: "#appPlanillas",
  data: {
    anio: fecha.getFullYear(),
    mes: 0,
    nuevos: 0,
    todos: 0,
    pendientes: 0,
    completados: 0,
    terminados: 0,
    anuladas: 0,
    detenidos: 0,
    autorizado: 0,
    abono: 0,
    entregadascompletas:0,
    creditos:0,
    cargando: false,
    id_orden_temporal: "",
    imp:'',
    autorizados:[],
    abonos:[],
    dia:[]
  },
  created() {
  //this.obtenerOrdenesTodos();
    
  },
  mounted(){
    this.obtenerOrdenesTodos();
    this.obtenerOrdenesCount();
  },
  methods: {
obtenerOrdenesCount(){
      axios
      .get("planilla/obtenerOrdenesCount")
      .then((response) => {
        if (response.data.errors == null) {
          this.dia = response.data;
        } else {
          let total_errores = response.data.errors.length;
          for (let i = 0; i < total_errores; i++) {
            notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
          }
        }
      })
      .catch((e) => notificacion());
    },
 obtenerOrdenesAutorizados() {   
      $('#tabla_autorizados').DataTable().destroy();
      axios({
        method: "post",
        url: "planilla/obtenerOrdenesAutorizados",
        data: {
          anio: this.anio,
          mes: this.mes
        },
        transformRequest: serializar(),
      })
        .then((response) => {
            if (response.data.errors == null) {
              this.autorizados = response.data.lista;
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion())
          .finally(() => {
            $(document).ready(function () {
let buttonCommonServ = {
            exportOptions: {
              columns: [0, 1, 2,3,4,5],
              format: {
                body: function (data, row, column, node) {
                  if (column === 0) {
                    return convertir_a_float(data);
                  } else {
                    return data.replace(/<[^>]*>?/g, "");
                  }
                },
              },
            },
          };

              $("#tabla_autorizados").DataTable({
                order: [],
                dom: "Blfrtip",
		    buttons: [
		      $.extend(true, {}, buttonCommonServ, {
		        extend: "excelHtml5",
		        title: "Ordenes autorizadas",
		     
		      }),
		    ],
              });
            });
          });
    },
    obtenerOrdenesAbonado() {   
      $('#tabla_abonos').DataTable().destroy();
      axios({
        method: "post",
        url: "planilla/obtenerOrdenesAbonado",
        data: {
          anio: this.anio,
          mes: this.mes
        },
        transformRequest: serializar(),
      })
        .then((response) => {
            if (response.data.errors == null) {
              this.abonos = response.data.lista;
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion())
          .finally(() => {
            $(document).ready(function () {
              $("#tabla_abonos").DataTable({
                order: [],
              });
            });
          });
    },
    obtenerOrdenesTodos() {   
      $('#tabla_todos').DataTable().destroy();
let buttonCommonServ = {
            exportOptions: {
              columns: [0, 1, 2,3,4,5,6],
              format: {
                body: function (data, row, column, node) {
                  if (column === 0) {
                    return convertir_a_float(data);
                  } else {
                    return data.replace(/<[^>]*>?/g, "");
                  }
                },
              },
            },
          };

      $('#tabla_todos').DataTable({
          'processing': true,
          'serverSide': true,
          'serverMethod': 'post',
          'autoWidth':false,
          'retrieve':true,
          'order':[[0,'desc']],
          'LengthMenu':[[25,100,-1],[25,100,'All']],
          'pageLength':25,
dom: "Blfrtip",
            buttons: [
              $.extend(true, {}, buttonCommonServ, {
                extend: "excelHtml5",
                title: "Orden",
             
              }),
            ],
          'ajax':{
              'url':'planilla/obtenerOrdenesTodas',
                  'data':{
                    'anio': this.anio,
                    'mes': this.mes
                  },
          },
          'columnDefs': [
              {width:"7%",
              targets:"0"},
              {width:"35%",
              targets:"1"},
              {width:"12%",
              targets:"2"},
              {width:"12%",
              targets:"3"},
              {width:"12%",
              targets:"4"},
              {width:"12%",
              targets:"5"},
              {width:"6%",
              targets:"6"}
          ],
          'columns': [
              { data: 'pre_correlativo',
                  render:function (data,type,row) {
                      return "<a href='"+row.uri+"' target='_blank'>"+row.pre_correlativo+"</a>";
                  }
              },
              { data: 'pre_creado' },
              { data: 'cli_razon_social'},
              { data: 'mot_motor' },
              { data: 'presupuesto',
                render:function(data,type,row){
                  let btn='';
                  if(row.generar_orden==true){
                    btn=(row.existe_presupuesto == true)? "<a href='"+row.uri_presupuesto+"' target='_blank' rel='noopener noreferrer'>"+row.presupuesto+"</a>":"No asignado";
                  }else{
                    (row.existe_presupuesto == true)? row.uri_presupuesto:"No asignado";
                  }
                  return btn;
                }
               },
              {  data: 'pagado',
                render:function(data,type,row){
                if(row.pagado == "PENDIENTE"){
                  $est="PENDIENTE";
                  $text="text-danger";
                }else if(row.pagado == "ABONADO"){
                  $est="ABONADO";
                  $text="text-primary";
                }else if(row.pagado == "AUTORIZADO"){
                  $est="AUTORIZADO";
                  $text="text-warning";
                } else {
                  $est="PAGADO";
                  $text="text-success";
                }
                return '<span class="'+$text+'">'+row.pagado+'</span>';
              }
             },{data: 'entreg',
                  render:function (data,type,row) {
                    if(row.entreg == "PENDIENTE"){
                      $text="text-warning";
                    }else if(row.entreg == "ANULADA"){
                      $text="text-danger";
                    }else if(row.entreg == "CREDITO"){
                      $text="text-info";
                    }else if(row.entreg == "NUEVO"){
                      $text="text-primary";
                    }else if(row.entreg == "DETENIDO"){
                      $text="text-danger";
                    }else {
                      $text="text-success";
                    }
                    return '<span class="'+$text+'">'+row.entreg+'</span>';
                  }
              },
              //{ defaultContent: "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>" },
          ],
      });
      this.obtenerOrdenesCountTodas();
    },
    obtenerOrdenesPendientes() {   
      $('#tabla_pendientes').DataTable().destroy();

      $('#tabla_pendientes').DataTable({
          'processing': true,
          'serverSide': true,
          'destroy': true,
          'serverMethod': 'post',
          'autoWidth':false,
          'order':[[0,'desc']],
          'ajax':{
              'url':'planilla/obtenerOrdenesPendientes',
                  'data':{
                    'anio': this.anio,
                    'mes': this.mes
                  },
          },
          'columnDefs': [
              {width:"7%",
              targets:"0"},
              {width:"25%",
              targets:"1"},
              {width:"12%",
              targets:"2"},
              {width:"12%",
              targets:"3"},
              {width:"12%",
              targets:"4"},
              {width:"12%",
              targets:"5"},
              {width:"16%",
              targets:"6"}
          ],
          'columns': [
              { data: 'pre_correlativo',
                  render:function (data,type,row) {
                      return "<a href='"+row.uri+"' target='_blank'>"+row.pre_correlativo+"</a>";
                  }
              },
              { data: 'pre_creado' },
              { data: 'cli_razon_social'},
              { data: 'mot_motor' },
              { data: 'presupuesto',
                render:function(data,type,row){
                  let btn='';
                  if(row.generar_orden==true){
                    btn=(row.existe_presupuesto == true)? "<a href='"+row.uri_presupuesto+"' target='_blank' rel='noopener noreferrer'>"+row.presupuesto+"</a>":"No asignado";
                  }else{
                    (row.existe_presupuesto == true)? row.uri_presupuesto:"No asignado";
                  }
                  return btn;
                }
               },
              {  data: 'pagado',
                render:function(data,type,row){
                if(row.pagado == "PENDIENTE"){
                  $est="PENDIENTE";
                  $text="text-danger";
                }else if(row.pagado == "ABONADO"){
                  $est="ABONADO";
                  $text="text-primary";
                }else if(row.pagado == "AUTORIZADO"){
                  $est="AUTORIZADO";
                  $text="text-warning";
                } else {
                  $est="AUTORIZADO";
                  $text="text-success";
                }
                return '<span class="'+$text+'">'+row.pagado+'</span>';
              }
              },
              {
                render:function (data,type,row) {
                  let btn1= (row.existe_presupuesto == false && row.generar_orden==true)? "<button type='button' id='generar' class='generar btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fa fa-file text-dark'></i></button>":"";
                  let btn2= "<button type='button' id='anular' class='anular btn btn-icon btn-sm btn-light mt-2' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fa fa-times text-danger'></i></button>";
                  let btn3= "<button type='button' id='detener' class='detener btn btn-icon btn-sm btn-light mt-2' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fa fa-stop-circle text-warning'></i></button>";
                  return "<button type='button' id='impresora' class='impresora btn btn-icon btn-sm btn-light mt-2' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fa fa-print text-dark'></i></button>"+btn1+btn2+btn3;
                }
              }
              
              //{ defaultContent: "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>" },
          ],
      });
      $("#tabla_pendientes tbody").on('click','button.impresora',function () {
        let tb=$('#tabla_pendientes').DataTable();
        var datos=tb.row($(this).parents("tr")).data();
        vue.imp=datos.id;
        $("#modal_imprimir_pend").modal("show");
      });
      $("#tabla_pendientes tbody").on('click','button.anular',function () {
        let tb=$('#tabla_pendientes').DataTable();
        var datos=tb.row($(this).parents("tr")).data();
        vue.anularOrden(datos.id,datos.pre_correlativo);
      });
      $("#tabla_pendientes tbody").on('click','button.detener',function () {
        let tb=$('#tabla_pendientes').DataTable();
        var datos=tb.row($(this).parents("tr")).data();
        vue.detenerOrden(datos.id,datos.pre_correlativo);
      });
      $("#tabla_pendientes tbody").on('click','button.generar',function () {
        let tb=$('#tabla_pendientes').DataTable();
        var datos=tb.row($(this).parents("tr")).data();
        vue.abrirModalGenerarPresupuesto(datos);
      });
    },
    obtenerOrdenesCountTodas() {
      axios({
        method: 'post',
        url: 'planilla/obtenerOrdenesCountTodas',
        data:  {
            anio: this.anio,
            mes: this.mes,
        },
        transformRequest: serializar(),
       }).then(response => {
          this.nuevos=response.data.nuevo;
          this.pendientes=response.data.pendiente;
          this.todos=response.data.todos;
          this.completados=response.data.completada;
          this.terminados=response.data.terminado;
          this.anuladas=response.data.anulada;
          this.detenidos=response.data.detenido;
          this.entregadascompletas=response.data.entregar;
          this.creditos=response.data.credito;
          this.autorizado=response.data.autorizado;
          this.abono=response.data.abono;
        })
        .catch((e) => notificacion())
        .finally(() => {
          
        });
    },
    obtenerOrdenesentregadascompletas() {   
      $('#table-entregadascompletas').DataTable().destroy();

      $('#table-entregadascompletas').DataTable({
          'processing': true,
          'serverSide': true,
          'destroy': true,
          'serverMethod': 'post',
          'autoWidth':false,
          'order':[[0,'desc']],
          'ajax':{
              'url':'planilla/obtenerOrdensCompletadasEntregadas',
                  'data':{
                    'anio': this.anio,
                    'mes': this.mes
                  },
          },
          'columnDefs': [
              {width:"7%",
              targets:"0"},
              {width:"25%",
              targets:"1"},
              {width:"12%",
              targets:"2"},
              {width:"12%",
              targets:"3"},
              {width:"12%",
              targets:"4"},
              {width:"12%",
              targets:"5"}
          ],
          'columns': [
              { data: 'pre_correlativo',
                  render:function (data,type,row) {
                      return "<a href='"+row.uri+"' target='_blank'>"+row.pre_correlativo+"</a>";
                  }
          },
              { data: 'pre_modificado' },
              { data: 'cli_razon_social'},
              { data: 'mot_motor' },
              { data: 'presupuesto',
                render:function(data,type,row){
                  let btn='';
                  if(row.generar_orden==true){
                    btn=(row.existe_presupuesto == true)? "<a href='"+row.uri_presupuesto+"' target='_blank' rel='noopener noreferrer'>"+row.presupuesto+"</a>":"No asignado";
                  }else{
                    (row.existe_presupuesto == true)? row.uri_presupuesto:"No asignado";
                  }
                  return btn;
                }
               },
              {  data: 'pagado',
                render:function(data,type,row){
                if(row.pagado == "PENDIENTE"){
                  $est="PENDIENTE";
                  $text="text-danger";
                }else if(row.pagado == "ABONADO"){
                  $est="ABONADO";
                  $text="text-primary";
                }else if(row.pagado == "AUTORIZADO"){
                  $est="AUTORIZADO";
                  $text="text-warning";
                } else {
                  $est="PAGADO";
                  $text="text-success";
                }
                return '<span class="'+$text+'">'+row.pagado+'</span>';
              }
             }
              
          ],
      });
    },
    obtenerOrdenesPreOrden() {   
      $('#table_pre_orden').DataTable().destroy();

      $('#table_pre_orden').DataTable({
          'processing': true,
          'serverSide': true,
          'destroy': true,
          'serverMethod': 'post',
          'autoWidth':false,
          'order':[[0,'desc']],
          'ajax':{
              'url':'planilla/obtenerOrdenesPreOrden',
                  'data':{
                    'anio': this.anio,
                    'mes': this.mes
                  },
          },
          'columns': [
              { data: 'pre_correlativo',
                  render:function (data,type,row) {
                      return "<a href='"+row.uri+"'>"+row.pre_correlativo+"</a>";
                  }
              },
              { data: 'pre_creado' },
              { data: 'cli_razon_social'},
              { data: 'mot_motor' },
              //{ defaultContent: "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>" },
          ],
      });
    },
    obtenerOrdenesAnuladas() {   
      $('#tabla_anuladas').DataTable().destroy();

      $('#tabla_anuladas').DataTable({
          'processing': true,
          'serverSide': true,
          'destroy': true,
          'serverMethod': 'post',
          'autoWidth':false,
          'order':[[0,'desc']],
          'ajax':{
              'url':'planilla/obtenerOrdenesAnuladas',
                  'data':{
                    'anio': this.anio,
                    'mes': this.mes
                  },
          },
          'columnDefs': [
              {width:"7%",
              targets:"0"},
              {width:"35%",
              targets:"1"},
              {width:"12%",
              targets:"2"},
              {width:"12%",
              targets:"3"},
              {width:"12%",
              targets:"4"},
              {width:"12%",
              targets:"5"}
          ],
          'columns': [
              { data: 'pre_correlativo',
                  render:function (data,type,row) {
                      return "<a href='"+row.uri+"' target='_blank'>"+row.pre_correlativo+"</a>";
                  }
          },
              { data: 'pre_creado' },
              { data: 'cli_razon_social'},
              { data: 'mot_motor' },
              { data: 'presupuesto',
                render:function(data,type,row){
                  let btn='';
                  if(row.generar_orden==true){
                    btn=(row.existe_presupuesto == true)? "<a href='"+row.uri_presupuesto+"' target='_blank' rel='noopener noreferrer'>"+row.presupuesto+"</a>":"No asignado";
                  }else{
                    (row.existe_presupuesto == true)? row.uri_presupuesto:"No asignado";
                  }
                  return btn;
                }
               },
              {  render:function(data,type,row){
                return "<span class='text-danger'>"+row.pagado+"</a>";
              }
              }
              //{ defaultContent: "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>" },
          ],
      });
    },
    obtenerOrdensCompletadas() {   
      $('#table-termcompletado').DataTable().destroy();

      $('#table-termcompletado').DataTable({
          'processing': true,
          'serverSide': true,
          'destroy': true,
          'serverMethod': 'post',
          'autoWidth':false,
          'order':[[0,'desc']],
          'ajax':{
              'url':'planilla/obtenerOrdensCompletadas',
                  'data':{
                    'anio': this.anio,
                    'mes': this.mes
                  },
          },
          'columnDefs': [
              {width:"7%",
              targets:"0"},
              {width:"35%",
              targets:"1"},
              {width:"12%",
              targets:"2"},
              {width:"12%",
              targets:"3"},
              {width:"12%",
              targets:"4"},
              {width:"12%",
              targets:"5"}
          ],
          'columns': [
              { data: 'pre_correlativo',
                  render:function (data,type,row) {
                      return "<a href='"+row.uri+"' target='_blank'>"+row.pre_correlativo+"</a>";
                  }
              },
              { data: 'pre_creado' },
              { data: 'cli_razon_social'},
              { data: 'mot_motor' },
              { data: 'presupuesto',
                render:function(data,type,row){
                  let btn='';
                  if(row.generar_orden==true){
                    btn=(row.existe_presupuesto == true)? "<a href='"+row.uri_presupuesto+"' target='_blank' rel='noopener noreferrer'>"+row.presupuesto+"</a>":"No asignado";
                  }else{
                    (row.existe_presupuesto == true)? row.uri_presupuesto:"No asignado";
                  }
                  return btn;
                }
               },
              {  data: 'pagado',
                render:function(data,type,row){
                if(row.pagado == "PENDIENTE"){
                  $est="PENDIENTE";
                  $text="text-danger";
                }else if(row.pagado == "ABONADO"){
                  $est="ABONADO";
                  $text="text-primary";
                }else if(row.pagado == "AUTORIZADO"){
                  $est="AUTORIZADO";
                  $text="text-warning";
                } else {
                  $est="AUTORIZADO";
                  $text="text-success";
                }
                return '<span class="'+$text+'">'+row.pagado+'</span>';
              }
             },
              {
                render:function (data,type,row) {
                  return "<button type='button' id='impresora' class='impresora btn btn-icon btn-sm btn-light mt-2' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fa fa-print text-dark'></i></button>";
                }
              },
              //{ defaultContent: "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>" },
          ],
      });
      $("#table-termcompletado tbody").on('click','button.impresora',function () {
        let tb=$('#table-termcompletado').DataTable();
        var datos=tb.row($(this).parents("tr")).data();
        vue.imp=datos.id;
        $("#modal_imprimir_pend").modal("show");
      });
    },
    obtenerOrdenesDetenidos() {   
      $('#tabla_detenidos').DataTable().destroy();
let buttonCommonServ = {
            exportOptions: {
              columns: [0, 1, 2,3,4],
              format: {
                body: function (data, row, column, node) {
                  if (column === 0) {
                    return convertir_a_float(data);
                  } else {
                    return data.replace(/<[^>]*>?/g, "");
                  }
                },
              },
            },
          };

      $('#tabla_detenidos').DataTable({
          'processing': true,
          'serverSide': true,
          'destroy': true,
          'serverMethod': 'post',
          'autoWidth':false,
          'order':[[0,'desc']],
	  'LengthMenu':[[25,100,-1],[25,100,'All']],
          'pageLength':25,
dom: "Blfrtip",
            buttons: [
              $.extend(true, {}, buttonCommonServ, {
                extend: "excelHtml5",
                title: "Ordenes detenidos",
             
              }),
            ],
          'ajax':{
              'url':'planilla/obtenerOrdenesDetenidos',
                  'data':{
                    'anio': this.anio,
                    'mes': this.mes
                  },
          },
          'columnDefs': [
              {width:"7%",
              targets:"0"},
              {width:"35%",
              targets:"1"},
              {width:"12%",
              targets:"2"},
              {width:"12%",
              targets:"3"},
              {width:"12%",
              targets:"4"},
              {width:"12%",
              targets:"5"}
          ],
          'columns': [
              { data: 'pre_correlativo',
                  render:function (data,type,row) {
                      return "<a href='"+row.uri+"' target='_blank'>"+row.pre_correlativo+"</a>";
                  }
              },
              { data: 'pre_creado' },
              { data: 'cli_razon_social'},
              { data: 'mot_motor' },
              { data: 'presupuesto',
                render:function(data,type,row){
                  let btn='';
                  if(row.generar_orden==true){
                    btn=(row.existe_presupuesto == true)? "<a href='"+row.uri_presupuesto+"' target='_blank' rel='noopener noreferrer'>"+row.presupuesto+"</a>":"No asignado";
                  }else{
                    (row.existe_presupuesto == true)? row.uri_presupuesto:"No asignado";
                  }
                  return btn;
                }
               },
              {
                render:function (data,type,row) {
                  return "<button type='button' id='estatus' class='estatus btn btn-icon btn-sm btn-light mt-2' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fa fa-check text-success'></i></button>";
                }
              },
              //{ defaultContent: "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>" },
          ],
      });
      $("#tabla_detenidos tbody").on('click','button.estatus',function () {
        let tb=$('#tabla_detenidos').DataTable();
        var datos=tb.row($(this).parents("tr")).data();
        vue.activarOrden(datos.id,datos.pre_correlativo);
      });
    },
    obtenerOrdenesCreditos() {   
      $('#tabla_creditos').DataTable().destroy();

      $('#tabla_creditos').DataTable({
          'processing': true,
          'serverSide': true,
          'destroy': true,
          'serverMethod': 'post',
          'autoWidth':false,
          'order':[[0,'desc']],
          'ajax':{
              'url':'planilla/obtenerOrdenesCreditos',
                  'data':{
                    'anio': this.anio,
                    'mes': this.mes
                  },
          },
          'columnDefs': [
              {width:"7%",
              targets:"0"},
              {width:"35%",
              targets:"1"},
              {width:"12%",
              targets:"2"},
              {width:"12%",
              targets:"3"},
              {width:"12%",
              targets:"4"},
              {width:"12%",
              targets:"5"}
          ],
          'columns': [
              { data: 'pre_correlativo',
                  render:function (data,type,row) {
                      return "<a href='"+row.uri+"' target='_blank'>"+row.pre_correlativo+"</a>";
                  }
              },
              { data: 'pre_creado' },
              { data: 'cli_razon_social'},
              { data: 'mot_motor' },
              { data: 'presupuesto',
                render:function(data,type,row){
                  let btn='';
                  if(row.generar_orden==true){
                    btn=(row.existe_presupuesto == true)? "<a href='"+row.uri_presupuesto+"' target='_blank' rel='noopener noreferrer'>"+row.presupuesto+"</a>":"No asignado";
                  }else{
                    (row.existe_presupuesto == true)? row.uri_presupuesto:"No asignado";
                  }
                  return btn;
                }
               }
              //{ defaultContent: "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>" },
          ],
      });
    },
    obtenerOrdenesCompletadas() {   
      $('#table-completados').DataTable().destroy();

      $('#table-completados').DataTable({
          'processing': true,
          'serverSide': true,
          'destroy': true,
          'serverMethod': 'post',
          'autoWidth':false,
          'order':[[0,'desc']],
          'ajax':{
              'url':'planilla/obtenerOrdenesCompletadas',
                  'data':{
                    'anio': this.anio,
                    'mes': this.mes
                  },
          },
          'columnDefs': [
              {width:"7%",
              targets:"0"},
              {width:"25%",
              targets:"1"},
              {width:"12%",
              targets:"2"},
              {width:"12%",
              targets:"3"},
              {width:"12%",
              targets:"4"},
              {width:"12%",
              targets:"5"},
              {width:"6%",
              targets:"6"}
          ],
          'columns': [
              { data: 'pre_correlativo',
                  render:function (data,type,row) {
                      return "<a href='"+row.uri+"' target='_blank'>"+row.pre_correlativo+"</a>";
                  }
          },
              { data: 'pre_modificado' },
              { data: 'cli_razon_social'},
              { data: 'mot_motor' },
              { data: 'presupuesto',
                render:function(data,type,row){
                  let btn='';
                  if(row.generar_orden==true){
                    btn=(row.existe_presupuesto == true)? "<a href='"+row.uri_presupuesto+"' target='_blank' rel='noopener noreferrer'>"+row.presupuesto+"</a>":"No asignado";
                  }else{
                    (row.existe_presupuesto == true)? row.uri_presupuesto:"No asignado";
                  }
                  return btn;
                }
               },
              {  data: 'pagado',
                render:function(data,type,row){
                if(row.pagado == "PENDIENTE"){
                  $est="PENDIENTE";
                  $text="text-danger";
                }else if(row.pagado == "ABONADO"){
                  $est="ABONADO";
                  $text="text-primary";
                }else if(row.pagado == "AUTORIZADO"){
                  $est="AUTORIZADO";
                  $text="text-warning";
                } else {
                  $est="AUTORIZADO";
                  $text="text-success";
                }
                return '<span class="'+$text+'">'+row.pagado+'</span>';
              }
             },
              {data: 'mot_motor',
                  
              },
              
          ],
      });
    },
    activarOrden(id, numero_orden) {
      Swal.fire({
        title: "<strong>¿Activar?</strong>",
        html: "Orden # <strong>"+numero_orden+ "</strong>",
        showCloseButton: true,
        showCancelButton: true,
        focusConfirm: false,
        cancelButtonColor: "#aaa",
        confirmButtonColor: "#3085d6",
        confirmButtonText: "Aceptar",
        cancelButtonText: "Cancelar",
      }).then((result) => {
        if (result.value) {
          axios
          .get("planilla/activarOrden", {
            params: {
              id: id,
              orden: numero_orden
            }
          }).then(response => {
            if (response.data.errors == null) {
              this.obtenerOrdenesPendientes();
              this.obtenerOrdenesDetenidos();
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion())
        }
      });
    },
    detenerOrden(id, numero_orden) {
      Swal.fire({
        title: "<strong>¿Detener?</strong>",
        html: "Orden # <strong>"+numero_orden+ "</strong>",
        showCloseButton: true,
        showCancelButton: true,
        focusConfirm: false,
        cancelButtonColor: "#aaa",
        confirmButtonColor: "#3085d6",
        confirmButtonText: "Aceptar",
        cancelButtonText: "Cancelar",
      }).then((result) => {
        if (result.value) {
          axios
          .get("planilla/detenerOrden", {
            params: {
              id: id,
              orden: numero_orden
            }
          }).then(response => {
            if (response.data.errors == null) {
              this.obtenerOrdenesPendientes();
              this.obtenerOrdenesDetenidos();
              this.cronMsj(id,0)
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion())
        }
      });
    },
    abrirModalGenerarPresupuesto(orden) {
      this.id_orden_temporal = orden.id;
      document.getElementById("pre_serie").selectedIndex = 1;
      document.getElementById("pre_almacen").selectedIndex = 1;
      $("#modal_generar_presupuesto").modal("show");
    },
    async generarPresupuesto() {
      let form = document.getElementById("form_generar_presupuesto");

      let formData = new FormData(form);

      formData.append("id_orden", this.id_orden_temporal);

      await axios({
        method: "post",
        url: "planilla/generarPresupuesto",
        data: formData,
      })
        .then((response) => {
          if (response.data.errors == null) {
            location.href = response.data;
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion());
    },
    async imprimirTicket(id_orden, id_impresora) {
      const data_ticket = await axios
        .get("planilla/imprimirTicket", {
          params: {
            id_orden: id_orden,
            id_impresora: id_impresora,
          },
        })
        .then((response) => {
          return response.data;
        })
        .catch((e) => notificacion());

      if (data_ticket.errors == null) {
        console.log(data_ticket.data);
        fetch(data_ticket.ip_puerto, {
          method: "POST",
          body: JSON.stringify(data_ticket.data),
        })
          .then((j) => {
            console.log(j);
            if (j.ok) {
              notificacion("fa fa-check", "Impreso", "Impresion exitosa", "success");
            } else {
              notificacion("fa fa-ban", "Error", "Respuesta de red OK pero respuesta HTTP no OK", "warning");
            }
          })
          .catch((error) => {
            notificacion("fa fa-ban", "Error", "Hubo un problema con la petición Fetch:" + error.message, "danger");
          });
      } else {
        let total_errores = data_ticket.errors.length;
        for (let i = 0; i < total_errores; i++) {
          notificacion("fa fa-ban", "Advertencia", data_ticket.errors[i], "warning");
        }
      }
    },
    async abrirOrden(id) {
      axios
        .get("planilla/abrirOrden/" + id)
        .then((response) => {
          this.obtenerOrdenesPendientes();
        })
        .catch((e) => notificacion());
    },
    actualizarDatatab() {
      this. obtenerOrdenesTodos();
      this.obtenerOrdenesPendientes();
      this.obtenerOrdenesPreOrden();
      this.obtenerOrdenesCompletadas();
      this.obtenerOrdenesAnuladas();
      this.obtenerOrdensCompletadas();
      this.obtenerOrdenesDetenidos();
      this.obtenerOrdenesCreditos();
      this.obtenerOrdenesentregadascompletas();
    },
    anularOrden(id, numero_orden) {
      Swal.fire({
        title: "<strong>¿Anular?</strong>",
        html: "Orden # <strong>"+numero_orden+ "</strong>",
        showCloseButton: true,
        showCancelButton: true,
        focusConfirm: false,
        cancelButtonColor: "#aaa",
        confirmButtonColor: "#3085d6",
        confirmButtonText: "Aceptar",
        cancelButtonText: "Cancelar",
      }).then((result) => {
        if (result.value) {
          axios
          .get("planilla/anularOrden", {
            params: {
              id: id,
              orden: numero_orden
            }
          }).then(response => {
            if (response.data.errors == null) {
              this.obtenerOrdenesPendientes();
              this.obtenerOrdenesAnuladas();
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion())
        }
      });
    },
    cronMsj(id,tipo) {
      axios({
        method: "post",
        url: "planilla/cronSMS",
        data: {
          id_orden: id,
          tipo: tipo,
        },
        transformRequest: serializar(),
      })
        .then((response) => {
          if (response.data.errors) {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          } else {
            notificacion("fa fa-info", "", "Proceso ejecutado", "info");
          }
        })
        .catch((e) => notificacion());
    },
  }
});
