Vue.component('v-select', VueSelect.VueSelect)

new Vue({
    el: '#appOrdenDeEntregaVer',
    data: {
        id_factura: document.getElementById('id_fac').value,
        cliente: document.getElementById('id_cliente_fac').value,
        simbolo_master: '',
        div_nombre_master: '',
        div_locale: '',
        div_simbolo: '',
        div_decimal: 2,
        div_conv_locale: '',
        div_conv_currency: '',
        div_conv_decimal: 2,
        div_conv_factor: 1,
        factura: [],
        divisa_pagar: '',
        metodo_pagar: '',
        cuenta_pagar: '',
        abonos: [],
        cuentas: [],
        metodos_de_pagos: [],
        formDocumentos: { 'id_factura': '', 'descripcion': '', 'documento': '' },
        documentos: [],
        monto: 0,
        restante_original: 0,
        articulosTotal: 0,
        total_pagado: 0,
        descuento: 0,
        restante: 0,
        subtotal: 0,
        total: 0,
        neto: 0,
        iva: 0,
        divisas: [],
        divisa_predeterminada: '',
        almacenes: [],
        almacen_predeterminado: '',
        series: [],
        serie_predeterminada: '',
        sucursal_predeterminada:"",
        sucursales_empleado:[],
        series_empleado:[],
        productos: [],
        carrito: [],
        money: {
            decimal: '.',
            thousands: ',',
            prefix: '',
            suffix: '',
            precision: 2,
            masked: false /* doesn't work with directive */
        },
        cargando: false,
        errorForm: [],
        clientes: [],
        clienteEncontrado: true,
        observaciones: '',
        dataForm: {
            'ruta': '',
            'cli_tipodoc': '',
            'cli_dni': '',
            'cli_razon_social': '',
            'cli_fecha_nac': '',
            'cli_email': '',
            'cli_telefono': '',
            'cli_telefono_2': '',
            'cli_direccion': '',
            'cli_contribuyente': '',
            'cli_estatus': '',
            'cli_fecha_reg': '',
            'cli_genero': '',
            'cli_paisid': '',
            'cli_estado': '',
            'cli_ciudad': '',
            'cli_codpostal': '',
            'cli_descuento': '',
            'cli_razonsocial': '',
            'cli_natural': '',
            'cli_grupid': '',
            'cli_observaciones': ''
        },
        icon_buscador: 'fa fa-search',
        icon_buscador_cliente: 'fa fa-search',
        observacion_anular: '',
        loader_correo: false,
        selected_cli: ''
    },
    created() {
        axios.get('ordendeentregaeditar/obtenerFactura/' + this.id_factura).then(response => {
            this.factura = response.data.factura;

            this.obtenerSucursalesEmpleado();

            this.almacen_predeterminado = this.factura.id_almacen;
            this.sucursal_predeterminada = this.factura.sucursal;
            this.serie_predeterminada = this.factura.id_serie;
            this.divisa_predeterminada = this.factura.id_divisa;
            this.div_nombre_master = response.data.div_nombre;
            this.div_locale = response.data.div_locale;
            this.div_simbolo = response.data.div_simbolo;
            this.div_decimal = response.data.div_decimal;
            this.div_conv_locale = response.data.div_locale;
            this.div_conv_currency = response.data.div_simbolo;
            this.div_conv_decimal = response.data.div_decimal;
            this.observaciones = this.factura.observaciones;
            this.div_conv_factor = response.data.factor;

            if (response.data.div_locale == 'de-DE') {
                this.money.decimal = ',';
                this.money.thousands = '.';
                this.money.precision = response.data.div_decimal;
            } else if (response.data.div_locale == 'en-US') {
                this.money.decimal = '.';
                this.money.thousands = ',';
                this.money.precision = response.data.div_decimal;
            }

            this.articulosTotal = response.data.articulos_cantidad;
            this.subtotal = response.data.subtotal;
            this.descuento = response.data.descuento;
            this.neto = response.data.neto;
            this.iva = response.data.iva;
            this.total = response.data.total
            this.monto = parseFloat(response.data.restante).toFixed(this.money.precision);
            this.restante_original = response.data.restante;
            this.restante = response.data.restante;
            this.carrito = response.data.data_carrito;
            this.abonos = response.data.abonos;
            this.total_pagado = response.data.total_pagado;
            this.obtenerDocumentos();
        });
    },
    methods: {
        obtenerSucursalesEmpleado(){
            axios
            .get("ordendeentrega/obtenerSucursalesEmpleado")
            .then((response) => {
              this.sucursales_empleado = response.data.sucursales;
              this.obtenerSeriesEmpleado();
            })
            .catch((e) => notificacion());
          },
          obtenerSeriesEmpleado(){
            axios
            .get("ordendeentrega/obtenerSeriesAlmacenesEmpleado/"+ this.sucursal_predeterminada)
            .then((response) => {
                this.series_empleado = response.data.series;
            })
            .catch((e) => notificacion());
          },
        modal_buscar_cliente(ruta) {
            this.dataForm.ruta = ruta;
            this.errorForm = [];
            $('#modal_buscar_cliente').modal({ show: true, backdrop: 'static', keyboard: false });
            $('#modal_buscar_cliente').on('shown.bs.modal', function () {
                $('#tututut > div > div > input').trigger('focus')
            });
        },
        modalCorreo() {
            $('#modal_correo').modal('show');
            $('#modal_correo').on('shown.bs.modal', function () {
                //$('#nombre_divisa').trigger('focus');
            });
        },
        enviarFactura() {

            this.errorForm = [];

            let de = document.getElementById('cor_emailde').value;
            let para = document.getElementById('cor_emailpara').value;
            let copia = document.getElementById('cor_emailcopia').value;
            let firma = document.getElementById('cor_emailfirma').value;
            let tipo = document.getElementById('cor_tipo').value;

            if (!de)
                this.errorForm.push('El campo De es obligatorio.');
            if (!para)
                this.errorForm.push('El campo Para es obligatorio.');

            if (de && para) {
                if (!validaEmail(de))
                    this.errorForm.push('El Correo Electrónico ' + de + ' no es válido.');
                if (!validaEmail(para))
                    this.errorForm.push('El Correo Electrónico ' + para + ' no es válido.');
            }

            if (this.errorForm.length == 0) {

                this.loader_correo = true;

                axios({
                    method: 'post',
                    url: 'ordendeentregaeditar/eniviarFactura',
                    data: {
                        id_factura: this.id_factura,
                        de: de,
                        para: para,
                        copia: copia,
                        firma: firma,
                        tipo: tipo
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data) {
                            notificacion('fa fa-check', 'Enviado', response.data, 'success');
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => {
                    notificacion();
                }).finally(() => this.loader_correo = false);
            } else {
                let total_errores = this.errorForm.length
                for (let i = 0; i < total_errores; i++) {
                    notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                }
            }
        },
        obtenerDocumentos() {
            axios.get('ordendeentregaeditar/obtnerDocumentos/' + this.id_factura).then(response => {
                if (Array.isArray(response.data)) {
                    this.documentos = response.data;
                }
            });
        },
        moneda(num, div_locale_, div_simbolo, decimal_ = 2) {
            if (this.div_conv_locale) {
                let monto_ = convertir_a_float(String(num).toString());
                let m = new Intl.NumberFormat(div_locale_, { minimumFractionDigits: decimal_ }).format(monto_);
                return div_simbolo + '' + m;
            }
        },
        decimal(num, div_locale, decimal = 2) {
            if (this.div_conv_locale) {
                let monto_ = convertir_a_float(String(num).toString());
                return new Intl.NumberFormat(div_locale, { minimumFractionDigits: decimal }).format(monto_);
            }
        },
        modalBuscarCliente() {
            this.errorForm = [];
            this.clientes = [];
            $('#modal_buscar_clientes').modal();
        },
        cambiarCliente(cliente) {
            let cambiar_buscli = document.getElementById('cambiar_buscli');
            cambiar_buscli.disabled = true;
            this.clientes = [];
            this.icon_buscador_cliente = 'is-loading pr-3'
            axios.get('ordendeentregaeditar/cambiarCliente', {
                params: {
                    id_cliente: cliente,
                    id_factura: this.id_factura
                }
            }).then(response => {
                if (response.data.errors == null) {
                    location.href = response.data;
                } else {
                    cambiar_buscli.disabled = false;
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => {
                cambiar_buscli.disabled = false;
                notificacion();
            });
        },
        onSearch(search, loading) {
            if (search) {
                loading(true);
                this.search(loading, search, this);
            }
        },
        search: _.debounce((loading, search, vm) => {
            axios.get('notadecredito/buscarCliente', {
                params: {
                    'buscar': search
                }
            }).then(response => {
                if (response.data.length > 0) {
                    vm.clientes = response.data;
                    vm.clienteEncontrado = true;
                } else {
                    vm.clientes = [];
                    if (!isNaN(search)) {
                        vm.dataForm.cli_dni = search;
                    } else {
                        vm.dataForm.cli_dni = '';
                    }
                    vm.clienteEncontrado = false;
                }
            }).catch(e => notificacion()).finally(() => {
                loading(false);
            });
        }, 350),
        redireccionarANuevaFactura() {
            location.href = baseURL + this.dataForm.ruta + '/nuevaFactura/' + this.selected_cli.id;
        }
    }
});