new Vue({
    el: '#appImpuestos',
    data: {
        titulo: '',
        accion: '',
        impuestos: [],
        dataForm: { 'id': '', 'ci': '', 'vi': 0, 'di': '', 'ri': 0 },
        errorForm: {},
    },
    created() {
        this.obtenerImpuestos();
    },
    methods: {
        obtenerImpuestos() {
            axios.get('impuestos/getImpuestos').then(response => {
                this.impuestos = response.data;
            }).catch(e => notificacion());
        },
        resetearFormulario() {
            document.getElementById('modal_form_impuesto').reset();
            this.dataForm.id = '';
            this.dataForm.ci = '';
            this.dataForm.vi = 0;
            this.dataForm.di = '';
            this.dataForm.ri = 0;
        },
        modalImpuesto() {
            this.resetearFormulario();
            this.titulo = 'Agregar Impuesto';
            this.accion = 'Guardar';
            $('#modalImpuesto').modal('show');
            $('#modalImpuesto').on('shown.bs.modal', function () {
                $('#ni').trigger('focus');
            });
        },
        ver(id, codigo, descripcion, valor, retencion) {
            this.dataForm.id = id;
            this.dataForm.ci = codigo;
            this.dataForm.vi = valor;
            this.dataForm.di = descripcion;
            this.dataForm.ri = retencion;
            this.titulo = 'Editar Impuesto';
            this.accion = 'Actualizar';
            $('#modalImpuesto').modal('show');
        },
        guardarEditar() {
            axios({
                method: 'post',
                url: 'impuestos/guardar',
                data: this.dataForm,
                transformRequest: serializar(),
            }).then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        if (this.dataForm.idi !== '') {
                            $('#modalImpuesto').modal('hide');
                            notificacion('fa fa-edit', 'Actualización', 'Impuesto actualizado exitosamente', 'info');
                        } else {
                            notificacion('fa fa-check', 'Registro', 'Impuesto registrado exitosamente', 'success');
                        }
                        this.obtenerImpuestos();
                        this.resetearFormulario();
                    } else {
                        notificacion('fa fa-ban', 'Error', 'Error en operación', 'danger');
                    }
                } else {
                    let total_errores = response.data.errors.length;
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        modificarEstatus(id) {
            axios.get('impuestos/modificarEstatus/' + Number(id)).then(response => {
                if (response.data == true) {
                    this.obtenerImpuestos();
                }
            }).catch(e => notificacion());
        },
        eliminar(id, imp_codigo) {
            Swal.fire({
                title: 'Eliminar impuesto',
                text: "¿Estás seguro de eliminar el impuesto " + imp_codigo + "?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('impuestos/eliminar/' + id).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                let posicion = this.impuestos.findIndex((item) => item.imp_id == id);
                                this.impuestos.splice(posicion, 1);
                                notificacion('fa fa-trash', 'Impuesto eliminado', imp_codigo.toUpperCase(), 'danger');
                            } else {
                                notificacion('fa fa-ban', 'Error al eliminar', imp_codigo.toUpperCase(), 'warning');
                            }
                        } else {
                            let total_errores = response.data.errors.length;
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion());
                }
            });
        },
    }
});