new Vue({
    el: '#appFormaPago',
    data: {
        titulo: '',
        accion: '',
        formaPago: [],
        dataForm: { 'idmp': '', 'cmp': '', 'nmp': '', 'dmp': '' },
        errorForm: {},
    },
    created() {
        this.obtenerMetodosPago();
    },
    methods: {
        obtenerMetodosPago() {
            axios.get('metodospago/obtenerMetodosPago').then(response => {
                this.formaPago = response.data
            }).catch(e => notificacion());
        },
        resetearFormulario() {
            document.getElementById('modal_form_metodos_pago').reset();
            this.dataForm.idmp = '';
            this.dataForm.cmp = '';
            this.dataForm.nmp = '';
            this.dataForm.dmp = '';
        },
        modalMetodoDePago() {
            this.resetearFormulario();
            this.titulo = 'Guardar Métodos de Pago';
            this.accion = 'Guardar';
            $('#modalMetodoDePago').modal('show');
            $('#modalMetodoDePago').on('shown.bs.modal', function () {
                $('#cmp').trigger('focus');
            });
        },
        ver(id, codigo, nombre, descripcion) {
            this.dataForm.idmp = id;
            this.dataForm.cmp = codigo;
            this.dataForm.nmp = nombre;
            this.dataForm.dmp = descripcion;
            this.titulo = 'Editar Métodos de Pago';
            this.accion = 'Actualizar';
            $('#modalMetodoDePago').modal('show');
        },
        guardarEditar() {
            this.dataForm['token'] = $('meta[name=token]').attr('content');
            axios({
                method: 'post',
                url: 'metodospago/guardar',
                data: this.dataForm,
                transformRequest: serializar(),
            }).then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        $('#modalMetodoDePago').modal('hide');
                        notificacion('fa fa-check', 'Información', 'Operación realizada exitosamente', 'success');
                        this.resetearFormulario();
                        this.obtenerMetodosPago();
                    }
                } else {
                    let total_errores = response.data.errors.length;
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        modificarEstatus(mp_id, etiqueta) {
            axios.get('metodospago/modificarEstatus/' + Number(mp_id)).then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        let eti = document.getElementById(etiqueta);
                        eti.className = (eti.className === 'fa fa-times text-danger') ? 'fa fa-check text-success' : 'fa fa-times text-danger';
                        notificacion('fa fa-check', 'Actualizado', 'Estatus modificado', 'info');
                    }
                } else {
                    let total_errores = response.data.errors.length;
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        eliminar(mp_id, mp_nombre) {
            Swal.fire({
                title: '¡Eliminar metodo de pago!',
                text: "¿Estás seguro de eliminar el metodo de pago " + mp_nombre + "?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('metodospago/eliminar/' + Number(mp_id)).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                this.obtenerMetodosPago();
                                notificacion('fa fa-trash', 'Metodo de pago eliminado', mp_nombre.toUpperCase(), 'danger');
                            } else {
                                notificacion('fa fa-ban', 'Error al eliminar', mp_nombre.toUpperCase(), 'danger');
                            }
                        } else {
                            let total_errores = response.data.errors.length;
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion())
                }
            });
        },
    }
});