new Vue({
    el: '#appCarritoVer',
    data: {
        id_factura: document.getElementById('id_fac').value,
        cliente: document.getElementById('id_cliente_fac').value,
        div_nombre_master: '',
        div_locale: '',
        div_simbolo: '',
        div_decimal: 2,
        div_conv_factor: 1,
        factura: [],
        divisa_pagar: '',
        metodo_pagar: '',
        cuenta_pagar: '',
        abonos: [],
        cuentas: [],
        metodos_de_pagos: [],
        formDocumentos: { 'id_factura': '', 'descripcion': '', 'documento': '' },
        documentos: [],
        monto: 0,
        restante_original: 0,
        articulosTotal: 0,
        total_pagado: 0,
        descuento: 0,
        restante: 0,
        subtotal: 0,
        total: 0,
        neto: 0,
        iva: 0,
        divisa_predeterminada: '',
        almacen_predeterminado: '',
        serie_predeterminada: '',
        productos: [],
        carrito: [],
        money: {
            locale: '',
            decimal: '.',
            thousands: ',',
            prefix: '',
            suffix: '',
            precision: 2,
            masked: false /* doesn't work with directive */
        },
        moneyPagar: {
            locale: '',
            decimal: '.',
            thousands: ',',
            prefix: '',
            suffix: '',
            precision: 2,
            masked: false
        },
        moneyConver: {
            decimal: '.',
            thousands: ',',
            prefix: '',
            suffix: '',
            precision: 2,
            masked: false
        },
        cargando: false,
        errorForm: [],
        observacion_anular: '',
        cargando_documento: false,
        creditos: [],
        ver_contenedor_campos_pagar: true,
        select_credito: '',
        conv_factor: '',
        conv_simbolo: '',
        conv_locale: '',
        conv_precision: '',
        divisa_convertir_p: '',
        divisa_convertir_s: '',
        monto_conv: 0.00,
        diferencia_credito: 0.00,
        divisa_pagar_credito: '',
        metodo_pagar_credito: '',
        cuenta_pagar_credito: '',
        pagar_descripcion_credito: '',
        generar_credito: false,
        creditosFactura: [],
        idCreditoImprimir: ''
    },
    created() {
        axios.get('facturacioncajaeditar/obtenerFactura/' + this.id_factura).then(response => {
            this.factura = response.data.factura;
            this.almacen_predeterminado = this.factura.id_almacen;
            this.serie_predeterminada = this.factura.id_serie;
            this.divisa_predeterminada = this.factura.id_divisa;
            this.div_nombre_master = response.data.div_nombre;
            this.div_locale = response.data.div_locale;
            this.div_simbolo = response.data.div_simbolo;
            this.div_decimal = response.data.div_decimal;

            this.moneyPagar.locale = this.money.locale = response.data.divisa.locale;
            this.moneyPagar.prefix = this.money.prefix = response.data.divisa.symbol + ' ';
            this.moneyPagar.decimal = this.money.decimal = response.data.divisa.decimal;
            this.moneyPagar.thousands = this.money.thousands = response.data.divisa.thousands;
            this.moneyPagar.precision = this.money.precision = response.data.divisa.precision;

            this.articulosTotal = response.data.articulos_cantidad;
            this.subtotal = Number(response.data.subtotal).toFixed(this.money.precision);
            this.descuento = Number(response.data.descuento).toFixed(this.money.precision);
            this.neto = Number(response.data.neto).toFixed(this.money.precision);
            this.iva = Number(response.data.iva).toFixed(this.money.precision);
            this.total = Number(response.data.total).toFixed(this.money.precision);
            this.restante_original = Number(response.data.restante).toFixed(this.money.precision);
            this.restante = Number(response.data.restante).toFixed(this.money.precision);
            this.total_pagado = Number(response.data.total_pagado).toFixed(this.money.precision);
            this.carrito = response.data.data_carrito;
            this.abonos = response.data.abonos;
            this.creditosFactura = response.data.creditos;
            this.obtenerDocumentos();
        });

        this.obtenerCreditos();
    },
    methods: {
        obtenerCreditos() {
            this.ver_contenedor_campos_pagar = true;
            axios.get('notasdeentregaeditar/obtenerCreditos/' + this.cliente).then(response => {
                this.creditos = response.data;
            }).catch(e => notificacion()).finally(() => { });
        },
        obtenerCreditosFactura() {
            axios.get('poseditar/obtenerCreditosFactura/' + Number(this.id_factura)).then(response => {
                this.creditosFactura = response.data;
            }).catch(e => notificacion());
        },
        pagarConCredito() {
            let input_pagar = document.getElementById('pagarmonto');
            if (this.select_credito) {
                axios.get('facturacioncajaeditar/obtenerFactor', {
                    params: {
                        id_factura: this.id_factura,
                        id_credito: this.select_credito
                    }
                }).then(response => {
                    if (response.data.errors == null) {
                        this.monto = Number(response.data).toFixed(2);
                        this.ver_contenedor_campos_pagar = false;
                        input_pagar.disabled = true;
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => { });
            } else {
                this.monto = 0;
                this.ver_contenedor_campos_pagar = true;
                input_pagar.disabled = false;
            }
        },
        modalPagar() {
            document.getElementById('modal_form_pagar').reset();
            this.monto = 0.00;
            this.monto = Number(this.monto).toFixed(this.moneyPagar.precision);
            this.errorForm = [];
            this.divisa_pagar = '';
            this.metodo_pagar = '';
            this.metodos_de_pagos = [];
            this.cuenta_pagar = '';
            this.cuentas = [];
            axios.get('facturacioncajaeditar/comprobarFactura/' + this.id_factura).then(response => {
                if (response.data.errors == null) {
                    $('#modal_pagar').modal({ show: true, backdrop: 'static', keyboard: false });
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            });
        },
        obtenerMetodosSegunDivisa(event) {

            this.errorForm = [];
            this.metodo_pagar = '';
            this.metodos_de_pagos = [];
            this.cuenta_pagar = '';
            this.cuentas = [];

            if (!event.target.value)
                this.errorForm.push('La divisa es requerida');

            if (this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'facturacioncajaeditar/obtenerMetodosSegunDivisa',
                    data: { 'id_factura': this.id_factura, 'id_divisa': event.target.value },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data) {
                            this.moneyPagar.locale = response.data.divisa.locale;
                            this.moneyPagar.prefix = response.data.divisa.symbol + ' ';
                            this.moneyPagar.decimal = response.data.divisa.decimal;
                            this.moneyPagar.thousands = response.data.divisa.thousands;
                            this.moneyPagar.precision = response.data.divisa.precision;
                            this.metodos_de_pagos = response.data.data_metodos;
                            this.div_conv_factor = response.data.factor;
                            this.restante_original = Number(response.data.restante).toFixed(this.moneyPagar.precision);
                            this.restante = parseFloat(response.data.restante * response.data.factor).toFixed(this.moneyPagar.precision);
                            this.monto = Number(this.monto).toFixed(this.moneyPagar.precision);
                            //this.monto = this.restante;
                        }
                    } else {
                        this.divisa_pagar = '';
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        obtenerCuentasSegunMetodo(event) {
            this.errorForm = [];
            this.cuenta_pagar = '';
            this.cuentas = [];

            if (!event.target.value)
                this.errorForm.push('El Método de Pago es requerido');

            if (this.errorForm.length == 0) {
                axios.get('facturacioncajaeditar/obtenerCuentasSegunMetodo/' + event.target.value).then(response => {
                    if (response.data.errors == null) {
                        if (Array.isArray(response.data)) {
                            if (response.data.length > 0) {
                                this.cuentas = response.data;
                            }
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        pagar() {

            if (!this.ver_contenedor_campos_pagar) {
                axios.get('facturacioncajaeditar/pagarConCredito', {
                    params: {
                        id_fac: this.id_factura,
                        id_credito: this.select_credito
                    }
                }).then(response => {
                    console.log(response.data)
                    if (response.data.errors == null) {
                        if (response.data) {
                            this.monto = 0.00;
                            this.abonos = response.data.abonos;
                            this.restante_original = Number(response.data.restante).toFixed(this.moneyPagar.precision);
                            this.restante = parseFloat(response.data.restante * this.div_conv_factor).toFixed(this.moneyPagar.precision);
                            this.monto = Number(this.monto).toFixed(this.moneyPagar.precision);
                            this.total_pagado = Number(response.data.total_pagado).toFixed(this.moneyPagar.precision);
                            //this.monto = this.restante;
                            if (response.data.pagado) {
                                $('#modal_pagar').modal('hide');
                                notificacion('fa fa-check', 'Advertencia', 'Total de factura pagada', 'success');
                            } else {
                                notificacion('fa fa-check', 'Pago', 'Pago exitoso', 'success');
                            }
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                    this.obtenerCreditos();
                }).catch(e => notificacion()).finally(() => {
                    let input_pagar = document.getElementById('pagarmonto');
                    input_pagar.disabled = false;
                    input_pagar.value = '';
                });
            } else {

                this.errorForm = [];

                if (!this.divisa_pagar)
                    this.errorForm.push('El campo Divisa es obligatorio');
                if (!this.metodo_pagar)
                    this.errorForm.push('El campo Método es obligatorio');
                if (!this.cuenta_pagar)
                    this.errorForm.push('El campo Cuenta es obligatorio');
                if (!this.monto)
                    this.errorForm.push('El campo Monto es obligatorio');

                if (this.errorForm.length == 0) {
                    this.cargando = true;
                    axios({
                        method: 'post',
                        url: 'facturacioncajaeditar/pagar',
                        data: {
                            id_factura: this.id_factura,
                            id_divisa: this.divisa_pagar,
                            id_metodo_divisa: this.metodo_pagar,
                            id_cuenta_metodo: this.cuenta_pagar,
                            monto: this.monto,
                            credito: this.generar_credito
                        },
                        transformRequest: serializar(),
                    }).then(response => {
                        if (response.data.errors == null) {
                            if (response.data) {
                                this.monto = 0.00;
                                this.abonos = response.data.abonos;
                                this.restante_original = Number(response.data.restante).toFixed(this.moneyPagar.precision);
                                this.restante = parseFloat(response.data.restante * this.div_conv_factor).toFixed(this.moneyPagar.precision);
                                this.monto = Number(this.monto).toFixed(this.moneyPagar.precision);
                                this.total_pagado = Number(response.data.total_pagado).toFixed(this.moneyPagar.precision);
                                //this.monto = this.restante;
                                if (response.data.pagado) {
                                    $('#modal_pagar').modal('hide');
                                    notificacion('fa fa-check', 'Advertencia', 'Total de factura pagada', 'success');
                                } else {
                                    notificacion('fa fa-check', 'Pago', 'Pago exitoso', 'success');
                                }
                            }
                        } else {
                            let total_errores = response.data.errors.length
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => {
                        notificacion();
                    }).finally(() => {
                        this.cargando = false;
                        this.monto = 0;
                        this.divisa_pagar = ''
                        this.metodo_pagar = '';
                        this.cuenta_pagar = '';
                        this.obtenerCreditosFactura();
                    });
                } else {
                    let total_errores = this.errorForm.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                    }
                }
            }
        },
        eliminarPago(id) {
            axios({
                method: 'post',
                url: 'facturacioncajaeditar/eliminarPago',
                data: { 'id_factura': this.id_factura, 'id': id },
                transformRequest: serializar(),
            }).then(response => {
                if (response.data.errors == null) {
                    if (response.data) {
                        this.monto = 0.00;
                        this.abonos = response.data.abonos;
                        this.restante_original = Number(response.data.restante).toFixed(this.money.precision);
                        this.restante = parseFloat(response.data.restante * this.div_conv_factor).toFixed(this.money.precision);
                        this.monto = Number(this.monto).toFixed(this.money.precision);
                        this.total_pagado = Number(response.data.total_pagado).toFixed(this.money.precision);
                        //this.monto = this.restante;
                        notificacion('fa fa-trash', 'Eliminado', 'Pago eliminado', 'danger');
                    }
                } else {
                    this.divisa_pagar = '';
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        obtenerDocumentos() {
            axios.get('facturacioncajaeditar/obtnerDocumentos/' + this.id_factura).then(response => {
                this.documentos = response.data;
            });
        },
        moneda(num, div_locale_, div_simbolo_, decimal_ = 2) {
            if (Object.keys(this.carrito).length > 0) {
                let monto_ = convertir_a_float(String(num).toString());
                return monedaMoneda(monto_, div_locale_, div_simbolo_, decimal_);
            }
        },
        decimal(num, div_locale_, decimal_ = 2) {
            if (Object.keys(this.carrito).length > 0) {
                let monto_ = convertir_a_float(String(num).toString());
                return monedaDecimal(monto_, div_locale_, decimal_);
            }
        },
        modalAnular() {
            $('#modal_anular').modal();
            $('#modal_anular').on('shown.bs.modal', function () {
                $('#observacion_anular').trigger('focus')
            });
        },
        anular() {

            Swal.fire({
                title: '<strong>¿Anular factura?</strong>',
                showCloseButton: true,
                showCancelButton: true,
                focusConfirm: false,
                cancelButtonColor: '#aaa',
                confirmButtonColor: '#3085d6',
                confirmButtonText: 'Aceptar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.value) {
                    axios.get('facturacioncajaeditar/anularFactura', {
                        params: {
                            id_factura: this.id_factura,
                            descripcion: this.observacion_anular
                        }
                    }).then(response => {
                        if (response.data.errors == null) {
                            if (response.data !== false) {
                                location.href = response.data;
                            } else {
                                notificacion('fa fa-ban', 'Error', 'Error al anular la factura', 'danger');
                            }
                        } else {
                            let total_errores = response.data.errors.length
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion()).finally(() => this.cargando = false);
                }
            });
        },
        modalImprimirCredito(id_credito) {
            this.idCreditoImprimir = id_credito;
            $('#modal-imprimir-credito').modal();
        },
        imprimirCredito(id_impresora) {
            axios.get('poseditar/imprimirCredito', {
                params: {
                    id_credito: Number(this.idCreditoImprimir),
                    id_impresora: id_impresora
                }
            }).then(response => {
                console.log(response.data);
                if (response.data.errors == null) {
                    if (response.data !== false) {
                        fetch(response.data.ip_puerto, {
                            method: 'POST',
                            body: JSON.stringify(response.data.data)
                        }).then((j) => {
                            console.log(j);
                            if (j.ok) {
                                notificacion('fa fa-check', 'Impreso', 'Impresion exitosa', 'success');
                                axios.get('poseditar/facturaImpresa/' + Number(this.id_factura)).then(response => {
                                    notificacion('fa fa-info', '', response.data, 'info');
                                }).catch(e => {
                                    notificacion('fa fa-ban', 'No impreso', 'debe actualizar manualmente el documento como impreso', 'success');
                                });
                            } else {
                                notificacion('fa fa-ban', 'Error', 'Respuesta de red OK pero respuesta HTTP no OK', 'warning');
                            }
                        }).catch((error) => {
                            notificacion('fa fa-ban', 'Error', 'Hubo un problema con la petición Fetch:' + error.message, 'danger');
                        });
                    }
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());

        },
        modalImprimir(ruta) {
            this.errorForm = [];
            $('#modal-imprimir').modal();
        },
        imprimir(id) {
            axios.get('facturacioncajaeditar/imprimir', {
                params: {
                    id_factura: Number(this.id_factura),
                    impresora: id,
                }
            }).then(response => {
                console.log(response.data);
                if (response.data.data.errors == null) {
                    if (response.data !== false) {
                        fetch(response.data.ip_puerto, {
                            method: 'POST',
                            body: JSON.stringify(response.data.data)
                        }).then((j) => {
                            console.log(j)
                            if (j.ok) {
                                notificacion('fa fa-check', 'Impreso', 'Impresion exitosa', 'success');
                                axios.get('facturacioncajaeditar/facturaImpresa/' + Number(this.id_factura)).then(response => {
                                    notificacion('fa fa-info', '', response.data, 'info');
                                }).catch(e => {
                                    notificacion('fa fa-ban', 'No impreso', 'debe actualizar manualmente el documento como impreso', 'success');
                                });
                            } else {
                                notificacion('fa fa-ban', 'Error', 'Respuesta de red OK pero respuesta HTTP no OK', 'warning');
                            }
                        }).catch((error) => {
                            notificacion('fa fa-ban', 'Error', 'Hubo un problema con la petición Fetch:' + error.message, 'danger');
                        });
                    }
                } else {
                    let total_errores = response.data.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        conversor() {
            if (this.divisa_convertir_p && this.divisa_convertir_s) {
                axios.get('generico/conversion', {
                    params: {
                        'div_p': this.divisa_convertir_p,
                        'div_s': this.divisa_convertir_s
                    }
                }).then(response => {
                    if (!this.monto_conv) this.monto_conv = 0;
                    this.monto_conv = convertir_a_float(this.monto_conv);
                    this.monto_conv = this.monto_conv.toFixed(response.data.divisa_conv.precision);
                    this.moneyConver.decimal = response.data.divisa_conv.decimal;
                    this.moneyConver.thousands = response.data.divisa_conv.thousands;
                    this.moneyConver.prefix = response.data.divisa_conv.symbol;
                    this.moneyConver.precision = response.data.divisa_conv.precision;
                    this.conv_factor = response.data.factor;
                    this.conv_simbolo = response.data.divisa_result.symbol;
                    this.conv_local = response.data.divisa_result.locale;
                    this.conv_precision = response.data.divisa_result.precision;
                    let total = this.monto_conv * this.conv_factor;
                    total = monedaMoneda(total, this.conv_local, this.conv_simbolo, this.conv_precision);
                    document.getElementById('result_conv').value = total;
                }).catch(e => notificacion()).finally(() => {

                })
            }
        },
        convedorInput() {
            if (this.divisa_convertir_p && this.divisa_convertir_s) {
                let total = convertir_a_float(this.monto_conv) * this.conv_factor;
                total = monedaMoneda(total, this.conv_local, this.conv_simbolo, this.conv_precision);
                document.getElementById('result_conv').value = total;
            }
        },
        colocarEnMonto() {
            if (this.ver_contenedor_campos_pagar == true) {
                this.monto_conv = this.monto = Number(this.restante).toFixed(this.moneyPagar.precision);
            }
        },
        modalCrearCredito() {
            this.errorForm = [];
            this.divisa_pagar_credito = '';
            this.metodo_pagar_credito = '';
            this.cuenta_pagar_credito = '';
            this.pagar_descripcion_credito = '';
            this.cuentas = [];
            this.metodos_de_pagos = [];
            $('#modal_crear_credito').modal('show');
        },
        pagarCredito() {

            this.errorForm = [];

            if (!this.serie_predeterminada)
                this.errorForm.push('El campo Serie es obligatorio');
            if (!this.divisa_pagar_credito)
                this.errorForm.push('El campo Divisa es obligatorio');
            if (!this.metodo_pagar_credito)
                this.errorForm.push('El campo Método es obligatorio');
            if (!this.cuenta_pagar_credito)
                this.errorForm.push('El campo Cuenta es obligatorio');
            if (!this.diferencia_credito)
                this.errorForm.push('El campo Monto es obligatorio');

            if (this.errorForm.length == 0) {
                this.cargando = true;
                axios({
                    method: 'post',
                    url: 'poseditar/guardarCredito',
                    data: {
                        id_factura: this.id_factura,
                        id_serie: this.serie_predeterminada,
                        monto: this.diferencia_credito,
                        id_divisa: this.divisa_pagar_credito,
                        id_metodo_divisa: this.metodo_pagar_credito,
                        id_cuenta_metodo: this.cuenta_pagar_credito,
                        observacion: this.pagar_descripcion_credito
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    console.log(response.data);
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            notificacion('fa fa-check', '', 'Operación exitosa', 'success');
                        } else {
                            notificacion('fa fa-ban', 'Error', 'Error en la operación', 'danger');
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                    this.obtenerCreditosFactura();
                    this.divisa_pagar_credito = '';
                    this.metodo_pagar_credito = '';
                    this.cuenta_pagar_credito = '';
                    this.pagar_descripcion_credito = '';
                    this.cuentas = [];
                    this.metodos_de_pagos = [];
                    $('#modal_crear_credito').modal('hide');
                });
            }
        }
    },
    computed: {
        balance() {
            let total = convertir_a_float(String(this.restante));
            let monto = convertir_a_float(String(this.monto));
            let balance_ = (total - monto);
            if (balance_ <= 0) {
                balance_ = 0;
            }
            return this.moneda(balance_, this.moneyPagar.locale, this.moneyPagar.prefix, this.moneyPagar.precision);
        },
        diferencia_n() {
            let total = convertir_a_float(String(this.restante));
            let monto = convertir_a_float(String(this.monto));
            let balance_ = (total - monto);
            return balance_ = (balance_ <= 0) ? Math.abs(balance_) : 0;
        },
        diferencia() {
            let total = convertir_a_float(String(this.restante));
            let monto = convertir_a_float(String(this.monto));
            let balance_ = (total - monto);
            balance_ = (balance_ <= 0) ? Math.abs(balance_) : 0;
            return this.moneda(balance_, this.moneyPagar.locale, this.moneyPagar.prefix, this.moneyPagar.precision);
        }
    }
});