moment.locale('es', {
    months: 'Enero_Febrero_Marzo_Abril_Mayo_Junio_Julio_Agosto_Septiembre_Octubre_Noviembre_Diciembre'.split('_'),
    monthsShort: 'Enero._Feb._Mar_Abr._May_Jun_Jul._Ago_Sept._Oct._Nov._Dec.'.split('_'),
    weekdays: 'Domingo_Lunes_Martes_Miercoles_Jueves_Viernes_Sabado'.split('_'),
    weekdaysShort: 'Dom._Lun._Mar._Mier._Jue._Vier._Sab.'.split('_'),
    weekdaysMin: 'Do_Lu_Ma_Mi_Ju_Vi_Sa'.split('_'),
});

var fecha = new Date();

function padLeft(n) {
    return ("00" + n).slice(-2);
}

var mess = padLeft(fecha.getMonth() + 1);

Vue.component('v-select', VueSelect.VueSelect)

let vue=new Vue({
    el: '#appFactura',
    data: {
        facturasPagas: 0,
        facturasNoPagas: 0,
        facturasAnuladas: 0,
        notasdeentregaPagas: 0,
        notasdeentregaNoPagas: 0,
        notasdeentregaAnuladas: 0,
        pedidosPagas: 0,
        pedidosNoPagas: 0,
        presupuestosPagas: 0,
        presupuestosNoPagas: 0,
        ordenesPagas: 0,
        ordenesPendientes: 0,
        ordenesAnuladas: 0,
        ordenesCreditos: 0,
        filtro: 1,
        lineas: [],
        clientes: [],
        clienteEncontrado: true,
        ruta: '',
        errorForm: [],
        cargando: false,
        cargando_lineas: '',
        cargando_tabla: '',
        icon_buscador: 'fa fa-search',
        creditosActivos: [],
        creditosInactivos: [],
        detalleCredito: [],
        detalleCreditoId: '',
        detalleCreditoTotal: 0,
        metodos_de_pagos: [],
        cuentas: [],
        monto: 0,
        divisa_pagar: '',
        metodo_pagar: '',
        cuenta_pagar: '',
        pagardescripcion: '',
        money: {
            decimal: '.',
            thousands: ',',
            prefix: '',
            suffix: '',
            precision: 2,
            masked: false /* doesn't work with directive */
        },
        selected_cli: [],
        serie: '',
        dataFormFactor: '',
        titulo: '',
        divisasDiferentes: [],
        errorFormFactor: [],
        id_nota_cre_imp: '',
        sucursal_predeterminada: '',
        sucursales_empleado: [],
        disabled:false,
        tipoci:2,
        fact:false,
        clidni:'',
        fecha_desde: moment().format('YYYY-MM-DD'),
        fecha_hasta: moment().format('YYYY-MM-DD'),
        proveedores: [],
        proveedor: 0,
        totalproveedores:[],
        productos:[],
        total_divisas_p: [],
        total_divisas_n: [],
        cierres_del_dia: {
            positivo: [],
            negativo: [],
        },
        divisa:0,
        divisa_mes:0,
        productosVendido: [],
        costo_total: 0,
        venta_total: 0,
        artic_total: 0,
        ganancia: 0,
        ganancia_porc: 0,
        cantidad_articulos: 0,
        estatus_documentos: 0,
        agente: 0,
        productosVendidoDocumentos: [],
        costo_totalD: 0,
        venta_totalD: 0,
        artic_totalD: 0,
        gananciaD: 0,
        ganancia_porcD: 0,
        cantidad_articulosD: 0,
        cantidad_articulosS: 0,
        venta_totalS: 0,
        artic_totalS: 0,
        productosVendidoSimples: [],
        documento: 0,
        pendientedia: 0,
        acumuladodia: 0,
        artic_totaldia: 0,
        cantidad_artdia:0,
        totaldia: 0,
        productosVendidoDia: [],
        anio: moment().format('YYYY'),
        mes: moment().format('MM'),
        dias_ventas:[],
        art_total_D:0,
        costo_D: 0,
        venta_D: 0,
        ganancia_D: 0,
        porcentaje_D: 0,
        meses_ventas:[],
        art_total_m:0,
        costo_m: 0,
        venta_m: 0,
        ganancia_m: 0,
        porcentaje_m: 0,
        clipp:[],
        filtro: 1,
        productosPrecVenta:[],
        horas: [],
        art_totald: 0,
        costod: 0,
        ventad: 0,
        gananciad: 0,
        porcentajed: 0,
    },
    created() {
        axios
            .get("facturacion/obtenerSucursalesEmpleado")
            .then((response) => {
                this.sucursales_empleado = response.data.sucursales;
                this.sucursal_predeterminada = response.data.id;
                if(response.data.desactivar==true){
                 this.disabled=true
                }
                this.actualizarDatos();
                this.proveedoresActivos();
            })
            .catch((e) => notificacion());
    },
    methods: {
        obtener_clpp(){
            $('#tabla_factura_pendientes').DataTable().destroy();
            $('#tabla_notas_pendientes').DataTable().destroy();
            $('#tabla_ordenes_pendientes').DataTable().destroy();
            axios({
                method: 'get',
                url: 'facturacion/obtenerClientesConDocumentosPendientesPorPagar'
            }).then(response => {
                this.clipp = response.data;
            }).catch(e => notificacion()).finally(() => {
                var buttonCommon2 = {
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5,6,7,8,9,10,11],
                        format: {
                            body: function(data, row, column, node) {
                                if (column === 7 || column === 8 || column === 9) {
                                    return convertir_a_float(data)
                                } else {
                                    return data.replace(/<[^>]*>?/g, '');
                                }
                            }
                        }
                    }
                };
            
                $("#tabla_factura_pendientes").DataTable({
                    order: [],
                    dom: 'Bfrtip',
                    buttons: [
                        $.extend(true, {}, buttonCommon2, {
                            extend: 'excelHtml5',
                            title: 'Clientes con FACTURA pendientes por cobrar ' + moment().format('DD-MM-YYYY'),
                        })
                    ]
                });
                $("#tabla_notas_pendientes").DataTable({
                    order: [],
                    dom: 'Bfrtip',
                    buttons: [
                        $.extend(true, {}, buttonCommon2, {
                            extend: 'excelHtml5',
                            title: 'Clientes con NOTA DE ENTREGA pendientes por cobrar ' + moment().format('DD-MM-YYYY'),
                        }),
                    ]
                });
                $("#tabla_ordenes_pendientes").DataTable({
                    order: [],
                    dom: 'Bfrtip',
                    buttons: [
                        $.extend(true, {}, buttonCommon2, {
                            extend: 'excelHtml5',
                            title: 'Clientes con ORDEN DE ENTREGA pendientes por cobrar ' + moment().format('DD-MM-YYYY'),
                        }),
                    ]
                });
            });
        },
        actualizarDatos(){
            this.obtenerFacturasTodas();
            this.obtenerCreditosTodas();
            this.obtenerNotasdeEntrega();
            this.obtenerPresupuestoTodas();
            this.obtenerPedidosTodas();
            this.obtenerOrdendeEntrega();
        },
        obtenerCantFactura(){
            axios({
                method: 'post',
                url: 'facturacion/obtenerFacturas',
                data:  {
                    anio: this.anio,
                    mes: this.mes,
                    sucursal: this.sucursal_predeterminada
                },
                transformRequest: serializar(),
            }).then(response => {
                this.facturasNoPagas = response.data.pendientes;
                this.facturasPagas = response.data.pagadas;
                this.facturasAnuladas =response.data.anuladas;
            }).catch(e => notificacion()).finally(() => {
            });
        },
        obtenerFacturasPendientes() {   
            $('#table_facturas_pendientes').DataTable().destroy();

            var tabla=$('#table_facturas_pendientes').DataTable({
                'processing': true,
                'serverSide': true,
                'destroy': true,
                'serverMethod': 'post',
                'autoWidth':false,
                'order':[[5,'desc']],
                //'dom': 'Bfrtip',
                //'buttons': [
               //     'colvis'
               // ],
                'ajax':{
                    'url':'facturacion/obtenerFacturasPendientes',
                        'data':{
                            'anio': this.anio,
                            'mes': this.mes,
                            'sucursal':this.sucursal_predeterminada
                        },
                },
                'columnDefs': [
                    {width:"7%",
                    targets:"0"},
                    {width:"35%",
                    targets:"1"},
                    {width:"12%",
                    targets:"2"},
                    {width:"12%",
                    targets:"3"},
                    {width:"12%",
                    targets:"4"},
                    {width:"12%",
                    targets:"5"},
                    {width:"6%",
                    targets:"6"}
                ],
                'columns': [
                    { data: 'fm_correlativo',
                        render:function (data,type,row) {
                            return "<a href='"+row.uri+"'>"+row.fm_correlativo+"</a>";
                        }
                },
                    { data: 'cli_razon_social',
                         render:function (data,type,row) {
                             let ico=(row.msj==true)? "<i class='far fa-paper-plane text-warning' style='font-size: 16px;'></i>":"";
                             let ico2=(row.correo==true)? "<i class='far fa-envelope text-warning' style='font-size: 16px;'></i>":"";
                             let observacion="<small class='badge ml-2' style='background: #f2f2f2;color: #020202;white-space: normal;'>"+row.observacion+"</small>";
                            return row.cli_razon_social+' '+observacion+' '+ico+' '+ico2;
                        }
                    },
                    { data: 'acumulado'},
                    { data: 'pendiente' },
                    { data: 'total' },
                    { data: 'fm_fecha' },
                    {
                        data:'fm_id',
                        render:function (data,type,row) {
                            return "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>";
                        }
                    },
                    //{ defaultContent: "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>" },
                ],
                'footerCallback': function (row, data, start, end, display) {
                    var api = this.api(),
                        data;
                        
                        pageTotal = api
                        .column(4, { page: 'current' })
                        .data()
                        .reduce(function (a, b) {
                            return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                        }, 0);

                    $(api.column(4).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                    pageTotal = api
                        .column(3, { page: 'current' })
                        .data()
                        .reduce(function (a, b) {
                            return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                        }, 0);

                    $(api.column(3).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                    pageTotal = api
                        .column(2, { page: 'current' })
                        .data()
                        .reduce(function (a, b) {
                            return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                        }, 0);

                    $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                }
            });
            
            $("#table_facturas_pendientes tbody").on('click','button',function () {
                let tb=$('#table_facturas_pendientes').DataTable();
                var datos=tb.row($(this).parents("tr")).data();
                vue.finalizarFactura(datos,1);
            });
            this.obtenerCantFactura();
        },
        obtenerFacturasPagadas() {   
            $('#table_facturas_pagadas').DataTable().destroy();

            var tabla=$('#table_facturas_pagadas').DataTable({
                'processing': true,
                'serverSide': true,
                'destroy': true,
                'serverMethod': 'post',
                'autoWidth':false,
                'order':[[3,'desc']],
                //'dom': 'Bfrtip',
                //'buttons': [
               //     'colvis'
               // ],
                'ajax':{
                    'url':'facturacion/obtenerFacturasPagas',
                        'data':{
                            'anio': this.anio,
                            'mes': this.mes,
                            'sucursal':this.sucursal_predeterminada
                        },
                },
                'columnDefs': [
                    {width:"10%",
                    targets:"0"},
                    {width:"50%",
                    targets:"1"},
                    {width:"20%",
                    targets:"2"},
                    {width:"10%",
                    targets:"3"},
                    {width:"10%",
                    targets:"4"}
                ],
                'columns': [
                    { data: 'fm_correlativo',
                        render:function (data,type,row) {
                            return "<a href='"+row.uri+"'>"+row.fm_correlativo+"</a>";
                        }
                },
                    { data: 'cli_razon_social',
                         render:function (data,type,row) {
                             let ico=(row.msj==true)? "<i class='far fa-paper-plane text-warning' style='font-size: 16px;'></i>":"";
                             let ico2=(row.correo==true)? "<i class='far fa-envelope text-warning' style='font-size: 16px;'></i>":"";
                             let observacion="<small class='badge ml-2' style='background: #f2f2f2;color: #020202;white-space: normal;'>"+row.observacion+"</small>";
                            return row.cli_razon_social+' '+observacion+' '+ico+' '+ico2;
                        }
                    },
                    { data: 'total' },
                    { data: 'fm_fecha' },
                    {
                        data:'fm_id',
                        render:function (data,type,row) {
                            return "<button type='button' id='estatus' class='pagadas btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>";
                        }
                    },
                    //{ defaultContent: "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>" },
                ],
                "footerCallback": function (row, data, start, end, display) {
                    var api = this.api(),
                        data;

                    pageTotal = api
                        .column(2, { page: 'current' })
                        .data()
                        .reduce(function (a, b) {
                            return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                        }, 0);

                    $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                }
            });
            
            $("#table_facturas_pagadas tbody").on('click','button.pagadas',function () {
                let tb=$('#table_facturas_pagadas').DataTable();
                var datos=tb.row($(this).parents("tr")).data();
                vue.finalizarFactura(datos,2);
            });

        },
        obtenerFacturasAnuladas() {   
            $('#table_facturas_anuladas').DataTable().destroy();

            var tabla=$('#table_facturas_anuladas').DataTable({
                'processing': true,
                'serverSide': true,
                'destroy': true,
                'serverMethod': 'post',
                'autoWidth':false,
                'order':[[5,'desc']],
                //'dom': 'Bfrtip',
                //'buttons': [
               //     'colvis'
               // ],
                'ajax':{
                    'url':'facturacion/obtenerFacturasAnuladas',
                        'data':{
                            'anio': this.anio,
                            'mes': this.mes,
                            'sucursal':this.sucursal_predeterminada
                        },
                },
                'columnDefs': [
                    {width:"10%",
                    targets:"0"},
                    {width:"40%",
                    targets:"1"},
                    {width:"20%",
                    targets:"2"},
                    {width:"10%",
                    targets:"3"},
                    {width:"10%",
                    targets:"4"},
                    {width:"10%",
                    targets:"4"}
                ],
                'columns': [
                    { data: 'fm_correlativo',
                        render:function (data,type,row) {
                            return "<a href='"+row.uri+"'>"+row.fm_correlativo+"</a>";
                        }
                },
                    { data: 'cli_razon_social',
                         render:function (data,type,row) {
                             let ico=(row.msj==true)? "<i class='far fa-paper-plane text-warning' style='font-size: 16px;'></i>":"";
                             let ico2=(row.correo==true)? "<i class='far fa-envelope text-warning' style='font-size: 16px;'></i>":"";
                           let observacion="<small class='badge ml-2' style='background: #f2f2f2;color: #020202;white-space: normal;'>"+row.observacion+"</small>";
                            return row.cli_razon_social+' '+observacion+' '+ico+' '+ico2;
                        }
                    },
                    { data: 'acumulado'},
                    { data: 'pendiente' },
                    { data: 'total' },
                    { data: 'fm_fecha' }
                    //{ defaultContent: "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>" },
                ],
                "footerCallback": function (row, data, start, end, display) {
                    var api = this.api(),
                        data;

                    pageTotal = api
                        .column(4, { page: 'current' })
                        .data()
                        .reduce(function (a, b) {
                            return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                        }, 0);

                    $(api.column(4).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                    pageTotal = api
                        .column(3, { page: 'current' })
                        .data()
                        .reduce(function (a, b) {
                            return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                        }, 0);

                    $(api.column(3).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                    pageTotal = api
                        .column(2, { page: 'current' })
                        .data()
                        .reduce(function (a, b) {
                            return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                        }, 0);

                    $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                }
            });
        },
        obtenerFacturasTodas(){
            this.obtenerFacturasPendientes();
            this.obtenerFacturasPagadas();
            this.obtenerFacturasAnuladas();
        },
        //nota de entrega
        obtenerNotasdeEntrega(){
            this.obtenerNotasdeEntregaPendientes();
            this.obtenerNotasdeEntregaPagadas();
            this.obtenerNotasdeEntregaAnuladas();
            this.obtenerCantNotadeEntrega();
        },
        obtenerCantNotadeEntrega(){
            axios({
                method: 'post',
                url: 'facturacion/obtenerNotasdeEntrega',
                data:  {
                    anio: this.anio,
                    mes: this.mes,
                    sucursal: this.sucursal_predeterminada
                },
                transformRequest: serializar(),
            }).then(response => {
                this.notasdeentregaNoPagas = response.data.pendientes;
                this.notasdeentregaPagas = response.data.pagadas;
                this.notasdeentregaAnuladas =response.data.anuladas;
            }).catch(e => notificacion()).finally(() => {
            });
        },
        obtenerNotasdeEntregaPendientes() {   
            $('#table_notasdeentrega_pendientes').DataTable().destroy();

            var tabla=$('#table_notasdeentrega_pendientes').DataTable({
                'processing': true,
                'serverSide': true,
                'destroy': true,
                'serverMethod': 'post',
                'autoWidth':false,
                'order':[[5,'desc']],
                //'dom': 'Bfrtip',
                //'buttons': [
               //     'colvis'
               // ],
                'ajax':{
                    'url':'facturacion/obtenerNotasdeEntregaAnualesPendientes',
                        'data':{
                            'anio': this.anio,
                            'mes': this.mes,
                            'sucursal':this.sucursal_predeterminada,
                            'funcion':'notas_pendientes'
                        },
                },
                'columnDefs': [
                    {width:"7%",
                    targets:"0"},
                    {width:"35%",
                    targets:"1"},
                    {width:"12%",
                    targets:"2"},
                    {width:"12%",
                    targets:"3"},
                    {width:"12%",
                    targets:"4"},
                    {width:"12%",
                    targets:"5"},
                    {width:"6%",
                    targets:"6"}
                ],
                'columns': [
                    { data: 'ne_correlativo',
                        render:function (data,type,row) {
                            return "<a href='"+row.uri+"'>"+row.ne_correlativo+"</a>";
                        }
                },
                    { data: 'cli_razon_social',
                         render:function (data,type,row) {
                             let ico=(row.msj==true)? "<i class='far fa-paper-plane text-warning' style='font-size: 16px;'></i>":"";
                             let ico2=(row.correo==true)? "<i class='far fa-envelope text-warning' style='font-size: 16px;'></i>":"";
                            let observacion="<small class='badge ml-2' style='background: #f2f2f2;color: #020202;white-space: normal;'>"+row.observacion+"</small>";
                            return row.cli_razon_social+' '+observacion+' '+ico+' '+ico2;
                        }
                    },
                    { data: 'acumulado'},
                    { data: 'pendiente' },
                    { data: 'total' },
                    { data: 'ne_fecha' },
                    {
                        data:'ne_id',
                        render:function (data,type,row) {
                            return "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>";
                        }
                    },
                    //{ defaultContent: "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>" },
                ],
                'footerCallback': function (row, data, start, end, display) {
                    var api = this.api(),
                        data;

                    pageTotal = api
                        .column(4, { page: 'current' })
                        .data()
                        .reduce(function (a, b) {
                            return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                        }, 0);

                    $(api.column(4).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                    pageTotal = api
                        .column(3, { page: 'current' })
                        .data()
                        .reduce(function (a, b) {
                            return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                        }, 0);

                    $(api.column(3).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                    pageTotal = api
                        .column(2, { page: 'current' })
                        .data()
                        .reduce(function (a, b) {
                            return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                        }, 0);

                    $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                   
                }
            });
            
            $("#table_notasdeentrega_pendientes tbody").on('click','button.pendiente',function () {
                let tb=$('#table_notasdeentrega_pendientes').DataTable();
                var datos=tb.row($(this).parents("tr")).data();
                vue.finalizarNota(datos,1);
            });
        },
        obtenerNotasdeEntregaPagadas() {
            $('#table_notasdeentrega_pagadas').DataTable().destroy();

            var tabla=$('#table_notasdeentrega_pagadas').DataTable({
                'processing': true,
                'serverSide': true,
                'destroy': true,
                'serverMethod': 'post',
                'autoWidth':false,
                 'order':[[3,'desc']],
                //'dom': 'Bfrtip',
                //'buttons': [
               //     'colvis'
               // ],
                'ajax':{
                    'url':'facturacion/obtenerNotasdeEntregaAnualesPagadas',
                        'data':{
                            'anio': this.anio,
                            'mes': this.mes,
                            'sucursal':this.sucursal_predeterminada
                        }
                },
                'columnDefs': [
                    {width:"10%",
                    targets:"0"},
                    {width:"50%",
                    targets:"1"},
                    {width:"20%",
                    targets:"2"},
                    {width:"10%",
                    targets:"3"},
                    {width:"10%",
                    targets:"4"}
                ],
                'columns': [
                    { data: 'ne_correlativo',
                        render:function (data,type,row) {
                            return "<a href='"+row.uri+"'>"+row.ne_correlativo+"</a>";
                        }
                },
                     { data: 'cli_razon_social',
                         render:function (data,type,row) {
                             let ico=(row.msj==true)? "<i class='far fa-paper-plane text-warning' style='font-size: 16px;'></i>":"";
                             let ico2=(row.correo==true)? "<i class='far fa-envelope text-warning' style='font-size: 16px;'></i>":"";
                           let observacion="<small class='badge ml-2' style='background: #f2f2f2;color: #020202;white-space: normal;'>"+row.observacion+"</small>";
                            return row.cli_razon_social+' '+observacion+' '+ico+' '+ico2;
                        }
                    },
                    { data: 'total' },
                    { data: 'ne_fecha' },
                    {
                        data:'ne_id',
                        render:function (data,type,row) {
                            return "<button type='button' id='estatus' class='pagadas btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>";
                        }
                    },
                    //{ defaultContent: "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>" },
                ],
                'footerCallback': function (row, data, start, end, display) {
                    var api = this.api(),
                        data;

                    pageTotal = api
                        .column(2, { page: 'current' })
                        .data()
                        .reduce(function (a, b) {
                            return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                        }, 0);

                    $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                }
            });

            $("#table_notasdeentrega_pagadas tbody").on('click','button.pagadas',function () {
                let tb=$('#table_notasdeentrega_pagadas').DataTable();
                var datos=tb.row($(this).parents("tr")).data();
                vue.finalizarNota(datos,2);
            });
        },
        obtenerNotasdeEntregaAnuladas() {
            $('#table_notasdeentrega_anuladas').DataTable().destroy();

            var tabla=$('#table_notasdeentrega_anuladas').DataTable({
                'processing': true,
                'serverSide': true,
                'destroy': true,
                'autoWidth':false,
                'order':[[5,'desc']],
                'serverMethod': 'post',
                //'dom': 'Bfrtip',
                //'buttons': [
               //     'colvis'
               // ],
                'ajax':{
                    'url':'facturacion/obtenerNotasdeEntregaAnualesAnuladas',
                        'data':{
                            'anio': this.anio,
                            'mes': this.mes,
                            'sucursal':this.sucursal_predeterminada
                        }
                },
                'columnDefs': [
                    {width:"7%",
                    targets:"0"},
                    {width:"35%",
                    targets:"1"},
                    {width:"12%",
                    targets:"2"},
                    {width:"12%",
                    targets:"3"},
                    {width:"12%",
                    targets:"4"},
                    {width:"12%",
                    targets:"5"}
                ],
                'columns': [
                    { data: 'ne_correlativo',
                        render:function (data,type,row) {
                            return "<a href='"+row.uri+"'>"+row.ne_correlativo+"</a>";
                        }
                },
                   { data: 'cli_razon_social',
                         render:function (data,type,row) {
                             let ico=(row.msj==true)? "<i class='far fa-paper-plane text-warning' style='font-size: 16px;'></i>":"";
                             let ico2=(row.correo==true)? "<i class='far fa-envelope text-warning' style='font-size: 16px;'></i>":"";
                             let observacion="<small class='badge ml-2' style='background: #f2f2f2;color: #020202;white-space: normal;'>"+row.observacion+"</small>";
                            return row.cli_razon_social+' '+observacion+' '+ico+' '+ico2;
                        }
                    },
                    { data: 'acumulado'},
                    { data: 'pendiente' },
                    { data: 'total' },
                    { data: 'ne_fecha' }
                    //{ defaultContent: "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>" },
                ],
                'footerCallback': function (row, data, start, end, display) {
                    var api = this.api(),
                        data;

                    pageTotal = api
                        .column(4, { page: 'current' })
                        .data()
                        .reduce(function (a, b) {
                            return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                        }, 0);

                    $(api.column(4).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                    pageTotal = api
                        .column(3, { page: 'current' })
                        .data()
                        .reduce(function (a, b) {
                            return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                        }, 0);

                    $(api.column(3).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                    pageTotal = api
                        .column(2, { page: 'current' })
                        .data()
                        .reduce(function (a, b) {
                            return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                        }, 0);

                    $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                }
            });
        },
        //presupuesto
        obtenerPresupuestoTodas(){
            this.obtenerPresupuestoPendientes();
            this.obtenerPresupuestoPagadas();
            this.obtenerCantPresupuesto();
        },
        obtenerCantPresupuesto(){
            axios({
                method: 'post',
                url: 'facturacion/obtenerPresupuestos',
                data:  {
                    anio: this.anio,
                    mes: this.mes,
                    sucursal: this.sucursal_predeterminada
                },
                transformRequest: serializar(),
            }).then(response => {
                this.presupuestosNoPagas = response.data.pendientes;
                this.presupuestosPagas = response.data.pagadas;
                
            }).catch(e => notificacion()).finally(() => {
            });
        },
        obtenerPresupuestoPendientes() {   
            $('#table_presupuesto_pendientes').DataTable().destroy();

            var tabla=$('#table_presupuesto_pendientes').DataTable({
                'processing': true,
                'serverSide': true,
                'destroy': true,
                'serverMethod': 'post',
                'autoWidth':false,
                'order':[[3,'desc']],
                //'dom': 'Bfrtip',
                //'buttons': [
               //     'colvis'
               // ],
                'ajax':{
                    'url':'facturacion/obtenerPresupuestosPendientes',
                        'data':{
                            'anio': this.anio,
                            'mes': this.mes,
                            'sucursal':this.sucursal_predeterminada
                        },
                },
                'columnDefs': [
                    {width:"10%",
                    targets:"0"},
                    {width:"50%",
                    targets:"1"},
                    {width:"30%",
                    targets:"2"},
                    {width:"10%",
                    targets:"3"}
                ],
                'columns': [
                    { data: 'pre_correlativo',
                        render:function (data,type,row) {
                            return "<a href='"+row.uri+"'>"+row.pre_correlativo+"</a>";
                        }
                },
                    { data: 'cli_razon_social' },
                    { data: 'total' },
                    { data: 'pre_fecha' },
                    //{ defaultContent: "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>" },
                ],
                "footerCallback": function (row, data, start, end, display) {
                    var api = this.api(),
                        data;

                    pageTotal = api
                        .column(2, { page: 'current' })
                        .data()
                        .reduce(function (a, b) {
                            return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                        }, 0);

                    $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                }
            });
            
        },
        obtenerPresupuestoPagadas() {
            $('#table_presupuesto_pagadas').DataTable().destroy();

            var tabla=$('#table_presupuesto_pagadas').DataTable({
                'processing': true,
                'serverSide': true,
                'destroy': true,
                'serverMethod': 'post',
                'autoWidth':false,
                'order':[[3,'desc']],
                //'dom': 'Bfrtip',
                //'buttons': [
               //     'colvis'
               // ],
                'ajax':{
                    'url':'facturacion/obtenerPresupuestosPagadas',
                        'data':{
                            'anio': this.anio,
                            'mes': this.mes,
                            'sucursal':this.sucursal_predeterminada
                        }
                },
                'columnDefs': [
                    {width:"10%",
                    targets:"0"},
                    {width:"50%",
                    targets:"1"},
                    {width:"20%",
                    targets:"2"},
                    {width:"10%",
                    targets:"3"}
                ],
                'columns': [
                    { data: 'pre_correlativo',
                        render:function (data,type,row) {
                            return "<a href='"+row.uri+"'>"+row.pre_correlativo+"</a>";
                        }
                },
                    { data: 'cli_razon_social' },
                    { data: 'total' },
                    { data: 'pre_fecha' },
                    
                    //{ defaultContent: "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>" },
                ],
                "footerCallback": function (row, data, start, end, display) {
                    var api = this.api(),
                        data;

                    pageTotal = api
                        .column(2, { page: 'current' })
                        .data()
                        .reduce(function (a, b) {
                            return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                        }, 0);

                    $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                }
            });
        },
        //pedidos
        obtenerPedidosTodas(){
            this.obtenerPedidosPendientes();
            this.obtenerPedidosPagadas();
            this.obtenerCantPedido();
        },
        obtenerCantPedido(){
            axios({
                method: 'post',
                url: 'facturacion/obtenerPedidos',
                data:  {
                    anio: this.anio,
                    mes: this.mes,
                    sucursal: this.sucursal_predeterminada
                },
                transformRequest: serializar(),
            }).then(response => {
                this.pedidosNoPagas = response.data.pendientes;
                this.pedidosPagas = response.data.pagadas;
                
            }).catch(e => notificacion()).finally(() => {
            });
        },
        obtenerPedidosPendientes() {   
            $('#table_pedidos_pendientes').DataTable().destroy();

            var tabla=$('#table_pedidos_pendientes').DataTable({
                'processing': true,
                'serverSide': true,
                'destroy': true,
                'serverMethod': 'post',
                'autoWidth':false,
                'order':[[3,'desc']],
                //'dom': 'Bfrtip',
                //'buttons': [
               //     'colvis'
               // ],
                'ajax':{
                    'url':'facturacion/obtenerPedidosPendientes',
                        'data':{
                            'anio': this.anio,
                            'mes': this.mes,
                            'sucursal':this.sucursal_predeterminada
                        },
                },
                'columnDefs': [
                    {width:"10%",
                    targets:"0"},
                    {width:"50%",
                    targets:"1"},
                    {width:"30%",
                    targets:"2"},
                    {width:"10%",
                    targets:"3"},
                    {width:"10%",
                    targets:"4"}
                ],
                'columns': [
                    { data: 'pe_correlativo',
                        render:function (data,type,row) {
                            return "<a href='"+row.uri+"'>"+row.pe_correlativo+"</a>";
                        }
                },
                    { data: 'cli_razon_social' },
                    { data: 'total' },
                    { data: 'pe_fecha' },
                    {
                        data:'pe_id',
                        render:function (data,type,row) {
                            return "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>";
                        }
                    },
                    //{ defaultContent: "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>" },
                ],
                "footerCallback": function (row, data, start, end, display) {
                    var api = this.api(),
                        data;

                    pageTotal = api
                        .column(2, { page: 'current' })
                        .data()
                        .reduce(function (a, b) {
                            return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                        }, 0);

                    $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                }
            });

            $("#table_pedidos_pendientes tbody").on('click','button.pendiente',function () {
                let tb=$('#table_pedidos_pendientes').DataTable();
                var datos=tb.row($(this).parents("tr")).data();
                vue.finalizarPedido(datos,1);
            });
            
        },
        obtenerPedidosPagadas() {
            $('#table_pedidos_pagadas').DataTable().destroy();

            var tabla=$('#table_pedidos_pagadas').DataTable({
                'processing': true,
                'serverSide': true,
                'destroy': true,
                'serverMethod': 'post',
                'autoWidth':false,
                'order':[[3,'desc']],
                //'dom': 'Bfrtip',
                //'buttons': [
               //     'colvis'
               // ],
                'ajax':{
                    'url':'facturacion/obtenerPedidosPagadas',
                        'data':{
                            'anio': this.anio,
                            'mes': this.mes,
                            'sucursal':this.sucursal_predeterminada
                        }
                },
                'columnDefs': [
                    {width:"10%",
                    targets:"0"},
                    {width:"50%",
                    targets:"1"},
                    {width:"20%",
                    targets:"2"},
                    {width:"10%",
                    targets:"3"},
                    {width:"10%",
                    targets:"4"}
                ],
                'columns': [
                    { data: 'pe_correlativo',
                        render:function (data,type,row) {
                            return "<a href='"+row.uri+"'>"+row.pe_correlativo+"</a>";
                        }
                },
                    { data: 'cli_razon_social' },
                    { data: 'total' },
                    { data: 'pe_fecha' },
                    {
                        data:'pe_id',
                        render:function (data,type,row) {
                            return "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>";
                        }
                    },
                    
                    //{ defaultContent: "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>" },
                ],
                "footerCallback": function (row, data, start, end, display) {
                    var api = this.api(),
                        data;

                    pageTotal = api
                        .column(2, { page: 'current' })
                        .data()
                        .reduce(function (a, b) {
                            return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                        }, 0);

                    $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                }
            });

            $("#table_pedidos_pagadas tbody").on('click','button',function () {
                let tb=$('#table_pedidos_pagadas').DataTable();
                var datos=tb.row($(this).parents("tr")).data();
                vue.finalizarPedido(datos,2);
            });
        },
        //nota de credito
        obtenerCantCredito(){
            axios({
                method: 'post',
                url: 'facturacion/obtenerCreditos',
                data:  {
                    anio: this.anio,
                    mes: this.mes,
                    sucursal: this.sucursal_predeterminada
                },
                transformRequest: serializar(),
            }).then(response => {
                this.creditosActivos = response.data.pendientes;
                this.creditosInactivos = response.data.pagadas;
                
            }).catch(e => notificacion()).finally(() => {
            });
        },
        obtenerCredito_activos() {   
            $('#table_creditos_activos').DataTable().destroy();

            var tabla=$('#table_creditos_activos').DataTable({
                'processing': true,
                'serverSide': true,
                'destroy': true,
                'serverMethod': 'post',
                'autoWidth':false,
                'order':[[5,'desc']],
                //'dom': 'Bfrtip',
                //'buttons': [
               //     'colvis'
               // ],
                'ajax':{
                    'url':'facturacion/obtenerCreditosActivos',
                        'data':{
                            'anio': this.anio,
                            'mes': this.mes,
                            'sucursal':this.sucursal_predeterminada
                        },
                },
                'columnDefs': [
                    {width:"10%",
                    targets:"0"},
                    {width:"20%",
                    targets:"1"},
                    {width:"10%",
                    targets:"2"},
                    {width:"10%",
                    targets:"3"},
                    {width:"8%",
                    targets:"4"},
                    {width:"10%",
                    targets:"5"},
                    {width:"20%",
                    targets:"6"},
                    {width:"10%",
                    targets:"7"}
                ],
                'columns': [
                    { data: 'cre_id',
                        render:function (data,type,row) {
                            return "NCV"+row.cre_id;
                        }
                  },
                {
                    data:'uri',
                        render:function (data,type,row) {
                            return (row.uri !== '')?'<a href="'+row.uri+'">'+row.documento+"</a>":'CREDITO';
                        }
                    },
                    { data: 'cli_razon_social' },
                    { data: 'monto' },
                    { data: 'restante' },
                    { data: 'cre_fecha' },
                    { data: 'descripcion' },
                        {
                        data:null,
                        render:function (data,type,row) {
                            return "<button type='button' id='"+row.cre_id+"' class='imprimir btn btn-icon btn-sm btn-light'><i class='fas fa-print text-primary' style='padding: .65rem;'></i></button>"+
                            "<button  type='button' id='"+row.cre_id+"' class='movimiento btn btn-icon btn-sm btn-light'><i class='fas fa-eye text-info' style='padding: .65rem;'></i></button>"+
                            "<button  type='button' id='"+row.cre_id+"' class='inactivar btn btn-icon btn-sm btn-light'><i class='fa fa-times text-danger' style='padding: .65rem;'></i></button>";
                        }
                    },
                    //{ defaultContent: "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>" },
                ],
                
            });
            
            $("#table_creditos_activos tbody").on('click','button.imprimir',function () {
                var datos=$(this).attr('id');
                vue.modalImprimir(datos);
            });
            $("#table_creditos_activos tbody").on('click','button.movimiento',function () {
                var datos=$(this).attr('id');
                vue.verDetalleCredito(datos);
            }); 
            $("#table_creditos_activos tbody").on('click','button.inactivar',function () {
                let datos=tabla.row($(this).parents("tr")).data();
                vue.finalizarCredito(datos,2);
            });
        },
        obtenerCredito_inactivos() {
            $('#table_creditos_inactivos').DataTable().destroy();

            var tabla=$('#table_creditos_inactivos').DataTable({
                'processing': true,
                'serverSide': true,
                'destroy': true,
                'serverMethod': 'post',
                'autoWidth':false,
                'order':[[5,'desc']],
                //'dom': 'Bfrtip',
                //'buttons': [
               //     'colvis'
               // ],
                'ajax':{
                    'url':'facturacion/obtenerCreditosInactivos',
                        'data':{
                            'anio': this.anio,
                            'mes': this.mes,
                            'sucursal':this.sucursal_predeterminada
                        }
                },
                'columnDefs': [
                    {width:"10%",
                    targets:"0"},
                    {width:"20%",
                    targets:"1"},
                    {width:"10%",
                    targets:"2"},
                    {width:"10%",
                    targets:"3"},
                    {width:"10%",
                    targets:"4"},
                    {width:"10%",
                    targets:"5"},
                    {width:"20%",
                    targets:"6"},
                    {width:"10%",
                    targets:"7"}
                ],
                'columns': [
                    { data: 'cre_id',
                        render:function (data,type,row) {
                            return "NCV"+row.cre_id;
                        }
                  },
                {
                    data:'uri',
                        render:function (data,type,row) {
                            return (row.uri !== '')?'<a href="'+row.uri+'">'+row.documento+"</a>":'CREDITO';
                        }
                    },
                    { data: 'cli_razon_social' },
                    { data: 'monto' },
                    { data: 'restante' },
                    { data: 'cre_fecha' },
                    { data: 'descripcion' },
                    {
                        data:null,
                        render:function (data,type,row) {
                            return "<button  type='button' id='"+row.cre_id+"' class='movimiento btn btn-icon btn-sm btn-light'><i class='fas fa-eye text-info' style='padding: .65rem;'></i></button>";
                        }
                    },
                ],
               
            });

            $("#table_creditos_inactivos tbody").on('click','button.movimiento',function () {
                var datos=$(this).attr('id');
                vue.verDetalleCredito(datos);
            }); 
        },
        obtenerCreditosTodas(){
            this.obtenerCredito_activos();
            this.obtenerCredito_inactivos();
            this.obtenerCantCredito();
        },
        //orden de entrega
        obtenerOrdendeEntrega(){
            this.obtenerOrdendeEntregaPendientes();
            this.obtenerOrdendeEntregaPagadas();
            this.obtenerOrdendeEntregaAnuladas();
            this.obtenerOrdendeEntregaCreditos();
            this.obtenerCantOrdendeEntrega();
        },
        obtenerCantOrdendeEntrega(){
            axios({
                method: 'post',
                url: 'facturacion/obtenerOrdendeEntrega',
                data:  {
                    anio: this.anio,
                    mes: this.mes,
                    sucursal: this.sucursal_predeterminada
                },
                transformRequest: serializar(),
            }).then(response => {
                this.ordenesPendientes = response.data.pendientes;
                this.ordenesPagas = response.data.pagadas;
                this.ordenesAnuladas =response.data.anuladas;
                this.ordenesCreditos =response.data.creditos;
            }).catch(e => notificacion()).finally(() => {
            });
        },
        obtenerOrdendeEntregaPendientes() {   
            $('#table_ordenes_pendientes').DataTable().destroy();

            var tabla=$('#table_ordenes_pendientes').DataTable({
                'processing': true,
                'serverSide': true,
                'destroy': true,
                'serverMethod': 'post',
                'autoWidth':false,
                'order':[[6,'desc']],
                //'dom': 'Bfrtip',
                //'buttons': [
               //     'colvis'
               // ],
                'ajax':{
                    'url':'facturacion/obtenerOrdendeEntregaAnualesPendientes',
                        'data':{
                            'anio': this.anio,
                            'mes': this.mes,
                            'sucursal':this.sucursal_predeterminada,
                        },
                },
                'columnDefs': [
                    {width:"10%",
                    targets:"0"},
                    {width:"30%",
                    targets:"1"},
                    {width:"10%",
                    targets:"2"},
                    {width:"10%",
                    targets:"3"},
                    {width:"10%",
                    targets:"4"},
                    {width:"10%",
                    targets:"5"},
                    {width:"10%",
                    targets:"6"},
                    {width:"10%",
                    targets:"6"}
                ],
                'columns': [
                    { data: 'n_correlativo',
                        render:function (data,type,row) {
                            return "<a href='"+row.uri+"'>"+row.n_correlativo+"</a>";
                        }
                     },
                     { data: 'n_id',
                        render:function (data,type,row) {
                            return (row.planilla!='')? row.planilla:'No tiene';
                        }
                     },
                    { data: 'cli_razon_social' },
                    { data: 'acumulado'},
                    { data: 'pendiente' },
                    { data: 'total' },
                    { data: 'n_fecha' },
                    {
                        data:'n_id',
                        render:function (data,type,row) {
                            return "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>";
                        }
                    },
                    //{ defaultContent: "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>" },
                ],
                "footerCallback": function (row, data, start, end, display) {
                    var api = this.api(),
                        data;

                    pageTotal = api
                        .column(5, { page: 'current' })
                        .data()
                        .reduce(function (a, b) {
                            return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                        }, 0);

                    $(api.column(5).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                    pageTotal = api
                        .column(4, { page: 'current' })
                        .data()
                        .reduce(function (a, b) {
                            return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                        }, 0);

                    $(api.column(4).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                    pageTotal = api
                        .column(3, { page: 'current' })
                        .data()
                        .reduce(function (a, b) {
                            return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                        }, 0);

                    $(api.column(3).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                }
            });
            
            $("#table_ordenes_pendientes tbody").on('click','button.pendiente',function () {
                let tb=$('#table_ordenes_pendientes').DataTable();
                var datos=tb.row($(this).parents("tr")).data();
                vue.finalizarOrden(datos,1);
            });
        },
        obtenerOrdendeEntregaPagadas() {
            $('#table_ordenes_pagadas').DataTable().destroy();

            var tabla=$('#table_ordenes_pagadas').DataTable({
                'processing': true,
                'serverSide': true,
                'destroy': true,
                'serverMethod': 'post',
                'autoWidth':false,
                'order':[[4,'desc']],
                //'dom': 'Bfrtip',
                //'buttons': [
               //     'colvis'
               // ],
                'ajax':{
                    'url':'facturacion/obtenerOrdendeEntregaAnualesPagadas',
                        'data':{
                            'anio': this.anio,
                            'mes': this.mes,
                            'sucursal':this.sucursal_predeterminada,
                        },
                },
                'columnDefs': [
                    {width:"10%",
                    targets:"0"},
                    {width:"10%",
                    targets:"1"},
                    {width:"30%",
                    targets:"2"},
                    {width:"15%",
                    targets:"3"},
                    {width:"15%",
                    targets:"4"},
                    {width:"10%",
                    targets:"5"}
                ],
                'columns': [
                    { data: 'n_correlativo',
                        render:function (data,type,row) {
                            return "<a href='"+row.uri+"'>"+row.n_correlativo+"</a>";
                        }
                    },
                    { data: 'n_id',
                        render:function (data,type,row) {
                            return (row.planilla!='')? row.planilla:'No tiene';
                        }
                    },
                    { data: 'cli_razon_social' },
                    { data: 'total' },
                    { data: 'n_fecha' },
                    {
                        data:'n_id',
                        render:function (data,type,row) {
                            return "<button type='button' id='estatus' class='pagadas btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>";
                        }
                    },
                    //{ defaultContent: "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>" },
                ],
                "footerCallback": function (row, data, start, end, display) {
                    var api = this.api(),
                        data;

                    pageTotal = api
                        .column(3, { page: 'current' })
                        .data()
                        .reduce(function (a, b) {
                            return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                        }, 0);

                    $(api.column(3).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                }
            });
            
            $("#table_ordenes_pagadas tbody").on('click','button.pagadas',function () {
                let tb=$('#table_ordenes_pagadas').DataTable();
                var datos=tb.row($(this).parents("tr")).data();
                vue.finalizarOrden(datos,2);
            });
        },
        obtenerOrdendeEntregaAnuladas() {
            $('#table_ordenes_anuladas').DataTable().destroy();
            
            var tabla=$('#table_ordenes_anuladas').DataTable({
                'processing': true,
                'serverSide': true,
                'destroy': true,
                'serverMethod': 'post',
                'autoWidth':false,
                'order':[[6,'desc']],
                //'dom': 'Bfrtip',
                //'buttons': [
               //     'colvis'
               // ],
                'ajax':{
                    'url':'facturacion/obtenerOrdendeEntregaAnualesAnuladas',
                        'data':{
                            'anio': this.anio,
                            'mes': this.mes,
                            'sucursal':this.sucursal_predeterminada,
                        },
                },
                'columnDefs': [
                    {width:"10%",
                    targets:"0"},
                    {width:"30%",
                    targets:"1"},
                    {width:"10%",
                    targets:"2"},
                    {width:"10%",
                    targets:"3"},
                    {width:"10%",
                    targets:"4"},
                    {width:"10%",
                    targets:"5"},
                    {width:"10%",
                    targets:"6"},
                ],
                'columns': [
                    { data: 'n_correlativo',
                        render:function (data,type,row) {
                            return "<a href='"+row.uri+"'>"+row.n_correlativo+"</a>";
                        }
                    },
                    { data: 'n_id',
                        render:function (data,type,row) {
                            return (row.planilla!='')? row.planilla:'No tiene';
                        }
                    },
                    { data: 'cli_razon_social' },
                    { data: 'acumulado'},
                    { data: 'pendiente' },
                    { data: 'total' },
                    { data: 'n_fecha' },
                    //{ defaultContent: "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>" },
                ],
                "footerCallback": function (row, data, start, end, display) {
                    var api = this.api(),
                        data;

                    pageTotal = api
                        .column(5, { page: 'current' })
                        .data()
                        .reduce(function (a, b) {
                            return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                        }, 0);

                    $(api.column(5).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                    pageTotal = api
                        .column(4, { page: 'current' })
                        .data()
                        .reduce(function (a, b) {
                            return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                        }, 0);

                    $(api.column(4).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                    pageTotal = api
                        .column(3, { page: 'current' })
                        .data()
                        .reduce(function (a, b) {
                            return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                        }, 0);

                    $(api.column(3).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                }
            });
        },
        obtenerOrdendeEntregaCreditos() {   
            $('#table_ordenes_creditos').DataTable().destroy();

            var tabla=$('#table_ordenes_creditos').DataTable({
                'processing': true,
                'serverSide': true,
                'destroy': true,
                'serverMethod': 'post',
                'autoWidth':false,
                'order':[[6,'desc']],
                //'dom': 'Bfrtip',
                //'buttons': [
               //     'colvis'
               // ],
                'ajax':{
                    'url':'facturacion/obtenerOrdendeEntregaAnualesCreditos',
                        'data':{
                            'anio': this.anio,
                            'mes': this.mes,
                            'sucursal':this.sucursal_predeterminada,
                        },
                },
                'columnDefs': [
                    {width:"10%",
                    targets:"0"},
                    {width:"30%",
                    targets:"1"},
                    {width:"10%",
                    targets:"2"},
                    {width:"10%",
                    targets:"3"},
                    {width:"10%",
                    targets:"4"},
                    {width:"10%",
                    targets:"5"},
                    {width:"10%",
                    targets:"6"},
                    {width:"10%",
                    targets:"6"}
                ],
                'columns': [
                    { data: 'n_correlativo',
                        render:function (data,type,row) {
                            return "<a href='"+row.uri+"'>"+row.n_correlativo+"</a>";
                        }
                     },
                     { data: 'n_id',
                        render:function (data,type,row) {
                            return (row.planilla!='')? row.planilla:'No tiene';
                        }
                     },
                    { data: 'cli_razon_social' },
                    { data: 'acumulado'},
                    { data: 'pendiente' },
                    { data: 'total' },
                    { data: 'n_fecha' },
                    {
                        data:'n_id',
                        render:function (data,type,row) {
                            return "<button type='button' id='estatus' class='credito btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>";
                        }
                    },
                    //{ defaultContent: "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>" },
                ],
                "footerCallback": function (row, data, start, end, display) {
                    var api = this.api(),
                        data;

                    pageTotal = api
                        .column(5, { page: 'current' })
                        .data()
                        .reduce(function (a, b) {
                            return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                        }, 0);

                    $(api.column(5).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                    pageTotal = api
                        .column(4, { page: 'current' })
                        .data()
                        .reduce(function (a, b) {
                            return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                        }, 0);

                    $(api.column(4).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                    pageTotal = api
                        .column(3, { page: 'current' })
                        .data()
                        .reduce(function (a, b) {
                            return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                        }, 0);

                    $(api.column(3).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                }
            });
            
            $("#table_ordenes_creditos tbody").on('click','button.credito',function () {
                let tb=$('#table_ordenes_creditos').DataTable();
                var datos=tb.row($(this).parents("tr")).data();
                vue.finalizarOrden(datos,2);
            });
        },

        verDetalleCredito(id) {
            axios.get('facturacion/obtenerNotadeCreditoDetalle/' + id).then(response => {
                this.detalleCreditoId = id;
                this.detalleCredito = response.data.pagos;
                this.detalleCreditoTotal = response.data.total;
            }).catch(e => notificacion()).finally(() => {
                $('#modal_detalles_credito').modal('show');
            });
        },
        modalLineas() {
            this.errorForm = [];
            $('#modal_lineas').modal('show');
            $('#modal_lineas').on('shown.bs.modal', function () {
                $('#input_buscar_lineas').trigger('focus')
            });
        },
        filtrarPor(num) {
            this.filtro = num;
            document.getElementById('input_buscar_lineas').value = '';
            let nombre = 'Articulo';
            if (num == 2) {
                nombre = 'Cliente';
            } else if (num == 3) {
                nombre = 'Observaciones';
            }
            mostrar_nombre_filtro.innerHTML = nombre;
        },
        buscarLineas(event) {
            if (event.target.value) {
                this.cargando_lineas = 'is-loading is-loading-lg';
                this.bus_li(event.target.value, this);
            }
        },
        bus_li: _.debounce((value, vm) => {
            axios.get('facturacion/buscarLineas', {
                params: {
                    buscar: value,
                    filtro: vm.filtro,
                    sucursal: vm.sucursal_predeterminada
                }
            }).then(response => {
                if (response.data.length > 0) {
                    vm.lineas = response.data;
                } else {
                    vm.lineas = [];
                }
            }).catch(e => notificacion()).finally(() => vm.cargando_lineas = '');
        }, 350),
        modal_buscar_cliente(ruta) {
            this.clientes = [];
            this.selected_cli = '';
            this.ruta = ruta;
            this.errorForm = [];
            document.getElementById('form_cliente').reset();
            $('#modal_buscar_cliente').modal('show');
            $('#modal_buscar_cliente').on('shown.bs.modal', function () {
                $('#tututut > div > div > input').trigger('focus')
            });
        },
        guardarCliente() {

            this.errorForm = [];

            let form_cliente = document.getElementById('form_cliente');
            let formData = new FormData(form_cliente);
            formData.append('ruta', this.ruta);

            if (!formData.get('cli_tipodoc'))
                this.errorForm.push('El campo Tipo de Documento es obligatorio.');
            if (!formData.get('cli_telefono'))
                this.errorForm.push('El campo Teléfono es obligatorio.');
            if (!formData.get('cli_direccion'))
                this.errorForm.push('El campo Dirección es obligatorio.');
            if (!formData.get('cli_dni'))
                this.errorForm.push('El campo Número de Documento es obligatorio.');
            if (!formData.get('cli_razon_social'))
                this.errorForm.push('El campo Razón Social es obligatorio.');
            if (formData.get('cli_email')) {
                if (!validaEmail(formData.get('cli_email')))
                    this.errorForm.push('El Correo Electrónico debe tener un formato válido.');
            }

            formData.set('cli_natural', formData.has('cli_natural') ? true : false);

            if (this.errorForm.length == 0) {
                this.cargando = true;
                axios({
                    method: 'post',
                    url: 'facturacion/guardarCliente',
                    data: formData
                }).then(response => {
                    if (response.data.errors == null) {
                        location.href = response.data;
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                });
            }
        },
        finalizarFactura(row, estatus) {

            let estatus_nombre = '';

            if (estatus == 1) {
                estatus_nombre = 'Finalizado';
            } else if (estatus == 2) {
                estatus_nombre = 'Pendiente';
            } else if (estatus == 3) {
                estatus_nombre = 'Anulado';
            }

            Swal.fire({
                title: estatus_nombre,
                text: "¿Estás seguro que deseas cambiar el estatus de la factura " + row.fm_id + " a " + estatus_nombre + " del cliente " + row.cli_razon_social + "?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Aceptar'
            }).then((result) => {
                if (result.value) {
                    axios.get('facturacion/finalizarFactura', {
                        params: {
                            id: row.fm_id,
                            estatus: estatus
                        }
                    }).then(response => {
                        if (response.data == true) {
                            this.obtenerFacturasTodas();
                        } else {
                            notificacion('fa fa-ban', 'Advertencia', response.data, 'warning');
                        }
                    }).catch(e => notificacion());
                }
            });
        },
        finalizarNota(row, estatus) {

            let estatus_nombre = '';

            if (estatus == 1) {
                estatus_nombre = 'Finalizado';
            } else if (estatus == 2) {
                estatus_nombre = 'Pendiente';
            } else if (estatus == 3) {
                estatus_nombre = 'Anulado';
            }

            Swal.fire({
                title: estatus_nombre,
                text: "¿Estás seguro que deseas cambiar el estatus de la nota de entrega " + row.ne_id + " a " + estatus_nombre + " del cliente " + row.cli_razon_social + "?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Aceptar'
            }).then((result) => {
                if (result.value) {
                    axios.get('facturacion/finalizarNota', {
                        params: {
                            id: row.ne_id,
                            estatus: estatus
                        }
                    }).then(response => {
                        if (response.data == true) {
                            this.obtenerNotasdeEntrega();
                        } else {
                            notificacion('fa fa-ban', 'Advertencia', response.data, 'warning');
                        }
                    }).catch(e => notificacion());
                }
            });
        },
        finalizarOrden(row, estatus) {
            let estatus_nombre = '';

            if (estatus == 1) {
                estatus_nombre = 'Finalizado';
            } else if (estatus == 2) {
                estatus_nombre = 'Pendiente';
            } else if (estatus == 3) {
                estatus_nombre = 'Anulado';
            }

            Swal.fire({
                title: estatus_nombre,
                text: "¿Estás seguro que deseas cambiar el estatus de la orden de entrega " + row.n_id + " a " + estatus_nombre + " del cliente " + row.cli_razon_social + "?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Aceptar'
            }).then((result) => {
                if (result.value) {
                    axios.get('facturacion/finalizarOrden', {
                        params: {
                            id: row.n_id,
                            estatus: estatus
                        }
                    }).then(response => {
                        if (response.data == true) {
                            this.obtenerOrdendeEntrega();
                        } else {
                            notificacion('fa fa-ban', 'Advertencia', response.data, 'warning');
                        }
                    }).catch(e => notificacion());
                }
            });
        },
        finalizarPedido(row, estatus) {

            let estatus_nombre = '';

            if (estatus == 1) {
                estatus_nombre = 'Finalizado';
            } else if (estatus == 2) {
                estatus_nombre = 'Pendiente';
            } else if (estatus == 3) {
                estatus_nombre = 'Anulado';
            }

            Swal.fire({
                title: estatus_nombre,
                text: "¿Estás seguro de cambiar el estatus del pedido " + row.pe_id + " a " + estatus_nombre + " del cliente " + row.cli_razon_social + "?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Aceptar'
            }).then((result) => {
                if (result.value) {
                    axios.get('facturacion/finalizarPedido', {
                        params: {
                            id: row.pe_id,
                            estatus: estatus
                        }
                    }).then(response => {
                        if (response.data == true) {
                            this.obtenerPedidosTodas();
                        } else {
                            notificacion('fa fa-ban', 'Advertencia', response.data, 'warning');
                        }
                    }).catch(e => notificacion());
                }
            });
        },
        finalizarCredito(row, estatus) {

            let estatus_nombre = '';

            if (estatus == 1) {
                estatus_nombre = 'Activa';
            } else if (estatus == 2) {
                estatus_nombre = 'Inactiva';
            }

            Swal.fire({
                title: estatus_nombre,
                text: "¿Estás seguro de cambiar el estatus de la nota de credito " + row.cre_id + " a " + estatus_nombre + " del cliente " + row.cli_razon_social + "?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Aceptar'
            }).then((result) => {
                if (result.value) {
                    axios.get('facturacion/finalizarCredito', {
                        params: {
                            id: row.cre_id,
                            estatus: estatus
                        }
                    }).then(response => {
                        if (response.data == true) {
                            this.obtenerCreditosTodas();
                        } else {
                            notificacion('fa fa-ban', 'Advertencia', response.data, 'warning');
                        }
                    }).catch(e => notificacion());
                }
            });
        },
        moneda(num, div_locale, div_simbolo, decimal = 2) {
            return monedaMoneda(num, div_locale, div_simbolo, decimal);
        },
        decimal(num, div_locale, decimal = 2) {
            return monedaDecimal(num, div_locale, decimal);
        },
        modalCrearCredito() {
            this.errorForm = [];
            this.divisa_pagar = '';
            this.metodo_pagar = '';
            this.cuenta_pagar = '';
            this.cuentas = [];
            this.metodos_de_pagos = [];
            $('#modal_crear_credito').modal('show');
            $('#modal_crear_credito').on('shown.bs.modal', function () {
                $('#buscar_cliente_credito > div > div > input').trigger('focus')
            });
        },
        obtenerMetodosSegunDivisa(event) {

            this.errorForm = [];
            this.metodo_pagar = '';
            this.cuenta_pagar = '';
            this.cuentas = [];
            this.metodos_de_pagos = [];

            if (event.target.value) {
                axios.get('notadecredito/obtenerMetodosSegunDivisa/' + event.target.value).then(response => {
                    this.metodos_de_pagos = response.data.metodos;
                    this.money.decimal = response.data.divisa.decimal;
                    this.money.thousands = response.data.divisa.thousands;
                    this.money.precision = response.data.divisa.precision;
                }).catch(e => notificacion());
            }
        },
        obtenerCuentasSegunMetodo(event) {

            this.cuenta_pagar = '';
            this.cuentas = [];

            if (event.target.value) {
                axios.get('notadecredito/obtenerCuentasSegunMetodo/' + event.target.value).then(response => {
                    this.cuentas = response.data;
                }).catch(e => notificacion());
            }
        },
        onSearch(search, loading) {
            if (search) {
                loading(true);
                this.search(loading, search, this);
                //this.ocultoBoton();
            }
        },
        search: _.debounce((loading, search, vm) => {
            axios.get('notadecredito/buscarCliente', {
                params: {
                    'buscar': search
                }
            }).then(response => {
                if (response.data.length > 0) {
                    vm.clientes = response.data;
                    vm.clienteEncontrado = true;
                } else {
                    vm.clientes = [];
                    if (!isNaN(search) || !isNaN(search.charAt(1)) || !isNaN(search.charAt(2))) {
                        vm.clidni = 'V'+search;
                    } else {
                        vm.clidni = '';
                    }
                    vm.clienteEncontrado = false;
                }
            }).catch(e => notificacion()).finally(() => loading(false));
        }, 350),
        pagar() {

            this.errorForm = [];

            if (!this.serie)
                this.errorForm.push('El campo Serie es obligatorio');
            if (!this.divisa_pagar)
                this.errorForm.push('El campo Divisa es obligatorio');
            if (!this.metodo_pagar)
                this.errorForm.push('El campo Método es obligatorio');
            if (!this.cuenta_pagar)
                this.errorForm.push('El campo Cuenta es obligatorio');
            if (!this.monto)
                this.errorForm.push('El campo Monto es obligatorio');

            if (this.errorForm.length == 0) {
                this.cargando = true;
                axios({
                    method: 'post',
                    url: 'notadecredito/guardar',
                    data: {
                        serie: this.serie,
                        cliente: this.selected_cli.id,
                        monto: this.monto,
                        id_divisa: this.divisa_pagar,
                        id_metodo_divisa: this.metodo_pagar,
                        id_cuenta_metodo: this.cuenta_pagar,
                        observacion: this.pagardescripcion
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            this.obtenerCreditosTodas();
                            this.selected_cli = [];
                            this.clientes = [];
                            this.monto = 0;
                            this.serie = '';
                            this.pagardescripcion = '';
                            this.divisa_pagar = ''
                            this.metodo_pagar = '';
                            this.cuenta_pagar = '';
                            notificacion('fa fa-check', '', 'Operación exitosa', 'success');
                        } else {
                            notificacion('fa fa-ban', 'Error', 'Error en la operación', 'danger');
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                    this.divisa_pagar = '';
                    this.metodo_pagar = '';
                    this.cuenta_pagar = '';
                    this.cuentas = [];
                    this.metodos_de_pagos = [];
                    $('#modal_crear_credito').modal('hide');
                });
            }
        },
        redireccionarANuevaFactura() {
            location.href = baseURL + this.ruta + '/nuevaFactura/' + this.selected_cli.id;
        },
        modalFactor(id, descripcion) {
            this.errorFormFactor = [];
            this.titulo = descripcion + ' al cambio';
            axios.get('divisas/obtenerDivisasDiferente/' + Number(id)).then(response => {
                this.dataFormFactor = id;
                this.divisasDiferentes = response.data;
                    $('#modal-divisas').modal('hide');
                    $('#modal_factor').modal('show');
            }).catch(e => notificacion());
        },
        guardarFactor() {
                this.errorFormFactor = [];
                this.cargando = true;
                axios({
                    method: 'post',
                    url: 'divisas/guardarFactores',
                    data: {
                        'id_divisa_master': this.dataFormFactor,
                        'divisas': JSON.stringify(this.divisasDiferentes)
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            notificacion('fa fa-balance-scale', 'Actualizado', 'Factor actualizado correctamente', 'info');
                        } else {
                            notificacion('fa fa-balance-scale', 'Error', 'Error al actualizar factor', 'danger');
                        }
                    } else {
                        this.errorFormFactor = response.data.errors;
                    }
                }).catch(e => {
                    notificacion()
                }).finally(() => this.cargando = false);
        },
        modalImprimir(id_credito) {
            this.errorForm = [];
            this.id_nota_cre_imp = id_credito;
            $('#modal-imprimir').modal();
        },
        imprimir(id_impresora) {
            axios.get('facturacion/imprimir', {
                params: {
                    id_factura: Number(this.id_nota_cre_imp),
                    id_impresora: Number(id_impresora),
                }
            }).then(response => {
                console.log(response.data);
                if (response.data.errors == null) {
                    fetch(response.data.ip_puerto, {
                        method: 'POST',
                        body: JSON.stringify(response.data.data)
                    }).then((j) => {
                        if (j.ok) {
                            notificacion('fa fa-check', 'Impreso', 'Impresion exitosa', 'success');
                        } else {
                            notificacion('fa fa-ban', 'Error', 'Respuesta de red OK pero respuesta HTTP no OK', 'warning');
                        }
                    }).catch((error) => {
                        notificacion('fa fa-ban', 'Error', 'Hubo un problema con la petición Fetch:' + error.message, 'danger');
                    });
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        fechaNormal(value) {
            return moment(value).format('DD/MM/YYYY, h:mm A');
        },
        formatearSelect(){
            this.clidni='';
        },
        cne() {
            let dataFormcne = {
                'tipo': this.tipoci,
                'cli_dni': this.clidni
            };
            document.getElementById('btncne').disabled = true;
                axios({
                    method: 'post',
                    url: 'facturacion/cne',
                    data: dataFormcne,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.error == 0) {
                       // if (response.data == true) {
                          console.log(response.data);
                            document.getElementById('razon_social').value= response.data.apellidos+' '+response.data.nombres;
                            document.getElementById('direccion_uno').value =response.data.direccion;
                       // }
                    } else {
                       notificacion('fa fa-ban', 'Advertencia', response.data, 'warning');
                    }
                    document.getElementById('btncne').disabled = false;
                }).catch(e => notificacion()).finally();
          },
        ocultoBoton(){
            let a = document.getElementById("dni").value.length;
            if(a>=7 && this.tipoci==2){
              document.getElementById("btncne").disabled = false;
            }else{
              document.getElementById('btncne').disabled = true;
            }
        },
        proveedoresActivos() {
            axios
                .get("facturacion/proveedoresActivos")
                .then((response) => {
                    this.proveedores = response.data;
                })
                .catch((e) => notificacion());
        },
        buscarVentaProvee() {

            this.errorForm = [];
            this.cargando = true;
            this.cargando_tabla = 'is-loading is-loading-lg';
            $("#tab_provee").DataTable().destroy();

            axios.get('facturacion/proveedoresReportes', {
                params: {
                    fecha_desde: this.fecha_desde,
                    fecha_hasta: this.fecha_hasta,
                    proveedor: this.proveedor,
                    sucursal:this.sucursal_predeterminada
                }
            }).then(response => {
                if (response.data.errors == null) {
                    this.totalproveedores = response.data;
                } else {
                    this.errorForm = response.data.errors;
                }
            }).catch(e => notificacion()).finally(() => {
                this.cargando = false;
                this.cargando_tabla = '';

                let buttonCommon = {
                    exportOptions: {
                        format: {
                            body: function(data, row, column, node) {
                                if (column === 2 || column === 3 || column === 4) {
                                    return convertir_a_float(data)
                                } else {
                                    return data.replace(/<[^>]*>?/g, '');
                                }
                            }
                        }
                    }
                };

                $("#tab_provee").DataTable({
                    retrieve: true,
                    order: [],
                    dom: 'Blfrtip',
                    buttons: [
                        $.extend(true, {}, buttonCommon, {
                            extend: 'excelHtml5',
                            title: 'Ventas por proveedores' +
                                moment(this.fecha_desde).format('DD-MM-YYYY') +
                                ' hasta ' +
                                moment(this.fecha_desde).format('DD-MM-YYYY')
                        }),
                        'pdf'
                    ],
                    'footerCallback': function (row, data, start, end, display) {
                        var api = this.api(),
                            data;
    
                        pageTotal = api
                            .column(1, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);
    
                        $(api.column(1).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                        pageTotal = api
                        .column(2, { page: 'current' })
                        .data()
                        .reduce(function (a, b) {
                            return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                        }, 0);

                    $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                    pageTotal = api
                    .column(3, { page: 'current' })
                    .data()
                    .reduce(function (a, b) {
                        return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                    }, 0);

                    $(api.column(3).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                    }
                });
            });
        },
        lists_productos(id) {
            $("#tab_pp").DataTable().destroy();
            axios.get('facturacion/productosProvReportes', {
                params: {
                    fecha_desde: this.fecha_desde,
                    fecha_hasta: this.fecha_hasta,
                    proveedor: id,
                    sucursal: this.sucursal_predeterminada
                }
            }).then(response => {
                if (response.data.errors == null) {
                    this.productos = response.data;
                } else {
                    this.errorForm = response.data.errors;
                }
            }).catch(e => notificacion()).finally(() => {
                $("#tab_pp").DataTable({
                    order: [],
                    dom: 'Blfrtip',
                    buttons:[
                        'pdf'
                    ]
                });
                $('#modal_pp').modal('show');
            });
        },
        buscarCierreDelDia() {
            this.errorForm = [];
            $('#tabla_cierre_dia_ingreso, #tabla_cierre_dia_egreso').DataTable().destroy();
            axios.get('facturacion/obtenerCierreDelDia', {
                params: {
                    fecha: this.fecha_desde,
                    sucursal: this.sucursal_predeterminada
                }
            }).then(response => {
                if (response.data.errors == null) {
                    this.cierres_del_dia.positivo = response.data.cierre_positivo;
                    this.cierres_del_dia.negativo = response.data.cierre_negativo;
                    this.total_divisas_p = response.data.total_divisas_p;
                    this.total_divisas_n = response.data.total_divisas_n;
                } else {
                    this.errorForm = response.data.errors;
                }
            }).catch(e => notificacion()).finally(() => {
                this.cargando_tabla = '';

                let buttonCommon = {
                    exportOptions: {
                        format: {
                            body: function(data, row, column, node) {
                                if (column === 4) {
                                    return convertir_a_float(data)
                                } else {
                                    return data.replace(/<[^>]*>?/g, '');
                                }
                            }
                        }
                    }
                };

                $("#tabla_cierre_dia_ingreso").DataTable({
                    order: [],
                    dom: 'Bfrtip',
                    buttons: [
                        $.extend(true, {}, buttonCommon, {
                            extend: 'excelHtml5',
                            title: 'Cierre del dia (INGRESO) ' + moment(this.fecha).format('DD-MM-YYYY'),
                        }),
                    ]
                });

                $("#tabla_cierre_dia_egreso").DataTable({
                    order: [],
                    dom: 'Bfrtip',
                    buttons: [
                        $.extend(true, {}, buttonCommon, {
                            extend: 'excelHtml5',
                            title: 'Cierre del dia (EGRESO) ' + moment(this.fecha).format('DD-MM-YYYY'),
                        }),
                    ]
                });
            });
        },
        modalImprimirCierre(estatus) {
            this.errorForm = [];
            $('#modal-imprimircierre').modal();
            this.estatus = estatus;
        },
        ImprimirCierre(id) {
            axios.get('facturacion/imprimirCierre', {
                params: {
                    fecha: this.fecha_desde,
                    id: id,
                    estatus: this.estatus,
                    sucursal: this.sucursal_predeterminada
                }
            }).then(response => {
                console.log(response.data);
                if (response.data.data.errors == null) {
                    fetch(response.data.ip_puerto, {
                        method: 'POST',
                        body: JSON.stringify(response.data.data)
                    }).then((j) => {
                        if (j.ok) {
                            notificacion('fa fa-check', 'Impreso', 'Impresion exitosa', 'success');
                        } else {
                            notificacion('fa fa-ban', 'Error', 'Respuesta de red OK pero respuesta HTTP no OK', 'warning');
                        }
                    }).catch((error) => {
                        notificacion('fa fa-ban', 'Error', 'Hubo un problema con la petición Fetch:' + error.message, 'danger');
                    });
                } else {
                    let total_errores = response.data.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        buscarProductoVendido: function(event) {

            let select_divisa = document.getElementById('pvdivisas');
            let selectedOptionDiv = select_divisa.options[select_divisa.selectedIndex];

            this.errorForm = [];
            this.cargando = true;
            this.cargando_tabla = 'is-loading is-loading-lg';
            $("#tab_pro_ven").DataTable().destroy();

            axios.get('facturacion/obtenerProductosVendidos', {
                params: {
                    fecha_desde: this.fecha_desde,
                    fecha_hasta: this.fecha_hasta,
                    divisa: this.divisa,
                    sucursal: this.sucursal_predeterminada
                }
            }).then(response => {
                if (response.data.errors == null) {
                    this.productosVendido = response.data.productos;
                    this.costo_total = response.data.costo_total;
                    this.venta_total = response.data.venta_total;
                    this.artic_total = response.data.artic_total;
                    this.ganancia = response.data.ganancia;
                    this.ganancia_porc = response.data.ganancia_porc;
                    this.cantidad_articulos = response.data.cantidad_articulos;
                } else {
                    this.errorForm = response.data.errors;
                }
            }).catch(e => notificacion()).finally(() => {
                this.cargando = false;
                this.cargando_tabla = '';

                let buttonCommon = {
                    exportOptions: {
                        format: {
                            body: function(data, row, column, node) {
                                if (column === 2 || column === 3 || column === 4 || column === 5 || column === 6 || column === 7) {
                                    return convertir_a_float(data)
                                } else {
                                    return data.replace(/<[^>]*>?/g, '');
                                }
                            }
                        }
                    }
                };

                $("#tab_pro_ven").DataTable({
                    order: [],
                    dom: 'Bfrtip',
                    buttons: [
                        $.extend(true, {}, buttonCommon, {
                            extend: 'excelHtml5',
                            title: 'Productos vendidos desde ' +
                                moment(this.fecha_desde).format('DD-MM-YYYY') +
                                ' hasta ' +
                                moment(this.fecha_desde).format('DD-MM-YYYY') +
                                ' Divisa (' + selectedOptionDiv.text + ')',
                        }),
                    ]
                });
            });
        },
         buscarProductoVendidoSimple: function(event) {

            let select_divisa = document.getElementById('pvdivisass');
            let selectedOptionDiv = select_divisa.options[select_divisa.selectedIndex];

            this.errorForm = [];
            this.cargando = true;
            this.cargando_tabla = 'is-loading is-loading-lg';
            $("#tab_pro_ven_simpl").DataTable().destroy();

            axios.get('facturacion/obtenerProductosVendidos', {
                params: {
                    fecha_desde: this.fecha_desde,
                    fecha_hasta: this.fecha_hasta,
                    divisa: this.divisa,
                    sucursal: this.sucursal_predeterminada
                }
            }).then(response => {
                if (response.data.errors == null) {
                    this.productosVendidoSimples = response.data.productos;
                    this.venta_totalS = response.data.venta_total;
                    this.artic_totalS = response.data.artic_total;
                    this.cantidad_articulosS = response.data.cantidad_articulos;
                } else {
                    this.errorForm = response.data.errors;
                }
            }).catch(e => notificacion()).finally(() => {
                this.cargando = false;
                this.cargando_tabla = '';

                let buttonCommon = {
                    exportOptions: {
                        format: {
                            body: function(data, row, column, node) {
                                if (column === 2 || column === 3 || column === 4 || column === 5 || column === 6 || column === 7) {
                                    return convertir_a_float(data)
                                } else {
                                    return data.replace(/<[^>]*>?/g, '');
                                }
                            }
                        }
                    }
                };

                $("#tab_pro_ven_simpl").DataTable({
                    order: [],
                    dom: 'Bfrtip',
                    buttons: [
                        $.extend(true, {}, buttonCommon, {
                            extend: 'excelHtml5',
                            title: 'Productos vendidos desde ' +
                                moment(this.fecha_desde).format('DD-MM-YYYY') +
                                ' hasta ' +
                                moment(this.fecha_desde).format('DD-MM-YYYY') +
                                ' Divisa (' + selectedOptionDiv.text + ')',
                        }),
                    ]
                });
            });
        },
        buscarProductoVendidosDocumento: function(event) {

            let select_divisa = document.getElementById('pvdivisas');
            let selectedOptionDiv = select_divisa.options[select_divisa.selectedIndex];

            this.errorForm = [];
            this.cargando = true;
            this.cargando_tabla = 'is-loading is-loading-lg';
            $("#tab_pro_vend").DataTable().destroy();

            axios.get('facturacion/obtenerProductosVendidosdocumentos', {
                params: {
                    fecha_desde: this.fecha_desde,
                    fecha_hasta: this.fecha_hasta,
                    divisa: this.divisa,
                    sucursal: this.sucursal_predeterminada,
                    estatus: this.estatus_documentos,
                    agente:this.agente
                }
            }).then(response => {
                if (response.data.errors == null) {
                    this.productosVendidoDocumentos = response.data.productos;
                    this.costo_totalD = response.data.costo_total;
                    this.venta_totalD = response.data.venta_total;
                    this.artic_totalD = response.data.artic_total;
                    this.gananciaD = response.data.ganancia;
                    this.ganancia_porcD = response.data.ganancia_porc;
                    this.cantidad_articulosD = response.data.cantidad_articulos;
                } else {
                    this.errorForm = response.data.errors;
                }
            }).catch(e => notificacion()).finally(() => {
                this.cargando = false;
                this.cargando_tabla = '';

                let buttonCommon = {
                    exportOptions: {
                        format: {
                            body: function(data, row, column, node) {
                                if (column === 11 || column === 12 || column === 13 || column === 14 || column === 15) {
                                    return convertir_a_float(data)
                                } else {
                                    return data.replace(/<[^>]*>?/g, '');
                                }
                            }
                        }
                    }
                };

               var table= $("#tab_pro_vend").DataTable({
                    order: [],
                    dom: 'Bfrtip',
                    scrollX:true,
                    buttons: [
                        $.extend(true, {}, buttonCommon, {
                            extend: 'excelHtml5',
                            title: 'Productos vendidos desde ' +
                                moment(this.fecha_desde).format('DD-MM-YYYY') +
                                ' hasta ' +
                                moment(this.fecha_desde).format('DD-MM-YYYY') +
                                ' Divisa (' + selectedOptionDiv.text + ')',
                        }),
                    ]
                });

                $("#tab_pro_vend tbody tr.group-start").each(function () {
                    var name=$(this).data('documento');
                    collapsedGroups[name]=!collapsedGroups[name];
                });
                table.draw(false);

                $("#tab_pro_vend tbody").on('click','tr.group-start',function () {
                    var name=$(this).data('documento');
                    collapsedGroups[name]=!collapsedGroups[name];
                    table.draw(false);
                });
            });
        },
        buscarVentaDia: function(event) {

            let select_documento = document.getElementById('vddocumentodia');
            let select_divisa = document.getElementById('pvdivisasdia');

            let selectedOptionDoc = select_documento.options[select_documento.selectedIndex];
            let selectedOptionDiv = select_divisa.options[select_divisa.selectedIndex];

            this.errorForm = [];
            this.cargando = true;
            this.cargando_tabla = 'is-loading is-loading-lg';
            $("#tab_venta_dia").DataTable().destroy();

            axios.get('facturacion/obtenerDocumentosVentaDia', {
                params: {
                    fecha_desde: this.fecha_desde,
                    fecha_hasta: this.fecha_desde,
                    divisa: this.divisa,
                    documento: this.documento,
                    sucursal: this.sucursal_predeterminada
                }
            }).then(response => {
                if (response.data.errors == null) {
                    this.productosVendidoDia = response.data.documentos;
                    this.pendientedia = response.data.pendiente;
                    this.acumuladodia = response.data.acumulado;
                    this.artic_totaldia = response.data.artic_total;
                    this.totaldia = response.data.total;
                    this.cantidad_artdia=response.data.cantidad_art;
                } else {
                    this.errorForm = response.data.errors;
                }
            }).catch(e => notificacion()).finally(() => {
                this.cargando = false;
                this.cargando_tabla = '';

                let buttonCommon = {
                    exportOptions: {
                        format: {
                            body: function(data, row, column, node) {
                                if (column === 2 || column === 3 || column === 4) {
                                    return convertir_a_float(data)
                                } else {
                                    return data.replace(/<[^>]*>?/g, '');
                                }
                            }
                        }
                    }
                };

                $("#tab_venta_dia").DataTable({
                    order: [],
                    dom: 'Bfrtip',
                    buttons: [
                        $.extend(true, {}, buttonCommon, {
                            extend: 'excelHtml5',
                            title: 'Ventas del dia ' +
                                moment(this.fecha_desde).format('DD-MM-YYYY') +
                                ' hasta ' +
                                moment(this.fecha_hasta).format('DD-MM-YYYY') +
                                ' Documento (' + selectedOptionDoc.text + ')' +
                                ' Divisa (' + selectedOptionDiv.text + ')',
                        }),
                    ]
                });
            });
        },
        buscarVentapordia:function (event) {

            let select_meses = document.getElementById('dia_meses');
            let select_divisa = document.getElementById('dia_divisas');
            let selectedOptionMes = select_meses.options[select_meses.selectedIndex];
            let selectedOptionDiv = select_divisa.options[select_divisa.selectedIndex];

            this.errorForm = [];
            this.cargando = true;
            this.cargando_tabla = 'is-loading is-loading-lg';
            $("#tabla_dias").DataTable().destroy();

            axios.get('facturacion/produccionDia', {
                params: {
                    anio: this.anio,
                    mes: this.mes,
                    divisa: this.divisa,
                    sucursal: this.sucursal_predeterminada
                }
            }).then(response => {
                if (response.data.errors == null) {
                    this.dias_ventas = response.data.dias;
                    this.art_total_D = response.data.art_total
                    this.costo_D = response.data.costo;
                    this.venta_D = response.data.venta;
                    this.ganancia_D = response.data.ganancia;
                    this.porcentaje_D = response.data.porcentaje;
                } else {
                    this.errorForm = response.data.errors;
                }
            }).catch(e => notificacion()).finally(() => {
                this.cargando = false;
                this.cargando_tabla = '';

                let buttonCommon = {
                    exportOptions: {
                        format: {
                            body: function(data, row, column, node) {
                                return convertir_a_float(data);
                            }
                        }
                    }
                };

                $("#tabla_dias").DataTable({
                    dom: 'Bfrtip',
                    buttons: [
                        $.extend(true, {}, buttonCommon, {
                            extend: 'excelHtml5',
                            title: 'Año (' + this.anio + ')' +
                                ' Mes (' + selectedOptionMes.text + ')' +
                                ' Divisa (' + selectedOptionDiv.text + ')',
                        }),
                    ]
                });
            });
        },
        buscarVentapormes:function (event) {

            let select_divisa = document.getElementById('mes_divisas');
            let selectedOptionDiv = select_divisa.options[select_divisa.selectedIndex];

            this.errorForm = [];
            this.cargando = true;
            this.cargando_tabla = 'is-loading is-loading-lg';
            $("#tabla_meses").DataTable().destroy();

            axios({
                method: 'post',
                url: 'facturacion/produccionMes',
                data:  {
                    anio: this.anio,
                    divisa: this.divisa_mes,
                    sucursal:this.sucursal_predeterminada
                },
                transformRequest: serializar(),
            }).then(response => {
                if (response.data.errors == null) {
                    this.meses_ventas = response.data.meses;
                    this.art_total_m = response.data.art_total
                    this.costo_m = response.data.costo;
                    this.venta_m = response.data.venta;
                    this.ganancia_m = response.data.ganancia;
                    this.porcentaje_m = response.data.porcentaje;
                } else {
                    this.errorForm = response.data.errors;
                }
            }).catch(e => notificacion()).finally(() => {
                this.cargando = false;
                this.cargando_tabla = '';

                let buttonCommon = {
                    exportOptions: {
                        format: {
                            body: function(data, row, column, node) {
                                return convertir_a_float(data);
                            }
                        }
                    }
                };

                $("#tabla_meses").DataTable({
                    order: [],
                    dom: 'Bfrtip',
                    buttons: [
                        $.extend(true, {}, buttonCommon, {
                            extend: 'excelHtml5',
                            title: 'Ventas por meses del Año (' + this.anio + ')' +
                                ' Divisa (' + selectedOptionDiv.text + ')',
                        }),
                    ]
                });

            });

        },
        buscarPrecioVenta: function(event) {

            let select_divisa = document.getElementById('pvdivisasp');
            let selectedOptionDiv = select_divisa.options[select_divisa.selectedIndex];

            this.errorForm = [];
            this.cargando = true;
            this.cargando_tabla = 'is-loading is-loading-lg';
            $("#tab_precio_ven").DataTable().destroy();

            axios.get('facturacion/obtenerPrecioProductoVendidos', {
                params: {
                    fecha_desde: this.fecha_desde,
                    fecha_hasta: this.fecha_hasta,
                    divisa: this.divisa,
                    filtro: this.filtro,
                    sucursal: this.sucursal_predeterminada
                }
            }).then(response => {
                if (response.data.errors == null) {
                    this.productosPrecVenta = response.data.productos;
                } else {
                    this.errorForm = response.data.errors;
                }
            }).catch(e => notificacion()).finally(() => {
                this.cargando = false;
                this.cargando_tabla = '';

                let buttonCommon = {
                    exportOptions: {
                        format: {
                            body: function(data, row, column, node) {
                                if (column === 2 || column === 3 || column === 4 || column === 5 || column === 6) {
                                    return convertir_a_float(data)
                                } else {
                                    return data.replace(/<[^>]*>?/g, '');
                                }
                            }
                        }
                    }
                };

                $("#tab_precio_ven").DataTable({
                    order: [],
                    dom: 'Bfrtip',
                    buttons: [
                        $.extend(true, {}, buttonCommon, {
                            extend: 'excelHtml5',
                            title: 'Productos vendidos desde ' +
                                moment(this.fecha_desde).format('DD-MM-YYYY') +
                                ' hasta ' +
                                moment(this.fecha_desde).format('DD-MM-YYYY') +
                                ' Divisa (' + selectedOptionDiv.text + ')',
                        }),
                    ]
                });
            });
        },
        buscarVentaHora: function(event) {
            this.errorForm = [];
            this.cargando = true;
            this.cargando_tabla = 'is-loading is-loading-lg';
            $("#tabla_dias").DataTable().destroy();

            axios.get('facturacion/produccionDiaHora', {
                params: {
                    fecha: this.fecha_desde,
                    divisa: this.divisa,
                    sucursal: this.sucursal_predeterminada
                }
            }).then(response => {
                if (response.data.errors == null) {
                    this.horas = response.data.horas;
                    this.art_totald = response.data.art_total
                    this.costod = response.data.costo;
                    this.ventad = response.data.venta;
                    this.gananciad = response.data.ganancia;
                    this.porcentajed = response.data.porcentaje;
                } else {
                    this.errorForm = response.data.errors;
                }
            }).catch(e => notificacion()).finally(() => {
                this.cargando = false;
                this.cargando_tabla = '';

                let buttonCommon = {
                    exportOptions: {
                        format: {
                            body: function(data, row, column, node) {
                                return convertir_a_float(data);
                            }
                        }
                    }
                };

                $("#tabla_dias").DataTable({
                    dom: 'Bfrtip',
                    buttons: [
                        $.extend(true, {}, buttonCommon, {
                            extend: 'excelHtml5',
                            title: 'Fecha (' + this.fecha_desde + ')',
                        }),
                    ]
                });
            });
        },
    }
});

var chartVentasSemanales = '';
var ventasSemanales = document.getElementById('ventasSemanales').getContext('2d');

function obtenerIngresosDiarios() {
    let sucursal = document.getElementById("sucursal").value;
    chartVentasSemanales.destroy();
    _ingresosDiarios(sucursal);
}

function _ingresosDiarios(sucursal) {
//let sucursal=document.getElementById('sucursal').value;
    axios({
        method: 'post',
        url: 'facturacion/obtenerIngresosDiarios',
        data:  {
            sucursal: sucursal
        },
        transformRequest: serializar(),
    }).then(response => {
        let ingreso_dsm = response.data.dias_semana;

        let dsm_USD = [0, 0, 0, 0, 0, 0, 0];
        let dsm_BS = [0, 0, 0, 0, 0, 0, 0];
        let dsm_acumulado=[0, 0, 0, 0, 0, 0, 0];
        let dsm_pendiente=[0, 0, 0, 0, 0, 0, 0];

        Object.keys(ingreso_dsm).forEach(function(k) {
            for (let i = 0; i < 7; i++) {
                if (ingreso_dsm[k].n_dia_semana == i) {
                    dsm_USD[i] += ingreso_dsm[k].venta_USD;
                    dsm_BS[i] += ingreso_dsm[k].venta_BS;
                    dsm_acumulado[i] += ingreso_dsm[k].acumulado;
                    dsm_pendiente[i] += ingreso_dsm[k].pendiente;
                }
            }
        });

        chartVentasSemanales = new Chart(ventasSemanales, {
            type: 'bar',
            data: {
                labels: ['Lun', 'Mar', 'Mié', 'Jue', 'Vie', 'Sáb', 'Dom'],
                datasets: [{
                    label: "Movimiento en Bolivares BS",
                    data: dsm_BS,
                    backgroundColor: '#007bff',
                    borderColor: '#6610f2',
                    borderWidth: 1
                },
                {
                    label: "Movimiento en Dolares USD ",
                    data: dsm_USD,
                    backgroundColor: '#54e374',
                    borderColor: '#28a745',
                    borderWidth: 1
                },
                {
                    label: "Total acumulado en venta USD",
                    data: dsm_acumulado,
                    backgroundColor: '#E8611F',
                    borderColor: '#9B3E10',
                    borderWidth: 1
                },
                {
                    label: "Total Pendiente en venta USD",
                    data: dsm_pendiente,
                    backgroundColor: '#FF3535',
                    borderColor: '#B90A0A',
                    borderWidth: 1
                }
            ]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                title: {
                    display: true,
                    text: 'Ventas semanal (Pagos)'
                },
                tooltips: {
                    callbacks: {
                        label: function(tooltipItem, chart) {
                            var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                            return datasetLabel + ' ' + tooltipItem.yLabel;
                        }
                    }
                },
                scales: {
                    yAxes: [{
                        ticks: {
                            beginAtZero: true,
                            callback: function(value, index, values) {
                                return value;
                            }
                        }
                    }]
                }
            }
        });

    });
}

var chartVentasSemanalesdocumento = '';
var ventasSemanalesdocumento = document.getElementById('ventasSemanalesDocumento').getContext('2d');

function obtenerIngresosDiariosDocumento() {
    chartVentasSemanalesdocumento.destroy();
    chartVentasSemanalesdocumentoHora.destroy();
    
    _ingresosDiariosDocumentoHora();
    _ingresosDiariosDocumento();
}

function _ingresosDiariosDocumento() {
let sucursal = document.getElementById("sucursal").value;
let mes = document.getElementById("meses").value;
let divisa = document.getElementById("divisas").value;

    axios({
        method: 'post',
        url: 'facturacion/obtenerIngresosDiariosDocumentos',
        data:  {
            sucursal: sucursal,
            mes: mes,
            divisa: divisa
        },
        transformRequest: serializar(),
    }).then(response => {
        let ingreso_dsm = response.data.dias_semana;

        let dsm_venta = [0, 0, 0, 0, 0, 0, 0];
        let dsm_documento = [0, 0, 0, 0, 0, 0, 0];

        Object.keys(ingreso_dsm).forEach(function(k) {
            for (let i = 0; i < 7; i++) {
                if (ingreso_dsm[k].n_dia_semana == i) {
                    dsm_venta[i] += ingreso_dsm[k].venta;
                    dsm_documento[i] += ingreso_dsm[k].documentos;
                }
            }
        });

        chartVentasSemanalesdocumento = new Chart(ventasSemanalesdocumento, {
            type: 'bar',
            data: {
                labels: ['Lun', 'Mar', 'Mié', 'Jue', 'Vie', 'Sáb', 'Dom'],
                datasets: [{
                    label: "Monto",
                    data: dsm_venta,
                    backgroundColor: '#007bff',
                    borderColor: '#007bff8f',
                    borderWidth: 1
                },
                {
                    label: "cantidad de documentos",
                    data: dsm_documento,
                    backgroundColor: '#54e374',
                    borderColor: '#54e374a1',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                title: {
                    display: true,
                    text: 'Ventas semanales (Dia)'
                },
                tooltips: {
                    callbacks: {
                        label: function(tooltipItem, chart) {
                            if(tooltipItem.datasetIndex===0){
                                var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                                return datasetLabel + ' ' + monedaMoneda(tooltipItem.yLabel, response.data.div_locale, response.data.div_simbolo);
                            }else{
                                var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                                return datasetLabel + ' ' + tooltipItem.yLabel;
                            }
                           
                        },
                    }
                },
                scales: {
                    yAxes: [{
                        ticks: {
                            beginAtZero: true,
                            callback: function(value, index, values) {
                                return value;
                            }
                        }
                    }]
                }
            }
        });

    });
}


var chartVentasSemanalesdocumentoHora = '';
var ventasSemanalesdocumentoHora = document.getElementById('ventasSemanalesDocumentoHora').getContext('2d');


function _ingresosDiariosDocumentoHora() {

    let sucursal = document.getElementById("sucursal").value;
    let mes = document.getElementById("meses").value;
    let divisa = document.getElementById("divisas").value;
    
        axios({
            method: 'post',
            url: 'facturacion/obtenerIngresosDiariosDocumentosHora',
            data:  {
                sucursal: sucursal,
                mes: mes,
                divisa: divisa
            },
            transformRequest: serializar(),
        }).then(response => {
            let ingreso_dsm = response.data.horas;
    
            let tit=['08 AM', '09 AM', '10 AM', '11 AM', '12 PM', '01 PM', '02 PM', '03 PM', '04 PM','05 PM','06 PM','07 PM','08 PM'];
            let dsm_venta = [0, 0, 0, 0, 0, 0, 0,0,0,0,0,0,0];
            let dsm_documento =[0, 0, 0, 0, 0, 0, 0,0,0,0,0,0,0];
            
            Object.keys(ingreso_dsm).forEach(function(k) {
                for (let i = 0; i <13; i++) {
                    if (ingreso_dsm[k].hora== tit[i]) {
                        dsm_venta[i] = ingreso_dsm[k].venta;
                        dsm_documento[i] = ingreso_dsm[k].documentos;
                    }
                }
            });
    
            chartVentasSemanalesdocumentoHora = new Chart(ventasSemanalesdocumentoHora, {
                type: 'bar',
                data: {
                    labels: ['08 AM', '09 AM', '10 AM', '11 AM', '12 PM', '01 PM', '02 PM', '03 PM', '04 PM','05 PM','06 PM','07 PM','08 PM'],
                    datasets: [{
                        label: "Monto",
                        data: dsm_venta,
                        backgroundColor: '#37ecff',
                        borderColor: '#37ecff6b',
                        borderWidth: 1
                    },
                    {
                        label: "cantidad de documentos",
                        data: dsm_documento,
                        backgroundColor: '#f9972f',
                        borderColor: '#f9972f91',
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    title: {
                        display: true,
                        text: 'Ventas semanales (Hora)'
                    },
                    tooltips: {
                        callbacks: {
                            label: function(tooltipItem, chart) {
                                if(tooltipItem.datasetIndex===0){
                                    var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                                    return datasetLabel + ' ' + monedaMoneda(tooltipItem.yLabel, response.data.div_locale, response.data.div_simbolo);
                                }else{
                                    var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                                    return datasetLabel + ' ' + tooltipItem.yLabel;
                                }
                               
                            },
                        }
                    },
                    scales: {
                        yAxes: [{
                            ticks: {
                                beginAtZero: true,
                                callback: function(value, index, values) {
                                    return value;
                                }
                            }
                        }]
                    }
                }
            });
    
        });
    }


    var chartVentasSemanalescompraMes = '';
    var ventasSemanalescompraMes= document.getElementById('ventasSemanalescompraMes').getContext('2d');

    
function _ingresosDiarioscompraMes() {

    let anio = document.getElementById("mes_anio").value;
    let divisas = document.getElementById("mes_divisas").value;
    let sucursal = document.getElementById("sucursal").value;
        axios({
            method: 'post',
            url: 'facturacion/produccionMes',
            data:  {
                anio: anio,
                divisa:divisas,
                sucursal:sucursal
            },
            transformRequest: serializar(),
        }).then(response => {
            let ingreso_dsm = response.data.meses;
    
            let tit=[1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12];
            let dsm_venta = [0, 0, 0, 0, 0, 0, 0,0,0,0,0,0];
            let dsm_documento =[0, 0, 0, 0, 0, 0, 0,0,0,0,0,0];
            
            Object.keys(ingreso_dsm).forEach(function(k) {
                for (let i = 0; i <12; i++) {
                    if (ingreso_dsm[k].mes== tit[i]) {
                        dsm_venta[i] = ingreso_dsm[k].venta;
                        dsm_documento[i] = ingreso_dsm[k].cantidad;
                    }
                }
            });
    
            chartVentasSemanalescompraMes = new Chart(ventasSemanalescompraMes, {
                type: 'bar',
                data: {
                    labels: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep','Oct','Nov','Dic'],
                    datasets: [{
                        label: "Porcentaje en ventas",
                        data: dsm_venta,
                        backgroundColor: '#37ecff',
                        borderColor: '#37ecff6b',
                        borderWidth: 1
                    },
                    {
                        label: "Total de articulos",
                        data: dsm_documento,
                        backgroundColor: '#f9972f',
                        borderColor: '#f9972f91',
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    title: {
                        display: true,
                        text: 'Reporte de ventas mensuales'
                    },
                    tooltips: {
                        callbacks: {
                            label: function(tooltipItem, chart) {
                                if(tooltipItem.datasetIndex===0){
                                    var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                                    return datasetLabel + ' ' + monedaMoneda(tooltipItem.yLabel, response.data.div_locale, response.data.div_simbolo);
                                }else{
                                    var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                                    return datasetLabel + ': ' + tooltipItem.yLabel;
                                }
                               
                            },
                        }
                    },
                    scales: {
                        yAxes: [{
                            ticks: {
                                beginAtZero: true,
                                callback: function(value, index, values) {
                                    return value;
                                }
                            }
                        }]
                    }
                }
            });
    
        });
    }


    function obtenerIngresosDiariosComprasMes() {
        chartVentasSemanalescompraMes.destroy();
        ///if(document.getElementById('sucursal').value!=''){
            _ingresosDiarioscompraMes();
        //}
    }

window.onload = _ingresosDiariosDocumentoHora();
window.onload = _ingresosDiariosDocumento();
window.onload = _ingresosDiarios();
window.onload = _ingresosDiarioscompraMes();