
Vue.component('v-select', VueSelect.VueSelect)

new Vue({
    el: '#appCarritoVer',
    data: {
        id_factura: document.getElementById('id_fac').value,
        cliente: document.getElementById('id_cliente_fac').value,
        div_nombre_master: '',
        div_locale: '',
        div_simbolo: '',
        div_decimal: 2,
        div_conv_factor: 1,
        factura: [],
        divisa_pagar: '',
        metodo_pagar: '',
        cuenta_pagar: '',
        abonos: [],
        cuentas: [],
        metodos_de_pagos: [],
        formDocumentos: { 'id_factura': '', 'descripcion': '', 'documento': '' },
        documentos: [],
        monto: 0,
        restante_original: 0,
        articulosTotal: 0,
        total_pagado: 0,
        descuento: 0,
        restante: 0,
        subtotal: 0,
        total: 0,
        neto: 0,
        iva: 0,
        divisa_predeterminada: '',
        almacen_predeterminado: '',
        serie_predeterminada: '',
        sucursal_predeterminada: '',
        productos: [],
        carrito: [],
        money: {
            locale: '',
            decimal: '.',
            thousands: ',',
            prefix: '',
            suffix: '',
            precision: 2,
            masked: false /* doesn't work with directive */
        },
        moneyPagar: {
            locale: '',
            decimal: '.',
            thousands: ',',
            prefix: '',
            suffix: '',
            precision: 2,
            masked: false
        },
        moneyConver: {
            decimal: '.',
            thousands: ',',
            prefix: '',
            suffix: '',
            precision: 2,
            masked: false
        },
        moneyBs: {
            decimal: ',',
            thousands: '.',
            prefix: '',
            suffix: '',
            precision: 2,
            masked: false
        },
        cargando: false,
        errorForm: [],
        loader_correo: false,
        observacion_anular: '',
        cargando_documento: false,
        creditos: [],
        ver_contenedor_campos_pagar: true,
        select_credito: '',
        ubicacionProductos: [],
        conv_factor: '',
        conv_simbolo: '',
        conv_locale: '',
        conv_precision: '',
        divisa_convertir_p: '',
        divisa_convertir_s: '',
        monto_conv: 0.00,
        diferencia_credito: 0.00,
        divisa_pagar_credito: '',
        metodo_pagar_credito: '',
        cuenta_pagar_credito: '',
        pagar_descripcion_credito: '',
        generar_credito: false,
        comisiones_por_agentes: [],
        dataEditar: { id: 0, porcentaje: 1, monto: '', total: '', divisa: '', comisiones: [], id_comision: 0 },
        agentes_todos: [],
        creditosFactura: [],
        idCreditoImprimir: '',
        divisa_pagar_comision: '',
        agentes: '',
        captado: { id: '', nombre: '' },
        loader_convertir: false,
        prodCompuestos: [],
        sucursales_empleado: [],
        series_empleado: [],
        compra_dolares: false,
        cuenta_compradolares: '',
        pagomovil: 0,
        referencia: '',
        campos: [{ cm: '' }],
        numeroCampos: 1,
        pago_movil: [],
        redesSociales: [],
        form_redes: '',
        form_descripcion: '',
        form_id: '',
        cambiar_estatus: true,
        formWhatsapp: { telefono: '', mensaje: '' },
        clientes_lista: [],
        lic: { id: '', serial: '', fecha: '', comentario: '', factura: '' },
        articulos_total: 0,
        productobuscar: [],
        prodbuscar: '',
        buscarpro: '',
        productob: '',
        preciospro: [],
        almacenespro: [],
        cargandopro: '',
        impresoraid: 0,
        numfactura: 0
    },
    created() {
        this.obtenerfacturaFiscal();
    },
    methods: {
        async obtenerfacturaFiscal() {
            await axios.get('poseditar/obtenerFactura/' + this.id_factura).then(response => {
                this.factura = response.data.factura;

                this.obtenerSucursalesEmpleado();
                this.clientes_lista = response.data.licencia;
                this.almacen_predeterminado = this.factura.id_almacen;
                this.sucursal_predeterminada = this.factura.sucursal;
                this.serie_predeterminada = this.factura.id_serie
                this.divisa_predeterminada = this.factura.id_divisa
                this.div_nombre_master = response.data.div_nombre;
                this.div_locale = response.data.div_locale;
                this.div_simbolo = response.data.div_simbolo;
                this.div_decimal = response.data.div_decimal;

                this.moneyPagar.locale = this.money.locale = response.data.divisa.locale;
                this.moneyPagar.prefix = this.money.prefix = response.data.divisa.symbol + ' ';
                this.moneyPagar.decimal = this.money.decimal = response.data.divisa.decimal;
                this.moneyPagar.thousands = this.money.thousands = response.data.divisa.thousands;
                this.moneyPagar.precision = this.money.precision = response.data.divisa.precision;

                this.articulosTotal = response.data.articulos_cantidad;
                this.articulos_total = response.data.articulos_total;
                this.subtotal = Number(response.data.subtotal).toFixed(this.money.precision);
                this.descuento = Number(response.data.descuento).toFixed(this.money.precision);
                this.neto = Number(response.data.neto).toFixed(this.money.precision);
                this.iva = Number(response.data.iva).toFixed(this.money.precision);
                this.total = Number(response.data.total).toFixed(this.money.precision);
                this.restante_original = Number(response.data.restante).toFixed(this.money.precision);
                this.restante = Number(response.data.restante).toFixed(this.money.precision);
                this.total_pagado = Number(response.data.total_pagado).toFixed(this.money.precision);
                this.carrito = response.data.data_carrito;
                this.abonos = response.data.abonos;
                this.pago_movil = response.data.pago_movil;
                this.creditosFactura = response.data.creditos;
                this.obtenerDocumentos();
                this.obtenerRedesSociales();

                document.getElementById('confirmarp').disabled = true;
                this.obtenerCreditos();
                this.obtenerubicacionProductos();
                this.obtenerAgente(this.cliente);
            }).catch(e => notificacion());
        },
        modalLicencia(row) {
            this.lic.id = row.id;
            this.lic.serial = row.serial;
            this.lic.fecha = row.fecha;
            this.lic.comentario = row.comentario;
            $('#modal_licencia').modal('show');
        },
        GuardarLicencias() {
            this.lic.factura = this.id_factura;
            axios({
                method: "post",
                url: "poseditar/GuardarLicencias",
                data: this.lic,
                transformRequest: serializar(),
            })
                .then((response) => {
                    if (response.data == true) {
                        this.lic.id = '';
                        this.lic.fecha = '';
                        this.lic.serial = '';
                        this.lic.comentario = '';
                        notificacion('fa fa-check', 'Actualizado', "Actualizado exitosamente", 'warning');
                        $('#modal_licencia').modal('hide');
                        axios.get('poseditar/obtenerFactura/' + this.id_factura).then(response => {
                            this.clientes_lista = response.data.licencia;
                        });
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }


                }).catch(e => notificacion());
        },
        deleteValue: function (index) {
            this.campos.splice(index, 1);
            this.numeroCampos = this.numeroCampos - 1;
            //this.$emit('input', this.campos);
        },
        addValue: function () {
            this.campos.push({ cm: '' });
            this.numeroCampos = this.numeroCampos + 1;
            //this.$emit('input', this.campos);
            console.log(this.campos);
        },
        borrarSeleccionCredito() {
            //   if(this.compra_dolares==true){
            this.compra_dolares = false;
            // }
        },
        borrarSeleccionCompra() {
            //   if(this.compra_dolares==true){
            this.generar_credito = false;
            axios({
                method: 'post',
                url: 'poseditar/pagomovil',
                data: {
                    id_factura: this.id_factura,
                    monto: this.monto
                },
                transformRequest: serializar(),
            }).then(response => {
                this.pagomovil = response.data;
            })
                .catch((e) => notificacion());

            // }
        },
        obtenerSucursalesEmpleado() {
            axios
                .get("notasdeentrega/obtenerSucursalesEmpleado")
                .then((response) => {
                    this.sucursales_empleado = response.data.sucursales;
                    this.obtenerSeriesEmpleado();
                })
                .catch((e) => notificacion());
        },
        obtenerSeriesEmpleado() {
            axios
                .get("notasdeentrega/obtenerSeriesAlmacenesEmpleado/" + this.sucursal_predeterminada)
                .then((response) => {
                    this.series_empleado = response.data.series;
                })
                .catch((e) => notificacion());
        },
        comboProductosCompuestos(producto) {
            axios.get('notasdeentregaeditar/obtenerProductosCompuestos/' + producto.id).then(response => {
                if (response.data != false) {
                    this.prodCompuestos = response.data;
                    $('#modal_productoscompuesto').modal('show');
                    console.log(response.data)
                }
            }).catch(e => notificacion());
        },
        obtenerubicacionProductos() {
            axios.get('poseditar/obtenerubicacionProductos/' + Number(this.id_factura)).then(response => {
                this.ubicacionProductos = response.data;
            }).catch(e => notificacion());
        },
        obtenerCreditosFactura() {
            axios.get('poseditar/obtenerCreditosFactura/' + Number(this.id_factura)).then(response => {
                this.creditosFactura = response.data;
            }).catch(e => notificacion());
        },
        obtenerCreditos() {
            this.ver_contenedor_campos_pagar = true;
            axios.get('notasdeentregaeditar/obtenerCreditos/' + this.cliente).then(response => {
                this.creditos = response.data;
            }).catch(e => notificacion()).finally(() => { });
        },
        pagarConCredito() {
            let input_pagar = document.getElementById('pagarmonto');
            if (this.select_credito) {
                axios.get('poseditar/obtenerFactor', {
                    params: {
                        id_factura: this.id_factura,
                        id_credito: this.select_credito
                    }
                }).then(response => {
                    if (response.data.errors == null) {
                        this.monto = Number(response.data).toFixed(2);
                        this.ver_contenedor_campos_pagar = false;
                        input_pagar.disabled = true;
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => { });
            } else {
                this.monto = 0;
                this.ver_contenedor_campos_pagar = true;
                input_pagar.disabled = false;
            }
        },
        actualizarDetalles() {

            this.errorForm = [];

            let dataFormClienteDetalle = {
                'id': this.cliente,
                'cli_tipodoc': document.getElementById('cli_tipodoc').value,
                'cli_dni': document.getElementById('cli_dni').value,
                'cli_razon_social': document.getElementById('cli_razon_social').value,
                'cli_fecha_nac': document.getElementById('cli_fecha_nac').value,
                'cli_email': document.getElementById('cli_email').value,
                'cli_telefono': document.getElementById('cli_telefono').value,
                'cli_telefono_2': '',
                'cli_direccion': document.getElementById('cli_direccion').value,
                'cli_contribuyente': '',
                'cli_estatus': '',
                'cli_fecha_reg': '',
                'cli_genero': '',
                'cli_paisid': document.getElementById('cli_pais').value,
                'cli_estado': document.getElementById('cli_estado').value,
                'cli_ciudad': document.getElementById('cli_ciudad').value,
                'cli_codigopostal': document.getElementById('cli_codigopostal').value,
                'cli_descuento': '',
                'cli_razonsocial': '',
                'cli_natural': '',
                'cli_grupid': '',
                'cli_observaciones': '',
                'id_agente': this.captado.id,
                'id_captado': this.captado.nombre,
                'factura': this.id_factura
            };

            if (!dataFormClienteDetalle.cli_tipodoc)
                this.errorForm.push('El campo Tipo de Documento es obligatorio');
            if (!dataFormClienteDetalle.cli_dni)
                this.errorForm.push('El campo Número de Documento es obligatorio.');
            if (!dataFormClienteDetalle.cli_direccion)
                this.errorForm.push('El campo Dirección es obligatorio');
            if (!dataFormClienteDetalle.cli_razon_social)
                this.errorForm.push('El campo Razón Social es obligatorio.');

            if (this.errorForm.length == 0) {
                this.cargando = true;
                axios({
                    method: 'post',
                    url: 'poseditar/guardarDetallesCliente',
                    data: dataFormClienteDetalle,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            document.getElementById('cabecera_cliente').innerHTML = dataFormClienteDetalle.cli_razon_social + ' ' + dataFormClienteDetalle.cli_dni;
                            notificacion('fa fa-edit', '', 'Actualización exitosa', 'info');
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => this.cargando = false);
            } else {
                let total_errores = this.errorForm.length
                for (let i = 0; i < total_errores; i++) {
                    notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                }
            }
        },
        actualizarEnvio() {

            this.errorForm = [];

            let dataFormClienteEnvio = {
                'id_factura': this.id_factura,
                'env_nombre_opcional': document.getElementById('env_nombre_opcional').value,
                'env_agencia_transporte': document.getElementById('env_agencia_transporte').value,
                'env_codigo_seguimiento': document.getElementById('env_codigo_seguimiento').value,
                'env_direccion': document.getElementById('env_direccion').value,
                'env_pais': document.getElementById('env_pais').value,
                'env_estado': document.getElementById('env_estado').value,
                'env_ciudad': document.getElementById('env_ciudad').value,
                'env_codigopostal': document.getElementById('env_codigopostal').value,
                'env_asegurado': document.getElementById('env_asegurado').checked
            };

            if (!dataFormClienteEnvio.env_agencia_transporte)
                this.errorForm.push('El campo Agencia de Tranporte es obligatorio.');
            if (!dataFormClienteEnvio.env_codigo_seguimiento)
                this.errorForm.push('El campo Codigo de seguimiento es obligatorio.');
            if (!dataFormClienteEnvio.env_direccion)
                this.errorForm.push('El campo Dirección obligatorio.');
            if (!dataFormClienteEnvio.env_pais)
                this.errorForm.push('El campo País es obligatorio.');
            if (!dataFormClienteEnvio.env_estado)
                this.errorForm.push('El campo Estado es obligatorio.');
            if (!dataFormClienteEnvio.env_ciudad)
                this.errorForm.push('El campo Ciudad es obligatorio.');
            if (!dataFormClienteEnvio.env_codigopostal)
                this.errorForm.push('El campo Código Postal es obligatorio.');

            if (this.id_factura && this.cliente && this.errorForm.length == 0) {
                this.cargando = true;
                axios({
                    method: 'post',
                    url: 'poseditar/guardarEnvioCliente',
                    data: dataFormClienteEnvio,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data) {
                            if (document.getElementById('env_asegurado').checked == true) {
                                notificacion('fa fa-check', '', 'Envío asegurado', 'success');
                            } else {
                                notificacion('fa fa-info', '', 'Envío No asegurado', 'info');
                            }
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => this.cargando = false);
            } else {
                let total_errores = this.errorForm.length
                for (let i = 0; i < total_errores; i++) {
                    notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                }
            }
        },
        modalPagar() {
            document.getElementById('modal_form_pagar').reset();
            this.monto = 0.00;
            this.monto = Number(this.monto).toFixed(this.moneyPagar.precision);
            this.errorForm = [];
            this.divisa_pagar = '';
            this.metodo_pagar = '';
            this.metodos_de_pagos = [];
            this.cuenta_pagar = '';
            this.cuentas = [];
            this.referencia = '';
            axios.get('poseditar/comprobarFactura/' + this.id_factura).then(response => {
                if (response.data.errors == null) {
                    $('#modal_pagar').modal({ show: true, backdrop: 'static', keyboard: false });
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            });
        },
        obtenerMetodosSegunDivisa: function (event) {

            this.errorForm = [];
            this.metodo_pagar = '';
            this.metodos_de_pagos = [];
            this.cuenta_pagar = '';
            this.cuentas = [];

            if (!event.target.value)
                this.errorForm.push('La divisa es requerida');

            if (this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'poseditar/obtenerMetodosSegunDivisa',
                    data: { 'id_factura': this.id_factura, 'id_divisa': event.target.value },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data) {
                            this.moneyPagar.locale = response.data.divisa.locale;
                            this.moneyPagar.prefix = response.data.divisa.symbol + ' ';
                            this.moneyPagar.decimal = response.data.divisa.decimal;
                            this.moneyPagar.thousands = response.data.divisa.thousands;
                            this.moneyPagar.precision = response.data.divisa.precision;
                            this.metodos_de_pagos = response.data.data_metodos;
                            this.div_conv_factor = monedaDecimal(response.data.factor, 'en-US', 2);
                            this.restante_original = Number(response.data.restante).toFixed(this.moneyPagar.precision);
                            this.restante = parseFloat(response.data.restante * response.data.factor).toFixed(this.moneyPagar.precision);
                            this.monto = Number(this.monto).toFixed(this.moneyPagar.precision);                            //this.monto = this.restante;
                        }
                    } else {
                        this.divisa_pagar = '';
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        obtenerCuentasSegunMetodo: function (event) {
            this.errorForm = [];
            this.cuenta_pagar = '';
            this.cuentas = [];

            if (!event.target.value)
                this.errorForm.push('El Método de Pago es requerido');

            if (this.errorForm.length == 0) {
                axios.get('poseditar/obtenerCuentasSegunMetodo/' + event.target.value).then(response => {
                    if (response.data.errors == null) {
                        if (Array.isArray(response.data)) {
                            if (response.data.length > 0) {
                                this.cuentas = response.data;
                            }
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        pagar() {

            if (!this.ver_contenedor_campos_pagar) {
                axios.get('poseditar/pagarConCredito', {
                    params: {
                        id_fac: this.id_factura,
                        id_credito: this.select_credito
                    }
                }).then(response => {
                    console.log(response.data)
                    if (response.data.errors == null) {
                        if (response.data) {
                            this.monto = 0.00;
                            this.abonos = response.data.abonos;
                            this.restante_original = Number(response.data.restante).toFixed(this.moneyPagar.precision);
                            this.restante = parseFloat(response.data.restante * convertir_a_float(String(this.div_conv_factor))).toFixed(this.moneyPagar.precision);
                            this.monto = this.monto.toFixed(this.moneyPagar.precision);
                            this.total_pagado = Number(response.data.total_pagado).toFixed(this.moneyPagar.precision);
                            //this.monto = this.restante;
                            if (response.data.pagado) {
                                $('#modal_pagar').modal('hide');
                                notificacion('fa fa-check', 'Advertencia', 'Total de factura pagada', 'success');
                            } else {
                                notificacion('fa fa-check', 'Pago', 'Pago exitoso', 'success');
                            }
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                    this.obtenerCreditos();
                }).catch(e => notificacion()).finally(() => {
                    let input_pagar = document.getElementById('pagarmonto');
                    input_pagar.disabled = false;
                    input_pagar.value = '';
                });
            } else {

                this.errorForm = [];

                if (!this.divisa_pagar)
                    this.errorForm.push('El campo Divisa es obligatorio');
                if (!this.metodo_pagar)
                    this.errorForm.push('El campo Método es obligatorio');
                if (!this.cuenta_pagar)
                    this.errorForm.push('El campo Cuenta es obligatorio');
                if (!this.monto)
                    this.errorForm.push('El campo Monto es obligatorio');

                if (this.errorForm.length == 0) {
                    this.cargando = true;
                    axios({
                        method: 'post',
                        url: 'poseditar/pagar',
                        data: {
                            id_factura: this.id_factura,
                            id_divisa: this.divisa_pagar,
                            id_metodo_divisa: this.metodo_pagar,
                            id_cuenta_metodo: this.cuenta_pagar,
                            monto: this.monto,
                            credito: this.generar_credito,
                            compra_dolares: this.compra_dolares,
                            cuenta_pagod: JSON.stringify(this.campos),
                            referencia: this.referencia,
                            factor: convertir_a_float(String(this.div_conv_factor))
                        },
                        transformRequest: serializar(),
                    }).then(response => {
                        console.log(response.data)
                        if (response.data.errors == null) {
                            if (response.data) {
                                this.monto = 0.00;
                                this.abonos = response.data.abonos;
                                this.pago_movil = response.data.pago_movil;
                                this.restante_original = Number(response.data.restante).toFixed(this.moneyPagar.precision);
                                this.restante = parseFloat(response.data.restante * convertir_a_float(String(this.div_conv_factor))).toFixed(this.moneyPagar.precision);
                                this.monto = this.monto.toFixed(this.moneyPagar.precision);
                                this.total_pagado = Number(response.data.total_pagado).toFixed(this.moneyPagar.precision);
                                //this.monto = this.restante;
                                if (response.data.pagado) {
                                    $('#modal_pagar').modal('hide');
                                    notificacion('fa fa-check', 'Advertencia', 'Total de factura pagada', 'success');
                                } else {
                                    notificacion('fa fa-check', 'Pago', 'Pago exitoso', 'success');
                                }
                            }
                        } else {
                            let total_errores = response.data.errors.length
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => {
                        notificacion();
                    }).finally(() => {
                        this.cargando = false;
                        this.monto = 0;
                        this.divisa_pagar = ''
                        this.metodo_pagar = '';
                        this.cuenta_pagar = '';
                        this.obtenerCreditosFactura();
                    });
                } else {
                    let total_errores = this.errorForm.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                    }
                }
            }
        },
        eliminarPago(id) {
            axios({
                method: 'post',
                url: 'poseditar/eliminarPago',
                data: { 'id_factura': this.id_factura, 'id': id },
                transformRequest: serializar(),
            }).then(response => {
                if (response.data.errors == null) {
                    if (response.data) {
                        this.monto = 0.00;
                        this.abonos = response.data.abonos;
                        this.restante_original = Number(response.data.restante).toFixed(this.money.precision);
                        this.restante = parseFloat(response.data.restante * convertir_a_float(String(this.div_conv_factor))).toFixed(this.money.precision);
                        this.monto = this.monto.toFixed(this.money.precision);
                        this.total_pagado = Number(response.data.total_pagado).toFixed(this.money.precision);
                        //this.monto = this.restante;
                        notificacion('fa fa-trash', 'Eliminado', 'Pago eliminado', 'danger');
                    }
                } else {
                    this.divisa_pagar = '';
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        modalCorreo() {
            $('#modal_correo').modal('show');
        },
        enviarFactura() {

            this.errorForm = [];

            let de = document.getElementById('cor_emailde').value;
            let para = document.getElementById('cor_emailpara').value;
            let copia = document.getElementById('cor_emailcopia').value;
            let firma = document.getElementById('cor_emailfirma').value;
            let tipo = document.getElementById('cor_tipo').value;

            if (!de)
                this.errorForm.push('El campo De es obligatorio.');
            if (!para)
                this.errorForm.push('El campo Para es obligatorio.');

            if (de && para) {
                if (!validaEmail(de))
                    this.errorForm.push('El Correo Electrónico ' + de + ' no es válido.');
                if (!validaEmail(para))
                    this.errorForm.push('El Correo Electrónico ' + para + ' no es válido.');
            }

            if (this.errorForm.length == 0) {

                this.loader_correo = true;

                axios({
                    method: 'post',
                    url: 'poseditar/eniviarFactura',
                    data: {
                        id_factura: this.id_factura,
                        de: de,
                        para: para,
                        copia: copia,
                        firma: firma,
                        tipo: tipo
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data) {
                            notificacion('fa fa-check', 'Enviado', response.data, 'success');
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => this.loader_correo = false);
            } else {
                let total_errores = this.errorForm.length
                for (let i = 0; i < total_errores; i++) {
                    notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                }
            }
        },
        handleFileUpload() {
            this.formDocumentos.documento = this.$refs.file.files[0];
        },
        enviarDocumento() {

            this.errorForm = [];

            this.formDocumentos.id_factura = this.id_factura;

            if (!this.formDocumentos.descripcion)
                this.errorForm.push('El campo Descripción es obligatorio.');

            if (!this.formDocumentos.documento)
                this.errorForm.push('El Documento es obligatorio.');

            if (this.errorForm.length == 0) {
                this.cargando_documento = true;
                axios({
                    method: 'post',
                    url: 'poseditar/enviarDocumento',
                    data: this.formDocumentos,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            this.obtenerDocumentos();
                            notificacion('fa fa-check', 'Enviado', 'documento cargado exitosamente', 'success');
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => this.cargando_documento = false);
            } else {
                let total_errores = this.errorForm.length
                for (let i = 0; i < total_errores; i++) {
                    notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                }
            }
        },
        obtenerDocumentos() {
            axios.get('poseditar/obtnerDocumentos/' + this.id_factura).then(response => {
                this.documentos = response.data;
            });
        },
        moneda(num, div_locale_, div_simbolo_, decimal_ = 2) {
            if (Object.keys(this.carrito).length > 0) {
                let monto_ = convertir_a_float(String(num).toString());
                return monedaMoneda(monto_, div_locale_, div_simbolo_, decimal_);
            }
        },
        decimal(num, div_locale_, decimal_ = 2) {
            if (Object.keys(this.carrito).length > 0) {
                let monto_ = convertir_a_float(String(num).toString());
                return monedaDecimal(monto_, div_locale_, decimal_);
            }
        },
        modalAnular() {
            $('#modal_anular').modal();
            $('#modal_anular').on('shown.bs.modal', function () {
                $('#observacion_anular').trigger('focus')
            });
        },
        anular() {
            Swal.fire({
                title: '<strong>¿Anular factura?</strong>',
                showCloseButton: true,
                showCancelButton: true,
                focusConfirm: false,
                cancelButtonColor: '#aaa',
                confirmButtonColor: '#3085d6',
                confirmButtonText: 'Aceptar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.value) {
                    if (this.factura.impreso == 1) {
                        $('#modal_anular').modal('hide');
                        $('#modal-imprimir-anular').modal('show');
                        this.numfactura = document.getElementById("idreimpresion").value;
                    } else {
                        axios.get('poseditar/anularFactura', {
                            params: {
                                id_factura: this.id_factura,
                                descripcion: this.observacion_anular
                            }
                        }).then(response => {
                            if (response.data.errors == null) {
                                if (response.data !== false) {
                                    location.href = response.data;
                                } else {
                                    notificacion('fa fa-ban', 'Error', 'Error al anular la factura', 'danger');
                                }
                            } else {
                                let total_errores = response.data.errors.length
                                for (let i = 0; i < total_errores; i++) {
                                    notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                                }
                            }
                        }).catch(e => notificacion()).finally(() => this.cargando = false);
                    }
                }
            });
        },
        modalImprimirCredito(id_credito) {
            this.idCreditoImprimir = id_credito;
            $('#modal-imprimir-credito').modal();
        },
        imprimirCredito(id_impresora) {
            axios.get('poseditar/imprimirCredito', {
                params: {
                    id_credito: Number(this.idCreditoImprimir),
                    id_impresora: id_impresora
                }
            }).then(response => {
                console.log(response.data);
                if (response.data.errors == null) {
                    if (response.data !== false) {
                        fetch(response.data.ip_puerto, {
                            method: 'POST',
                            body: JSON.stringify(response.data.data)
                        }).then((j) => {
                            console.log(j);
                            if (j.ok) {
                                notificacion('fa fa-check', 'Impreso', 'Impresion exitosa', 'success');
                                axios.get('poseditar/facturaImpresa/' + Number(this.id_factura)).then(response => {
                                    notificacion('fa fa-info', '', response.data, 'info');
                                }).catch(e => {
                                    notificacion('fa fa-ban', 'No impreso', 'debe actualizar manualmente el documento como impreso', 'success');
                                });
                            } else {
                                notificacion('fa fa-ban', 'Error', 'Respuesta de red OK pero respuesta HTTP no OK', 'warning');
                            }
                        }).catch((error) => {
                            notificacion('fa fa-ban', 'Error', 'Hubo un problema con la petición Fetch:' + error.message, 'danger');
                        });
                    }
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        modalImprimir() {
            $('#modal-imprimir').modal();
        },
        imprimirAnular(id) {
            this.loader_convertir = true;
            axios.get('poseditar/imprimirAnular', {
                params: {
                    id_factura: Number(this.id_factura),
                    impresora: id,
                    numero: Number(this.numfactura)
                }
            }).then(response => {
                console.log(response.data);
                if (response.data.data.errors == null) {
                    if (response.data !== false) {
                        fetch(response.data.ip_puerto, {
                            method: 'POST',
                            body: JSON.stringify(response.data.data)
                        }).then((j) => {
                            console.log(j);
                            if (j.ok) {
                                notificacion('fa fa-check', 'Impreso', 'Impresion exitosa', 'success');
                                axios.get('poseditar/anularFactura', {
                                    params: {
                                        id_factura: this.id_factura,
                                        descripcion: this.observacion_anular
                                    }
                                }).then(response => {
                                    if (response.data.errors == null) {
                                        if (response.data !== false) {
                                            location.href = response.data;
                                        } else {
                                            notificacion('fa fa-ban', 'Error', 'Error al anular la factura', 'danger');
                                        }
                                    } else {
                                        let total_errores = response.data.errors.length
                                        for (let i = 0; i < total_errores; i++) {
                                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                                        }
                                    }
                                }).catch(e => notificacion()).finally(() => this.cargando = false);
                            } else {
                                notificacion('fa fa-ban', 'Error', 'Respuesta de red OK pero respuesta HTTP no OK', 'warning');
                                this.loader_convertir = false
                            }
                        }).catch((error) => {
                            notificacion('fa fa-ban', 'Error', 'Hubo un problema con la petición Fetch:' + error.message, 'danger');
                            this.loader_convertir = false
                        });
                    }
                } else {
                    this.loader_convertir = false;
                    let total_errores = response.data.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        imprimir(id) {
            this.loader_convertir = true;
            if (this.factura.impreso == 1) {
                this.loader_convertir = false;
                $('#modal-imprimir').modal('hide');
                $('#modal_reimprimir').modal('show');
                this.impresoraid = id;
            } else {
                axios.get('poseditar/imprimir', {
                    params: {
                        id_factura: Number(this.id_factura),
                        impresora: id,
                    }
                }).then(response => {
                    console.log(response.data);
                    if (response.data.data.errors == null) {
                        if (response.data !== false) {
                            fetch(response.data.ip_puerto, {
                                method: 'POST',
                                body: JSON.stringify(response.data.data)
                            }).then((j) => {
                                console.log(j);
                                if (j.ok) {
                                    notificacion('fa fa-check', 'Impreso', 'Impresion exitosa', 'success');
                                    axios.get('poseditar/facturaImpresa/' + Number(this.id_factura)).then(response => {
                                        notificacion('fa fa-info', '', response.data, 'info');
                                        this.loader_convertir = false;
                                        this.modal_numfactura();
                                    }).catch(e => {
                                        notificacion('fa fa-ban', 'No impreso', 'debe actualizar manualmente el documento como impreso', 'success');
                                        this.loader_convertir = false
                                    });
                                } else {
                                    notificacion('fa fa-ban', 'Error', 'Respuesta de red OK pero respuesta HTTP no OK', 'warning');
                                    this.loader_convertir = false
                                }
                            }).catch((error) => {
                                notificacion('fa fa-ban', 'Error', 'Hubo un problema con la petición Fetch:' + error.message, 'danger');
                                this.loader_convertir = false
                            });
                        }
                    } else {
                        let total_errores = response.data.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.data.errors[i], 'warning');
                        }
                        this.loader_convertir = false
                    }
                }).catch(e => notificacion());
            }
        },
        modal_numfactura() {
            $('#modal-numimprimir').modal('show');
        },
        ActualizarNumFactura() {
            this.loader_convertir = true;
            axios({
                method: "post",
                url: "poseditar/ActualizarNumFactura",
                data: {
                    id_factura: Number(this.id_factura),
                    num: Number(document.getElementById("idnumfactura").value),
                },
                transformRequest: serializar(),
            }).then((response) => {
                if (response.data == true) {
                    notificacion('fa fa-check', 'Actualizado', "Actualizado exitosamente", 'success');
                    $('#modal-numimprimir').modal('hide');
                } else {
                    let total_errores = response.data.errors.length;
                    for (let i = 0; i < total_errores; i++) {
                        notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
                    }
                }
                this.loader_convertir = false;
            })
                .catch((e) => notificacion())
                .finally(() => (this.loader_convertir = false));
        },
        reimprimirFactura() {
            this.loader_convertir = true;
            axios.get('poseditar/reimprimirFactura', {
                params: {
                    id_factura: Number(document.getElementById("num_reimpresion").value),
                    impresora: this.impresoraid,
                }
            }).then(response => {
                console.log(response.data);
                if (response.data.data.errors == null) {
                    if (response.data !== false) {
                        fetch(response.data.ip_puerto, {
                            method: 'POST',
                            body: JSON.stringify(response.data.data)
                        }).then((j) => {
                            console.log(j);
                            if (j.ok) {
                                notificacion('fa fa-check', 'Reimpreso', 'Impresion exitosa', 'success');
                                axios.get('poseditar/facturaImpresa/' + Number(this.id_factura)).then(response => {
                                    notificacion('fa fa-info', '', response.data, 'info');
                                    this.loader_convertir = false;
                                    $('#modal_reimprimir').modal('hide');
                                }).catch(e => {
                                    notificacion('fa fa-ban', 'No impreso', 'debe actualizar manualmente el documento como impreso', 'success');
                                    this.loader_convertir = false;
                                });
                                this.impresoraid = 0;
                            } else {
                                notificacion('fa fa-ban', 'Error', 'Respuesta de red OK pero respuesta HTTP no OK', 'warning');
                                this.loader_convertir = false;
                            }
                        }).catch((error) => {
                            notificacion('fa fa-ban', 'Error', 'Hubo un problema con la petición Fetch:' + error.message, 'danger');
                            this.loader_convertir = false;
                        });
                    }
                } else {
                    let total_errores = response.data.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.data.errors[i], 'warning');
                    }
                    this.loader_convertir = false;
                }
            }).catch(e => notificacion());
        },
        colocarEnMonto() {
            if (this.ver_contenedor_campos_pagar == true) {
                this.monto_conv = this.monto = Number(this.restante).toFixed(this.moneyPagar.precision);
            }
        },
        conversor() {
            if (this.divisa_convertir_p && this.divisa_convertir_s) {
                axios.get('generico/conversion', {
                    params: {
                        'div_p': this.divisa_convertir_p,
                        'div_s': this.divisa_convertir_s
                    }
                }).then(response => {
                    if (!this.monto_conv) this.monto_conv = 0;
                    this.monto_conv = convertir_a_float(this.monto_conv);
                    this.monto_conv = this.monto_conv.toFixed(response.data.divisa_conv.precision);
                    this.moneyConver.decimal = response.data.divisa_conv.decimal;
                    this.moneyConver.thousands = response.data.divisa_conv.thousands;
                    this.moneyConver.prefix = response.data.divisa_conv.symbol;
                    this.moneyConver.precision = response.data.divisa_conv.precision;
                    this.conv_factor = response.data.factor;
                    this.conv_simbolo = response.data.divisa_result.symbol;
                    this.conv_local = response.data.divisa_result.locale;
                    this.conv_precision = response.data.divisa_result.precision;
                    let total = this.monto_conv * this.conv_factor;
                    total = monedaMoneda(total, this.conv_local, this.conv_simbolo, this.conv_precision);
                    document.getElementById('result_conv').value = total;
                }).catch(e => notificacion());
            }
        },
        convedorInput() {
            if (this.divisa_convertir_p && this.divisa_convertir_s) {
                let total = convertir_a_float(this.monto_conv) * this.conv_factor;
                total = monedaMoneda(total, this.conv_local, this.conv_simbolo, this.conv_precision);
                document.getElementById('result_conv').value = total;
            }
        },
        modalCrearCredito() {
            this.errorForm = [];
            this.divisa_pagar_credito = '';
            this.metodo_pagar_credito = '';
            this.cuenta_pagar_credito = '';
            this.pagar_descripcion_credito = '';
            this.cuentas = [];
            this.metodos_de_pagos = [];
            $('#modal_crear_credito').modal('show');
        },
        pagarCredito() {

            this.errorForm = [];

            if (!this.serie_predeterminada)
                this.errorForm.push('El campo Serie es obligatorio');
            if (!this.divisa_pagar_credito)
                this.errorForm.push('El campo Divisa es obligatorio');
            if (!this.metodo_pagar_credito)
                this.errorForm.push('El campo Método es obligatorio');
            if (!this.cuenta_pagar_credito)
                this.errorForm.push('El campo Cuenta es obligatorio');
            if (!this.diferencia_credito)
                this.errorForm.push('El campo Monto es obligatorio');

            if (this.errorForm.length == 0) {
                this.cargando = true;
                axios({
                    method: 'post',
                    url: 'poseditar/guardarCredito',
                    data: {
                        id_factura: this.id_factura,
                        id_serie: this.serie_predeterminada,
                        monto: this.diferencia_credito,
                        id_divisa: this.divisa_pagar_credito,
                        id_metodo_divisa: this.metodo_pagar_credito,
                        id_cuenta_metodo: this.cuenta_pagar_credito,
                        observacion: this.pagar_descripcion_credito
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    console.log(response.data);
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            notificacion('fa fa-check', '', 'Operación exitosa', 'success');
                        } else {
                            notificacion('fa fa-ban', 'Error', 'Error en la operación', 'danger');
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                    this.obtenerCreditosFactura();
                    this.divisa_pagar_credito = '';
                    this.metodo_pagar_credito = '';
                    this.cuenta_pagar_credito = '';
                    this.pagar_descripcion_credito = '';
                    this.cuentas = [];
                    this.metodos_de_pagos = [];
                    $('#modal_crear_credito').modal('hide');
                });
            }
        },
        obtenerComisionesActivas() {
            axios.get('generico/obtenerComisionesactivas').then(response => {
                if (response.data != null) {
                    this.dataEditar.comisiones = response.data;
                }
            }).catch(e => notificacion());
        },
        obtenerAgenteVenta() {
            axios.get('generico/obtenerAgenteVenta').then(response => {
                if (response.data != null) {
                    this.agentes_todos = response.data;
                }
            }).catch(e => notificacion());
        },
        async obtenerAgente() {
            this.errorForm = [];
            axios.get('poseditar/obtenerAgente/' + this.id_factura).then(response => {
                this.agentes = response.data;
                this.captado.nombre = this.agentes.empagent_captado;
                this.captado.id = this.agentes.empagent_empid;
            }).catch(e => notificacion());
        },
        obtenerComisionFactNotaPendiente() {
            axios.get('poseditar/obtenerComisionesPendiente/' + Number(this.id_factura))
                .then(response => {
                    if (response.data) {
                        this.obtenerAgenteVenta();
                        this.obtenerComisionesActivas();
                        this.comisiones_por_agentes = response.data;
                    }
                }).catch(e => notificacion());
        },
        eliminarComisionPendiente(id) {
            if (id > 0) {
                Swal.fire({
                    title: 'Eliminar Comision',
                    text: "¿Estás seguro de querer eliminar esta comision pendiente ?",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#aaa',
                    confirmButtonText: 'Eliminar'
                }).then((result) => {
                    if (result.value) {
                        axios.get('generico/eliminarComisionPendiente/' + id).then(response => {
                            if (response.data == true) {
                                this.obtenerComisionFactNotaPendiente();
                                notificacion('fa fa-trash', 'Comision eliminada', '', 'danger');
                            } else {
                                notificacion('fa fa-ban', 'Error al eliminar la dirección de envío', this.dataTipoCom.nombrecom.toUpperCase(), 'danger');
                            }
                        }).catch(e => notificacion());
                    }
                });
            } else {
                notificacion('fa fa-ban', 'Advertencia', 'Error en la seleccion.', 'warning');
            }
        },
        factor_b() {
            let rest = convertir_a_float(String(this.restante_original));
            let factor = convertir_a_float(String(this.div_conv_factor));
            let fact = rest * factor;
            this.restante = fact;
        },
        modalAgregarAgente() {
            this.divisa_pagar_comision = this.divisa_predeterminada;
            $('#modal_agregarag').modal('show');
        },
        agregaragente() {

            let agente = document.getElementById('agenteid').value;
            let comision = document.getElementById('comisionesa').value;
            let monto = document.getElementById('montoca').value;

            this.errorAgente = [];

            if (agente == 0)
                this.errorAgente.push('Debe seleccionar un agente.');
            if (comision == 0)
                this.errorAgente.push('Debe seleccionar la comision, para realizar los cambios.');
            if (monto == 0)
                this.errorAgente.push('Debe agregar un monto, para realizar los cambios.');

            if (this.errorAgente.length == 0) {
                axios({
                    method: 'post',
                    url: 'poseditar/agregaragente',
                    data: {
                        id_agente: agente,
                        id_comision: comision,
                        id_factura: this.id_factura,
                        monto: monto,
                        id_divisa: this.divisa_pagar_comision
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            this.obtenerComisionFactNotaPendiente();
                            notificacion('fa fa-edit', '', 'Agente agregado correctamente', 'info');
                        } else {
                            notificacion('fa fa-ban', '', response.data, 'warning');
                        }
                    } else {
                        let total_errores = response.data.errors.length;
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => {
                    agente = '';
                    comision = '';
                    monto = '';
                });
            } else {
                let total_errores = this.errorAgente.length;
                for (let i = 0; i < total_errores; i++) {
                    notificacion('fa fa-ban', 'Advertencia', this.errorAgente[i], 'warning');
                }
            }
        },
        modalPendienteeditar(id, porcentaje, monto, total, divisa) {
            $('#modal_pendiente').modal('show');
            this.dataEditar.id = id;
            this.dataEditar.porcentaje = porcentaje;
            this.dataEditar.total = total;
            this.dataEditar.monto = convertir_a_float(String(monto)).toFixed(this.money.precision);
            this.dataEditar.divisa = divisa;
        },
        editarpendiente() {
            axios({
                method: 'post',
                url: 'poseditar/editarpendiente',
                data: {
                    id: this.dataEditar.id,
                    porcentaje: this.dataEditar.porcentaje,
                    monto: this.dataEditar.monto,
                },
                transformRequest: serializar(),
            }).then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        this.obtenerComisionFactNotaPendiente();
                        notificacion('fa fa-check', 'Actualizacion', 'Modificado exitosamente', 'success');
                    }
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());

        },
        obtenerRedesSociales() {
            axios.get('clientes/obtenerRedesSociales/' + this.cliente).then(response => {
                this.redesSociales = response.data;
            }).catch(e => notificacion());
        },
        editarGuardarRedes() {

            this.errorForm = [];

            if (!this.form_redes)
                this.errorForm.push('Seleccione el tipo de red social obligatorio.');

            if (!this.form_descripcion)
                this.errorForm.push('Agregue la descripcion de la red social obligatorio.');

            if (this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'clientes/guardarRedes',
                    data: {
                        'tipo': this.form_redes,
                        'descripcion': this.form_descripcion,
                        'id': this.cliente,
                        'rd': this.form_id
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        this.obtenerRedesSociales();
                        this.form_descripcion = '';
                        this.form_id = '';
                        this.form_redes = '';
                    } else {
                        this.errorForm = response.data.errors;
                    }
                }).catch(e => notificacion());
            }
        },
        verRedes(redes) {
            this.errorForm = [];
            this.form_redes = redes.clird_type;
            this.form_descripcion = redes.clird_descripcion;
            this.form_id = redes.clird_id;
        },
        eliminarRedes(redes) {

            this.errorForm = [];

            Swal.fire({
                title: 'Eliminar Red social',
                text: "¿Estás seguro que deseas eliminar la red social " + redes.clird_type + " ?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('clientes/eliminarRedes/' + redes.clird_id).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                let posicion = this.redesSociales.findIndex(item => item.id == redes.clird_id);
                                this.redesSociales.splice(posicion, 1);
                                notificacion('fa fa-trash', 'Red social eliminada', redes.clird_descripcion.toUpperCase(), 'danger');
                            } else {
                                notificacion('fa fa-ban', 'Error al eliminar', redes.clird_descripcion.toUpperCase(), 'danger');
                            }
                        } else {
                            this.errorForm = response.data.errors;
                        }
                    }).catch(e => notificacion()).finally(() => {
                        this.form_redes = '';
                        this.form_descripcion = '';
                        this.form_id = '';
                    })
                }
            });
        },
        modal_whatsapp() {
            let mensaje = document.getElementById('nombEmpresa').value + ' le recuerda que tiene ' + document.getElementById('cant_pend').value + ' facturas pendientes por un monto de ' + document.getElementById('pagot').value;
            let mens = mensaje + ', agradecemos que cumpla con sus compromisos de pago.';
            window.open('https://api.whatsapp.com/send?phone=+58' + document.getElementById('telcli').value + '&text=' + mens);
        }
    },
    computed: {
        costo() {
            let sum = 0;
            if (Object.keys(this.carrito).length > 0) {
                Object.keys(this.carrito).forEach((key, i) => {
                    let costo = parseFloat(this.carrito[key].costo);
                    let cantidad = parseFloat(this.carrito[key].cantidad);
                    sum += costo * cantidad;
                    if (sum <= 0) {
                        sum = 0;
                    }
                });
            }
            return this.moneda(sum, this.money.locale, this.money.prefix, this.money.precision);
        },
        balance: function () {
            let total = convertir_a_float(String(this.restante));
            let monto = convertir_a_float(String(this.monto));
            let balance_ = (total - monto);
            if (balance_ <= 0) {
                balance_ = 0;
            }
            return this.moneda(balance_, this.moneyPagar.locale, this.moneyPagar.prefix, this.moneyPagar.precision);
        },
        diferencia_n() {
            let total = convertir_a_float(String(this.restante));
            let monto = convertir_a_float(String(this.monto));
            let balance_ = (total - monto);
            return balance_ = (balance_ <= 0) ? Math.abs(balance_) : 0;
        },
        diferencia: function () {
            let total = convertir_a_float(String(this.restante));;
            let monto = convertir_a_float(String(this.monto));
            let balance_ = (total - monto);
            balance_ = (balance_ <= 0) ? Math.abs(balance_) : 0;
            return this.moneda(balance_, this.moneyPagar.locale, this.moneyPagar.prefix, this.moneyPagar.precision);
        },
        porcentajemonto: function () {
            let total = convertir_a_float(String(this.dataEditar.total));
            let monto = convertir_a_float(String(this.dataEditar.monto));
            let Tcomision_ = (monto * 100) / total;
            Tcomision_ = (Tcomision_ >= 0) ? Tcomision_ : 0;
            this.dataEditar.porcentaje = convertir_a_float(String(Tcomision_)).toFixed(this.money.precision);
            return this.dataEditar.porcentaje;
        },
        map_input() {
            let map = document.getElementById("pac-input").value;
            document.getElementById('cli_direccion').value = map;
        },
        modal_redes() {
            $('#modal-whatsapp').modal('show');
            let maps = document.getElementById('cli_direccion').value;
            let dir = (document.getElementById('txtLat').value != '') ? ' MAPS: https://www.google.com/maps/search/?api=1%26query=' + document.getElementById('txtLat').value + ',' + document.getElementById('txtLng').value : '';

            this.formWhatsapp.mensaje = 'Cliente: ' + document.getElementById('cli_razon_social').value + ', Documento: ' + document.getElementById('cli_dni').value + ', Direccion: ' + document.getElementById('cli_direccion').value + ', Correo electronico: ' + document.getElementById('cli_email').value + ', Telefono: ' + document.getElementById('cli_telefono').value + dir;
        },
        enviarWhatsapp() {
            if (this.formWhatsapp.telefono.length > 0 && this.formWhatsapp.mensaje.length > 0) {
                window.open('https://api.whatsapp.com/send?phone=+58' + this.formWhatsapp.telefono + '&text=' + this.formWhatsapp.mensaje);
            } else {
                notificacion('fa fa-ban', 'Debe llenar todos los campo', '', 'warning');
            }
        },
    }
});