var currentFocus;

new Vue({
  el: "#appCarrito",
  data: {
    cliente: document.getElementById("id_cliente_fac").value,
    id_tab: document.getElementById("id_tab").value,
    observaciones: "",
    articulosTotal: 0,
    descuento: 0,
    subtotal: 0,
    total: 0,
    neto: 0,
    iva: 0,
    productos: [],
    carrito: [],
    cargando: false,
    errorForm: [],
    divisa_nombre: "",
    almacen_nombre: "",
    toggleBarcode: false,
    emp_agente: "",
    ubicacionProductos: [],
    money: {
      locale: "",
      decimal: ".",
      thousands: ",",
      prefix: "",
      suffix: "",
      precision: 2,
      masked: false /* doesn't work with directive */,
    },
    agente_cliente: false,
    agente_seleccionado: { id: "", nombres: "", apellidos: "" },
    prodCompuestos:[],
    sucursal_predeterminada:'',
    sucursales_empleado:[],
    series_empleado:[],
    sucursals:'',
    disabled:false,
    serie_predeterminada:'',
    almacen_predeterminado:'',
    almacenes:[],
    lista_tarifas:[],
    tarifa:0,
  },
  created() {
    axios
      .get("facturacion/obtenerDivisaParaFactura")
      .then((response) => {
        this.money.locale = response.data.locale;
        this.money.prefix = response.data.symbol + " ";
        this.money.decimal = response.data.decimal;
        this.money.thousands = response.data.thousands;
        this.money.precision = response.data.precision;
      })
      .catch((e) => notificacion());
      //this.obtenerAgenteCliente();
      this.obtenerSucursalesEmpleado();
      this.obtenerTarifas();
  },
  mounted() {
    document.getElementById("buscador").focus();
  },
  methods: {
    seleccionarTarifa(){
      $('#modal_tarifas').modal('show');
   },
   obtenerTarifas(){
    axios
    .get("pos/obtenertarifas")
    .then((response) => {
        this.lista_tarifas = response.data;
    })
    .catch((e) => notificacion());
 },
    obtenerSucursalesEmpleado(){
      axios
      .get("pos/obtenerSucursalesEmpleado")
      .then((response) => {
        this.sucursales_empleado = response.data.sucursales;
        this.sucursals=response.data.id;
        if(response.data.desactivar==true){
          this.disabled=true
         }
        if(this.sucursals!=0){
          axios
          .get("pos/obtenerSeriesAlmacenesEmpleado/"+ this.sucursals)
          .then((response) => {
            this.almacenes = response.data.almacenes;
            this.almacen_predeterminado=response.data.id_alm;
            this.series_empleado = response.data.series;
            this.serie_predeterminada=response.data.id_ser;
          })
          .catch((e) => notificacion());
        }
      })
      .catch((e) => notificacion());
    },
    obtenerSeriesAlmacenesEmpleado(){
      axios
      .get("pos/obtenerSeriesAlmacenesEmpleado/"+ this.$refs.sucursal_predeterminada.value)
      .then((response) => {
        this.almacenes = response.data.almacenes;
        this.almacen_predeterminado=response.data.id_alm;
        this.series_empleado = response.data.series;
        this.serie_predeterminada=response.data.id_ser;
      })
      .catch((e) => notificacion());
    },
    comboProductosCompuestos(producto){
      axios.get('notasdeentregaeditar/obtenerProductosCompuestos/' + producto.id).then(response => {
          if (response.data != false) {
              this.prodCompuestos = response.data;
              $('#modal_productoscompuesto').modal('show');
              console.log(response.data)
          }
      }).catch(e => notificacion());
  },
    obtenerAgenteCliente() {
      axios
        .get("pos/obtenerAgenteCliente/" + Number(this.emp_agente))
        .then((response) => {
          if (response.data != false) {
            this.agente_cliente = true;
            this.agente_seleccionado.id = this.emp_agente;
            this.agente_seleccionado.nombres = response.data.einfo_nombres + " " + response.data.einfo_apellidos;
          }
        })
        .catch((e) => notificacion());
    },
    obtenerubicacionProductos() {
      axios
        .get("pos/obtenerubicacionProductos/" + this.cliente)
        .then((response) => {
          this.ubicacionProductos = response.data;
        })
        .catch((e) => notificacion());
    },
    cambiarAlmacen() {
      axios
        .get("pos/cambiarAlmacen/" + this.cliente)
        .then((response) => {
          if (response.data == true) {
            this.productos = [];
            this.articulosTotal = 0;
            this.subtotal = 0;
            this.descuento = 0;
            this.neto = 0;
            this.iva = 0;
            this.total = 0;
            this.carrito = [];
          } else {
            location.reload();
          }
        })
        .catch((e) => notificacion());
    },
    predeterminarDivisa(event) {
      axios
        .get("pos/predeterminarDivisa", {
          params: {
            id_cliente: this.cliente,
            id_divisa: event.target.value,
            descuento: this.descuento,
          },
        })
        .then((response) => {
          if (response.data.errors == null) {
            if (Object.keys(response.data.divisa).length > 0) {
              this.money.locale = response.data.divisa.locale;
              this.money.prefix = response.data.divisa.symbol + " ";
              this.money.decimal = response.data.divisa.decimal;
              this.money.thousands = response.data.divisa.thousands;
              this.money.precision = response.data.divisa.precision;
            }
            if (Object.keys(response.data.data_carrito).length > 0) {
              this.articulosTotal = response.data.data_carrito.articulos_cantidad;
              this.subtotal = response.data.data_carrito.subtotal;
              this.descuento = response.data.data_carrito.descuento;
              this.neto = response.data.data_carrito.neto;
              this.iva = response.data.data_carrito.iva;
              this.total = response.data.data_carrito.total;
              this.carrito = response.data.data_carrito.carrito;
            }
          } else {
            let total_errores = response.data.errors.length;
            for (let i = 0; i < total_errores; i++) {
              notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
            }
          }
        })
        .catch((e) => notificacion());
    },
    focusBuuscar() {
      document.getElementById("buscador").focus();
    },
    buscarProducto(event) {
      this.search(event.target.value, event, this);
    },
    search: _.debounce((search, event, vm) => {
      if (vm.toggleBarcode == false) {
        currentFocus = 0;
        let a, b;
        var x = document.getElementsByClassName("autocomplete-items");

        for (var i = 0; i < x.length; i++) {
          x[i].parentNode.removeChild(x[i]);
        }

        if (!search) {
          return false;
        }

        axios
          .get("pos/buscarProducto", {
            params: {
              divisa: vm.$refs.divisa_predeterminada.value,
              almacen: vm.$refs.almacen_predeterminado.value,
              buscar: search.trim(),
            },
          })
          .then((response) => {
            vm.productos = response.data;
          })
          .catch((e) => {
            notificacion();
          })
          .finally(() => {
            currentFocus = -1;

            a = document.createElement("div");
            a.id = event.target.id + "autocomplete-list";
            a.classList.add("autocomplete-items");
            event.target.parentNode.appendChild(a);

            let self = vm;

            vm.productos.forEach((item) => {
              b = document.createElement("div");

              if (item.imagen) {
                b.innerHTML +=
                  "<img src='" +
                  item.imagen +
                  "' class='avatar-img rounded-circle' style='width: 50px; height: 50px; margin-right: 15px'>";
              }

              if (item.pro_descripcion.substr(0, search.length).toUpperCase() == search.toUpperCase()) {
                b.innerHTML += "<strong>" + item.pro_descripcion.substr(0, search.length) + "</strong>";
                b.innerHTML += "<span>" + item.pro_descripcion.substr(search.length) + "</span>";
              } else {
                b.innerHTML += "<strong>" + item.pro_descripcion + "</strong>";
              }

              b.innerHTML +=
                "<small class='text-primary' style='margin-right: 5px'> stock: " + item.ps_cantidad + "</small> <br>";
              b.innerHTML +=
                "<small class='text-primary' style='margin-right: 10px'> fabricante: " + item.fabricante + "</small>";
              b.innerHTML +=
                "<input type='hidden' value='" +
                item.pro_id +
                "' data-almacen='" +
                item.id_almacen +
                "' data-name='" +
                item.pro_descripcion +
                "'>";

              b.addEventListener("click", function (e) {
                event.target.value = this.getElementsByTagName("input")[0].getAttribute("data-name");
                let id_producto = this.getElementsByTagName("input")[0].value;
                let id_almacen = this.getElementsByTagName("input")[0].getAttribute("data-almacen");

                self.agregarProducto(id_producto, id_almacen);

                for (var i = 0; i < x.length; i++) {
                  x[i].parentNode.removeChild(x[i]);
                }
              });

              a.appendChild(b);
            });
          });
      }
    }, 500),
    agregarProducto(id_producto, id_almacen) {
      if (this.$refs.divisa_predeterminada.value && id_producto && id_almacen && this.cliente) {
        axios({
          method: "post",
          url: "pos/agregarProducto",
          data: {
            id_cliente: this.cliente,
            id_producto: id_producto,
            id_almacen: id_almacen,
            id_divisa: this.$refs.divisa_predeterminada.value,
            descuento_global: this.descuento,
          },
          transformRequest: serializar(),
        })
          .then((response) => {
            if (response.data.errors == null) {
              this.articulosTotal = response.data.articulos_cantidad;
              this.subtotal = response.data.subtotal;
              this.descuento = response.data.descuento;
              this.neto = response.data.neto;
              this.iva = response.data.iva;
              this.total = response.data.total;
              this.carrito = response.data.carrito;
              this.obtenerubicacionProductos();
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion())
          .finally(() => {
            document.getElementById("buscador").value = "";
          });
      }
    },
    seleccionarProducto(event) {
      var x = document.getElementById(event.target.id + "autocomplete-list");

      if (x) x = x.getElementsByTagName("div");

      if (event.key == "ArrowDown") {
        currentFocus++;
        active(x);
      } else if (event.key == "ArrowUp") {
        currentFocus--;
        active(x);
      } else if (event.key == "Enter") {
        event.preventDefault();

        if (this.toggleBarcode == true) {
          this.agregarProductoBarcode(event.target.value);
          document.getElementById("buscador").value = "";
        } else {
          if (currentFocus > -1) {
            if (x) x[currentFocus].click();
          }
        }
      }
    },
    agregarProductoBarcode(producto) {
      if (this.$refs.divisa_predeterminada.value && this.$refs.almacen_predeterminado.value && this.cliente) {
        axios({
          method: "post",
          url: "pos/agregarProductoBarcode",
          data: {
            id_cliente: this.cliente,
            producto: producto,
            id_almacen: this.$refs.almacen_predeterminado.value,
            id_divisa: this.$refs.divisa_predeterminada.value,
            descuento_global: this.descuento,
          },
          transformRequest: serializar(),
        })
          .then((response) => {
            if (response.data.errors == null) {
              this.articulosTotal = response.data.articulos_cantidad;
              this.subtotal = response.data.subtotal;
              this.descuento = response.data.descuento;
              this.neto = response.data.neto;
              this.iva = response.data.iva;
              this.total = response.data.total;
              this.carrito = response.data.carrito;
              this.obtenerubicacionProductos();
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion());
      }
    },
    actualizarPrecio(unique, event) {
      let precio = convertir_a_float(event.target.value);
      if (event.target.value && precio > 0 && unique && this.cliente) {
        axios({
          method: "post",
          url: "pos/actualizarPrecio",
          data: {
            id_cliente: this.cliente,
            unique: unique,
            precio: event.target.value,
            descuento_global: this.descuento,
          },
          transformRequest: serializar(),
        })
          .then((response) => {
            if (response.data.errors == null) {
              this.articulosTotal = response.data.articulos_cantidad;
              this.subtotal = response.data.subtotal;
              this.descuento = response.data.descuento;
              this.neto = response.data.neto;
              this.iva = response.data.iva;
              this.total = response.data.total;
              Object.keys(response.data.carrito).forEach((key, i) => {
                this.carrito[key].neto = response.data.carrito[key].neto;
                this.carrito[key].total = response.data.carrito[key].total;
              });
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => console.log(e));
      }
    },
    ActualizarPrecioTarifa(){
      axios({
         method: "post",
         url: "pos/ActualizarPrecioTarifa",
         data: {
             'tarifa':this.tarifa,
             'id':this.cliente,
             'descuento_global': this.descuento,
         },
         transformRequest: serializar(),
     })
         .then((response) => {
             if (response.data.errors == null) {
              this.articulosTotal = response.data.articulos_cantidad;
              this.subtotal = response.data.subtotal;
              this.descuento = response.data.descuento;
              this.neto = response.data.neto;
              this.iva = response.data.iva;
              this.total = response.data.total;
                 $('#modal_tarifas').modal('hide');
                 Object.keys(response.data.carrito).forEach((key, i) => {
                     this.carrito[key].precio = response.data.carrito[key].precio;
                     this.carrito[key].neto = response.data.carrito[key].neto;
                     this.carrito[key].total = response.data.carrito[key].total;
                     this.carrito[key].tarifa = response.data.carrito[key].tarifa;
                 });
             } else {
                 let total_errores = response.data.errors.length
                 for (let i = 0; i < total_errores; i++) {
                     notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                 }
             }
         }).catch(e => notificacion());
 },
    actualizarCantidad(id_producto, event) {
      let cantidad = convertir_a_float(event.target.value);
      if (event.target.value && cantidad > 0 && this.errorForm.length == 0) {
        axios({
          method: "post",
          url: "pos/actualizarCantidad",
          data: {
            id_cliente: this.cliente,
            id_producto: id_producto,
            cantidad: event.target.value,
            descuento_global: this.descuento,
          },
          transformRequest: serializar(),
        })
          .then((response) => {
            if (response.data.errors == null) {
              this.articulosTotal = response.data.articulos_cantidad;
              this.subtotal = response.data.subtotal;
              this.descuento = response.data.descuento;
              this.neto = response.data.neto;
              this.iva = response.data.iva;
              this.total = response.data.total;
              Object.keys(response.data.carrito).forEach((key, i) => {
                this.carrito[key].neto = response.data.carrito[key].neto;
                this.carrito[key].total = response.data.carrito[key].total;
              });
            } else {
              if (response.data.cantidad > 0) {
                event.target.value = response.data.cantidad;
              }
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion());
      }
    },
    aplicarNuevoIva(unique, id_iva) {
      if (unique && id_iva && this.cliente) {
        axios({
          method: "post",
          url: "pos/aplicarNuevoIva",
          data: {
            id_cliente: this.cliente,
            unique: unique,
            id_iva: id_iva,
            descuento: this.descuento,
          },
          transformRequest: serializar(),
        })
          .then((response) => {
            if (response.data.errors == null) {
              this.articulosTotal = response.data.articulos_cantidad;
              this.subtotal = response.data.subtotal;
              this.descuento = response.data.descuento;
              this.neto = response.data.neto;
              this.iva = response.data.iva;
              this.total = response.data.total;
              this.carrito = response.data.carrito;
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion());
      }
    },
    aplicarDescuentoProducto(unique, event) {
      let descuento_ = convertir_a_float(event.target.value);
      if (unique && this.cliente) {
        axios({
          method: "post",
          url: "pos/aplicarDescuentoProducto",
          data: {
            id_cliente: this.cliente,
            unique: unique,
            descuento: descuento_,
            descuento_global: this.descuento,
          },
          transformRequest: serializar(),
        })
          .then((response) => {
            if (response.data.errors == null) {
              this.articulosTotal = response.data.articulos_cantidad;
              this.subtotal = response.data.subtotal;
              this.descuento = response.data.descuento;
              this.neto = response.data.neto;
              this.iva = response.data.iva;
              this.total = response.data.total;
              Object.keys(response.data.carrito).forEach((key, i) => {
                this.carrito[key].neto = response.data.carrito[key].neto;
                this.carrito[key].total = response.data.carrito[key].total;
              });
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion());
      }
    },
    aplicarDescuentoAdicional() {
      if (!isNaN(this.descuento) && this.descuento >= 0) {
        axios({
          method: "post",
          url: "pos/aplicarDescuentoAdicional",
          data: {
            descuento: this.descuento,
            id_cliente: this.cliente,
          },
          transformRequest: serializar(),
        })
          .then((response) => {
            if (response.data.errors == null) {
              this.articulosTotal = response.data.articulos_cantidad;
              this.subtotal = response.data.subtotal;
              this.neto = response.data.neto;
              this.iva = response.data.iva;
              this.total = response.data.total;
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion());
      }
    },
    eliminarProducto(unique) {
      if (this.cliente && unique) {
        axios({
          method: "post",
          url: "pos/eliminarProducto",
          data: {
            unique: unique,
            id_cliente: this.cliente,
            descuento_global: this.descuento,
          },
          transformRequest: serializar(),
        })
          .then((response) => {
            if (response.data.errors == null) {
              this.articulosTotal = response.data.articulos_cantidad;
              this.subtotal = response.data.subtotal;
              this.descuento = response.data.descuento;
              this.neto = response.data.neto;
              this.iva = response.data.iva;
              this.total = response.data.total;
              this.carrito = response.data.carrito;
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion());
      }
    },
    actualizarDetalles() {
      this.errorForm = [];

      let dataFormClienteDetalle = {
        id: this.cliente,
        cli_tipodoc: document.getElementById("cli_tipodoc").value,
        cli_dni: document.getElementById("cli_dni").value,
        cli_razon_social: document.getElementById("cli_razon_social").value,
        cli_fecha_nac: "",
        cli_email: "",
        cli_telefono: "",
        cli_telefono_2: "",
        cli_direccion: document.getElementById("cli_direccion").value,
        cli_contribuyente: "",
        cli_estatus: "",
        cli_fecha_reg: "",
        cli_genero: "",
        cli_paisid: document.getElementById("cli_pais").value,
        cli_estado: document.getElementById("cli_estado").value,
        cli_ciudad: document.getElementById("cli_ciudad").value,
        cli_codigopostal: document.getElementById("cli_codigopostal").value,
        cli_descuento: "",
        cli_razonsocial: "",
        cli_natural: "",
        cli_grupid: "",
        cli_observaciones: "",
      };

      if (!dataFormClienteDetalle.cli_tipodoc) this.errorForm.push("El campo Tipo de Documento es obligatorio");
      if (!dataFormClienteDetalle.cli_dni) this.errorForm.push("El campo Número de Documento es obligatorio.");
      if (!dataFormClienteDetalle.cli_direccion) this.errorForm.push("El campo Dirección es obligatorio");
      if (!dataFormClienteDetalle.cli_razon_social) this.errorForm.push("El campo Razón Social es obligatorio.");

      if (this.errorForm.length == 0) {
        this.cargando = true;
        axios({
          method: "post",
          url: "pos/guardarDetallesCliente",
          data: dataFormClienteDetalle,
          transformRequest: serializar(),
        })
          .then((response) => {
            if (response.data.errors == null) {
              if (response.data == true) {
                document.getElementById("cabecera_cliente").innerHTML =
                  dataFormClienteDetalle.cli_razon_social + " " + dataFormClienteDetalle.cli_dni;
                notificacion("fa fa-edit", "", "Actualización exitosa", "info");
              }
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion())
          .finally(() => (this.cargando = false));
      } else {
        let total_errores = this.errorForm.length;
        for (let i = 0; i < total_errores; i++) {
          notificacion("fa fa-ban", "Advertencia", this.errorForm[i], "warning");
        }
      }
    },
    actualizarDescripcion(unique, event) {
      this.errorForm = [];

      if (!event.target.value) this.errorForm.push("La descripción no debe quedar vacia.");

      if (this.cliente && this.errorForm.length == 0) {
        axios({
          method: "post",
          url: "pos/actualizarDescripcion",
          data: {
            id_cliente: this.cliente,
            unique: unique,
            descripcion: event.target.value,
          },
          transformRequest: serializar(),
        })
          .then((response) => {
            if (response.data.errors) {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion());
      } else {
        let total_errores = this.errorForm.length;
        for (let i = 0; i < total_errores; i++) {
          notificacion("fa fa-ban", "Advertencia", this.errorForm[i], "warning");
        }
      }
    },
    guardarFactura() {
      axios.get("notasdeentrega/nombreDivisa/" + this.$refs.divisa_predeterminada.value).then((response) => {
        this.divisa_nombre = response.data;
      });

      axios.get("notasdeentrega/nombreAlmacen/" + this.$refs.almacen_predeterminado.value).then((response) => {
        if (response.data) {
          this.almacen_nombre = response.data;

          Swal.fire({
            title: "<strong>¿Continuar?</strong>",
            html:
              "Documento: <strong>Factura en ventas </strong> <br>" +
              "Divisa: <strong>" +
              this.divisa_nombre +
              "</strong>" +
              "Almacén: <strong>" +
              this.almacen_nombre +
              "</strong>",
            showCloseButton: true,
            showCancelButton: true,
            focusConfirm: true,
            confirmButtonText: "SI",
            confirmButtonAriaLabel: "SI",
            cancelButtonText: "NO",
            cancelButtonAriaLabel: "NO",
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#aaa",
          }).then((result) => {
            if (result.value) {
              this.errorForm = [];

              if (this.carrito.length == 0) this.errorForm.push("No ha seleccinado algún producto para la compra");
              if (!this.$refs.serie_predeterminada.value) this.errorForm.push("Debe seleccionar una serie");
              if (!this.$refs.sucursal_predeterminada.value) this.errorForm.push("Debe seleccionar una Sucursal");
              if (!document.getElementById("fecha").value) this.errorForm.push("Debe seleccionar una fecha");

              if (this.cliente && this.errorForm.length == 0) {
                this.cargando = true;
                axios({
                  method: "post",
                  url: "pos/ventaEnEspera",
                  data: {
                    id_serie: this.$refs.serie_predeterminada.value,
                    id_sucursal: this.$refs.sucursal_predeterminada.value,
                    id_cliente: this.cliente,
                    fecha: document.getElementById("fecha").value,
                    observaciones: this.observaciones,
                    agente: this.emp_agente,
                    descuento_global: this.descuento,
                    id_tab: this.id_tab
                  },
                  transformRequest: serializar(),
                })
                  .then((response) => {
                    if (response.data.errors == null) {
                      location.href = response.data;
                    } else {
                      let total_errores = response.data.errors.length;
                      for (let i = 0; i < total_errores; i++) {
                        notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
                      }
                    }
                  })
                  .catch((e) => notificacion())
                  .finally(() => (this.cargando = false));
              } else {
                let total_errores = this.errorForm.length;
                for (let i = 0; i < total_errores; i++) {
                  notificacion("fa fa-ban", "Advertencia", this.errorForm[i], "warning");
                }
              }
            }
          });
        }
      });
    },
    chequearAgente(event) {
      if (event.target.value) {
        let agente_id = event.target.value;
        axios
          .get("pos/chequearAgente", {
            params: {
              id_cliente: this.cliente,
              id_agente: agente_id,
            },
          })
          .then((response) => {
            if (response.data.errors == null) {
              if (response.data == true) {
                this.obtenerAgenteCliente();
                this.emp_agente = agente_id;
                notificacion(
                  "fa fa-check",
                  "Agente",
                  "Agente seleccionado asignado por defecto a este cliente",
                  "success"
                );
              } else {
                notificacion("fa fa-ban", "Agente", "Error de operacion", "warning");
              }
            } else {
              let total_errores = response.data.errors.length;
              for (let i = 0; i < total_errores; i++) {
                notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
              }
            }
          })
          .catch((e) => notificacion());
      }
    },
    moneda(num, div_locale_, div_simbolo_, decimal_ = 2) {
      if (Object.keys(this.carrito).length > 0) {
        let monto_ = convertir_a_float(String(num).toString());
        return monedaMoneda(monto_, div_locale_, div_simbolo_, decimal_);
      }
    },
    decimal(num, div_locale_, decimal_ = 2) {
      if (Object.keys(this.carrito).length > 0) {
        let monto_ = convertir_a_float(String(num).toString());
        return monedaDecimal(monto_, div_locale_, decimal_);
      }
    },
  },
  computed:{
    costo() {
      let sum=0;
      if (Object.keys(this.carrito).length > 0) {
        Object.keys(this.carrito).forEach((key, i) => {
          let costo=parseFloat(this.carrito[key].costo);
          let cantidad=parseFloat(this.carrito[key].cantidad);
          sum+=costo*cantidad;
          if (sum <= 0) {
            sum = 0;
          }
        });
     }
      return this.moneda(sum, this.money.locale, this.money.prefix, this.money.precision);
    }
  }
});

function active(x) {
  if (!x) return false;

  for (var i = 0; i < x.length; i++) {
    x[i].classList.remove("autocomplete-active");
  }

  if (currentFocus >= x.length) currentFocus = 0;
  if (currentFocus < 0) currentFocus = x.length - 1;

  x[currentFocus].classList.add("autocomplete-active");
}

function closeAllLists(elmnt) {
  let inp = document.getElementById("buscador");
  let x = document.getElementsByClassName("autocomplete-items");
  for (var i = 0; i < x.length; i++) {
    if (elmnt != x[i] && elmnt != inp) {
      x[i].parentNode.removeChild(x[i]);
    }
  }
}

document.addEventListener("click", function (e) {
  closeAllLists(e.target);
});
