new Vue({
    el: '#appFabricantes',
    data: {
        titulo: '',
        accion: '',
        fabricantes: [],
        dataForm: { 'id': '', 'codigo': '', 'descripcion': '' },
        errorForm: [],
        cargando: false
    },
    created() {
        this.obtenerFabricantes();
    },
    methods: {
        obtenerFabricantes() {
            axios.get('fabricantes/obtenerFabricantes').then(response => {
                this.fabricantes = response.data;
            }).catch(e => notificacion());
        },
        resetearFormulario() {
            document.getElementById('form_modal_fabricantes').reset();
            this.dataForm.id = '';
            this.dataForm.codigo = '';
            this.dataForm.descripcion = '';
            this.errorForm = [];
        },
        modalGuardar() {
            this.resetearFormulario();
            this.titulo = 'Guardar fabricante';
            this.accion = 'Guardar';
            $('#modal_fabricantes').modal('show');
            $('#modal_fabricantes').on('shown.bs.modal', function () {
                $('#codigo').trigger('focus');
            });
        },
        ver(id, codigo, descripcion) {
            this.errorForm = [];
            this.dataForm.id = id;
            this.dataForm.codigo = codigo;
            this.dataForm.descripcion = descripcion;
            this.titulo = 'Editar fabricante';
            this.accion = 'Actualizar';
            $('#modal_fabricantes').modal('show');
        },
        editarGuardar: function () {

            this.errorForm = [];

            if (!this.dataForm.codigo)
                this.errorForm.push('El campo Código es obligatorio.');
            if (!this.dataForm.descripcion)
                this.errorForm.push('El campo Descripción es obligatorio.');

            if (this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'fabricantes/guardar',
                    data: this.dataForm,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            this.obtenerFabricantes();
                            if (this.dataForm.id !== '') {
                                $('#modal_fabricantes').modal('hide');
                                notificacion('fa fa-edit', 'Actualizado', 'Fabricante actualizado correctamente', 'info');
                            } else {
                                notificacion('fa fa-check', 'Registrado', 'Fabricante registrado correctamente', 'success');
                            }
                            this.resetearFormulario();
                        }
                    } else {
                        let total_errores = response.data.errors.length;
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        eliminar(id, nombre) {
            Swal.fire({
                title: 'Eliminar Fabricante',
                text: "¿Estás seguro que deseas eliminar el fabricante " + nombre + " ?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('fabricantes/eliminar/' + id).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                let posicion = this.fabricantes.findIndex(item => item.id == id);
                                this.fabricantes.splice(posicion, 1);
                                notificacion('fa fa-trash', 'Fabricante eliminado', nombre.toUpperCase(), 'danger');
                            } else {
                                notificacion('fa fa-ban', 'Error al eliminar', nombre.toUpperCase(), 'danger');
                            }
                        } else {
                            let total_errores = response.data.errors.length;
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion());
                }
            });
        }
    }
});