new Vue({
    el: '#appConfiguracionEmpresa',
    data: {
        dataForm: { 'ide': '', 'rde': 'RIF', 're': '', 'nce': '', 'ne': '', 'pide': '', 'cpe': '', 'de': '', 'coe': '', 'fae': '', 'oe': '', 'ee': '', 'ce': '', 'rie': '', 't1e': '', 't2e': '', 'passwd': '', 'hce': '', 'ptce': 587, cantiad: 0 },
        errorForm: [],
        cargando: false,
        cargando_correo: false,
        picked: '',
        agente: false,
        iva:false
    },
    created() {
        this.obtenerEmpresa();
    },
    methods: {
        obtenerEmpresa() {
            axios.get('empresa/obtenerDatosEmpresa').then(response => {
                if (Object.keys(response.data).length > 0) {
                    this.dataForm.ide = response.data.emp_id;
                    this.dataForm.rde = response.data.emp_rif_dni;
                    this.dataForm.re = response.data.emp_rif;
                    this.dataForm.nce = response.data.emp_nombrecorto;
                    this.dataForm.ne = response.data.emp_nombre;
                    this.dataForm.pide = response.data.emp_paisid;
                    this.dataForm.cpe = response.data.emp_codpostal;
                    this.dataForm.de = response.data.emp_direccion;
                    this.dataForm.coe = response.data.emp_email;
                    this.dataForm.fae = response.data.emp_fax;
                    this.dataForm.oe = response.data.emp_observaciones;
                    this.dataForm.ee = response.data.emp_estado;
                    this.dataForm.ce = response.data.emp_ciudad;
                    this.dataForm.t1e = response.data.emp_telefono_1;
                    this.dataForm.t2e = response.data.emp_telefono_2;
                    this.dataForm.passwd = response.data.emp_email_password;
                    this.dataForm.hce = response.data.emp_host_correo;
                    this.dataForm.cantidad = response.data.emp_cantidad;
                    this.picked = this.dataForm.hce;
                    this.dataForm.ptce = response.data.emp_port_correo;
                    this.agente = response.data.emp_figura_agente == 1 ? true : false;
                    this.iva = response.data.emp_iva == 1 ? true : false;
                }
            }).catch(e => {
                console.log(e)
                notificacion();
            });
        },
        toggleAgente() {
            axios.get('empresa/habilitarDeshabilitarFiguraAgente').then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        this.agente = !this.agente
                        notificacion('fa fa-edit', '', 'Actualizado', 'info');
                    }
                } else {
                    this.errorForm = response.data.errors;
                }
            }).catch(e => notificacion()).finally(() => this.cargando = false);
        },
         toggleIva() {
            axios.get('empresa/habilitarDeshabilitarIva').then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        this.iva = !this.iva
                        notificacion('fa fa-edit', '', 'Actualizado', 'info');
                    }
                } else {
                    this.errorForm = response.data.errors;
                }
            }).catch(e => notificacion()).finally(() => this.cargando = false);
        },
        submitEmpresa: function (e) {

            this.errorForm = [];

            if (!this.dataForm.rde)
                this.errorForm.push('El campo Id. Fiscal es requerido.');
            if (!this.dataForm.re)
                this.errorForm.push('El campo RIF es requerido.');
            if (!this.dataForm.nce)
                this.errorForm.push('El campo Nombre Corto es requerido.');
            if (!this.dataForm.ne)
                this.errorForm.push('El campo Nombre de Empresa es requerido.');
            if (!this.dataForm.pide)
                this.errorForm.push('El campo País es requerido.');
            if (!this.dataForm.cpe)
                this.errorForm.push('El campo Código Postal es requerido.');
            if (!this.dataForm.de)
                this.errorForm.push('El campo Dirección es requerido.');
            if (!this.dataForm.t1e)
                this.errorForm.push('El campo Teléfono uno es requerido.');
            if (!this.dataForm.passwd)
                this.errorForm.push('El campo Contraseña Correo es requerido.');
            if (!this.dataForm.coe) {
                this.errorForm.push('El Correo Electrónico es obligatorio.');
            } else if (!validaEmail(this.dataForm.coe)) {
                this.errorForm.push('El Correo Electrónico debe tener un formato válido.');
            }
            if (!this.dataForm.ptce)
                this.errorForm.push('El campo Puerto Correo es requerido.');
            if (!this.dataForm.hce)
                this.errorForm.push('El campo Host Correo es requerido.');

            if (this.errorForm.length == 0) {
                this.cargando = true;
                axios({
                    method: 'post',
                    url: 'empresa/guardar',
                    data: this.dataForm,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            notificacion('fa fa-edit', 'Actualización', 'Empresa actualizada exitosamente', 'info');
                        }
                    } else {
                        this.errorForm = response.data.errors;
                    }
                }).catch(e => notificacion()).finally(() => this.cargando = false);
            }
        },
        probarCorreo() {
            this.errorForm = [];
            this.cargando_correo = true;
            axios('empresa/probarCorreo').then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        notificacion('fa fa-check', 'Actualización', 'Correo correcto', 'success');
                    }
                } else {
                    let total_errores = response.data.errors.length;
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion()).finally(() => this.cargando_correo = false);
        },
        cambiarHostPuerto() {
            this.dataForm.hce = this.picked;
            if (this.picked == 'smtp.gmail.com') {
                this.dataForm.ptce = '587';
            } else if (this.picked == 'smtp.hotmail.com') {
                this.dataForm.ptce = '465';
            } else {
                this.dataForm.ptce = '25';
            }
        }
    }
});