new Vue({
    el: '#appEmpleados',
    data: {
        titulo: '',
        accion: '',
        empleados: [],
        dataForm: { 'id': '', 'nombres': '', 'apellidos': '', 'telefono': '', 'correo': '', 'direccion_uno': '', 'direccion_dos': '', 'ciudad': '', 'estado': '', 'agente_de_venta': false },
        errorForm: [],
        cargando: false,
        cargando_tabla: 'is-loading is-loading-lg'
    },
    created() {
        this.obtenerEmpleados();
    },
    methods: {
        obtenerEmpleados() {
            axios.get('empleados/obtenerEmpleados').then(response => {
                $('#tabla_empleados').DataTable().destroy();
                if (Array.isArray(response.data)) {
                    this.empleados = response.data;
                }
            }).catch(e => notificacion()).finally(() => {
                this.cargando_tabla = '';
                $('#tabla_empleados').DataTable();
            });
        },
        resetearFormulario() {
            document.getElementById('modal_form_empleado').reset();
            this.dataForm.id = '';
            this.dataForm.nombres = '';
            this.dataForm.apellidos = '';
            this.dataForm.telefono = '';
            this.dataForm.correo = '';
            this.dataForm.direccion_uno = '';
            this.dataForm.direccion_dos = '';
            this.dataForm.ciudad = '';
            this.dataForm.estado = '';
        },
        modalGuardar() {
            this.resetearFormulario();
            this.titulo = 'Guardar empleado';
            this.accion = 'Guardar';
            $('#modal_empleado').modal('show');
            $('#modal_empleado').on('shown.bs.modal', function () {
                $('#empnombres').trigger('focus');
            });
        },
        guardar() {

            this.errorForm = [];

            if (!this.dataForm.nombres)
                this.errorForm.push('El campo Nombres es obligatorio.');
            if (!this.dataForm.apellidos)
                this.errorForm.push('El campo Apellidos es obligatorio.');
            if (!this.dataForm.telefono)
                this.errorForm.push('El campo Teléfono es obligatorio.');
            if (!this.dataForm.correo) {
                this.errorForm.push('El campo Correo Electrónico es obligatorio.');
            } else if (!validaEmail(this.dataForm.correo)) {
                this.errorForm.push('El Correo Electrónico debe tener un formato válido.');
            }
            if (!this.dataForm.direccion_uno)
                this.errorForm.push('El campo Dirección es obligatorio.');
            if (!this.dataForm.ciudad)
                this.errorForm.push('El campo Ciudad es obligatorio.');
            if (!this.dataForm.estado)
                this.errorForm.push('El campo Estado es obligatorio.');

            if (this.errorForm.length == 0) {
                this.cargando = true;
                axios({
                    method: 'post',
                    url: 'empleados/guardarEmpleadoInfo',
                    data: this.dataForm,
                    transformRequest: serializar(),
                }).then(async response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            if (this.dataForm.id !== '') {
                                $('#modal_empleado').modal('hide');
                                notificacion('fa fa-edit', 'Registro', 'Empleado actualizado correctamente', 'info');
                            } else {
                                notificacion('fa fa-check', 'Registro', 'Empleado registrado correctamente', 'success');
                            }
                            this.obtenerEmpleados();
                            this.resetearFormulario();
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => this.cargando = false);
            }
        },
        modificarEstatus(id, etiqueta) {
            axios.get('empleados/modificarEstatus', {
                params: {
                    id: id
                }
            }).then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        let eti = document.getElementById(etiqueta);
                        eti.className = (eti.className === 'fa fa-times text-danger') ? 'fa fa-check text-success' : 'fa fa-times text-danger';
                        notificacion('fa fa-check', 'Actualizado', 'Estatus modificado', 'info');
                    } else {
                        notificacion('fa fa-times', 'Advertencia', 'Este empleado aun no tiene usuario', 'warning');
                    }
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        eliminar(id, nombre) {
            Swal.fire({
                title: 'Eliminar Empleado',
                text: "¿Estás seguro de eliminar el empleado " + nombre + " ?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('empleados/eliminarEmpleado', {
                        params: {
                            id: id
                        }
                    }).then(response => {
                        if (response.data) {
                            notificacion('fa fa-times', 'Empleado eliminado', nombre.toUpperCase(), 'danger');
                            this.obtenerEmpleados();
                        } else {
                            notificacion('fa fa-times', 'Error al eliminar', 'Este empleado aún no tiene usuario', 'danger');
                        }
                    }).catch(e => notificacion());
                }
            });
        }
    }
});