new Vue({
    el: '#appEmpleadoVer',
    data: {
        id_empleado: document.getElementById('empleado').value,
        dataForm: { 'id': '', 'nombres': '', 'apellidos': '', 'telefono': '', 'correo': '', 'direccion_uno': '', 'direccion_dos': '', 'ciudad': '', 'estado': '', 'agente_de_venta': false },
        dataFormUser: { 'id': '', 'emp_edatosid': '', 'nombre': '', 'password': '', 'repassword': '','obrero':false },
        errorForm: [],
        cargando: false,
        all_modules: [],
        serie: '',
        sucursales:'',
        almacen: '',
        clientes: [],
        series_empleado: [],
        sucursales_empleado:[],
        almacenes_empleado: [],
        imagen: '',
        upload_imagen: '',
        errorImage: [],
        ruta_imagen: '',
        permisosDeInicio: [],
        selectedPagina: '',
        selectedDivisa: '',
        miDivisa: '',
        cuenta: '',
        empleadoCuentas: [],
        empleadoDivisas: [],
        divisas: [],
        dataTipoCom: { id: 0, porcent: 0, nombrecom: '', estatus: true },
        dataEditar: { porcentaje: 0, monto: '', divisa: '', total: '' },
        dataPagoComisiones_id: '',
        comisionesAgentepagadas: [],
        comisionesAgentependientes: [],
        comisionestodas: [],
        comisionesAgente: [],
        agentes: [],
        picked: '',
        metodos_pg: [],
        cuentas_pg: [],
        money: {
            decimal: '.',
            thousands: ',',
            prefix: '',
            suffix: '',
            precision: 2,
            masked: false /* doesn't work with directive */
        },
        posicionDivisaApagar: '',
        spanPorcentaje: true,
        inputPorcentaje: false,
        documentos: [],
        errorFormComEmpDoc: [],
        idComEmp: '',
        documentos_asignados: [],
    },
    created() {
        this.obtenerEmpleado();
        this.obtenerDivisas();
        this.obtenerClienteAgente(this.id_empleado);
        this.obtenerComisiones();
        this.obtenerComisionesAgente(this.id_empleado);
    },
    methods: {
        predeterminadoSucursal(id,empleado) {
            axios.get('empleados/predeterminadoSucursal', {
                params: {
                    id: id,
                    empleado: empleado
                }
            }).then(response => {
                if (response.data== true) {
                    this.obtenerEmpleadoSucursales();
                    notificacion('fa fa-check', '', 'Actualizado exitosamente', 'success');
                } else {
                    notificacion('fa fa-ban', '', 'Error al actualizar', 'warning');
                }
            }).catch(e => notificacion());
        },
        predeterminadoSerie(id,empleado) {
            axios.get('empleados/predeterminadoSerie', {
                params: {
                    id: id,
                    empleado: empleado
                }
            }).then(response => {
                if (response.data== true) {
                    this.obtenerEmpleadoSeries();
                    notificacion('fa fa-check', '', 'Actualizado exitosamente', 'success');
                } else {
                    notificacion('fa fa-ban', '', 'Error al actualizar', 'warning');
                }
            }).catch(e => notificacion());
        },
        predeterminadoAlmacen(id,empleado) {
            axios.get('empleados/predeterminadoAlmacen', {
                params: {
                    id: id,
                    empleado: empleado
                }
            }).then(response => {
                if (response.data== true) {
                    this.obtenerEmpleadoAlmacenes();
                    notificacion('fa fa-check', '', 'Actualizado exitosamente', 'success');
                } else {
                    notificacion('fa fa-ban', '', 'Error al actualizar', 'warning');
                }
            }).catch(e => notificacion());
        },
        obtenerDivisas() {
            axios.get('empleados/obtenerDivisas/' + Number(this.dataFormUser.id)).then(response => {
                this.divisas = response.data;
            });
        },
        obtenerDivisasEmpleado() {
            axios.get('empleados/obtenerDivisasEmpleado/' + Number(this.dataFormUser.id)).then(response => {
                this.empleadoDivisas = response.data;
            });
        },
        obtenerEmpleado() {
            axios.get('empleados/obtenerEmpleado/' + this.id_empleado).then(response => {
                if (response.data) {
                    this.selectedDivisa = response.data.divisa;
                    this.dataForm.id = response.data.info.einfo_id;
                    this.dataForm.nombres = response.data.info.einfo_nombres;
                    this.dataForm.apellidos = response.data.info.einfo_apellidos;
                    this.dataForm.telefono = response.data.info.einfo_telefono_movil;
                    this.dataForm.correo = response.data.info.einfo_email;
                    this.dataForm.direccion_uno = response.data.info.einfo_direccion_1;
                    this.dataForm.direccion_dos = response.data.info.einfo_direccion_2;
                    this.dataForm.ciudad = response.data.info.einfo_ciudad;
                    this.dataForm.estado = response.data.info.einfo_estado;
                    this.dataForm.agente_de_venta = (response.data.info.einfo_agente_de_venta == 1) ? true : false;

                    if (response.data.info.einfo_imagen) {
                        this.ruta_imagen = imgURL + 'empleados/' + response.data.info.einfo_imagen;
                    } else {
                        this.ruta_imagen = baseURL + 'public/assets/img/default.png';
                    }

                    this.dataFormUser.emp_edatosid = response.data.info.einfo_id;

                    if (response.data.user) {
                        this.selectedPagina = response.data.pagina;
                        this.dataFormUser.id = response.data.user.emp_id;
                        this.dataFormUser.nombre = response.data.user.emp_username;
                        this.dataFormUser.password = '';
                        this.dataFormUser.repassword = '';
                        this.dataFormUser.obrero=(response.data.user.emp_tipo == 'OBRERO') ? true : false;
                        this.obtenerEmpleadoSeries();
                        this.obtenerEmpleadoSucursales();
                        this.obtenerEmpleadoAlmacenes();
                        this.obtenerPermisosDeInicio();
                        this.obtenerEmpleadoCuentas();
                        this.obtenerDivisasEmpleado();
                    }

                    this.all_modules = response.data.permisos;

                }
            }).catch(e => notificacion());
        },
        editarInfo() {

            this.errorForm = [];

            if (!this.dataForm.nombres)
                this.errorForm.push('El campo Nombres es obligatorio.');
            if (!this.dataForm.apellidos)
                this.errorForm.push('El campo Apellidos es obligatorio.');
            if (!this.dataForm.telefono)
                this.errorForm.push('El campo Teléfono es obligatorio.');
            if (!this.dataForm.correo) {
                this.errorForm.push('El campo Correo Electrónico es obligatorio.');
            } else if (!validaEmail(this.dataForm.correo)) {
                this.errorForm.push('El Correo Electrónico debe tener un formato válido.');
            }
            if (!this.dataForm.direccion_uno)
                this.errorForm.push('El campo Dirección es obligatorio.');
            if (!this.dataForm.ciudad)
                this.errorForm.push('El campo Ciudad es obligatorio.');
            if (!this.dataForm.estado)
                this.errorForm.push('El campo Estado es obligatorio.');

            if (this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'empleados/guardarEmpleadoInfo',
                    data: this.dataForm,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            notificacion('fa fa-edit', '', 'Empleado actualizado correctamente', 'info');
                        } else {
                            notificacion('fa fa-ban', '', 'Error al actualizar', 'warning');
                        }
                    } else {
                        this.errorForm = response.data.errors;
                    }
                }).catch(e => notificacion());
            }
        },
        editarGuardarUser() {

            this.errorForm = [];

            if (!this.dataFormUser.nombre)
                this.errorForm.push('El campo Usuario es obligatorio.');
            if (!this.dataFormUser.password)
                this.errorForm.push('El campo Contraseña es obligatorio.');
            if (this.dataFormUser.password !== this.dataFormUser.repassword)
                this.errorForm.push('La contraseña no conincide.');

            if (this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'empleados/guardarUsuario',
                    data: this.dataFormUser,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            this.obtenerEmpleado();
                            notificacion('fa fa-edit', '', 'Usuario actualizado correctamente', 'info');
                        } else {
                            notificacion('fa fa-ban', '', 'Error al actualizar usuario', 'warning');
                        }
                    } else {
                        this.errorForm = response.data.errors;
                    }
                }).catch(e => notificacion());
            }
        },
        permitirModulo(id_modulo, permiso) {
            this.errorForm = [];
            axios({
                method: 'post',
                url: 'empleados/permitirModulo',
                data: {
                    id_empleado: this.dataFormUser.id,
                    id_modulo: id_modulo,
                    permiso: permiso.target.checked
                },
                transformRequest: serializar(),
            }).then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        if (permiso.target.checked == true) {
                            notificacion('fa fa-check', '', 'Permiso activado', 'success');
                        } else {
                            notificacion('fa fa-ban', '', 'Permiso desactivado', 'warning');
                        }
                    } else {
                        notificacion('fa fa-ban', '', 'Error al actualizar permisos', 'warning');
                    }
                } else {
                    let total_errores = response.data.errors.length;
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion()).finally(() => {
                this.obtenerPermisosDeInicio();
            })
        },
        permitirModuloAcciones(id_modulo, id_accion, permiso) {
            this.errorForm = [];
            axios({
                method: 'post',
                url: 'empleados/permitirModuloAcciones',
                data: {
                    id_empleado: this.dataFormUser.id,
                    id_modulo: id_modulo,
                    id_accion: id_accion,
                    permiso: permiso.target.checked
                },
                transformRequest: serializar(),
            }).then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        if (permiso.target.checked == true) {
                            notificacion('fa fa-check', '', 'Permiso activado', 'success');
                        } else {
                            notificacion('fa fa-ban', '', 'Permiso desactivado', 'warning');
                        }
                    } else {
                        notificacion('fa fa-ban', '', 'Error al actualizar permisos', 'warning');
                    }
                } else {
                    let total_errores = response.data.errors.length;
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        obtenerEmpleadoSeries() {
            axios.get('empleados/obtenerEmpleadoSeries', {
                params: {
                    id: this.dataFormUser.id
                }
            }).then(response => {
                this.series_empleado = response.data;
            }).catch(e => notificacion());
        },
        obtenerEmpleadoSucursales() {
            axios.get('empleados/obtenerEmpleadoSucursales', {
                params: {
                    id: this.dataFormUser.id
                }
            }).then(response => {
                this.sucursales_empleado = response.data;
            }).catch(e => notificacion());
        },
        establecerDivisa(event) {
            if (event.target.value) {
                axios.get('empleados/establecerDivisa', {
                    params: {
                        id_empleado: this.dataFormUser.id,
                        id_divisa: event.target.value
                    }
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            notificacion('fa fa-check', '', 'Operación exitosa', 'success');
                        }
                    } else {
                        let total_errores = response.data.errors.length;
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => {
                    this.selectedDivisa = '';
                    this.obtenerDivisas();
                    this.obtenerDivisasEmpleado();
                });
            }
        },
        eliminarDivisa(divisa) {
            Swal.fire({
                title: 'Eliminar Divisa',
                text: "¿Estás seguro de querer eliminar al empleado la divisa " + divisa.nombre,
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('empleados/eliminarDivisa/' + divisa.id).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                notificacion('fa fa-trash', 'Divisa eliminada', divisa.nombre.toUpperCase(), 'danger');
                            }
                        } else {
                            let total_errores = response.data.errors.length;
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion()).finally(() => {
                        this.obtenerDivisas();
                        this.obtenerDivisasEmpleado();
                    })
                }
            });
        },
        guardarSerie() {
            this.errorForm = [];
            if (this.serie) {
                axios({
                    method: 'post',
                    url: 'empleados/guardarSerie',
                    data: {
                        id_empleado: this.dataFormUser.id,
                        serie: this.serie,
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            this.serie = '';
                            this.obtenerEmpleadoSeries();
                        }
                    } else {
                        let total_errores = response.data.errors.length;
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        guardarSucursal() {
            this.errorForm = [];
            if (this.sucursales) {
                axios({
                    method: 'post',
                    url: 'empleados/guardarSucursal',
                    data: {
                        id_empleado: this.dataFormUser.id,
                        sucursales: this.sucursales,
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            this.sucursales = '';
                            this.obtenerEmpleadoSucursales();
                        }
                    } else {
                        let total_errores = response.data.errors.length;
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        obtenerEmpleadoAlmacenes() {
            axios.get('empleados/obtenerEmpleadoAlmacenes', {
                params: {
                    id: this.dataFormUser.id
                }
            }).then(response => {
                this.almacenes_empleado = response.data;
            }).catch(e => notificacion());
        },
        guardarAlmacen() {
            this.errorForm = [];
            if (this.almacen) {
                axios({
                    method: 'post',
                    url: 'empleados/guardarAlmacen',
                    data: {
                        id_empleado: this.dataFormUser.id,
                        almacen: this.almacen,
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            this.almacen = '';
                            this.obtenerEmpleadoAlmacenes();
                        }
                    } else {
                        let total_errores = response.data.errors.length;
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        eliminarAlmacen(id_almacen, nombre) {
            Swal.fire({
                title: 'Eliminar Almacén',
                text: "¿Estás seguro de querer eliminar el almacén " + nombre + " al empleado " + this.dataForm.nombres + " ?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('empleados/eliminarAlmacen', {
                        params: {
                            id_almacen: id_almacen,
                            id_empleado: this.dataFormUser.id,
                        }
                    }).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                notificacion('fa fa-trash', 'Almacén eliminado', nombre.toUpperCase(), 'danger');
                                this.obtenerEmpleadoAlmacenes();
                            }
                        } else {
                            let total_errores = response.data.errors.length;
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion());
                }
            });
        },
        eliminarSerie(id_serie, nombre) {
            Swal.fire({
                title: 'Eliminar Serie',
                text: "¿Estás seguro de querer eliminar la serie " + nombre + " al empleado " + this.dataForm.nombres + " ?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('empleados/eliminarSerie', {
                        params: {
                            id_serie: id_serie,
                            id_empleado: this.dataFormUser.id,
                        }
                    }).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                notificacion('fa fa-trash', 'Serie eliminada', nombre.toUpperCase(), 'danger');
                                this.obtenerEmpleadoSeries();
                            }
                        } else {
                            let total_errores = response.data.errors.length;
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion());
                }
            });
        },
        eliminarSucursales(id_sucursal, nombre) {
            Swal.fire({
                title: 'Eliminar Sucursal',
                text: "¿Estás seguro de querer eliminar la sucursal " + nombre + " al empleado " + this.dataForm.nombres + " ?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('empleados/eliminarSucursales', {
                        params: {
                            id_sucursal: id_sucursal,
                            id_empleado: this.dataFormUser.id,
                        }
                    }).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                notificacion('fa fa-trash', 'Sucursal eliminada', nombre.toUpperCase(), 'danger');
                                this.obtenerEmpleadoSucursales();
                            }
                        } else {
                            let total_errores = response.data.errors.length;
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion());
                }
            });
        },
        obtenerEmpleadoCuentas() {
            axios.get('empleados/obtenerEmpleadoCuentas/' + Number(this.dataFormUser.id)).then(response => {
                this.empleadoCuentas = response.data;
            }).catch(e => notificacion());
        },
        guardarCuenta() {
            this.errorForm = [];
            if (this.cuenta) {
                axios({
                    method: 'post',
                    url: 'empleados/guardarCuentas',
                    data: {
                        id_empleado: this.dataFormUser.id,
                        cuenta: this.cuenta,
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            this.cuenta = '';
                            this.obtenerEmpleadoCuentas();
                        }
                    } else {
                        let total_errores = response.data.errors.length;
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        eliminarCuenta(cuenta) {
            Swal.fire({
                title: 'Eliminar Cuenta',
                text: "¿Estás seguro de querer eliminar al empleado la cuenta " + cuenta.alias,
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('empleados/eliminarCuenta/' + cuenta.id).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                notificacion('fa fa-trash', 'Cuenta eliminada', cuenta.alias.toUpperCase(), 'danger');
                                this.obtenerEmpleadoCuentas();
                            }
                        } else {
                            let total_errores = response.data.errors.length;
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion());
                }
            });
        },
        handleFileUpload() {

            this.imagen = this.$refs.file.files[0];

            this.errorImage = [];

            if (!this.imagen)
                this.errorImage.push('La imagen es obligatoria.');

            if (this.errorImage.length == 0) {
                this.upload_imagen = 'is-loading is-loading-lg';
                axios({
                    method: 'post',
                    url: 'empleados/imagenPerfil',
                    data: {
                        id_empleado: this.id_empleado,
                        imagen: this.imagen
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            notificacion('fa fa-check', 'Enviado', response.data, 'success');
                        }
                    } else {
                        this.errorImage = response.data.errors;
                    }
                }).catch(e => notificacion()).finally(() => this.upload_imagen = '');
            }
        },
        obtenerPermisosDeInicio() {
            if (this.dataFormUser.id) {
                axios.get('empleados/obtenerPermisosDeInicio/' + this.dataFormUser.id).then(response => {
                    this.permisosDeInicio = response.data;
                }).catch(e => notificacion());
            }
        },
        establecerPaginaDeInicio(event) {
            if (this.dataFormUser.id) {
                axios.get('empleados/establecerPaginaDeInicio', {
                    params: {
                        id_empleado: this.dataFormUser.id,
                        id_modulo: event.target.value
                    }
                }).then(response => {
                    if (response.data == true) {
                        notificacion('fa fa-check', '', 'Pagina establecida correctamente', 'success');
                    }
                }).catch(e => notificacion());
            }
        },
        obtenerClienteAgente(id_empleado) {
            axios.get('empleados/obtenerClienteAgente/' + id_empleado).then(response => {
                this.clientes = response.data;
            }).catch(e => notificacion());
        },
        eliminarCliente(cliente, nombre) {
            Swal.fire({
                title: 'Eliminar Cliente',
                text: "¿Estás seguro de querer eliminar el cliente " + nombre + " ?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('empleados/eliminarCliente/' + cliente).then(response => {
                        if (response.data == true) {
                            this.obtenerClienteAgente(this.id_empleado);
                            notificacion('fa fa-trash', 'Agente eliminado', nombre.toUpperCase(), 'danger');
                        } else {
                            notificacion('fa fa-ban', 'Error al eliminar', nombre.toUpperCase(), 'danger');
                        }
                    }).catch(e => notificacion());
                }
            });
        },
        modalComision() {
            $('#modal_comision').modal('show');
        },
        guardarComision() {
            const idcomision = document.getElementById('tipocom');
            const porcentaje = document.getElementById('porcentaje_crear_comision');
            if (idcomision.value) {
                axios({
                    method: 'post',
                    url: 'empleados/guardarComisiones',
                    data: {
                        idagente: this.id_empleado,
                        idcomision: idcomision.value,
                        porcentaje: porcentaje.value
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            this.obtenerComisionesAgente(this.id_empleado);
                            notificacion('fa fa-check', 'Registrado', 'Registro exitoso', 'success');
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => {
                    idcomision.selectedIndex = 0
                    porcentaje.value = '';
                });
            }
        },
        cambiarEstatusAgenteComision(row) {
            axios('empleados/cambiarEstatusAgenteComision/' + row.id).then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        row.estatus = row.estatus == 1 ? 0 : 1;
                        notificacion('fa fa-check', '', 'Estatus actualizado', 'success');
                    } else {
                        notificacion('fa fa-ban', '', 'Error al actualizar', 'warning');
                    }
                } else {
                    let total_errores = response.data.errors.length;
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        cambiarPorcentajeComisionAgente() {
            this.spanPorcentaje = false;
            this.inputPorcentaje = true;
        },
        editarPorcentajeComisionAgente(row) {
            let valor_por = document.getElementById('porcentaje' + row.id).value;
            axios({
                method: 'post',
                url: 'empleados/editarPorcentajeComisionAgente',
                data: {
                    id_comision_agente: row.id,
                    porcentaje: valor_por
                },
                transformRequest: serializar(),
            }).then(response => {
                console.log(response.data)
                if (response.data.errors == null) {
                    if (response.data == true) {
                        row.porcentaje = valor_por;
                        notificacion('fa fa-check', '', 'Porcentaje actualizado', 'success');
                    } else {
                        notificacion('fa fa-ban', '', 'Error al actualizar', 'warning');
                    }
                } else {
                    let total_errores = response.data.errors.length;
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion()).finally(() => {
                this.spanPorcentaje = true;
                this.inputPorcentaje = false;
            });
        },
        eliminarComisionAgente() {
            if ((this.dataTipoCom.id > 0) && (this.dataTipoCom.nombrecom != '')) {
                Swal.fire({
                    title: 'Eliminar Comision',
                    text: "¿Estás seguro de querer eliminar esta comision " + this.dataTipoCom.nombrecom + " ?",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#aaa',
                    confirmButtonText: 'Eliminar'
                }).then((result) => {
                    if (result.value) {
                        axios.get('empleados/eliminarComisionAgente/' + this.dataTipoCom.id).then(response => {
                            if (response.data == true) {
                                this.obtenerComisionesAgente(this.id_empleado);
                                notificacion('fa fa-trash', 'Comision eliminada', this.dataTipoCom.nombrecom.toUpperCase(), 'danger');
                            } else {
                                notificacion('fa fa-ban', 'Error al eliminar la comision', this.dataTipoCom.nombrecom.toUpperCase(), 'danger');
                            }
                        }).catch(e => notificacion());
                    }
                });
            } else {
                notificacion('fa fa-ban', 'Advertencia', 'No ha seleccionado ninguna comision.', 'warning');
            }
        },
        //INICIO COMISIONES DEL EMPLEADO
        async obtenerComisionesEmpAgentePagadas() {
            this.cargando_tabla = 'is-loading is-loading-lg';
            $('#table_comisiones_pagadas').DataTable().destroy();
            await axios.get('empleados/obtenerComisionesEmpAgentePagadas/' + this.id_empleado).then(response => {
                this.comisionesAgentepagadas = response.data;
            }).catch(e => notificacion()).finally(() => {
                $('#table_comisiones_pagadas').DataTable({
                    order: [],
                });
            });
        },
        async obtenerComisionesEmpAgentePendiente() {
            this.cargando_tabla = 'is-loading is-loading-lg';
            axios.get('empleados/obtenerComisionesEmpAgentePendiente/' + this.id_empleado).then(response => {
                this.comisionesAgentependientes = response.data;
            }).catch(e => notificacion());
        },
        //FIN COMISIONES DEL EMPLEADO
        //INICO PAGAR UNICA COMISION
        resetearFormularioComisionUnico() {
            document.getElementById('modal_form_pagar').reset();
            this.metodos_pg = [];
            this.cuentas_pg = [];
            this.dataPagoComisiones_id = '';
        },
        modalPagoPendienteId(pendiente) {
            this.resetearFormularioComisionUnico();
            this.dataPagoComisiones_id = pendiente.id
            $('#modal_pagar_pendiente').modal('show');
        },
        obtenerMetodosDivisa(event) {
            this.metodos_pg = [];
            this.cuentas_pg = [];
            axios.get('empleados/obtenerMetodoPagoComisiones/' + event.target.value).then(response => {
                if (response.data) {
                    this.metodos_pg = response.data
                    this.obtenerMontoApagar(event.target.value);
                }
            }).catch(e => notificacion());
        },
        obtenerMontoApagar(divisa) {
            axios.get('empleados/obtenerPagoDivisa', {
                params: {
                    id_divisa: divisa,
                    id_comision: this.dataPagoComisiones_id
                }
            }).then(response => {
                if (response.data.errors == null) {
                    document.getElementById('monto_sin_conversion').value = response.data.total_sin_conversion;
                    document.getElementById('monto_con_conversion').value = response.data.total_con_conversion;
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        obtenerCuentasSegunMetodo(event) {
            this.cuentas_pg = [];
            axios.get('empleados/obtenerCuentasSegunMetodo/' + event.target.value).then(response => {
                this.cuentas_pg = response.data;
            }).catch(e => notificacion());
        },
        pagarComision() {
            let select_divisa = document.getElementById('pagardivisa');
            let select_metodo = document.getElementById('pagarmetodo');
            let select_cuenta = document.getElementById('pagarcuenta');
            select_divisa = select_divisa.options[select_divisa.selectedIndex];
            select_metodo = select_metodo.options[select_metodo.selectedIndex];
            select_cuenta = select_cuenta.options[select_cuenta.selectedIndex];
            axios({
                method: 'post',
                url: 'empleados/pagarComision',
                data: {
                    id_divisa: select_divisa.value,
                    id_metodo: select_metodo.value,
                    id_cuenta: select_cuenta.value,
                    id_empleado: this.id_empleado,
                    id: this.dataPagoComisiones_id
                },
                transformRequest: serializar(),
            }).then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        this.resetearFormularioComisionUnico();
                        notificacion('fa fa-check', 'Actualizacion', 'Pago exitoso', 'success');
                        $('#modal_pagar_pendiente').modal('hide');
                        this.obtenerComisionesEmpAgentePendiente();
                    }
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        //FIN PAGAR UNICA COMISION
        //INICIO PAGAR COMISIONES SELECCIONADAS
        resetearFormularioComisionesSeleccionadas() {
            document.getElementById('modal_form_pagar_comisiones').reset();
            this.metodos_pg = [];
            this.cuentas_pg = [];
            this.posicionDivisaApagar = '';
        },
        modalPagarTodo(indice) {
            this.resetearFormularioComisionesSeleccionadas();
            this.posicionDivisaApagar = indice;
            $('#modal-pagarComisiones').modal('show');
        },
        checktodos(posicion, event) {
            for (let row of this.comisionesAgentependientes[posicion].pendientes) {
                row.checked = event.target.checked;
            }
        },
        async obtenerMetodosDivisaComisionesSeleccionadas(event) {
            this.metodos_pg = [];
            this.cuentas_pg = [];
            await axios.get('empleados/obtenerMetodoPagoComisiones/' + event.target.value).then(response => {
                if (response.data) {
                    this.metodos_pg = response.data
                    this.obtenerMontoApagarDeComisionesSeleccionadas(event.target.value);
                }
            }).catch(e => notificacion());
        },
        async obtenerMontoApagarDeComisionesSeleccionadas(divisa) {

            let id_comisiones = [];

            for (let row of this.comisionesAgentependientes[this.posicionDivisaApagar].pendientes) {
                if (row.checked == true) {
                    id_comisiones.push(row.id);
                }
            }

            await axios({
                method: 'post',
                url: 'empleados/obtenerMontoApagarDeComisionesSeleccionadas',
                data: {
                    id_divisa: divisa,
                    id_comisiones: JSON.stringify(id_comisiones)
                },
                transformRequest: serializar(),
            }).then(response => {
                if (response.data.errors == null) {
                    document.getElementById('monto_total_sin_conversion_comisiones').value = response.data.total_sin_conversion;
                    document.getElementById('monto_total_con_conversion_comisiones').value = response.data.total_con_conversion;
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        pagarComisiones() {
            this.cargando = true;
            let select_divisa = document.getElementById('pagardivisa_comisiones');
            let select_metodo = document.getElementById('pagarmetodo_comisiones');
            let select_cuenta = document.getElementById('pagarcuenta_comisiones');
            select_divisa = select_divisa.options[select_divisa.selectedIndex];
            select_metodo = select_metodo.options[select_metodo.selectedIndex];
            select_cuenta = select_cuenta.options[select_cuenta.selectedIndex];

            let id_comisiones = [];

            for (let row of this.comisionesAgentependientes[this.posicionDivisaApagar].pendientes) {
                if (row.checked == true) {
                    id_comisiones.push(row.id);
                }
            }

            axios({
                method: 'post',
                url: 'empleados/pagarComisiones',
                data: {
                    id_divisa: select_divisa.value,
                    id_metodo: select_metodo.value,
                    id_cuenta: select_cuenta.value,
                    id_comisiones: JSON.stringify(id_comisiones)
                },
                transformRequest: serializar(),
            }).then(response => {
                console.log(response.data);
                if (response.data.errors == null) {
                    if (response.data == true) {
                        notificacion('fa fa-check', 'Actualizacion', 'Pago exitoso', 'success');
                    }
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion()).finally(() => {
                this.resetearFormularioComisionesSeleccionadas();
                $('#modal_form_pagar_comisiones').modal('hide');
                this.obtenerComisionesEmpAgentePendiente();
                this.cargando = false;
            })
        },
        //FIN PAGAR COMISIONES SELECCIONADAS
        modalPendienteeditar(porcentaje, monto, total, divisa, id) {
            this.dataEditar.id = id;
            this.dataEditar.porcentaje = porcentaje;
            this.dataEditar.total = total;
            this.dataEditar.monto = 0.00;
            this.dataEditar.monto = convertir_a_float(String(monto)).toFixed(2);
            this.dataEditar.divisa = divisa;
            $('#modal_pendiente').modal('show');
        },
        eliminarComisionPendiente(id) {
            if (id > 0) {
                Swal.fire({
                    title: 'Eliminar Comision',
                    text: "¿Estás seguro de querer eliminar esta comision pendiente ?",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#aaa',
                    confirmButtonText: 'Eliminar'
                }).then((result) => {
                    if (result.value) {
                        axios.get('empleados/eliminarComisionPendiente/' + id).then(response => {
                            if (response.data == true) {
                                this.obtenerComisionesEmpAgentePendiente();
                                notificacion('fa fa-trash', 'Comision eliminada', '', 'danger');
                            } else {
                                notificacion('fa fa-ban', 'Error al eliminar la comision', this.dataTipoCom.nombrecom.toUpperCase(), 'danger');
                            }
                        }).catch(e => notificacion());
                    }
                });
            } else {
                notificacion('fa fa-ban', 'Advertencia', 'Error en la seleccion.', 'warning');
            }
        },
        obtenerComisiones() {
            axios.get('empleados/obtenerComisionesactivas').then(response => {
                this.comisionestodas = response.data;
            }).catch(e => notificacion());
        },
        async obtenerComisionesAgente(id_empleado) {
            await axios.get('empleados/obtenerComisionesAgente/' + id_empleado).then(response => {
                this.comisionesAgente = response.data;
            }).catch(e => notificacion());
        },
        editarpendiente() {
            axios({
                method: 'post',
                url: 'empleados/editarpendiente',
                data: {
                    id: this.dataEditar.id,
                    porcentaje: this.dataEditar.porcentaje,
                    monto: this.dataEditar.monto
                },
                transformRequest: serializar(),
            }).then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        this.obtenerComisionesEmpAgentePendiente();
                        this.dataEditar.monto = 0.00;
                        notificacion('fa fa-check', 'Actualizacion', 'Modificado exitosamente', 'success');
                    }
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        llenarPorcentaje(event) {
            const input_porcentaje = document.getElementById('porcentaje_crear_comision');
            const posicion = this.comisionestodas.findIndex((item) => item.com_id == event.target.value);
            const comision = this.comisionestodas[posicion];
            if (comision.com_estatus == 1) {
                input_porcentaje.disabled = true;
                input_porcentaje.value = comision.com_porcentaje;
            } else {
                input_porcentaje.disabled = false;
                input_porcentaje.value = 0;
            }
        },
        async obtenerDocumentos(id) {
            await axios.get('empleados/obtenerDocumentosSegunComisionAgente/' + id).then(response => {
                if (response.data.errors == null) {
                    this.documentos = response.data.documentos;
                    this.documentos_asignados = response.data.doc_asignados;
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        modalDocumentos(row) {
            this.idComEmp = row.id;
            this.obtenerDocumentos(this.idComEmp);
            $('#modal_documentos').modal('show');
        },
        eliminarSeleccion(id){
                    Swal.fire({
                        title: 'Eliminar Comision',
                        text: "¿Estás seguro de querer eliminar la comision del empleado?",
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#aaa',
                        cancelButtonText: 'Cancelar',
                        confirmButtonText: 'Eliminar'
                    }).then((result) => {
                        if (result.value) {
                            axios({
                                method: 'post',
                                url: 'empleados/eliminarSeleccionComision',
                                data: {
                                    id: id,
                                },
                                transformRequest: serializar(),
                            }).then(response => {
                                if (response.data.errors == null) {
                                    if (response.data == true) {
                                        this.obtenerComisionesAgente(this.id_empleado);
                                        notificacion('fa fa-trash', '', 'Eliminado', 'danger');
                                    }
                                } else {
                                    let total_errores = response.data.errors.length
                                    for (let i = 0; i < total_errores; i++) {
                                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                                    }
                                }
                            }).catch(e => notificacion());
                         }
                     });
        },
        guardarComisionEmpleadoDocumento() {

            const form = document.getElementById('form_modal_documentos');

            const formData = new FormData(form);

            formData.set('id_com_emp', this.idComEmp);

            if (!formData.get('documentos'))
                this.errorFormComEmpDoc.push('El campo Documento es obligatorio');
            if (!formData.get('documentoFijo'))
                this.errorFormComEmpDoc.push('El campo Fijo es obligatorio');

            axios({
                method: 'post',
                url: 'empleados/guardarComisionEmpleadoDocumento',
                data: formData
            }).then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        this.obtenerDocumentos(this.idComEmp);
                        notificacion('fa fa-check', '', 'Agregado exitosamente', 'success');
                    }
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        async editarDocAsignado(row) {
            document.getElementById('doc_asig').value = row.id;
            await this.documentos.push({
                id: row.id_documento,
                descripcion: row.descripcion,
                prefijo: row.prefijo
            });
            document.getElementById('documentos').value = row.id_documento;
            document.getElementById('documentoFijo').value = row.fijo;
        },
        eliminarDocAsignado(row) {
            axios.get('empleados/eliminarDocAsignado/' + row.id).then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        this.obtenerDocumentos(this.idComEmp);
                        notificacion('fa fa-trash', '', 'Eliminado', 'danger');
                    }
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        }
    },
    computed: {
        porcentajemonto: function () {
            let total = convertir_a_float(String(this.dataEditar.total));
            let monto = convertir_a_float(String(this.dataEditar.monto));
            let Tcomision_ = (monto * 100) / total;
            Tcomision_ = (Tcomision_ >= 0) ? Tcomision_ : 0;
            this.dataEditar.porcentaje = convertir_a_float(String(Tcomision_).toString()).toFixed(2);
            return this.dataEditar.porcentaje;
        }
    }
});