new Vue({
    el: '#appDocumentos',
    data: {
        titulo: '',
        accion: '',
        documentos: [],
        dataForm: { 'id': '', 'codigo': '', 'prefijo': '', 'descripcion': '' },
        errorForm: {},
    },
    created() {
        this.obtenerDocumentos();
    },
    methods: {
        obtenerDocumentos() {
            axios.get('documentos/obtenerDocumentos').then(response => {
                if (Array.isArray(response.data)) {
                    this.documentos = response.data;
                }
            }).catch(e => notificacion());
        },
        resetearFormulario() {
            document.getElementById('form_modal_docuemtos').reset();
            this.dataForm.id = '';
            this.dataForm.codigo = '';
            this.dataForm.prefijo = '';
            this.dataForm.descripcion = '';
        },
        modalGuardar() {
            this.resetearFormulario();
            this.titulo = 'Agregar Documento';
            this.accion = 'Guardar';
            $('#modal_documentos').modal('show');
            $('#modal_documentos').on('shown.bs.modal', function() {
                $('#doccodigo').trigger('focus');
            });
        },
        editarGuardar() {
            this.dataForm['token'] = $('meta[name=token]').attr('content');
            axios({
                method: 'post',
                url: 'documentos/guardar',
                data: this.dataForm,
                transformRequest: serializar(),
            }).then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        if (this.dataForm.id !== '') {
                            $('#modal_documentos').modal('hide');
                            notificacion('fa fa-edit', 'Información', 'Documento actualizado correctamente', 'info');
                        } else {
                            notificacion('fa fa-check', 'Información', 'Documento registrado correctamente', 'success');
                        }
                        this.obtenerDocumentos();
                        this.resetearFormulario();
                    }
                } else {
                    let total_errores = response.data.errors.length;
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        modificarEstatus(id, etiqueta) {
            axios.get('documentos/modificarEstatus/' + id).then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        let eti = document.getElementById(etiqueta);
                        eti.className = (eti.className === 'fa fa-times text-danger') ? 'fa fa-check text-success' : 'fa fa-times text-danger';
                        notificacion('fa fa-check', 'Actualizado', 'Estatus modificado', 'info');
                    }
                } else {
                    let total_errores = response.data.errors.length;
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        }
    },
});