var fecha = new Date();

function padLeft(n){
    return ("00" + n).slice(-2);
  }

var mess=padLeft(fecha.getMonth()+1);

new Vue({
    el: '#appCompras',
    data: {
        anio: fecha.getFullYear(),
        mes: moment().format('MM'),
        facturas: [],
        facturasPendientes: [],
        facturasAnuladas: [],
        notasdeentrega: [],
        notasdeentregaPendientes: [],
        notasdeentregaAnuladas: [],
        pedidos: [],
        pedidosPendientes: [],
        pedidosAnuladas: [],
        filtro: 1,
        ruta: '',
        lineas: [],
        errorForm: [],
        cargando: false,
        cargando_lineas: '',
        cargando_tabla: '',
        icon_buscador: 'fa fa-search',
        creditosActivos: [],
        creditosInactivos: [],
        detalleCredito: [], 
        detalleCreditoId: '',
        detalleCreditoTotal: 0,
        meses: [],
        mes_s: [01, 02, 03, 04, 05, 06, 07, 08, 09, 10, 11, 12],
        divisa: '',
        v: [],
        venta:0,
        ganancia:0,
        porcentaje:0,
        proveedor:0,
        compra_prov:[],
        fecha_desde: moment().format('YYYY-MM-DD'),
        fecha_desdep: moment().format('YYYY-MM-DD'),
        fecha_hastap: moment().format('YYYY-MM-DD'),
        sucursal:0,
        mov_proveedor:[],
        optionsProveedores:[],
        stockbajo:[],
        proveedor_filtro:'',
        almacen_prov:'',
        searc:'',
        pro_nombre:'',
        serie_prov:'',
        series:'',
        loader_crear:false,
        divisa_prov:0,
        sugerencia:[],
        proveedores:[]
    },
    computed:{
        filteredStockbajo:function(){
          return this.stockbajo.filter((item)=>{
            return item.descripcion.toLowerCase().includes(this.searc);
          })
        },
    },
    created() {
        this.obtenerFacturas();
        this.obtenerNotasdeEntrega();
        this.obtenerNotasdeCredito();
        this.obtenerPedidos();
       
        
        axios.get('compras/obtenerDatosCrudForaneos').then(response => {
            this.optionsProveedores = response.data.proveedores;
            this.series=response.data.series;
            this.obtenerProductosStockBajoLists();
        }).catch(e => notificacion());
    },
    methods: {
        GenerarExcel(row){
            axios({
                method: 'post',
                url: 'compras/generarExcel',
                data: {
                    mes: row.mes,
                    anio: row.anio,
                    divisa:row.divisa,
                    productos: JSON.stringify(row.productos)
                },
                headers:{
                    'Content-Disposition':"attachment;filename=template.xlsx",
                   'Content-Type':'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' 
                },
                responseType:'arraybuffer',
                transformRequest: serializar(),
            }).then(response => {
                const link=document.createElement('a');
                link.href=window.URL.createObjectURL(
                    new Blob([response.data])
                );
                link.setAttribute('download','Reporte de inventario.xlsx');
                document.body.appendChild(link);
                link.click();
            }).catch(e => notificacion()).finally(() => {
               
            })
        },
        obtenerProductosStockBajoLists(){
            $('#table_sugerencias').DataTable().destroy();
            axios.get('compras/obtenerProductosStockBajo').then(response => {
                this.sugerencia = response.data;
            }) .catch((e) => notificacion()).finally(() => {
                $('#table_sugerencias').DataTable({
                    order: [[3, 'desc']],
                    retrieve: true,
                });
              });
        },
        obtenerProductosProveedores(id){
            $('#table_proveed').DataTable().destroy();
            axios.get('compras/obtenerProductosProveedores/'+id).then(response => {
                this.proveedores = response.data;
            }) .catch((e) => notificacion()).finally(() => {
                $('#table_proveed').DataTable({
                    order: [],
                    retrieve: true,
                });
              });
        },
        modal_proveedores(id){
            $('#modal_proveedores').modal('show');
            this.obtenerProductosProveedores(id);
        },
        modal_crearorden() {
            if(this.proveedor_filtro>0 && this.almacen_prov>0){
                $('#modal_crearorden').modal('show');
                $('#modal_crearorden').on('shown.bs.modal', function () {
                    //$('#nombre_divisa').trigger('focus');
                });
            }
        },
        guardarStockchecked() {
            this.loader_crear=true;
            axios({
              method: "post",
              url: "compras/CrearPedido",
              data: {
                prov: this.proveedor_filtro,
                almacen: this.almacen_prov,
                id_serie:this.serie_prov,
                productos: JSON.stringify(this.stockbajo),
              },
              transformRequest: serializar(),
            }).then((response) => {
                if (response.data.errors == null) {
                    this.stockbajo = [];
                    location.href = response.data;
                } else {
                  let total_errores = response.data.errors.length;
                  for (let i = 0; i < total_errores; i++) {
                    notificacion("fa fa-ban", "Advertencia", response.data.errors[i], "warning");
                  }
                }
              })
              .catch((e) => notificacion()).finally(() => {
                this.loader_crear=false;
              });
          },
        checktodosServicios(event) {
            for (let item of this.stockbajo) {
              item.checked = event.target.checked;
            }
        },
        obtenerProductosStockBajo(){
            this.stockbajo =[];
            if(this.proveedor_filtro>0 && this.almacen_prov>0 && this.proveedor_filtro!='' && this.almacen_prov!=''){
                $("#tabla_stock_bajo").DataTable().destroy();
                axios({
                    method: 'post',
                    url: 'compras/obtenerProductosStockBajoProv',
                    data:  {
                        prov: this.proveedor_filtro,
                        almacen: this.almacen_prov,
                    },
                    transformRequest: serializar(),
                }).then(response => {
                this.stockbajo = response.data.stock;
                this.pro_nombre=response.data.nombre;
                })
                .catch((e) => notificacion())
                .finally(() => {
                    $("#tabla_stock_bajo").DataTable({
                    order: [],
                    pageLength: 50,
                    dom: "Blfrtip",
                    buttons: [
                        {
                        extend: "excelHtml5",
                        title: "Stock bajo " + moment().format("DD-MM-YYYY"),
                        },
                    ],
                    });
                });
            }
          },
        compraAnuales(){
                        
            axios({
                method: 'post',
                url: 'compras/reporteGeneralAnual',
                data:  {
                    anio:0
                },
                transformRequest: serializar(),
            }).then(response => {
                var chartComprasSemanales = '';
                var comprasAnuales = document.getElementById('comprasAnuales').getContext('2d');

                let ingreso_dsm = response.data.anios;

                let dsm_venta = [0, 0, 0];
                let dsm_label = [0, 0, 0];
                let i=0;
                Object.keys(ingreso_dsm).forEach(function(k) {
                    dsm_venta[i] = ingreso_dsm[k].venta;
                    dsm_label[i] = ingreso_dsm[k].anio;
                    i+=1;
                });

                chartComprasSemanales = new Chart(comprasAnuales, {
                    type: 'pie',
                    data: {
                        labels: dsm_label,
                        datasets: [{
                            data: dsm_venta,
                            backgroundColor: ['#007bff','#2A2F5B','#F0760A','#2AD21B','#ECCA12','#A812EC','#EC12CA','#EC1212','#22950B'],
                            borderWidth:0
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        legend:{
                            position:'bottom',
                            labels:{
                                fontColor:'rgb(154,154,154)',
                                fontSize:11,
                                usePointStyle:true,
                                padding:20
                            }
                        },
                        pieceLabel:{
                            render:'porcentaje',
                            fontColor:'White',
                            fontSize:14
                        },
                        tooltips: false,
                        layout:{
                            padding:{
                                left:5,
                                right:5,
                                top:5,
                                bottom:5
                            }
                        }
                    }
                });

            });

        },
        obtenerFacturas() {
            this.cargando_tabla = 'is-loading is-loading-lg';
            $('#table_facturas_pagadas').DataTable().destroy();
            $('#table_facturas_pendientes').DataTable().destroy();
            $('#table_facturas_anuladas').DataTable().destroy();
            axios.get('compras/obtenerFacturas', {
                params: {
                    anio: this.anio,
                    mes:this.mes
                }
            }).then(response => {
                this.facturas = response.data.pagas;
                this.facturasPendientes = response.data.pendientes;
                this.facturasAnuladas = response.data.anuladas;
            }).catch(e => notificacion()).finally(() => {
                this.cargando_tabla = '';
                $('#table_facturas_pagadas').DataTable({
                    retrieve: true,
                    order: [],
                    "footerCallback": function (row, data, start, end, display) {
                        var api = this.api(),
                            data;

                        pageTotal = api
                            .column(3, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(3).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                    }
                });
                $('#table_facturas_pendientes').DataTable({
                    order: [],
                    retrieve: true,
                    "footerCallback": function (row, data, start, end, display) {
                        var api = this.api(),
                            data;

                        pageTotal = api
                            .column(5, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(5).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                        pageTotal = api
                            .column(4, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(4).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                        pageTotal = api
                            .column(3, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(3).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                    }
                });
                $('#table_facturas_anuladas').DataTable({
                    order: [],
                    retrieve: true,
                    "footerCallback": function (row, data, start, end, display) {
                        var api = this.api(),
                            data;

                        pageTotal = api
                            .column(5, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(5).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                        pageTotal = api
                            .column(4, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(4).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                        pageTotal = api
                            .column(3, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(3).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                    }
                });
            });
        },
        obtenerNotasdeEntrega() {
            this.cargando_tabla = 'is-loading is-loading-lg';
            $('#table_notasdeentrega_pagadas').DataTable().destroy();
            $('#table_notasdeentrega_pendientes').DataTable().destroy();
            $('#table_notasdeentrega_anuladas').DataTable().destroy();
            axios.get('compras/obtenerNotasdeEntregaAnuales', {
                params: {
                    anio: this.anio,
                    mes:this.mes
                }
            }).then(response => {
                this.notasdeentrega = response.data.pagas;
                this.notasdeentregaPendientes = response.data.pendientes;
                this.notasdeentregaAnuladas = response.data.anuladas;
            }).catch(e => notificacion()).finally(() => {
                this.cargando_tabla = '';
                $('#table_notasdeentrega_pagadas').DataTable({
                    order: [],
                    retrieve: true,
                    "footerCallback": function (row, data, start, end, display) {
                        var api = this.api(),
                            data;

                        pageTotal = api
                            .column(3, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(3).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                    }
                });
                $('#table_notasdeentrega_pendientes').DataTable({
                    order: [],
                    retrieve: true,
                    "footerCallback": function (row, data, start, end, display) {
                        var api = this.api(),
                            data;

                        pageTotal = api
                            .column(5, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(5).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                        pageTotal = api
                            .column(4, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(4).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                        pageTotal = api
                            .column(3, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(3).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                    }
                });
                $('#table_notasdeentrega_anuladas').DataTable({
                    order: [],
                    retrieve: true,
                    "footerCallback": function (row, data, start, end, display) {
                        var api = this.api(),
                            data;

                        pageTotal = api
                            .column(5, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(5).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                        pageTotal = api
                            .column(4, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(4).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                        pageTotal = api
                            .column(3, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(3).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                    }
                });
            });
        },
        obtenerPedidos() {
            this.cargando_tabla = 'is-loading is-loading-lg';
            
            $('#table_pedidos_pendientes').DataTable().destroy();
            $('#table_pedidos_pagadas').DataTable().destroy();
            $('#table_pedidos_anulados').DataTable().destroy();
            axios.get('compras/obtenerPedidosAnuales', {
                params: {
                    anio: this.anio,
                    mes:this.mes
                }
            }).then(response => {
                this.pedidos = response.data.pagas;
                this.pedidosPendientes = response.data.pendientes;
                this.pedidosAnuladas = response.data.anuladas;
            }).catch(e => notificacion()).finally(() => {
                this.cargando_tabla = '';
                $('#table_pedidos_pagadas').DataTable({
                    order: [],
                    retrieve: true,
                    "footerCallback": function (row, data, start, end, display) {
                        var api = this.api(),
                            data;

                        pageTotal = api
                            .column(2, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                    }
                });
                $('#table_pedidos_pendientes').DataTable({
                    order: [],
                    retrieve: true,
                    "footerCallback": function (row, data, start, end, display) {
                        var api = this.api(),
                            data;

                        pageTotal = api
                            .column(2, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                    }
                });
                $('#table_pedidos_anulados').DataTable({
                    order: [],
                    retrieve: true,
                    "footerCallback": function (row, data, start, end, display) {
                        var api = this.api(),
                            data;
                    }
                });
            });
        },
        obtenerNotasdeCredito() {
            this.cargando_tabla = 'is-loading is-loading-lg';
            $('#table_creditos_activos, #table_creditos_inactivos').DataTable().destroy();
            axios.get('compras/obtenerNotasdeCredito', {
                params: {
                    anio: this.anio,
                    mes:this.mes
                }
            }).then(response => {
                this.creditosActivos = response.data.activos;
                this.creditosInactivos = response.data.inactivos;
            }).catch(e => notificacion()).finally(() => {
                this.cargando_tabla = '';
                $('#table_creditos_activos, #table_creditos_inactivos').DataTable();
            });
        },
        verDetalleCredito(id) {
            axios.get('compras/obtenerNotadeCreditoDetalle/' + id).then(response => {
                this.detalleCreditoId = id;
                this.detalleCredito = response.data.pagos;
                this.detalleCreditoTotal = response.data.total;
            }).catch(e => notificacion()).finally(() => {
                $('#modal_detalles_credito').modal('show');
            });
        },
        modalLineas() {
            this.errorForm = [];
            $('#modal_lineas').modal({ show: true, backdrop: 'static', keyboard: false });
            $('#modal_lineas').on('shown.bs.modal', function () {
                $('#input_buscar_lineas').trigger('focus')
            });
        },
        filtrarPor(num) {
            this.filtro = num;
            document.getElementById('input_buscar_lineas').value = '';
        },
        buscarLineas(event) {
            if (event.target.value) {
                if (event.target.value.length > 2) {
                    this.cargando_lineas = 'is-loading is-loading-lg';
                    this.bus_li(event.target.value, this);
                }
            }
        },
        bus_li: _.debounce((value, vm) => {
            axios.get('compras/buscarLineas', {
                params: {
                    buscar: value,
                    filtro: vm.filtro
                }
            }).then(response => {
                if (response.data.length > 0) {
                    vm.lineas = response.data;
                } else {
                    vm.lineas = [];
                }
            }).catch(e => notificacion()).finally(() => vm.cargando_lineas = '');
        }, 350),
        finalizarFactura(row, estatus) {

            let estatus_nombre = '';

            if (estatus == 1) {
                estatus_nombre = 'Finalizado';
            } else if (estatus == 2) {
                estatus_nombre = 'Pendiente';
            } else if (estatus == 3) {
                estatus_nombre = 'Anulado';
            }

            Swal.fire({
                title: estatus_nombre,
                text: "¿Estás seguro que desea cambiar el estatus de la factura " + row.id + " a " + estatus_nombre + " del proveedor " + row.cliente + "?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Aceptar'
            }).then((result) => {
                if (result.value) {
                    axios.get('compras/finalizarFactura', {
                        params: {
                            id: row.id,
                            estatus: estatus
                        }
                    }).then(response => {
                        if (response.data == true) {
                            this.obtenerFacturas();
                        } else {
                            notificacion('fa fa-ban', 'Advertencia', response.data, 'warning');
                        }
                    }).catch(e => notificacion());
                }
            });
        },
        finalizarNota(row, estatus) {

            let estatus_nombre = '';

            if (estatus == 1) {
                estatus_nombre = 'Finalizado';
            } else if (estatus == 2) {
                estatus_nombre = 'Pendiente';
            } else if (estatus == 3) {
                estatus_nombre = 'Anulado';
            }

            Swal.fire({
                title: estatus_nombre,
                text: "¿Estás seguro que deseas cambiar el estatus de la nota de entrega " + row.id + " a " + estatus_nombre + " del proveedor " + row.cliente + "?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Aceptar'
            }).then((result) => {
                if (result.value) {
                    axios.get('compras/finalizarNota', {
                        params: {
                            id: row.id,
                            estatus: estatus
                        }
                    }).then(response => {
                        if (response.data == true) {
                            this.obtenerNotasdeEntrega();
                        } else {
                            notificacion('fa fa-ban', 'Advertencia', response.data, 'warning');
                        }
                    }).catch(e => notificacion());
                }
            });
        },
        finalizarPedido(row, estatus) {

            let estatus_nombre = '';

            if (estatus == 1) {
                estatus_nombre = 'Finalizado';
            } else if (estatus == 2) {
                estatus_nombre = 'Pendiente';
            } else if (estatus == 3) {
                estatus_nombre = 'Anulado';
            }

            Swal.fire({
                title: estatus_nombre,
                text: "¿Estás seguro que desea cambiar el estatus del pedido " + row.id + " a " + estatus_nombre + " del proveedor " + row.cliente + "?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Aceptar'
            }).then((result) => {
                if (result.value) {
                    axios.get('compras/finalizarPedido', {
                        params: {
                            id: row.id,
                            estatus: estatus
                        }
                    }).then(response => {
                        if (response.data == true) {
                            this.obtenerPedidos();
                        } else {
                            notificacion('fa fa-ban', 'Advertencia', response.data, 'warning');
                        }
                    }).catch(e => notificacion());
                }
            });
        },

        moneda(num, div_locale, div_simbolo, decimal = 2) {
            return monedaMoneda(num, div_locale, div_simbolo, decimal);
        },
        decimal(num, div_locale, decimal = 2) {
            return monedaDecimal(num, div_locale, decimal);
        },
        fechaNormal(value) {
            return moment(value).format('DD/MM/YYYY, h:mm A');
        },
        buscarFacturasCompras:function(event) {

            let select_divisa = document.getElementById('mes_divisasc');
            let selectedOptionDiv = select_divisa.options[select_divisa.selectedIndex];

            this.errorForm = [];
            this.cargando = true;
            this.v=[];
            this.meses=[];
            this.cargando_tabla = 'is-loading is-loading-lg';
            for (let o = 0; o < this.mes.length; o++) {
                if (o < 10) {
                    $("#tabla_productoscompras0" + this.mes[o]).DataTable().destroy();
                } else {
                    $("#tabla_productoscompras" + this.mes[o]).DataTable().destroy();
                }
                console.log(this.mes[o]);
            }

            axios.get('compras/productosVendidosComprasMes', {
                params: {
                    anio: this.anio,
                    divisa: this.$refs.divisa.value,
                    sucursal:this.sucursal
                }
            }).then(response => {
                if (response.data.errors == null) {
                    if (Object.keys(response.data.meses).length > 0) {
                        for (let o = 0; o < this.mes_s.length; o++) {
                            Object.keys(response.data.meses).forEach((key, i) => {
                                if (Number(key) == this.mes_s[o]) {
                                    this.meses.push(response.data.meses[key]);
                                    this.v.push(Number(key));
                                }
                            });
                        }

                        this.venta = response.data.venta;
                        this.ganancia = response.data.ganancia;
                        this.porcentaje = response.data.porcentaje;

                    }
                } else {
                    this.errorForm = response.data.errors;
                }
            }).catch(e => notificacion()).finally(() => {
                this.cargando = false;
                this.cargando_tabla = '';

                let buttonCommon = {
                    exportOptions: {
                        format: {
                            body: function(data, row, column, node) {
                                return convertir_a_float(data);
                            }
                        }
                    }
                };

                Object.keys(this.v).forEach((key, i) => {
                    console.log(this.v[key]);
                    if (this.v[key] < 10) {
                        $("#tabla_productoscompras0" + this.v[key]).DataTable({
                            order: [],
                            dom: 'Bfrtip',
                            buttons: [
                                $.extend(true, {}, buttonCommon, {
                                    extend: 'excelHtml5',
                                    title: 'Ventas por meses del Año (' + this.anio + ')' +
                                        ' Divisa (' + selectedOptionDiv.text + ')',
                                }),
                            ]
                        });
                    } else {
                        $("#tabla_productoscompras" + this.v[key]).DataTable({
                            order: [],
                            dom: 'Bfrtip',
                            buttons: [
                                $.extend(true, {}, buttonCommon, {
                                    extend: 'excelHtml5',
                                    title: 'Ventas por meses del Año (' + this.anio + ')' +
                                        ' Divisa (' + selectedOptionDiv.text + ')',
                                }),
                            ]
                        });
                    }
                });
            });

        },
        buscarProveedoresmasfrecuentes:function(event) {
            this.errorForm = [];
            this.cargando = true;
            this.compra_prov=[];
            this.cargando_tabla = 'is-loading is-loading-lg';
            $('#tabla_compras_frecuentes').DataTable().destroy();

            axios.get('compras/proveedoresReportesFrecuentes', {
                params: {
                    fecha_desde: this.fecha_desdep,
                    fecha_hasta: this.fecha_hastap,
                    proveedor:this.proveedor,
                    divisa:this.divisa_prov
                }
            }).then(response => {

                this.compra_prov=response.data.totales;
                //this.compra_prov.sort();
                //console.log(this.compra_prov);
                this.mov_proveedor=response.data.proveedores;
                 let prod=[];
                  //Object.keys(this.compra_prov).forEach(function(k) {
                    for (var k in response.data.totales) {
                     prod.push(response.data.totales[k]);
                    }
                   this.compra_prov=prod;
                   console.log(this.compra_prov.sort(((a, b) => b.venta - a.venta)));

            }).catch(e => notificacion()).finally(() => {
                this.cargando = false;
                this.cargando_tabla = '';

                $('#tabla_compras_frecuentes').DataTable({
                    order: [],
                    retrieve: true,
                    "footerCallback": function (row, data, start, end, display) {
                        var api = this.api(),
                            data;

                        pageTotal = api
                            .column(2, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                    }
                });
            });

        },
    }
});


var chartVentasSemanales = '';
var ventasSemanales = document.getElementById('ventasSemanales').getContext('2d');

function obtenerIngresosDiarios() {
    chartVentasSemanales.destroy();
    //if(document.getElementById('sucursal').value!=''){
        _ingresosDiarios();
    //}
}

function _ingresosDiarios() {
    axios({
        method: 'post',
        url: 'compras/proveedoresReportesAnio',
        data:  {
            anio:moment().format('YYYY')
        },
        transformRequest: serializar(),
    }).then(response => {
        let ingreso_dsm = response.data.proveedores;

        let dsm_venta = [0, 0, 0];
        let dsm_label = [0, 0, 0];
        let i=0;
        Object.keys(ingreso_dsm).forEach(function(k) {
            dsm_venta[i] = ingreso_dsm[k].venta;
            dsm_label[i] = ingreso_dsm[k].proveedor;
            i+=1;
        });

        chartVentasSemanales = new Chart(ventasSemanales, {
            type: 'pie',
            data: {
                labels: dsm_label,
                datasets: [{
                    data: dsm_venta,
                    backgroundColor: ['#007bff','#2A2F5B','#F0760A','#2AD21B','#ECCA12','#A812EC','#EC12CA','#EC1212','#22950B'],
                    borderWidth:0
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                title: {
                    display: true,
                    text: 'Proveedores de los que mas se vende'
                },
                legend:{
                    position:'bottom',
                    labels:{
                        fontColor:'rgb(154,154,154)',
                        fontSize:11,
                        usePointStyle:true,
                        padding:20
                    }
                },
                pieceLabel:{
                    render:'porcentaje',
                    fontColor:'White',
                    fontSize:14
                },
                tooltips: false,
                layout:{
                    padding:{
                        left:5,
                        right:5,
                        top:5,
                        bottom:5
                    }
                }
            }
        });

    });
}

var chartVentasSemanalesCompras = '';
var ventasSemanalesCompras = document.getElementById('comprasanualesc').getContext('2d');

var chartVentasSemanalescompraMes = '';
var ventasSemanalescompraMes= document.getElementById('ventasSemanalescompraMes').getContext('2d');



function obtenerIngresosDiariosCompras() {
    chartVentasSemanalesCompras.destroy();
    ///if(document.getElementById('sucursal').value!=''){
        _ingresosDiariosCompras();
    //}
}

function obtenerComprastodos(){
    obtenerIngresosDiariosCompras();
    obtenerIngresosDiariosComprasMes();
}


function obtenerIngresosDiariosComprasMes() {
    chartVentasSemanalescompraMes.destroy();
    ///if(document.getElementById('sucursal').value!=''){
        _ingresosDiarioscompraMes();
    //}
}

function _ingresosDiariosCompras() {
    let anio=document.getElementById('aniocompras').value;
    axios({
        method: 'post',
        url: 'compras/reporteGeneralAnual',
        data:  {
            anio:anio
        },
        transformRequest: serializar(),
    }).then(response => {
        let ingreso_dsm = response.data.anios;

        let dsm_venta = [0];
        let dsm_label = [0];
        let i=0;
        Object.keys(ingreso_dsm).forEach(function(k) {
            let vent=ingreso_dsm[k].venta;
            let porcentaje=(ingreso_dsm[k].venta*100)/response.data.total;
            dsm_venta[i] = porcentaje.toFixed(2);
            dsm_label[i] = ingreso_dsm[k].anio+" ("+monedaMoneda(vent, response.data.div_locale, response.data.div_simbolo)+")";
            i+=1;
        });

        chartVentasSemanalesCompras = new Chart(ventasSemanalesCompras, {
            type: 'pie',
            data: {
                labels: dsm_label,
                datasets: [{
                    data: dsm_venta,
                    backgroundColor: ['#007bff','#2A2F5B','#F0760A','#2AD21B','#ECCA12','#A812EC','#EC12CA','#EC1212','#22950B'],
                    borderWidth:0
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                tooltips:false,
                title: {
                    display: true,
                    text: 'Compras anuales'
                },
                legend:{
                    position:'bottom',
                    labels:{
                        fontColor:'rgb(154,154,154)',
                        fontSize:11,
                        usePointStyle:true,
                        padding:20
                    }
                },
                pieceLabel:{
                    render:'porcentaje',
                    fontColor:'White',
                    fontSize:14
                },
                layout:{
                    padding:{
                        left:5,
                        right:5,
                        top:5,
                        bottom:5
                    }
                }
            }
        });

    });
}


function _ingresosDiarioscompraMes() {

    let anio = document.getElementById("aniocompraMes").value;
    
        axios({
            method: 'post',
            url: 'compras/reporteGeneralMensual',
            data:  {
                anio: anio
            },
            transformRequest: serializar(),
        }).then(response => {
            let ingreso_dsm = response.data.meses;
    
            let tit=[1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12];
            let dsm_venta = [0, 0, 0, 0, 0, 0, 0,0,0,0,0,0];
            let dsm_documento =[0, 0, 0, 0, 0, 0, 0,0,0,0,0,0];
            
            Object.keys(ingreso_dsm).forEach(function(k) {
                for (let i = 0; i <12; i++) {
                    if (ingreso_dsm[k].mes== tit[i]) {
                        dsm_venta[i] = ingreso_dsm[k].venta;
                        dsm_documento[i] = ingreso_dsm[k].documentos;
                    }
                }
            });
    
            chartVentasSemanalescompraMes = new Chart(ventasSemanalescompraMes, {
                type: 'bar',
                data: {
                    labels: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep','Oct','Nov','Dic'],
                    datasets: [{
                        label: "Compras",
                        data: dsm_venta,
                        backgroundColor: '#f9972f',
                        borderColor: '#f9972f91',
                        borderWidth: 1
                    },
                    {
                        label: "Documentos",
                        data: dsm_documento,
                        backgroundColor: '#fbee29',
                        borderColor: '#fbee295e',
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    title: {
                        display: true,
                        text: 'Compras mensuales'
                    },
                    legend: {
                        position : 'bottom'
                    },
                    tooltips: {
                        mode: 'index',
                        intersect: false,
                        callbacks: {
                            label: function(tooltipItem, chart) {
                                if(tooltipItem.datasetIndex===0){
                                    var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                                    return datasetLabel + ' ' + monedaMoneda(tooltipItem.yLabel, response.data.div_locale, response.data.div_simbolo);
                                }else{
                                    var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                                    return datasetLabel + ' ' + tooltipItem.yLabel;
                                }
                               
                            },
                        }
                    },
                    responsive: true,
                    scales: {
                        xAxes: [{
                            stacked: true,
                        }],
                        yAxes: [{
                            stacked: true
                        }]
                    }
                   /* tooltips: {
                        callbacks: {
                            label: function(tooltipItem, chart) {
                                if(tooltipItem.datasetIndex===0){
                                    var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                                    return datasetLabel + ' ' + monedaMoneda(tooltipItem.yLabel, response.data.div_locale, response.data.div_simbolo);
                                }else{
                                    var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                                    return datasetLabel + ' ' + tooltipItem.yLabel;
                                }
                               
                            },
                        }
                    },
                    scales: {
                        yAxes: [{
                            ticks: {
                                beginAtZero: true,
                                callback: function(value, index, values) {
                                    return value;
                                }
                            }
                        }]
                    }*/
                }
            });
    
        });
    }

window.onload = _ingresosDiarios();
window.onload = _ingresosDiariosCompras();
window.onload = _ingresosDiarioscompraMes();