var fecha = new Date();

function padLeft(n){
    return ("00" + n).slice(-2);
  }

var mess=padLeft(fecha.getMonth()+1);

new Vue({
    el: '#appClienteEditar',
    data: {
        id_cliente: document.getElementById('id_cliente').value,
        errorForm: [],
        facturas: [],
        notasdeentrega: [],
        ordenesdeentrega: [],
        anio: fecha.getFullYear(),
        mes:mess,
        pedidos: [],
        presupuestos: [],
        creditos: [],
        direccionesEnvio: [],
        categorias: [],
        top_productos: [],
        agentes: [],
        tiposcli: [],
        detalleCreditoId: '',
        detalleCredito: [],
        detalleCreditoTotal: 0,
        contactos: [], 
        cargando: '',
        prodvendidos:[],
        cargando_tablas: 'is-loading is-loading-lg',
        form_redes:'',
        form_descripcion:'',
        form_descripcion_software:'',
        form_descripcion_key:'',
        redesSociales:[],
        form_id:'',
        formWhatsapp:{telefono:'',mensaje:'',tipo:0},
        abonos:[],
        clientes_lista:[]
    },
    created() {
        this.obtenerContactos();
        this.obtenerRedesSociales();
        this.obtenerAbonos();
        this.obtenerLicencias();
    },
    mounted() {

        self = this;
        $(function () {

            $('#modal_envios').on('hidden.bs.modal', function (e) {
                document.getElementById('modal_form_envios').reset();
                document.getElementById('env_id').value = '';
            });

            $('#modal_envios').on('show.bs.modal', function (e) {
                self.errorForm = []
            });

            $('#modalContacto').on('show.bs.modal', function (e) {
                self.errorForm = []
            });

            $('#modalContacto').on('hidden.bs.modal', function (e) {
                document.getElementById('formContacto').reset();
                document.getElementById('contactoID').value = '';
            });

           
            /*$('#table_abonos').DataTable({
                "footerCallback": function (row, data, start, end, display) {
                    var api = this.api(),
                        data;

                    pageTotal = api
                        .column(1, { page: 'current' })
                        .data()
                        .reduce(function (a, b) {
                            return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                        }, 0);

                    $(api.column(1).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                    pageTotal = api
                        .column(2, { page: 'current' })
                        .data()
                        .reduce(function (a, b) {
                            return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                        }, 0);

                    $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                    pageTotal = api
                        .column(3, { page: 'current' })
                        .data()
                        .reduce(function (a, b) {
                            return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                        }, 0);

                    $(api.column(3).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                }
            });*/
        });
    },
    methods: {
        obtenerAbonos(){
            let groupColumn = 2;
            $('#table_abonos').DataTable().destroy();
            axios.get('clientes/obtenerAbonos/'+this.id_cliente).then(response => {
                this.abonos = response.data.abonos;
            }) .catch((e) => notificacion()).finally(() => {
                var table = $('#table_abonos').DataTable({
                    columnDefs: [{
                        visible: false,
                        targets: groupColumn
                    }],
                    order: [
                        [groupColumn, 'asc'],[1,'desc']
                    ],
                    displayLength: 25,
                    drawCallback: function(settings) {
                        var api = this.api();
                        var rows = api.rows({
                            page: 'current'
                        }).nodes();
                        var last = null;
    
                        api
                            .column(groupColumn, {
                                page: 'current'
                            })
                            .data()
                            .each(function(group, i) {
                                if (last !== group) {
                                    $(rows)
                                        .eq(i)
                                        .before('<tr class="group"><td colspan="5">' + group + '</td></tr>');
    
                                    last = group;
                                }
                            });
                    },
                });
    
                // Order by the grouping
                $('#table_abonos tbody').on('click', 'tr.group', function() {
                    var currentOrder = table.order()[0];
                    if (currentOrder[0] === groupColumn && currentOrder[1] === 'asc') {
                        table.order([groupColumn, 'desc']).draw();
                    } else {
                        table.order([groupColumn, 'asc']).draw();
                    }
                });
              });
        },
        proveedor(id, nombre) {
            Swal.fire({
                title: 'Convertir en Proveedor a un Cliente ',
                text: "¿Estás seguro de convertir al cliente " + nombre + " en Proveedor?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                confirmButtonText: 'Aceptar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.value) {
                    axios.get('clientes/proveedor/' + id).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                notificacion('fa fa-info', '', 'Cliente convertido en Proveedor', 'info');
                            } else {
                                notificacion('fa fa-ban', '', 'Error al convertir cliente', 'danger');
                            }
                        } else {
                            let total_errores = response.data.errors.length
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion());
                }
            });
        },
        editarDatosBasicos() {

            this.errorForm = [];

            let tipo_documento = document.getElementById('tipo_documento').value;
            let dni = document.getElementById('dni').value;
            let razon_social = document.getElementById('razon_social').value;
            let fecha_nac = document.getElementById('fecha_nac').value;
            let correo = document.getElementById('correo').value;
            let telefono = document.getElementById('telefono').value;
            let telefono_2 = document.getElementById('telefono_2').value;
            let tarifa = document.getElementById('tarifa').value;
            let grupo = document.getElementById('grupo').value;

            if (!tipo_documento)
                this.errorForm.push('El campo Tipo de Documento es obligatorio.');
            if (!dni)
                this.errorForm.push('El campo DNI es obligatorio.');
            if (!razon_social)
                this.errorForm.push('El campo Razón Social es obligatorio.');
            if (!telefono)
                this.errorForm.push('El campo Teléfono es obligatorio.');
            if (correo) {
                if (!validaEmail(correo)) {
                    this.errorForm.push('El Correo Electrónico debe tener un formato válido.');
                }
            }

            if (this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'clientes/editar',
                    data: {
                        id: this.id_cliente,
                        tipo_documento: tipo_documento,
                        dni: dni,
                        razon_social: razon_social,
                        fecha_nac: fecha_nac,
                        correo: correo,
                        telefono: telefono,
                        telefono_2: telefono_2,
                        tarifa: tarifa,
                        grupo:grupo
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            document.getElementById('gui_cliente').innerHTML = razon_social;
                            notificacion('fa fa-edit', 'Actualización', 'Actualización exitosa', 'info');
                            this.errorForm = [];
                        } else {
                            notificacion('fa fa-ban', 'Error', 'Error al actualizar', 'danger');
                        }
                    } else {
                        this.errorForm = response.data.errors;
                    }
                }).catch(e => notificacion())
            }
        },
        editarDireccion() {

            this.errorForm = [];

            let direccion = document.getElementById('direccion').value;
            let pais = document.getElementById('pais').value;
            let estado = document.getElementById('estado').value;
            let ciudad = document.getElementById('ciudad').value;
            let codigo_postal = document.getElementById('codigo_postal').value;
            let lat = document.getElementById('txtLat').value;
            let lng = document.getElementById('txtLng').value;

            if (!direccion)
                this.errorForm.push('El campo Dirección es obligatorio.');
            if (!pais)
                this.errorForm.push('El campo País es obligatorio.');
            if (!estado)
                this.errorForm.push('El campo Estado es obligatorio.');
            if (!ciudad)
                this.errorForm.push('El campo Ciudad es obligatorio.');
            if (!codigo_postal)
                this.errorForm.push('El campo Código Postal es obligatorio.');

            if (this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'clientes/editarDireccion',
                    data: {
                        id: this.id_cliente,
                        direccion: direccion,
                        pais: pais,
                        estado: estado,
                        ciudad: ciudad,
                        codigo_postal: codigo_postal,
                        lat:lat,
                        lng:lng
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            notificacion('fa fa-edit', 'Actualización', 'Actualización realizada con éxito', 'info');
                            this.errorForm = [];
                        } else {
                            notificacion('fa fa-ban', 'Error', 'Error al actualizar dirección', 'danger');
                        }
                    } else {
                        this.errorForm = response.data.errors;
                    }
                }).catch(e => notificacion());
            }
        },
        modalEnvios() {
            this.errorForm = [];
            $('#modal_envios').modal('show');
        },
        modalAgente() {
            $('#modal_agente').modal('show');
        },
        modalInteres() {
            $('#modal_interes').modal('show');
        },
         modal_redes(){
            $('#modal-whatsapp').modal('show');
            let maps=document.getElementById('direccion').value;
            let dir=(document.getElementById('txtLat').value!='')?' MAPS: https://www.google.com/maps/search/?api=1%26query='+document.getElementById('txtLat').value+','+document.getElementById('txtLng').value : '';

            this.formWhatsapp.mensaje=' Direccion: '+document.getElementById('direccion').value+dir;
        },
        enviarWhatsapp(){
         if(this.formWhatsapp.telefono.length>0 && this.formWhatsapp.mensaje.length>0){
            window.open('https://api.whatsapp.com/send?phone=+58'+this.formWhatsapp.telefono+'&text='+this.formWhatsapp.mensaje+'');
         }else{
            notificacion('fa fa-ban', 'Debe llenar todos los campo', '', 'warning');
         }
        },
         modal_redesdireccion(lat,lng){
              this.formWhatsapp.telefono='';
            $('#modal-whatsapp').modal('show');
            let dir=(lat!='')?' MAPS: https://www.google.com/maps/search/?api=1%26query='+lat+','+lng : '';

            this.formWhatsapp.mensaje=dir;
        },
        guardarDireccionEnvio() {

            const formEnvio = document.getElementById('modal_form_envios');
            const formData = new FormData(formEnvio);

            this.errorForm = [];

            if (this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'clientes/guardarDireccionEnvio',
                    data: {
                        id: this.id_cliente,
                        id_envio: formData.get('env_id'),
                        direccion: formData.get('env_direccion'),
                        pais: formData.get('env_pais'),
                        estado: formData.get('env_estado'),
                        ciudad: formData.get('env_ciudad'),
                        codigo_postal: formData.get('env_codigo_postal'),
                        direccion: formData.get('env_direccion'),
                        lat: document.getElementById('lat').value,
                        long: document.getElementById('long').value,
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            this.obtenerDireccionesEnvios();
                            notificacion('fa fa-check', 'Registro', 'Registro exitoso', 'info');
                            $('#modal_envios').modal('hide');
                            this.errorForm = [];
                            document.getElementById('env_id').value = '';
                        } else {
                            notificacion('fa fa-ban', 'Error', 'Error registrar dirección', 'danger');
                        }
                    } else {
                        this.errorForm = response.data.errors;
                    }
                }).catch(e => notificacion());
            }
        },
        verDireccionEnvio(id, pais, estado, ciudad, codigo_postal, direccion,lat,long) {
            this.errorForm = [];
            document.getElementById('modal_form_envios').reset();
            document.getElementById('env_id').value = id;
            document.getElementById('env_pais').value = pais;
            document.getElementById('env_estado').value = estado;
            document.getElementById('env_ciudad').value = ciudad;
            document.getElementById('env_codigo_postal').value = codigo_postal;
            document.getElementById('env_direccion').value = direccion;
            document.getElementById('lat').value = lat;
            document.getElementById('long').value = long;
            $('#modal_envios').modal('show');
        },
        obtenerLicencias(){
              $('#table_licencias').DataTable().destroy();
            axios.get('clientes/obtenerLicencias/'+this.id_cliente).then(response => {
                this.clientes_lista = response.data;
            }).catch(e => notificacion()).finally(() => {
             $("#table_licencias").DataTable({
                    order: [],
                });
            });
        },
        async obtenerDireccionesEnvios() {
            axios.get('clientes/obtenerDireccionesEnvios/' + this.id_cliente).then(response => {
                this.direccionesEnvio = response.data;
            }).catch(e => notificacion());
        },
        async obtenerAgente() {
            this.errorForm = [];
            axios.get('clientes/obtenerAgente/' + this.id_cliente).then(response => {
                this.agentes = response.data;
            }).catch(e => notificacion());
        },
        async obtenerInteresesCli() {
            this.errorForm = [];
            axios.get('clientes/obtenerInteresesCli/' + this.id_cliente).then(response => {
                this.tiposcli = response.data;
            }).catch(e => notificacion());
            this.obtenerProductos();
        },
        async obtenerProductos(id_cliente) {
            this.errorForm = [];
            axios.get('clientes/obtenerProductos/' + this.id_cliente).then(response => {
                this.top_productos = response.data;
            }).catch(e => notificacion());
        },
        async eliminarDireccionEnvio(id, nombre) {
            this.errorForm = [];
            Swal.fire({
                title: 'Eliminar Dirección de Envío',
                text: "¿Estás seguro de querer eliminar la dirección de envío" + nombre + " ?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('clientes/eliminarDireccionEnvio/' + id).then(response => {
                        if (response.data == true) {
                            this.obtenerDireccionesEnvios();
                            notificacion('fa fa-check', 'Dirección eliminada', nombre.toUpperCase(), 'danger');
                        } else {
                            notificacion('fa fa-ban', 'Error al eliminar la dirección de envío', nombre.toUpperCase(), 'danger');
                        }
                    }).catch(e => notificacion());
                }
            });
        },
        async eliminarAgente(cliente, nombre, apellido) {
            this.errorForm = [];
            Swal.fire({
                title: 'Eliminar Agente de Venta',
                text: "¿Estás seguro de querer eliminar el agente de venta " + nombre + " " + apellido + " ?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('clientes/eliminarAgente/' + cliente).then(response => {
                        if (response.data == true) {
                            this.obtenerAgente(this.id_cliente);
                            notificacion('fa fa-trash', 'Agente eliminado', nombre.toUpperCase() + ' ' + apellido.toUpperCase(), 'danger');
                        } else {
                            notificacion('fa fa-ban', 'Error al eliminar la dirección de envío', nombre.toUpperCase() + ' ' + apellido.toUpperCase(), 'danger');
                        }
                    }).catch(e => notificacion());
                }
            });
        },
        async eliminarInteres(id_interes, nombre) {
            this.errorForm = [];
            Swal.fire({
                title: 'Eliminar Interes',
                text: "¿Estás seguro de querer eliminar este interes " + nombre + " ?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('clientes/eliminarInteres/' + id_interes).then(response => {
                        if (response.data == true) {
                            this.obtenerInteresesCli(this.id_cliente);
                            notificacion('fa fa-check', 'Interes eliminado', nombre.toUpperCase(), 'danger');
                        } else {
                            notificacion('fa fa-ban', 'Error al eliminar la dirección de envío', nombre.toUpperCase() + ' ' + apellido.toUpperCase(), 'danger');
                        }
                    }).catch(e => notificacion());
                }
            });
        },
        async obtenerFacturas() {
            this.errorForm = [];
            this.cargando_tablas = 'is-loading is-loading-lg';
            if ($.fn.DataTable.isDataTable('#table_facturas')) {
                $('#table_facturas').DataTable().destroy();
            }
            axios.get('clientes/obtenerFacturas/' + this.id_cliente).then(response => {
                this.facturas = response.data.facturas;
            }).catch(e => notificacion()).finally(() => {
                this.cargando_tablas = '';
                $('#table_facturas').DataTable({
                    "pageLength": 50,
                    "footerCallback": function (row, data, start, end, display) {
                        var api = this.api(),
                            data;

                        pageTotal = api
                            .column(1, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(1).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                        pageTotal = api
                            .column(2, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                        pageTotal = api
                            .column(3, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(3).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                    }
                });
            });

        },
        async productosvendidos() {
            this.errorForm = [];
            this.cargando_tablas = 'is-loading is-loading-lg';
            if ($.fn.DataTable.isDataTable('#table_prodvendidos')) {
                $('#table_prodvendidos').DataTable().destroy();
            }
            axios({
                method: 'post',
                url: 'clientes/obtenerProductosVendidos',
                data: {
                    id: this.id_cliente,
                    mes: this.mes,
                    anio:this.anio,
                },
                transformRequest: serializar(),
            }).then(response => {
                this.prodvendidos = response.data;
            }).catch(e => notificacion()).finally(() => {
                this.cargando_tablas = '';
                $('#table_prodvendidos').DataTable({
                    retrieve: true,
                    "order": [],
                    "footerCallback": function (row, data, start, end, display) {
                        var api = this.api(),
                            data;

                        pageTotal = api
                            .column(2, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
						
						 pageTotal = api
                            .column(3, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(3).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                    }
                });
            });

        },
        async obtenerNotasdeentrega() {
            this.errorForm = [];
            this.cargando_tablas = 'is-loading is-loading-lg';
            if ($.fn.DataTable.isDataTable('#table_Notasentrega')) {
                $('#table_Notasentrega').DataTable().destroy();
            }
            axios.get('clientes/obtenerNotasdeentrega/' + this.id_cliente).then(response => {
                this.notasdeentrega = response.data.notasdeentrega;
            }).catch(e => notificacion()).finally(() => {
                this.cargando_tablas = '';
                $('#table_Notasentrega').DataTable({
                    "pageLength": 50,
                    "footerCallback": function (row, data, start, end, display) {
                        var api = this.api(),
                            data;

                        pageTotal = api
                            .column(1, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(1).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                        pageTotal = api
                            .column(2, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                        pageTotal = api
                            .column(3, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(3).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                    }
                });
            });

        },
        async obtenerOrdenesdeentrega() {
            this.errorForm = [];
            this.cargando_tablas = 'is-loading is-loading-lg';
            if ($.fn.DataTable.isDataTable('#table_orden_de_entrega')) {
                $('#table_orden_de_entrega').DataTable().destroy();
            }
            axios.get('clientes/obtenerOrdenesdeentrega/' + this.id_cliente).then(response => {
                this.ordenesdeentrega = response.data.ordenesdeentrega;
            }).catch(e => notificacion()).finally(() => {
                this.cargando_tablas = '';
                $('#table_orden_de_entrega').DataTable({
                    "pageLength": 50,
                    "footerCallback": function (row, data, start, end, display) {
                        var api = this.api(),
                            data;

                        pageTotal = api
                            .column(1, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(1).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                        pageTotal = api
                            .column(2, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                        pageTotal = api
                            .column(3, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(3).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                    }
                });
            });

        },
        async obtenerPedidos() {
            this.errorForm = [];
            this.cargando_tablas = 'is-loading is-loading-lg';
            if ($.fn.DataTable.isDataTable('#table_pedidos')) {
                $('#table_pedidos').DataTable().destroy();
            }
            axios.get('clientes/obtenerPedidos/' + this.id_cliente).then(response => {
                this.pedidos = response.data.pedidos;
            }).catch(e => notificacion()).finally(() => {
                this.cargando_tablas = '';
                $('#table_pedidos').DataTable({
                    "pageLength": 50,
                    "footerCallback": function (row, data, start, end, display) {
                        var api = this.api(),
                            data;

                        pageTotal = api
                            .column(1, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(1).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                    }
                });
            });

        },
        async obtenerPresupuestos() {
            this.errorForm = [];
            this.cargando_tablas = 'is-loading is-loading-lg';
            if ($.fn.DataTable.isDataTable('#table_presupuestos')) {
                $('#table_presupuestos').DataTable().destroy();
            }
            axios.get('clientes/obtenerPresupuestos/' + this.id_cliente).then(response => {
                this.presupuestos = response.data.presupuestos;
            }).catch(e => notificacion()).finally(() => {
                this.cargando_tablas = '';
                $('#table_presupuestos').DataTable({
                    "pageLength": 50,
                    "footerCallback": function (row, data, start, end, display) {
                        var api = this.api(),
                            data;

                        pageTotal = api
                            .column(1, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(1).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));
                    }
                });
            });

        },
        async obtenerNotasdeCredito() {
            this.errorForm = [];
            this.cargando_tablas = 'is-loading is-loading-lg';
            $('#table_creditos').DataTable().destroy();
            axios.get('clientes/obtenerNotasdeCredito/' + this.id_cliente).then(response => {
                this.creditos = response.data;
            }).catch(e => notificacion()).finally(() => {
                this.cargando_tablas = '';
                $('#table_creditos').DataTable();
            });
        },
        verDetalleCredito(id) {
            axios.get('facturacion/obtenerNotadeCreditoDetalle/' + id).then(response => {
                this.detalleCreditoId = id;
                this.detalleCredito = response.data.pagos;
                this.detalleCreditoTotal = response.data.total;
            }).catch(e => notificacion()).finally(() => {
                $('#modal_detalles_credito').modal('show');
            });
        },
        moneda(num, div_locale, div_simbolo, decimal = 2) {
            return monedaMoneda(num, div_locale, div_simbolo, decimal);
        },
        decimal(num, div_locale, decimal = 2) {
            return monedaDecimal(num, div_locale, decimal);
        },
        Guardaragente() {

            let agente = document.getElementById('agente').value;
            let cliente = this.id_cliente;
            let fecha = document.getElementById('fecha').value;
            let captadocli = document.getElementById('captado').value;
            axios({
                method: 'post',
                url: 'clientes/guardarAgenteVenta',
                data: {
                    agente: agente,
                    idcliente: cliente,
                    fecha: fecha,
                    captado: captadocli
                },
                transformRequest: serializar(),
            }).then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        this.obtenerAgente(this.id_cliente);
                        notificacion('fa fa-check', 'Actualizado', 'Registro exitoso', 'success');
                    }
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());

        },
        guardarInteres() {
            let cliente = this.id_cliente;
            let descripcion = document.getElementById('descripcioninte').value;
            axios({
                method: 'post',
                url: 'clientes/guardarInteres',
                data: {
                    idcliente: cliente,
                    descripcion: descripcion
                },
                transformRequest: serializar(),
            }).then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        this.obtenerInteresesCli(this.id_cliente);
                        notificacion('fa fa-check', 'Actualizado', 'Registro exitoso', 'success');
                    }
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
         guardarContactoDirecto() {

             datF={'contactoID':'','contactoNombre':document.getElementById('razon_social').value,'contactoCargo':'Cliente','contactoTlf':document.getElementById('telefono').value,'contactoEmail':document.getElementById('correo').value,'id_cliente':this.id_cliente};
          if(document.getElementById('razon_social').value!='' && document.getElementById('telefono').value!='' && document.getElementById('correo').value!=''){
            axios({
                method: 'post',
                url: 'clientes/guardarContacto',
                data: {
                    'contactoID':'',
                    'contactoNombre':document.getElementById('razon_social').value,
                    'contactoCargo':'Cliente','contactoTlf':document.getElementById('telefono').value,
                    'contactoEmail':document.getElementById('correo').value,
                    'id_cliente':this.id_cliente
                },
                  transformRequest: serializar(),
            }).then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        this.obtenerContactos(this.id_cliente);
                        notificacion('fa fa-check', 'Actualizado', 'Registro exitoso', 'success');
                    } else {
                        notificacion('fa fa-ban', 'Error', 'Error al registrar', 'danger');
                    }
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
          }else{
                notificacion('fa fa-ban', 'Error', 'Campos vacios', 'danger');
              }
        },
        guardarContacto() {

            const formContacto = document.getElementById('formContacto');
            const formData = new FormData(formContacto);
            formData.set('id_cliente', this.id_cliente);

            axios({
                method: 'post',
                url: 'clientes/guardarContacto',
                data: formData
            }).then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        this.obtenerContactos(this.id_cliente);
                        notificacion('fa fa-check', 'Actualizado', 'Registro exitoso', 'success');
                        if (formData.get('contactoID')) {
                            $('#modalContacto').modal('hide');
                        }
                        document.getElementById('formContacto').reset();
                        document.getElementById('contactoID').value = '';
                    } else {
                        notificacion('fa fa-ban', 'Error', 'Error al registrar', 'danger');
                    }
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        async obtenerContactos() {
            axios.get('clientes/obtenerContactos/' + this.id_cliente).then(response => {
                this.contactos = response.data;
            }).catch(e => notificacion());
        },
        verContacto(contacto) {
            document.getElementById('contactoID').value = contacto.id;
            document.getElementById('contactoNombre').value = contacto.nombre;
            document.getElementById('contactoCargo').value = contacto.cargo;
            document.getElementById('contactoTlf').value = contacto.telefono;
            document.getElementById('contactoEmail').value = contacto.email;
            $('#modalContacto').modal('show');
        },
        eliminarContacto(contacto) {
            Swal.fire({
                title: 'Eliminar Contacto',
                text: "¿Estás seguro de querer eliminar al contacto " + contacto.nombre + " ?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('clientes/eliminarContacto/' + contacto.id).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                const posicion = this.contactos.findIndex(item => item.id == contacto.id);
                                this.contactos.splice(posicion, 1);
                                notificacion('fa fa-trash', 'Contacto eliminado', contacto.nombre.toUpperCase(), 'danger');
                            } else {
                                notificacion('fa fa-ban', 'Error al eliminar', contacto.nombre.toUpperCase(), 'danger');
                            }
                        } else {
                            let total_errores = response.data.errors.length;
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion());
                }
            });
        },
        obtenerRedesSociales() {
            axios.get('clientes/obtenerRedesSociales/' + this.id_cliente).then(response => {
                this.redesSociales = response.data;
            }).catch(e => notificacion());
        },
        editarGuardarRedes() {

            this.errorForm = [];

            if (!this.form_redes)
                this.errorForm.push('Seleccione el tipo de red social obligatorio.');

            if (!this.form_descripcion)
                this.errorForm.push('Agregue la descripcion de la red social obligatorio.');

            if (this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'clientes/guardarRedes',
                    data: {
                        'tipo':this.form_redes,
                        'descripcion':this.form_descripcion,
                        'id':this.id_cliente,
                        'rd':this.form_id
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                       this.obtenerRedesSociales();
                       this.form_descripcion='';
                       this.form_id='';
                       this.form_redes='';
                    } else {
                        this.errorForm = response.data.errors;
                    }
                }).catch(e => notificacion());
            }
        },
        verRedes(redes) {
            this.errorForm = [];
            this.form_redes = redes.clird_type;
            this.form_descripcion = redes.clird_descripcion;
            this.form_id = redes.clird_id;
        },
        eliminarRedes(redes) {

            this.errorForm = [];

            Swal.fire({
                title: 'Eliminar Red social',
                text: "¿Estás seguro que deseas eliminar la red social " + redes.clird_type + " ?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('clientes/eliminarRedes/' + redes.clird_id).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                let posicion = this.redesSociales.findIndex(item => item.id == redes.clird_id);
                                this.redesSociales.splice(posicion, 1);
                                notificacion('fa fa-trash', 'Categoria eliminada', redes.clird_descripcion.toUpperCase(), 'danger');
                            } else {
                                notificacion('fa fa-ban', 'Error al eliminar', redes.clird_descripcion.toUpperCase(), 'danger');
                            }
                        } else {
                            this.errorForm = response.data.errors;
                        }
                    }).catch(e => notificacion()).finally(() => {
                        this.form_redes = '';
                        this.form_descripcion = '';
                        this.form_id='';
                    })
                }
            });
        }
    }
});