let vuel=new Vue({
    el: '#appClientes',
    data: {
        clientes: 0,
        clientesActivos: 0,
        clientesInactivos: 0,
        clientesGrupos: 0,
        cargando: '',
        fecha_desde: moment().format('YYYY-MM-DD'),
        fecha_hasta: moment().format('YYYY-MM-DD'),
        cargando_tabla: 'is-loading is-loading-lg',
        cantidad_articulos:0,
        clientesCompran:[],
        divisa:2
    },
    created() {
        this.obtenerClientes();
        this.obtenerClientesEstatus();
        this.buscar();
    },
    methods: {
        obtenerClientesTodos(){
            $('#clientes-table').DataTable().destroy();
      
            var tabla=$('#clientes-table').DataTable({
                'processing': true,
                'serverSide': true,
                'serverMethod': 'post',
                'autoWidth':false,
                'order':[[0,'asc']],
                'lengthMenu':[[10,25,100,-1],[10,25,100,'Todos']],
                'pageLength':10,
                'dom': "Blfrtip",
                  'buttons': [{
                            extend: 'excelHtml5',
                            title: 'Clientes'
                        }],
                'ajax':{
                    'url':'clientes/obtenerClientes',
                    'data':{
                        'clientes': 'todos'
                    }
                },
                'columns': [
                    { data: 'cli_dni',
                        render:function (data,type,row) {
                            return "<a href='"+baseURL+"clientes/ver/"+row.cli_id+"'>"+row.cli_dni+"</a>";
                        }
                     },
                     { data: 'cli_razon_social'},
                    { data: 'cli_telefono' },
                    { data: 'cli_email'},
                    {
                        data:'cli_estatus',
                        render:function (data,type,row) {
                            let text=row.cli_estatus == 1 ? "<i class='fa fa-check text-success'></i>" : "<i class='fa fa-times text-danger'></i>";
                            return "<button type='button' id='estatus' class='estatus btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'>"+text+"</button>";
                        }
                    },
                    {
                        data:'cli_estatus',
                        render:function (data,type,row) {
                            let eliminar="<button type='button' id='eliminar' class='eliminar btn btn-link btn-primary' ><i class='fa fa-trash text-danger' style='padding: .65rem;'></i></button>";
                            let proveedor="<button type='button' id='proveedor' class='proveedor btn btn-link btn-primary'><i class='fa fa-users text-info' style='padding: .65rem;'></i></button>";
                            return '<div class="form-button-action">'+eliminar+' '+proveedor+'</div>';
                        }
                    }
                    //{ defaultContent: "<button type='button' id='estatus' class='pendiente btn btn-icon btn-sm btn-light' style='box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;'><i class='fas fa-check text-success' style='padding: .65rem;'></i></button>" },
                ],
            });
            
            $("#clientes-table tbody").on('click','button.estatus',function () {
                let tb=$('#clientes-table').DataTable();
                var datosd=tb.row($(this).parents("tr")).data();
                vuel.modificarEstatus(datosd.cli_id);
            });
            $("#clientes-table tbody").on('click','button.eliminar',function () {
                let tb=$('#clientes-table').DataTable();
                var datosd=tb.row($(this).parents("tr")).data();
                vuel.eliminar(datosd);
            });
            $("#clientes-table tbody").on('click','button.proveedor',function () {
                let tb=$('#clientes-table').DataTable();
                var datosd=tb.row($(this).parents("tr")).data();
                vuel.proveedor(datosd);
            });
          },
        obtenerClientes() { 
            this.cargando = 'is-loading is-loading-lg';
            axios.get('clientes/obtenerClientesGrupoT').then(response => {
                this.clientes = response.data.clientes;
                this.clientesGrupos = response.data.grupos;
                this.obtenerClientesTodos();
            }).catch(e => notificacion()).finally(() => {
                this.cargando = '';
                this.cargando_tabla = '';
            });
        },
        obtenerClientesEstatus() {
            axios.get('clientes/obtenerClientesActivosInactivos').then(response => {
                this.clientesActivos = response.data.activos;
                this.clientesInactivos = response.data.inactivos;
            }).catch(e => notificacion());
        },
        modificarEstatus(id) {
            axios.get('clientes/modificarEstatus/' + id).then(response => {
                    this.obtenerClientesEstatus();
                    location.href='';
            }).catch(e => notificacion());
        },
        eliminar(cliente) {
            Swal.fire({
                title: 'Eliminar cliente',
                text: "¿Estás seguro de eliminar al cliente " + cliente.cli_razon_social + " ?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                confirmButtonText: 'Eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.value) {
                    axios.get('clientes/eliminarCliente/' + cliente.cli_id).then(response => {
                        $('#clientes-table').DataTable().destroy();
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                this.obtenerClientesEstatus();
                                let posicion = this.clientes.findIndex((item) => item.id == cliente.cli_id);
                                this.clientes.splice(posicion, 1);
                                notificacion('fa fa-trash', 'Cliente eliminado', cliente.cli_razon_social.toUpperCase(), 'danger');
                            } else {
                                notificacion('fa fa-ban', 'Error al eliminar', cliente.cli_razon_social.toUpperCase(), 'danger');
                            }
                        } else {
                            let total_errores = response.data.errors.length
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => console.log(e)).finally(() => {
                        $("#clientes-table").DataTable({
                            retrieve: true,
                            order: []
                        });
                    })
                }
            });
        },
        proveedor(cliente) {
            Swal.fire({
                title: 'Convertir cliente en Proveedor',
                text: "¿Estás seguro de convertir al cliente " + cliente.cli_razon_social + " en Proveedor?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                confirmButtonText: 'Aceptar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.value) {
                    axios.get('clientes/proveedor/' + cliente.cli_id).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                notificacion('fa fa-info', '', 'Cliente convertido', 'info');
                            } else {
                                notificacion('fa fa-ban', '', 'Error al convertir cliente', 'danger');
                            }
                        } else {
                            let total_errores = response.data.errors.length
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion());
                }
            });
        },
        buscar() {
            this.errorForm = [];
           // this.cargando = true;
           this.cargando = 'is-loading is-loading-lg';
           this.clientesCompran=[];
            $("#tab_clientes_compran").DataTable().destroy();

            axios.get('clientes/obtenerClientesCompran', {
                params: {
                    fecha_desde: this.fecha_desde,
                    fecha_hasta: this.fecha_hasta,
                    divisa: this.divisa
                }
            }).then(response => {
                if (response.data.errors == null) {
                   this.clientesCompran=response.data.clientes;
                } else {
                    this.errorForm = response.data.errors;
                }
            }).catch(e => notificacion()).finally(() => {
                this.cargando = '';
                this.cargando_tabla = '';

                let buttonCommon = {
                    exportOptions: {
                        format: {
                            body: function(data, row, column, node) {
                                if (column === 1 || column === 2 || column === 3 || column === 4 || column === 5 || column === 6 || column === 7) {
                                    return convertir_a_float(data)
                                } else {
                                    return data.replace(/<[^>]*>?/g, '');
                                }
                            }
                        }
                    }
                };

                $("#tab_clientes_compran").DataTable({
                    retrieve:true,
                    dom: 'Blfrtip',
                    "pageLength":10,
                    "order":[],
                    buttons: [
                        $.extend(true, {}, buttonCommon, {
                            extend: 'excelHtml5',
                            title: 'Compras de clientes ' +
                                moment(this.fecha_desde).format('DD-MM-YYYY') +
                                ' hasta ' +
                                moment(this.fecha_desde).format('DD-MM-YYYY'),
                        }),
                    ],
                    "footerCallback": function (row, data, start, end, display) {
                        var api = this.api(),
                            data;

                            pageTotal = api
                            .column(1, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(1).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));


                        pageTotal = api
                            .column(2, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(2).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                        pageTotal = api
                            .column(3, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(3).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                        pageTotal = api
                            .column(4, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(4).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                        pageTotal = api
                            .column(5, { page: 'current' })
                            .data()
                            .reduce(function (a, b) {
                                return convertir_a_float(String(a).toString()) + convertir_a_float(String(b).toString());
                            }, 0);

                        $(api.column(5).footer()).html(monedaDecimal(String(pageTotal).toString(), 'de-De'));

                       
                    }
                });

            });
        },
        moneda(num, div_locale, div_simbolo, decimal = 2) {
            return monedaMoneda(num, div_locale, div_simbolo, decimal);
        }
    }
});