new Vue({
    el: '#appCategorias',
    data: {
        titulo: '',
        accion: '',
        categorias: [],
        dataForm: { 'id': '', 'codigo': '', 'descripcion': '','dependencia':'','wooc':'' },
        errorForm: [],
        cargando: false,
        lista_categoria:[]
    },
    created() {
        this.obtenerCategorias();
        this.obtenerCategoriasPadre();
    },
    methods: {
        obtenerCategorias() {
            axios.get('categorias/obtenerCategorias').then(response => {
                this.categorias = response.data;
                this.lista_categoria= response.data;
            }).catch(e => notificacion());
        },
        obtenerCategoriasPadre() {
            axios.get('categorias/obtenerCategoriasPadre').then(response => {
                this.lista_categoria= response.data;
            }).catch(e => notificacion());
        },
        toggleTreeView(event) {
            if (event.target.classList[0] == 'encabezado') {

                let toggler = document.getElementsByClassName("fas fa-angle-right");
                for (i = 0; i < toggler.length; i++) {
                    toggler[i].classList.remove("active-treeview");
                }
                event.target.classList.toggle('fa-arrow-down');
                event.target.classList.toggle("active-treeview");
                event.target.parentElement.querySelector(".ocultar-treeview").classList.toggle("activar-treeview");
            }
        },
        resetearFormulario() {
            document.getElementById('form_modal_categorias').reset();
            this.dataForm.id = '';
            this.dataForm.codigo = '';
            this.dataForm.descripcion = '';
            this.dataForm.dependencia = '';
            this.dataForm.wooc = '';
            this.errorForm = [];
        },
        modalGuardar() {
            this.resetearFormulario();
            this.titulo = 'Guardar categoria';
            this.accion = 'Guardar';
            $('#modal_categorias').modal('show');
            $('#modal_categorias').on('shown.bs.modal', function () {
                $('#codigo').trigger('focus');
            });
        },
        ver(id, codigo, descripcion,categoria,wooc) {
            this.errorForm = [];
            this.dataForm.id = id;
            this.dataForm.codigo = codigo;
            this.dataForm.descripcion = descripcion;
            this.dataForm.dependencia = categoria;
            console.log(this.dataForm.dependencia)
            this.dataForm.wooc = wooc;
            this.titulo = 'Editar categoria';
            this.accion = 'Actualizar';
            $('#modal_categorias').modal('show');
        },
        editarGuardar: function () {

            this.errorForm = [];

            if (!this.dataForm.codigo)
                this.errorForm.push('El campo Código es obligatorio.');
            if (!this.dataForm.descripcion)
                this.errorForm.push('El campo Descripción es obligatorio.');

            if (this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'categorias/guardar',
                    data: this.dataForm,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            this.obtenerCategorias();
                            this.obtenerCategoriasPadre();
                            if (this.dataForm.id !== '') {
                                $('#modal_categorias').modal('hide');
                                notificacion('fa fa-edit', 'Actualizado', 'Categoria actualizado correctamente', 'info');
                            } else {
                                notificacion('fa fa-check', 'Registrado', 'Categoria registrado correctamente', 'success');
                            }
                            this.resetearFormulario();
                        }
                    } else {
                        let total_errores = response.data.errors.length;
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        eliminar(id, nombre) {
            Swal.fire({
                title: 'Eliminar Categoría',
                text: "¿Estás seguro que deseas eliminar la categoria " + nombre + " ?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('categorias/eliminar/' + Number(id)).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                this.obtenerCategorias();
                                this.obtenerCategoriasPadre();
                                notificacion('fa fa-trash', 'Categoria eliminada', nombre.toUpperCase(), 'danger');
                            } else {
                                notificacion('fa fa-ban', 'Error al eliminar', nombre.toUpperCase(), 'danger');
                            }
                        } else {
                            let total_errores = response.data.errors.length;
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion());
                }
            });
        }
    }
});