new Vue({
    el: '#appCajas',
    data: {
        titulo: '',
        accion: '',
        cajas: [],
        impresoras: [],
        metodosDePago: [],
        dataForm: { id: '', codigo: '', descripcion: '', metododepago: '', impresora: '' },
        errorForm: [],
        cargando: false,
        empleados: [],
        cajeros: [],
        icon_buscador: 'fa fa-search',
        la_caja: ''
    },
    created() {
        this.obtenerCajas();
        this.obtenerImpresoras();
        this.obtenerMetodosPagoActivos();
    },
    methods: {
        obtenerCajas() {
            axios.get('caja/obtenerCajas').then(response => {
                this.cajas = response.data;
            }).catch(e => notificacion());
        },
        obtenerImpresoras() {
            axios.get('impresoras/obtenerImpresoras').then(response => {
                this.impresoras = response.data;
            }).catch(e => notificacion());
        },
        obtenerMetodosPagoActivos() {
            axios.get('metodospago/obtenerMetodosPagoActivos').then(response => {
                this.metodosDePago = response.data;
            }).catch(e => notificacion());
        },
        resetearFormulario() {
            document.getElementById('modal_form_cajas').reset();
            this.dataForm.id = '';
            this.dataForm.codigo = '';
            this.dataForm.descripcion = '';
            this.dataForm.impresora = '';
            this.dataForm.metododepago = '';
            this.errorForm = [];
        },
        modalCaja() {
            this.resetearFormulario();
            this.titulo = 'Guardar Caja';
            this.accion = 'Guardar';
            $('#modal-caja').modal('show');
            $('#modal-caja').on('shown.bs.modal', function() {
                $('#caj-codigo').trigger('focus');
            });
        },
        ver(caja) {
            this.resetearFormulario();
            this.dataForm.id = caja.id;
            this.dataForm.codigo = caja.codigo;
            this.dataForm.descripcion = caja.descripcion;
            this.dataForm.metododepago = caja.metododepago_id;
            this.dataForm.impresora = caja.impresora_id;
            this.titulo = 'Editar Caja';
            this.accion = 'Actualizar';
            $('#modal-caja').modal('show');
            $('#modal-caja').on('shown.bs.modal', function() {
                $('#caj-codigo').trigger('blur');
            });
        },
        guardarEditar() {

            this.errorForm = [];

            if (!this.dataForm.codigo)
                this.errorForm.push('El campo Código es obligatorio.');
            if (!this.dataForm.descripcion)
                this.errorForm.push('El campo Descripción es obligatorio.');
            if (!this.dataForm.impresora)
                this.errorForm.push('El campo Impresora es obligatorio.');
            if (!this.dataForm.metododepago)
                this.errorForm.push('El campo Método de pago es obligatorio.');

            if (this.errorForm.length == 0) {

                this.cargando = true;

                axios({
                    method: 'post',
                    url: 'caja/guardar',
                    data: this.dataForm,
                    transformRequest: serializar(),
                }).then(response => {
                    console.log(response.data)
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            if (this.dataForm.id !== '') {
                                $('#modal-caja').modal('hide');
                                notificacion('fa fa-edit', 'Actualizado', 'Caja actualizada correctamente', 'info');
                            } else {
                                notificacion('fa fa-check', 'Registrado', 'Caja registrada correctamente', 'success');
                            }
                            this.resetearFormulario();
                            this.obtenerCajas();
                        } else {
                            notificacion('fa fa-ban', 'Error', 'Error en operacion', 'danger');
                        }
                    } else {
                        this.errorForm = response.data.errors;
                    }
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                });
            }
        },
        cambiarEstatus(caja) {
            axios.get('caja/cambiarEstatus/' + caja.id).then(response => {
                if (response.data == true) {
                    caja.estatus = !caja.estatus;
                    notificacion('fa fa-info', '', 'Operacion exitosa', 'info');
                }
            }).catch(e => notificacion());
        },
        eliminar(caja) {
            Swal.fire({
                title: '¡Eliminar caja!',
                text: "¿Estás seguro de eliminar la caja " + caja.descripcion + " ?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('caja/eliminar/' + caja.id).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                let posicion_lista = this.caja.findIndex(element => element.id == caja.id);
                                this.cajas.splice(posicion_lista, 1);
                                notificacion('fa fa-trash', 'Caja eliminada', caja.descripcion.toUpperCase(), 'danger');
                            } else {
                                notificacion('fa fa-ban', 'Error al eliminar', caja.descripcion.toUpperCase(), 'danger');
                            }
                        } else {
                            let total_errores = response.data.errors.length;
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion());
                }
            });
        },
        cajero(caja) {
            this.la_caja = caja.id;
            this.obtenerCajeros();
            $('#modal-buscar-empleados').modal('show');
            $('#modal-buscar-empleados').on('shown.bs.modal', function() {
                $('#buscar-cajero').trigger('focus');
            });
        },
        buscarEmpleados(event) {
            //this.icon_buscador = 'is-loading pr-3';
            axios.get('caja/buscarEmpleados', {
                params: {
                    buscar: event.target.value
                }
            }).then(response => {
                this.empleados = response.data;
            }).catch(e => notificacion()).finally(() => {
                //this.icon_buscador = 'fa fa-search';
            });
        },
        agregarCajero(empleado) {
            axios.get('caja/agregarCajero', {
                params: {
                    caja: this.la_caja,
                    empleado: empleado
                }
            }).then(response => {
                if (response.data == true) {
                    this.obtenerCajeros();
                }
            }).catch(e => notificacion()).finally(() => {
                document.getElementById('buscar-cajero').value = '';
                this.empleados = [];
            });
        },
        obtenerCajeros() {
            axios.get('caja/obtenerCajeros/' + this.la_caja).then(response => {
                this.cajeros = response.data;
            }).catch(e => notificacion());
        },
        eliminarCajero(cajero) {
            axios.get('caja/eliminarCajero/' + cajero.id).then(response => {
                if (response.data = true) {
                    let posicion_lista = this.cajeros.findIndex(element => element.id == cajero.id);
                    this.cajeros.splice(posicion_lista, 1);
                    notificacion('fa fa-trash', '', 'Cajero eliminado', 'danger');
                } else {
                    notificacion('fa fa-ban', 'Error', 'Error al eliminar cajero', 'danger');
                }
            }).catch(e => notificacion());
        },
    },
});