new Vue({
    el: '#appUbicacion',
    data: {
        almacen: document.getElementById('almacen').value,
        label: '',
        titulo: '',
        accion: '',
        ubicaciones: [],
        zona: '',
        zonas: [],
        pasillo: '',
        pasillos: [],
        armario: '',
        armarios: [],
        seccion: '',
        secciones: [],
        cajon: '',
        cajones: [],
        descripcion: '',
        error: [],
        cargando: false
    },
    created() {
        this.obtenerZonas();
        this.obtenerUbicaciones();
    },
    methods: {
        llamarModal(nombre) {
            this.titulo = 'Guardar ' + nombre;
            this.label = nombre;
            this.error = [];
            $('#modal_ubicacion').modal('show');
            $('#modal_ubicacion').on('shown.bs.modal', function () {
                $('#descripcion').trigger('focus');
            });
        },
        obtenerZonas() {
            axios.get('almacenes/obtenerZonas/' + Number(this.almacen)).then(response => {
                this.zonas = response.data;
            }).catch(e => notificacion());
        },
        toggleTreeView(event) {
            if (event.target.classList[0] == 'encabezado') {

                let toggler = document.getElementsByClassName("fas fa-angle-right");
                for (i = 0; i < toggler.length; i++) {
                    toggler[i].classList.remove("active-treeview");
                }
                event.target.classList.toggle('fa-arrow-down');
                event.target.classList.toggle("active-treeview");
                event.target.parentElement.querySelector(".ocultar-treeview").classList.toggle("activar-treeview");
            }
        },
        obtenerUbicaciones() {
            axios.get('almacenes/obtenerUbicaciones/' + Number(this.almacen)).then(response => {
                this.ubicaciones = response.data;
            }).catch(e => notificacion());
        },
        llenarCombo(event, tipo) {
            axios.get('almacenes/llenarCombo/' + Number(event.target.value)).then(response => {
                if (tipo == 'Pasillos') {
                    this.armario = '';
                    this.armarios = response.data.armarios;
                    this.seccion = '';
                    this.secciones = response.data.secciones;
                    this.cajon = '';
                    this.cajones = response.data.cajones;
                } else if (tipo == 'Armarios') {
                    this.seccion = '';
                    this.secciones = response.data.secciones;
                    this.cajon = '';
                    this.cajones = response.data.cajones;
                } else if (tipo == 'Secciones') {
                    this.cajon = '';
                    this.cajones = response.data.cajones;
                } else {
                    this.pasillo = '';
                    this.pasillos = response.data.pasillos;
                    this.armario = '';
                    this.armarios = response.data.armarios;
                    this.seccion = '';
                    this.secciones = response.data.secciones;
                    this.cajon = '';
                    this.cajones = response.data.cajones;
                }
            }).catch(e => notificacion());
        },
        guardarUbicacion() {

            let padre = '';

            if (this.label == 'Zonas') {

                padre = 0;
            } else if (this.label == 'Pasillos') {
                padre = '';
                if (this.zona !== '') {
                    padre = this.zona;
                } else {
                    notificacion('fa fa-ban', 'Guardado', 'Debe seleccionar una zona', 'warning');
                }
            } else if (this.label == 'Armarios') {
                padre = '';
                if (this.pasillo !== '') {
                    padre = this.pasillo;
                } else {
                    if (this.zonas !== '') {
                        padre = this.zona;
                    }
                }
                if (padre == '') {
                    notificacion('fa fa-ban', 'Guardado', 'Debe seleccionar una zona o un pasillo', 'warning');
                }
            } else if (this.label == 'Secciones') {
                padre = '';
                if (this.armario !== '') {
                    padre = this.armario;
                } else {
                    if (this.pasillo !== '') {
                        padre = this.pasillo;
                    } else {
                        if (this.zonas !== '') {
                            padre = this.zona;
                        }
                    }
                }
                if (padre == '') {
                    notificacion('fa fa-ban', 'Guardado', 'Debe seleccionar una zona, pasillo o un armario', 'warning');
                }
            } else if (this.label == 'Cajones') {
                padre = '';
                if (this.seccion !== '') {
                    padre = this.seccion;
                } else {
                    if (this.armario !== '') {
                        padre = this.armario;
                    } else {
                        if (this.pasillo !== '') {
                            padre = this.pasillo;
                        } else {
                            if (this.zonas !== '') {
                                padre = this.zona;
                            }
                        }
                    }
                }
                if (padre == '') {
                    notificacion('fa fa-ban', 'Guardado', 'Debe seleccionar una zona, pasillo, armario o una sección', 'warning');
                }
            }

            if (this.label !== '' && padre !== '') {

                this.cargando = true;

                axios({
                    method: 'post',
                    url: 'almacenes/guardarUbicacion',
                    data: {
                        almacen: this.almacen,
                        descripcion: this.descripcion,
                        tipo: this.label,
                        padre: padre
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data !== false) {
                            if (response.data.tipo == 'Pasillos') {
                                this.pasillos = response.data.recargar;
                            } else if (response.data.tipo == 'Armarios') {
                                this.armarios = response.data.recargar;
                            } else if (response.data.tipo == 'Secciones') {
                                this.secciones = response.data.recargar;
                            } else if (response.data.tipo == 'Cajones') {
                                this.cajones = response.data.recargar;
                            }
                            notificacion('fa fa-check', 'Guardado', 'Registro exitoso', 'success');
                            if (this.label == 'Zonas') {
                                this.obtenerZonas();
                            }
                        }
                    } else {
                        this.error = response.data.errors;
                    }
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                    this.descripcion = '';
                    this.obtenerUbicaciones();
                });
            }
        },
        agregarUbicacion(id = '') {
            let input = document.getElementById('inputagregarubi' + id);
            input.classList.toggle('inputActive');
            input.focus();
        },
        agregarUbicacionArmarios(id) {
            let input = document.getElementById('inputagregarubiarm' + id);
            input.classList.toggle('inputActive');
            input.focus();
        },
        agregarUbicacionSecciones(id) {
            let input = document.getElementById('inputagregarubisec' + id);
            input.classList.toggle('inputActive');
            input.focus();
        },
        agregarUbicacionCajones(id) {
            let input = document.getElementById('inputagregarubicaj' + id);
            input.classList.toggle('inputActive');
            input.focus();
        },
        guardarUbicacionTreeView(padre, tipo, event) {

            this.cargando = true;

            if (event.target.value) {
                axios({
                    method: 'post',
                    url: 'almacenes/guardarUbicacion',
                    data: {
                        almacen: this.almacen,
                        descripcion: event.target.value,
                        tipo: tipo,
                        padre: padre
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data !== false) {
                            if (response.data.tipo == 'Pasillos') {
                                this.pasillos = response.data.recargar;
                            } else if (response.data.tipo == 'Armarios') {
                                this.armarios = response.data.recargar;
                            } else if (response.data.tipo == 'Secciones') {
                                this.secciones = response.data.recargar;
                            } else if (response.data.tipo == 'Cajones') {
                                this.cajones = response.data.recargar;
                            }
                            notificacion('fa fa-check', 'Guardado', 'Registro exitoso', 'success');
                            if (tipo == 'Zonas') {
                                this.obtenerZonas();
                            }
                        }
                    } else {
                        this.error = response.data.errors;
                    }
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                    this.obtenerUbicaciones();
                    event.target.value = '';
                });
            }
        },
        eliminar(ubicacion, tipo) {
            Swal.fire({
                title: 'Eliminar ubicación',
                text: "¿Estás seguro de eliminar la ubicacion: " + String(ubicacion.descripcion).toUpperCase() + " de " + tipo,
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                confirmButtonText: 'Aceptar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.value) {
                    axios.get('almacenes/eliminarUbicacion/' + ubicacion.id).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                this.obtenerUbicaciones();
                                if (tipo == 'Zonas') {
                                    this.obtenerZonas();
                                }
                                notificacion('fa fa-info', '', 'Operación exitosa', 'info');
                            } else {
                                notificacion('fa fa-ban', '', 'Operación fallida', 'danger');
                            }
                        } else {
                            let total_errores = response.data.errors.length
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion());
                }
            });
        }
    }
});

document.addEventListener("click", function (e) {
    if (e.target.classList[0] !== 'inputInactive' && e.target.classList[0] !== 'agregar') {
        let x = document.getElementsByClassName("inputInactive");
        for (let i = 0; i < x.length; i++) {
            if (e != x[i]) {
                x[i].classList.remove('inputActive');
            }
        }
    }
});