new Vue({
    el: '#appAlmacenes',
    data: {
        titulo: '',
        accion: '',
        almacenes: [],
        id_almacen: '',
        errorForm: [],
        cargando: false,
        garantia: false,
        sucursals:[]
    },
    created() {
        this.obtenerAlmacenes();
    },
    methods: {
        obtenerSucursales(id_almacen){
            axios.get('almacenes/obtenerSucursales/' + Number(id_almacen)).then(response => {
                this.sucursals = response.data
            }).catch(e => notificacion());
        },
        sucursales(almacen) {
            this.errorForm = [];
            this.id_almacen = almacen.alm_id;
            this.titulo = 'Sucursales almacen';
            this.accion = 'Agregar';
            this.cargando=false;
            this.obtenerSucursales(almacen.alm_id)
            $('#modal_sucursales').modal('show');
        },
        obtenerAlmacenes() {
            axios.get('almacenes/obtenerAlmacenes').then(response => {
                this.almacenes = response.data
            }).catch(e => notificacion());
        },
        resetearFormulario() {
            this.id_almacen = '';
            document.getElementById('form_modal_almacenes').reset();
            this.errorForm = [];
        },
        modalGuardar() {
            this.resetearFormulario();
            this.titulo = 'Guardar almacen';
            this.accion = 'Guardar';
            $('#modal_almacenes').modal('show');
            $('#modal_almacenes').on('shown.bs.modal', function () {
                $('#codigo').trigger('focus');
            });
        },
        ver(almacen) {
            this.errorForm = [];
            this.id_almacen = almacen.alm_id;
            document.getElementById('codigo').value = almacen.alm_codigo;
            document.getElementById('descripcion').value = almacen.alm_nombre;
            document.getElementById('telefono').value = almacen.alm_telefono;
            document.getElementById('pais').value = almacen.alm_paid;
            document.getElementById('estado').value = almacen.alm_provincia;
            document.getElementById('ciudad').value = almacen.alm_ciudad;
            document.getElementById('codigo_postal').value = almacen.alm_codpostal;
            if (almacen.alm_garantia == 1) {
                this.garantia = true;
            } else {
                this.garantia = false;
            }
            this.titulo = 'Editar almacen';
            this.accion = 'Actualizar';
            $('#modal_almacenes').modal('show');
        },
        GuardarSucursal: function () {
            this.errorForm = [];
            let form_sucursal=document.getElementById('form-sucursal-modal');
            let formData = new FormData(form_sucursal);

            if (!formData.get('sucursal'))
                this.errorForm.push('La sucursal es obligatorio.');

            if (this.id_almacen) {
                formData.append('id', this.id_almacen);
            }

            if (this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'almacenes/guardarSucursal',
                    data: formData
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            this.obtenerSucursales(this.id_almacen);
                               notificacion('fa fa-check', 'Agregado', 'Sucursal agregado correctamente', 'success');
                        }
                    } else {
                        let total_errores = response.data.errors.length;
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        editarGuardar: function () {

            this.errorForm = [];

            let form_almacenes = document.getElementById('form_modal_almacenes');
            let formData = new FormData(form_almacenes);

            if (!formData.get('codigo'))
                this.errorForm.push('El campo Código es obligatorio.');
            if (!formData.get('descripcion'))
                this.errorForm.push('El campo Descripcion es obligatorio.');
            if (!formData.get('telefono'))
                this.errorForm.push('El campo Teléfono es obligatorio.');

            if (this.id_almacen) {
                formData.append('id', this.id_almacen);
            }
            if (this.garantia == true) {
                formData.append('garantia', 1);
            } else {
                formData.append('garantia', 0);
            }

            if (this.errorForm.length == 0) {
                axios({
                    method: 'post',
                    url: 'almacenes/guardar',
                    data: formData
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            this.obtenerAlmacenes();
                            $('#modal_almacenes').modal('hide');
                            if (this.id_almacen !== '') {
                                notificacion('fa fa-edit', 'Actualizado', 'Alamcen actualizado correctamente', 'info');
                            } else {
                                notificacion('fa fa-check', 'Registrado', 'Almacen registrado correctamente', 'success');
                            }
                            this.resetearFormulario();
                        }
                    } else {
                        let total_errores = response.data.errors.length;
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());
            }
        },
        eliminarSucursal(row){
            axios.get('almacenes/eliminarSucursal/' + Number(row.alsu_id)).then(response => {
                if (response.data.errors == null) {
                    if (response.data == true) {
                        this.obtenerSucursales(row.alsu_almid);
                        notificacion('fa fa-trash', 'Sucursal eliminado', row.su_nombre.toUpperCase(), 'danger');
                    } else {
                        notificacion('fa fa-ban', 'Error al eliminar',  row.su_nombre.toUpperCase(), 'warning');
                    }
                } else {
                    let total_errores = response.data.errors.length;
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion());
        },
        eliminar(almacen) {
            Swal.fire({
                title: 'Eliminar Almacen',
                text: "¿Estás seguro de eliminar el almacen " + almacen.alm_nombre + " ?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('almacenes/eliminar/' + Number(almacen.alm_id)).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                let posicion = this.almacenes.findIndex((item) => item.id = almacen.alm_id);
                                this.almacenes.splice(posicion, 1);
                                notificacion('fa fa-trash', 'Almacen eliminado', almacen.alm_nombre.toUpperCase(), 'danger');
                            } else {
                                notificacion('fa fa-ban', 'Error al eliminar', almacen.alm_nombre.toUpperCase(), 'warning');
                            }
                        } else {
                            let total_errores = response.data.errors.length;
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion());
                }
            });
        }
    }
});