new Vue({
    el: '#appAgencias',
    data: {
        titulo: '',
        accion: '',
        agencias: [],
        dataForm: { 'id': '', 'descripcion': '', 'tarifa':0,'aplicar': 0, 'servicio': 0,'porcentaje':0 ,'pesomin':0},
        errorForm: {},
        cargando: false,
    },
    created() {
        this.obtenerAgencias();
    },
    methods: {
        ver(id, descripcion, aplicar,servicio,porcentaje,tarifa,pesomin) {
            this.dataForm.id = id;
            this.dataForm.descripcion = descripcion;
            this.dataForm.aplicar = aplicar;
            this.dataForm.servicio = servicio;
            this.dataForm.porcentaje = porcentaje;
            this.dataForm.tarifa = tarifa;
            this.dataForm.pesomin=pesomin;
            this.titulo = 'Editar agencia';
            this.accion = 'Actualizar';
            $('#modal_agencias').modal('show');
        },
        eliminar(id, nombre) {
            Swal.fire({
                title: 'Eliminar Agencia',
                text: "¿Estás seguro de eliminar la agencia " + nombre + "?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#aaa',
                cancelButtonText: 'Cancelar',
                confirmButtonText: 'Eliminar'
            }).then((result) => {
                if (result.value) {
                    axios.get('agencias/eliminar/' + Number(id)).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == true) {
                                this.obtenerAgencias();
                                notificacion('fa fa-trash', 'Agencia eliminada', nombre.toUpperCase(), 'danger');
                            } else {
                                notificacion('fa fa-ban', 'Error al eliminar agencia', nombre.toUpperCase(), 'warning');
                            }
                        } else {
                            let total_errores = response.data.errors.length;
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion());
                }
            });
        },
        modalAgencias() {
            this.resetearFormulario();
            this.titulo = 'Guardar agencia';
            this.accion = 'Guardar';
            $('#modal_agencias').modal('show');
            $('#modal_agencias').on('shown.bs.modal', function () {
                $('#descripcion').trigger('focus');
            });
        },
        obtenerAgencias() {
            axios.get('agencias/obtenerAgencias').then(response => {
                this.agencias = response.data;
            }).catch(e => notificacion());
        },
        resetearFormulario() {
            document.getElementById('modal_form_agencias').reset();
            this.dataForm.id = '';
            this.dataForm.descripcion = '';
            this.dataForm.aplicar = 0;
            this.dataForm.tarifa = 0;
            this.dataForm.servicio = 0;
            this.dataForm.porcentaje=0;
            this.dataForm.pesomin=1;
        },
        guardarEditar() {

            this.errorForm = [];

            if (!this.dataForm.descripcion)
                this.errorForm.push('El campo Descripcion es obligatorio.');
            if (!this.dataForm.tarifa)
                this.errorForm.push('El campo Tarifa es obligatorio.');

            if (this.errorForm.length == 0) {
                this.cargando = true;
                axios({
                    method: 'post',
                    url: 'agencias/guardar',
                    data: this.dataForm,
                    transformRequest: serializar(),
                }).then(response => {
                    if (response.data.errors == null) {
                        if (response.data == true) {
                            this.obtenerAgencias();
                            this.resetearFormulario();
                            $('#modal_agencias').modal('hide');
                            notificacion('fa fa-check', '', 'Operación exitosa', 'success');
                        } else {
                            notificacion('fa fa-ban', 'Error', 'Error al Registrar', 'danger');
                        }
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => this.cargando = false);
            }
        },
    },
});