axios.defaults.baseURL = 'http://localhost/concurso/';
axios.defaults.timeout = 30000;
axios.defaults.headers = {
    'X-Requested-With': 'XMLHttpRequest',
};

new Vue({
    el: '#appCurso',
    data: {
        participantes: [],
        premios: [],
        seleccionados: [],
        cargando: false
    },
    created() {
        this.obtenerParticipantes();
        this.obtenerSeleccionados();
        var self = this;
        setInterval(() => {
            self.mueveReloj();
        }, 1000);
    },
    methods: {
        obtenerParticipantes() {
            axios.get('core/participantes.php').then(response => {
                this.participantes = response.data.participantes;
                this.premios = response.data.premios;
            }).catch(e => notificacion());
        },
        obtenerSeleccionados() {
            axios.get('core/seleccionados.php').then(response => {
                this.seleccionados = response.data;
            }).catch(e => notificacion());
        },
        buscarProducto(event) {
            this.search(event.target.value, event, this);
        },
        sortear() {
            this.cargando = true;
            this.search(this);
        },
        search: _.debounce((vm) => {
            axios.get('core/sortear.php').then(response => {
                vm.seleccionados = response.data;
                vm.obtenerParticipantes();
            }).catch(e => notificacion()).finally(() => {
                vm.cargando = false;
            });
        }, 3000),
        mueveReloj() {
            momentoActual = new Date()
            hora = momentoActual.getHours()
            minuto = momentoActual.getMinutes()
            segundo = momentoActual.getSeconds()
            horaImprimible = hora + ":" + minuto + ":" + segundo
            document.getElementById('hora').innerHTML = horaImprimible
                //document.form_reloj.reloj.value = horaImprimible
        }
    }
});