<?php
require 'vendor/autoload.php';


use Core\Database;
use Core\Vista;

$options = parse_ini_file('config.ini', false);

foreach ($options as $constant => $value) {
    define($constant, $value);
}

ini_set('include_path', constant('APP_DIR'));
$id_tarea=$_GET['key'];

$newDBIni = new Database();

$empresa_data = $newDBIni->consultar('SELECT * FROM app_empresas WHERE emp_id=1')->row();

/*
$tarea = $newDBIni->consultar("SELECT tab.tab_nombre, tab.tab_color, list.tablist_nombre, tar.tar_id, tar.tar_orden, tar.tar_descripcion, DATE_FORMAT(tar.tar_creado, '%d-%m-%Y') as creado, DATE_FORMAT(tar.tar_fecha_vencimiento, '%d-%m-%Y') as vencimiento, cli_razon_social, cli_dni 
            FROM app_tableros tab 
            JOIN app_tableros_listas list ON list.tablist_tabid =  tab.tab_id 
            JOIN app_tableros_listas_tareas tar ON tar.tar_listid = list.tablist_id 
            LEFT JOIN app_clientes c ON c.cli_id = tar.tar_cliente
            WHERE tar.tar_id = $id_tarea")->row();
=======*/
$tarea = $newDBIni->consultar("SELECT tab.tab_nombre, tab.tab_color, lis.tablist_nombre, tar.tar_id, tar.tar_orden, tar.tar_descripcion, DATE_FORMAT(tar.tar_creado, '%d-%m-%Y') as creado, DATE_FORMAT(tar.tar_fecha_vencimiento, '%d-%m-%Y') as vencimiento, cli_razon_social, cli_dni 
            FROM app_tableros tab 
            LEFT JOIN app_tableros_listas lis ON lis.tablist_tabid =  tab.tab_id 
            LEFT JOIN app_tableros_listas_tareas tar ON tar.tar_listid = lis.tablist_id 
            LEFT JOIN app_clientes c ON c.cli_id = tar.tar_cliente 
            WHERE md5(tar.tar_id) = '$id_tarea'")->row();


if ($tarea) {

    $list_checklist = [];

    $checklist = $newDBIni->consultar("SELECT checklist_id, checklist_nombre,	checklist_orden, checklist_empid, DATE_FORMAT(checklist_creado, '%d-%m-%Y') creado, DATE_FORMAT(checklist_actualizado, '%d-%m-%Y') actualizado 
                FROM app_tableros_listas_tareas_checklist
                WHERE checklist_tarid = {$tarea['tar_id']} 
                ORDER BY checklist_orden")->all();

    if (is_countable($checklist) && count($checklist)) {

        foreach ($checklist as $row) {

            $items = $newDBIni->consultar("SELECT item_descripcion, item_estatus, DATE_FORMAT(item_creado, '%d-%m-%Y') as creado, DATE_FORMAT(item_actualizado, '%d-%m-%Y') as actualizado 
                        FROM app_tableros_listas_tareas_checklist_items 
                        WHERE item_checklistid = {$row['checklist_id']}
                        ORDER BY item_orden")->all();

            $item_mas = [];

            if (is_countable($items) && count($items)) {
                foreach ($items as $item) {
                    $item_mas[] = [
                        'descripcion' => $item['item_descripcion'],
                        'estatus' => $item['item_estatus'] ? true : false,
                        'creado' => $item['creado'],
                        'actualizado' => $item['actualizado']
                    ];
                }
            }

            $list_checklist[] = [
                'checklist_nombre' => $row['checklist_nombre'],
                'checklist_orden' => $row['checklist_orden'],
                'checklist_creado' => $row['creado'],
                'checklist_actualizado' => $row['actualizado'],
                'items' => $item_mas
            ];
        }
    }

    $mpdf = new \Mpdf\Mpdf([
        'mode'              => 'utf-8',
        'margin_left'       => 15,
        'margin_right'      => 15,
        'margin_top'        => 35,
        'margin_bottom'     => 15,
        'margin_header'     => 15,
        'margin_footer'     => 15,
        'format'            => 'A4',
        'orientation'       => 'P',
        'default_font_size' => 8,
        'default_font'      => 'helvetica'
    ]);

    $mpdf->SetTitle('Incidencias');
    $mpdf->SetAuthor($empresa_data['emp_nombre']);
    $mpdf->SetCreator($empresa_data['emp_nombre']);
    $mpdf->SetSubject('Incidencias');

    $html_header = Vista::viewPDF('servicios/header_pdf.php', [
        'emp_nombre'    => $empresa_data['emp_nombre'] ?? '',
        'emp_rif'       => $empresa_data['emp_rif'] ?? '',
        'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
        'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
        'emp_codpostal' => $empresa_data['emp_codpostal'] ?? '',
        'emp_estado'    => $empresa_data['emp_estado'] ?? '',
        'emp_ciudad'    => $empresa_data['emp_ciudad'] ?? '',
    ]);

    $mpdf->SetHTMLHeader($html_header);

    $html_footer = Vista::viewPDF('servicios/footer_pdf.php');

    $mpdf->SetHTMLFooter($html_footer);

    $html_body = Vista::viewPDF('servicios/body_pdf.php', [
        'tarea' => $tarea,
        'checklist' => $list_checklist
    ]);

    $mpdf->WriteHTML($html_body);

    $mpdf->Output("Inidencias.pdf", \Mpdf\Output\Destination::INLINE);
    exit;
}
