<?php
use Core\Database;

session_start();

$options = parse_ini_file('config.ini', false);

foreach ($options as $constant => $value) {
    define($constant, $value);
}

ini_set('include_path', constant('APP_DIR'));

//ini_set('session.gc_maxlifetime', SESSION_LIFE_TIME);
//ini_set('session.cookie_lifetime', SESSION_LIFE_TIME);

switch (constant('ENTORNO')) {
    case 'desarrollo':
        ini_set('display_errors', '1');
        error_reporting(E_ALL);
        break;
    case 'produccion':
        ini_set('display_errors', '0');
        error_reporting(E_ALL & ~E_NOTICE & ~E_DEPRECATED & ~E_STRICT & ~E_USER_NOTICE & ~E_USER_DEPRECATED);
        break;
    default:
        ini_set('display_errors', '0');
        break;
}

date_default_timezone_set("America/Caracas");

require 'core/Helpers/funciones.php';
require 'vendor/autoload.php';

$newDBIni = new Database();

$wc_config = $newDBIni->consultar("SELECT * FROM app_wc")->row();
$conf_emp_ = $newDBIni->consultar("SELECT * FROM app_empresas")->row();

if ($wc_config) {
    define('WCURL', $wc_config['wc_url']);
    define('WCKEY', $wc_config['wc_key']);
    define('WCSECRECT', $wc_config['wc_secret']);
    define('WCIMG', $wc_config['wc_url_img']);
    define('WCDESCRIPTION', $wc_config['wc_pro']);
}

if ($conf_emp_) {
    define('EMP_CANTIDAD', $conf_emp_['emp_cantidad']);
    define('EMP_NOMBRE', $conf_emp_['emp_nombre']);
    define('EMP_NOMBRE_CORTO', $conf_emp_['emp_nombrecorto']);
    define('EMP_DIRECCION', $conf_emp_['emp_direccion']);
    define('EMP_TELEFONO', $conf_emp_['emp_telefono_1']);
    define('EMP_ESTADO', $conf_emp_['emp_estado']);
    define('EMP_RIF', $conf_emp_['emp_rif']);
    define('EMP_CORREO', $conf_emp_['emp_email']);
    define('EMP_CORREO_PASSWORD', $conf_emp_['emp_email_password']);
    define('EMP_CORREO_HOST', $conf_emp_['emp_host_correo']);
    define('EMP_CORREO_PORT', $conf_emp_['emp_port_correo']);
    define('EMP_FIGURA_AGENTE', $conf_emp_['emp_figura_agente'] == 1 ? true : false);
}

Core\FrontController::inicio();
