<?php

require 'vendor/autoload.php';
//require 'core/Helpers/funciones.php';

use App\Controladores\SmsControlador;
use App\Modelos\BitacoraMensajesModel;
use App\Modelos\PlanillaPreOrden;
use App\Modelos\Ingresosegresos;
use App\Modelos\SmsContactosModel;
use App\Modelos\TablerosListas;
use Core\Database;
use Core\Helpers\Moneda;
use Core\Librerias\Http;
use Core\Librerias\SMS;


function extraer_numero_de_cadena(string $cadena): int
{
    return intval(preg_replace('/[^0-9]+/', '', $cadena), 10);
}

$options = parse_ini_file('config.ini', false);

foreach ($options as $constant => $value) {
    define($constant, $value);
}

ini_set('include_path', constant('APP_DIR'));

$newDBIni = new Database();

$newSMS = new SMS(constant('SMS_USER'), constant('SMS_PASSWORD'));

if ($newSMS->obtenerEstatus() != 'Activa')
    Http::json_response(['errors' => ['Lo siento el estatus de su Mensajeria se encuentra Inactiva']]);

if ($newSMS->obtenerCreditos() <= 0)
    Http::json_response(['errors' => ['Lo siento no posee creditos suficientes verifique su proveedor de Mensajeria']]);

$newSMSContact  = new SmsContactosModel();
$newBitacora    = new BitacoraMensajesModel();
$newListas = new TablerosListas();

$mensajes = $newSMSContact->obtenerMensajesContacosTodos(1);


$n = 0;

if (is_countable($mensajes) && count($mensajes)) {

    foreach ($mensajes as $row) {

        if ($n < 10) {

            if ($row['msj_modulo'] == 1) {

                if (!is_null($row['fecha_hasta'])) {
                    $fecha_hasta    = new DateTime($row['fecha_hasta']);
                    //$ultimo_envio   = new DateTime($row['ultimo_envio']);
                    $fecha   = new DateTime(date('Y-m-d'));
                    //$ultimo_envio->add(new DateInterval("P{$row['intervalo']}D"));

                    $numBitacora = $newBitacora->obtenerNumBitacoramensaje($row['idcliente'], $row['msj_id']);

                    $tele = str_replace('(', '', $row['cto_tlf']);
                    $tele = str_replace(')', '', $tele);
                    $tele = str_replace(' ', '', $tele);
                    $tele = str_replace('-', '', $tele);
                    $msj = str_replace(' ', '+', $row['msj_cuerpo']);
                    $msj = str_replace('-', '/', $msj);
                    $msj = str_replace('_', '.', $msj);
                    $msj = str_replace('$', 'USD', $msj);

                    if (($fecha_hasta >= $fecha) && ($row['intervalo'] > $numBitacora)) {

                        // http::json_response($msj);
                        $estatus = $newSMS->enviarMensaje($tele, $msj);

                        switch ($estatus) {
                            case "200 / 1":
                                $estatus_condicion = 'Enviado';
                                $newSMSContact->editar($row['id'], ['sc_ultimo_envio' => date('Y-m-d')]);
                                break;
                            case '200 / 0':
                                $estatus_condicion = 'Error al enviar';
                                Http::json_response(['errors' => [$estatus_condicion]]);
                                break;
                            case '401':
                                $estatus_condicion = 'Autenticación Inválida';
                                Http::json_response(['errors' => [$estatus_condicion . $estatus]]);
                                break;
                            case '402':
                                $estatus_condicion = 'Créditos Insuficientes';
                                Http::json_response(['errors' => [$estatus_condicion]]);
                                break;
                            case '403':
                                $estatus_condicion = 'Cuenta Inactiva';
                                Http::json_response(['errors' => [$estatus_condicion]]);
                                break;
                            case '405':
                                $estatus_condicion = 'Falta Destinatario';
                                Http::json_response(['errors' => [$estatus_condicion]]);
                                break;
                            case '501':
                                $estatus_condicion = 'Tipo de Cuenta Inválida';
                                Http::json_response(['errors' => [$estatus_condicion]]);
                                break;
                            case '502':
                                $estatus_condicion = 'Petición Sobrecargada';
                                Http::json_response(['errors' => [$estatus_condicion]]);
                                break;
                            default:
                                $estatus_condicion = $estatus;
                        }


                        $newBitacora->guardar([
                            'bitmen_cliente' => $row['idcliente'],
                            'bitmen_contacto' => $row['cto_nombre'],
                            'bitmen_telefono' => $row['cto_tlf'],
                            'bitmen_correo' => $row['cto_email'],
                            'bitmen_idmsj'  => $row['msj_id'],
                            'bitmen_titulo' => $row['msj_titulo'],
                            'bitmen_cuerpo' => $msj,
                            'bitmen_estatus' => $estatus_condicion,
                            'bitmen_tipo' => 'SMS'
                        ], true);

                        $n += 1;
                    }
                }
            }

            if ($row['msj_modulo'] == 2) {

                if (!is_null($row['fecha_hasta'])) {
                    $fecha_hasta    = new DateTime($row['fecha_hasta']);
                    //$ultimo_envio   = new DateTime($row['ultimo_envio']);
                    $fecha   = new DateTime(date('Y-m-d'));
                    //$ultimo_envio->add(new DateInterval("P{$row['intervalo']}D"));

                    $numBitacora = $newBitacora->obtenerNumBitacoramensaje($row['idcliente'], $row['msj_id']);

                    $tele = str_replace('(', '', $row['cto_tlf']);
                    $tele = str_replace(')', '', $tele);
                    $tele = str_replace(' ', '', $tele);
                    $tele = str_replace('-', '', $tele);
                    $msj = str_replace(' ', '+', $row['msj_cuerpo']);
                    $msj = str_replace('-', '/', $msj);
                    $msj = str_replace('_', '.', $msj);


                    $servicios_msj = '/';
                    $estatus_msj = '/';
                    $servicioss = $newListas->consultar("SELECT * FROM app_tableros_listas_tareas tr 
                                LEFT JOIN app_tableros_listas lt ON tr.tar_listid=lt.tablist_id 
                                WHERE lt.tablist_tabid=13 AND tr.tar_cliente ={$row['ccon_cliid']}")->all();

                    if (is_countable($servicioss) && count($servicioss)) {
                        foreach ($servicioss as $row1) {
                            $servicios_msj = $servicios_msj . 'SERV:' . $row1['tar_descripcion'] . '/';
                            $estatus_msj = $servicios_msj . $row1['tablist_nombre'] . '/';
                        }
                    }

                    $msj = str_replace('$servicio', $servicios_msj, $msj);
                    $msj = str_replace(' ', '+', $msj);
                    $msj = str_replace('-', '/', $msj);
                    $msj = str_replace('$estatus_nuevo', $estatus_msj, $msj);
                    $msj = str_replace('$', 'USD', $msj);

                    if (($fecha_hasta >= $fecha) && ($row['intervalo'] > $numBitacora)) {

                        $estatus = $newSMS->enviarMensaje($tele, $msj);

                        switch ($estatus) {
                            case "200 / 1":
                                $estatus_condicion = 'Enviado';
                                $newSMSContact->editar($row['id'], ['sc_ultimo_envio' => date('Y-m-d')]);
                                break;
                            case '200 / 0':
                                $estatus_condicion = 'Error al enviar';
                                Http::json_response(['errors' => [$estatus_condicion]]);
                                break;
                            case '401':
                                $estatus_condicion = 'Autenticación Inválida';
                                Http::json_response(['errors' => [$estatus_condicion . $estatus]]);
                                break;
                            case '402':
                                $estatus_condicion = 'Créditos Insuficientes';
                                Http::json_response(['errors' => [$estatus_condicion]]);
                                break;
                            case '403':
                                $estatus_condicion = 'Cuenta Inactiva';
                                Http::json_response(['errors' => [$estatus_condicion]]);
                                break;
                            case '405':
                                $estatus_condicion = 'Falta Destinatario';
                                Http::json_response(['errors' => [$estatus_condicion]]);
                                break;
                            case '501':
                                $estatus_condicion = 'Tipo de Cuenta Inválida';
                                Http::json_response(['errors' => [$estatus_condicion]]);
                                break;
                            case '502':
                                $estatus_condicion = 'Petición Sobrecargada';
                                Http::json_response(['errors' => [$estatus_condicion]]);
                                break;
                            default:
                                $estatus_condicion = $estatus;
                        }

                        $newBitacora->guardar([
                            'bitmen_cliente' => $row['idcliente'],
                            'bitmen_contacto' => $row['cto_nombre'],
                            'bitmen_telefono' => $row['cto_tlf'],
                            'bitmen_correo' => $row['cto_email'],
                            'bitmen_idmsj'  => $row['msj_id'],
                            'bitmen_titulo' => $row['msj_titulo'],
                            'bitmen_cuerpo' => $msj,
                            'bitmen_estatus' => $estatus_condicion,
                            'bitmen_tipo' => 'SMS'
                        ], true);

                        $n += 1;
                    }
                }
            }

            if ($row['msj_modulo'] == 3) {
                if (!is_null($row['fecha_hasta'])) {
                    $fecha_hasta    = new DateTime($row['fecha_hasta']);
                    //$ultimo_envio   = new DateTime($row['ultimo_envio']);
                    $fecha   = new DateTime(date('Y-m-d'));
                    //$ultimo_envio->add(new DateInterval("P{$row['intervalo']}D"));

                    $numBitacora = $newBitacora->obtenerNumBitacoramensaje($row['idcliente'], $row['msj_id']);


                    $tele = str_replace('(', '', $row['cto_tlf']);
                    $tele = str_replace(')', '', $tele);
                    $tele = str_replace(' ', '', $tele);
                    $tele = str_replace('-', '', $tele);
                    $msj = str_replace(' ', '+', $row['msj_cuerpo']);
                    $msj = str_replace('-', '/', $msj);
                    $msj = str_replace('_', '.', $msj);

                    $factura_msj = '/';
                    $factura_conteo = 0;
                    $factura_monto = 0;
                    $nota_msj = '/';
                    $orden_msj = '/';
                    $acumulado_t = 0;
                    $pendiente = 0;

                    $facturas = $newListas->consultar("SELECT * FROM app_factura_master fm WHERE (fm.fm_estatus=0 OR fm.fm_estatus=2) AND fm.fm_cliid={$row['ccon_cliid']}")->all();
                    $notas = $newListas->consultar("SELECT * FROM app_notas_de_entrega ne WHERE (ne.ne_estatus=0 OR ne.ne_estatus=2) AND ne.ne_cliid={$row['ccon_cliid']}")->all();
                    $orden = $newListas->consultar("SELECT * FROM app_orden_de_entrega n WHERE (n.n_estatus=0 OR n.n_estatus=2) AND n.n_cliid={$row['ccon_cliid']}")->all();

                    $div_master = Moneda::Predeterminada();
                    $newingreso = new Ingresosegresos();

                    if (($fecha_hasta >= $fecha) && ($row['intervalo'] > $numBitacora)) {

                        if (is_countable($facturas) && count($facturas)) {

                            foreach ($facturas as $row1) {
                                $acumulado = $newingreso->obtenerAcumulado($row1['fm_id'], 2);

                                $factura_msj .= '+FACV' . $row1['fm_correlativo'] . '/';
                                $factura_conteo += 1;
                                $factor = 1;

                                $newPreOrden = new PlanillaPreOrden();
                                if ($div_master['id'] != $row1['fm_divid']) {
                                    $factor_div = $newPreOrden->obtenerDivisaAlCambio($row1['fm_divid'], $div_master['id']);
                                    $factor = $factor_div['df_factor'];
                                    $row1['fm_total'] = $row1['fm_total'] * $factor;
                                    $acumulado['total'] = round($acumulado['total'] * $factor_div['df_factor'], 2);
                                }
                                $acumulado_total = ($acumulado['total']) ?? 0;

                                $acumulado_t += $acumulado_total;
                                $pendiente += $row1['fm_total'] - $acumulado_total;

                                //$factura_monto += $row1['fm_total'] * $factor;
                                $factura_monto += round($pendiente, 2);
                            }
                        }

                        if (is_countable($notas) && count($notas)) {

                            foreach ($notas as $row1) {
                                $acumulado = $newingreso->obtenerAcumulado($row1['ne_id'], 1);

                                $nota_msj .= '+NEV' . $row1['ne_correlativo'] . '/';
                                $factura_conteo += 1;
                                $factor = 1;

                                $newPreOrden = new PlanillaPreOrden();
                                if ($div_master['id'] != $row1['ne_divid']) {
                                    $factor_div = $newPreOrden->obtenerDivisaAlCambio($row1['ne_divid'], $div_master['id']);
                                    $factor = $factor_div['df_factor'];
                                    $row1['ne_total'] = $row1['ne_total'] * $factor;
                                    $acumulado['total'] = round($acumulado['total'] * $factor_div['df_factor'], 2);
                                }
                                $acumulado_total = ($acumulado['total']) ?? 0;

                                $acumulado_t += $acumulado_total;
                                $pendiente += $row1['ne_total'] - $acumulado_total;

                               // $factura_monto += $row1['ne_total'] * $factor;
                                $factura_monto += round($pendiente, 2);
                            }
                        }

                        if (is_countable($orden) && count($orden)) {

                            foreach ($orden as $row1) {
                                $acumulado = $newingreso->obtenerAcumulado($row1['n_id'], 12);

                                $orden_msj .= '+ORDENV' . $row1['n_correlativo'] . '/';
                                $factura_conteo += 1;
                                $factor = 1;

                                $newPreOrden = new PlanillaPreOrden();
                                if ($div_master['id'] != $row1['n_divid']) {
                                    $factor_div = $newPreOrden->obtenerDivisaAlCambio($row1['n_divid'], $div_master['id']);
                                    $factor = $factor_div['df_factor'];
                                    $row1['n_total'] = $row1['n_total'] * $factor;
                                    $acumulado['total'] = round($acumulado['total'] * $factor_div['df_factor'], 2);
                                }
                                $acumulado_total = ($acumulado['total']) ?? 0;

                                $acumulado_t += $acumulado_total;
                                $pendiente += $row1['n_total'] - $acumulado_total;

                                //$factura_monto += $row1['n_total'] * $factor;
                                 $factura_monto += round($pendiente, 2);
                            }
                        }

                        if ($factura_monto > 0) {
                            $combinacion = $factura_msj . $nota_msj . $orden_msj;
                            $mont = Moneda::moneda($factura_monto, $div_master['locale'], $div_master['symbol'], $div_master['precision']);
                            $msj = str_replace('$documentos', $combinacion, $msj);
                            $msj = str_replace('$monto', $mont, $msj);
                            $msj = str_replace('$total_documentos', $mont, $msj);
                            $msj = str_replace('$', 'USD', $msj);

                            $estatus = $newSMS->enviarMensaje($tele, $msj);

                            switch ($estatus) {
                                case "200 / 1":
                                    $estatus_condicion = 'Enviado';
                                    $newSMSContact->editar($row['id'], ['sc_ultimo_envio' => date('Y-m-d')]);
                                    break;
                                case '200 / 0':
                                    $estatus_condicion = 'Error al enviar';
                                    Http::json_response(['errors' => [$estatus_condicion]]);
                                    break;
                                case '401':
                                    $estatus_condicion = 'Autenticación Inválida';
                                    Http::json_response(['errors' => [$estatus_condicion . $estatus]]);
                                    break;
                                case '402':
                                    $estatus_condicion = 'Créditos Insuficientes';
                                    Http::json_response(['errors' => [$estatus_condicion]]);
                                    break;
                                case '403':
                                    $estatus_condicion = 'Cuenta Inactiva';
                                    Http::json_response(['errors' => [$estatus_condicion]]);
                                    break;
                                case '405':
                                    $estatus_condicion = 'Falta Destinatario';
                                    Http::json_response(['errors' => [$estatus_condicion]]);
                                    break;
                                case '501':
                                    $estatus_condicion = 'Tipo de Cuenta Inválida';
                                    Http::json_response(['errors' => [$estatus_condicion]]);
                                    break;
                                case '502':
                                    $estatus_condicion = 'Petición Sobrecargada';
                                    Http::json_response(['errors' => [$estatus_condicion]]);
                                    break;
                                default:
                                    $estatus_condicion = $estatus;
                            }

                            $newBitacora->guardar([
                                'bitmen_cliente' => $row['idcliente'],
                                'bitmen_contacto' => $row['cto_nombre'],
                                'bitmen_telefono' => $row['cto_tlf'],
                                'bitmen_correo' => $row['cto_email'],
                                'bitmen_idmsj'  => $row['msj_id'],
                                'bitmen_titulo' => $row['msj_titulo'],
                                'bitmen_cuerpo' => $msj,
                                'bitmen_estatus' => $estatus_condicion,
                                'bitmen_tipo' => 'SMS'
                            ], true);

                            $n += 1;
                        }
                    }
                }
            }
        }
    }
}
