<?php

require 'vendor/autoload.php';

use App\Controladores\SmsControlador;
use App\Modelos\BitacoraMensajesModel;
use App\Modelos\Ingresosegresos;
use App\Modelos\PlanillaPreOrden;
use App\Modelos\SmsContactosModel;
use App\Modelos\TablerosListas;
use Core\Database;
use Core\Helpers\Moneda;
use Core\Librerias\Http;
use PHPMailer\PHPMailer\PHPMailer;

$options = parse_ini_file('config.ini', false);

foreach ($options as $constant => $value) {
    define($constant, $value);
}

ini_set('include_path', constant('APP_DIR'));

$newDBIni = new Database();
$conf_emp_ = $newDBIni->consultar("SELECT * FROM app_empresas")->row();

if ($conf_emp_) {
    define('EMP_CANTIDAD', $conf_emp_['emp_cantidad']);
    define('EMP_NOMBRE', $conf_emp_['emp_nombre']);
    define('EMP_NOMBRE_CORTO', $conf_emp_['emp_nombrecorto']);
    define('EMP_DIRECCION', $conf_emp_['emp_direccion']);
    define('EMP_TELEFONO', $conf_emp_['emp_telefono_1']);
    define('EMP_ESTADO', $conf_emp_['emp_estado']);
    define('EMP_RIF', $conf_emp_['emp_rif']);
    define('EMP_CORREO', $conf_emp_['emp_email']);
    define('EMP_CORREO_PASSWORD', $conf_emp_['emp_email_password']);
    define('EMP_CORREO_HOST', $conf_emp_['emp_host_correo']);
    define('EMP_CORREO_PORT', $conf_emp_['emp_port_correo']);
    define('EMP_FIGURA_AGENTE', $conf_emp_['emp_figura_agente'] == 1 ? true : false);
}

if (
    !trim(constant('EMP_CORREO')) ||
    !trim(constant('EMP_CORREO_PASSWORD')) ||
    !trim(constant('EMP_CORREO_HOST')) ||
    !trim(constant('EMP_CORREO_PORT'))
)
    Http::json_response(['errors' => ['Debe configurar todos los parametros para poder enviar correos']]);

$mail           = new PHPMailer(true);
$newSMSContact  = new SmsContactosModel();
$newBitacora    = new BitacoraMensajesModel();
$newListas = new TablerosListas();

$div_master = Moneda::Predeterminada();
$mensajes       = $newSMSContact->obtenerMensajesContacosTodos(2);
$error = '';

$n = 0;

if (is_countable($mensajes) && count($mensajes)) {

    foreach ($mensajes as $row) {

        if ($n < 10) {

            if ($row['msj_modulo'] == 1) {

                if (!is_null($row['fecha_hasta'])) {
                    $fecha_hasta    = new DateTime($row['fecha_hasta']);
                    //$ultimo_envio   = new DateTime($row['ultimo_envio']);
                    $fecha   = new DateTime(date('Y-m-d'));
                    //$ultimo_envio->add(new DateInterval("P{$row['intervalo']}D"));

                    $numBitacora = $newBitacora->obtenerNumBitacoramensaje($row['idcliente'], $row['msj_id']);

                    if (($fecha_hasta >= $fecha) && ($row['intervalo'] > $numBitacora)) {

                        try {
                            $mail->isSMTP();
                            $mail->Host       = constant('EMP_CORREO_HOST');
                            $mail->SMTPAuth   = true;
                            $mail->Username   = constant('EMP_CORREO');
                            $mail->Password   = constant('EMP_CORREO_PASSWORD');
                            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
                            $mail->Port       = constant('EMP_CORREO_PORT');

                            $mail->setFrom($mail->Username);
                            $mail->addAddress($row['cto_email']);
                            $mail->addReplyTo($mail->Username, constant('EMP_NOMBRE'));
                            $mail->isHTML(true);

                            $mail->Subject = utf8_decode($row['msj_titulo']);
                            $mail->Body    = html_entity_decode($row['msj_cuerpo']);

                            $mail->send();
                        } catch (Exception $e) {
                            $error = "No se pudo enviar el mensaje. Error de envío: {$mail->ErrorInfo}.";
                        }

                        $data_envio = [
                            'bitmen_cliente'    => $row['idcliente'],
                            'bitmen_contacto'   => $row['cto_nombre'],
                            'bitmen_telefono'   => $row['cto_tlf'],
                            'bitmen_correo'     => $row['cto_email'],
                            'bitmen_idmsj'      => $row['msj_id'],
                            'bitmen_titulo'     => $row['msj_titulo'],
                            'bitmen_cuerpo'     => $row['msj_cuerpo'],
                            'bitmen_tipo'       => 'EMAIL'
                        ];

                        if ($error == '') {
                            $data_envio['bitmen_estatus'] = 'Enviado';
                            $newSMSContact->editar($row['id'], ['sc_ultimo_envio' => date('Y-m-d')]);
                        } else {
                            $data_envio['bitmen_estatus'] = $error;
                        }

                        $newBitacora->guardar($data_envio, true);

                        $n += 1;
                    }
                }
            }

            if ($row['msj_modulo'] == 2) {

                if (!is_null($row['fecha_hasta'])) {
                    $fecha_hasta    = new DateTime($row['fecha_hasta']);
                    //$ultimo_envio   = new DateTime($row['ultimo_envio']);
                    $fecha   = new DateTime(date('Y-m-d'));
                    //$ultimo_envio->add(new DateInterval("P{$row['intervalo']}D"));

                    $numBitacora = $newBitacora->obtenerNumBitacoramensaje($row['idcliente'], $row['msj_id']);

                    if (($row['intervalo'] > $numBitacora)) {

                        $msj = $row['msj_cuerpo'];
                        $servicios_msj = '/';
                        $estatus_msj = '/';

                        $servicioss = $newListas->consultar("SELECT * FROM app_tableros_listas_tareas tr 
                        LEFT JOIN app_tableros_listas lt ON tr.tar_listid=lt.tablist_id 
                        WHERE lt.tablist_tabid=13 AND tr.tar_cliente ={$row['ccon_cliid']}")->all();

                        if (is_countable($servicioss) && count($servicioss)) {
                            foreach ($servicioss as $row1) {
                                $servicios_msj += 'SERV:' . $row1['tar_descripcion'] . '/';
                                $estatus_msj += $row1['tablist_nombre'] . '/';
                            }
                        }

                        $msj = str_replace('$servicio', $servicios_msj, $msj);
                        $msj = str_replace('$estatus_nuevo', $estatus_msj, $msj);

                        try {
                            $mail->isSMTP();
                            $mail->Host       = constant('EMP_CORREO_HOST');
                            $mail->SMTPAuth   = true;
                            $mail->Username   = constant('EMP_CORREO');
                            $mail->Password   = constant('EMP_CORREO_PASSWORD');
                            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
                            $mail->Port       = constant('EMP_CORREO_PORT');

                            $mail->setFrom($mail->Username);
                            $mail->addAddress($row['cto_email']);
                            $mail->addReplyTo($mail->Username, constant('EMP_NOMBRE'));
                            $mail->isHTML(true);

                            $mail->Subject = utf8_decode($row['msj_titulo']);
                            $mail->Body    = html_entity_decode($msj);

                            $mail->send();
                        } catch (Exception $e) {
                            $error = "No se pudo enviar el mensaje. Error de envío: {$mail->ErrorInfo}.";
                        }

                        $data_envio = [
                            'bitmen_cliente'    => $row['idcliente'],
                            'bitmen_contacto'   => $row['cto_nombre'],
                            'bitmen_telefono'   => $row['cto_tlf'],
                            'bitmen_correo'     => $row['cto_email'],
                            'bitmen_idmsj'      => $row['msj_id'],
                            'bitmen_titulo'     => $row['msj_titulo'],
                            'bitmen_cuerpo'     => $msj,
                            'bitmen_tipo'       => 'EMAIL'
                        ];

                        if ($error == '') {
                            $data_envio['bitmen_estatus'] = 'Enviado';
                            $newSMSContact->editar($row['id'], ['sc_ultimo_envio' => date('Y-m-d')]);
                        } else {
                            $data_envio['bitmen_estatus'] = $error;
                        }

                        $newBitacora->guardar($data_envio, true);
                        $n += 1;
                    }
                }
            }

            if ($row['msj_modulo'] == 3) {

                if (!is_null($row['fecha_hasta'])) {
                    $fecha_hasta    = new DateTime($row['fecha_hasta']);
                    //$ultimo_envio   = new DateTime($row['ultimo_envio']);
                    $fecha   = new DateTime(date('Y-m-d'));
                    //$ultimo_envio->add(new DateInterval("P{$row['intervalo']}D"));

                    $numBitacora = $newBitacora->obtenerNumBitacoramensaje($row['idcliente'], $row['msj_id']);

                    if (($fecha_hasta >= $fecha) && ($row['intervalo'] > $numBitacora)) {

                        $msj = $row['msj_cuerpo'];
                        $factura_msj = '';
                        $nota_msj = '';
                        $orden_msj = '';
                        $factura_conteo = 0;
                        $factura_monto = 0;
                        $acumulado_t = 0;
                        $pendiente = 0;
                        
                        $newingreso = new Ingresosegresos();

                        $facturas = $newListas->consultar("SELECT * FROM app_factura_master fm WHERE (fm.fm_estatus=0 OR fm.fm_estatus=2) AND fm.fm_cliid={$row['ccon_cliid']}")->all();
                        $notas = $newListas->consultar("SELECT * FROM app_notas_de_entrega ne WHERE (ne.ne_estatus=0 OR ne.ne_estatus=2) AND ne.ne_cliid={$row['ccon_cliid']}")->all();
                        $orden = $newListas->consultar("SELECT * FROM app_orden_de_entrega n WHERE (n.n_estatus=0 OR n.n_estatus=2) AND n.n_cliid={$row['ccon_cliid']}")->all();

                        if (is_countable($facturas) && count($facturas)) {

                            foreach ($facturas as $row1) {
                                $acumulado = $newingreso->obtenerAcumulado($row1['fm_id'], 2);

                                $factura_msj .= ' FACV' . $row1['fm_correlativo'] . '/ ';
                                $factor = 1;
                                $factura_conteo += 1;
                                
                                $newPreOrden = new PlanillaPreOrden();
                                if ($div_master['id'] != $row1['fm_divid']) {
                                    $factor_div = $newPreOrden->obtenerDivisaAlCambio($row1['fm_divid'], $div_master['id']);
                                    $factor = $factor_div['df_factor'];
                                    $row1['fm_total'] = $row1['fm_total'] * $factor;
                                    $acumulado['total'] = round($acumulado['total'] * $factor_div['df_factor'], 2);
                                }
                                $acumulado_total = ($acumulado['total']) ?? 0;

                                $acumulado_t += $acumulado_total;
                                $pendiente += $row1['fm_total'] - $acumulado_total;
                                //$factura_monto += $row1['fm_total'] * $factor;
                                $factura_monto += round($pendiente, 2);
                            }
                        }

                        if (is_countable($notas) && count($notas)) {

                            foreach ($notas as $row1) {
                                $acumulado = $newingreso->obtenerAcumulado($row1['ne_id'], 1);

                                $nota_msj .= ' NEV' . $row1['ne_correlativo'] . '/ ';
                                $factor = 1;
                                $factura_conteo += 1;
                                $newPreOrden = new PlanillaPreOrden();
                                if ($div_master['id'] != $row1['ne_divid']) {
                                    $factor_div = $newPreOrden->obtenerDivisaAlCambio($row1['ne_divid'], $div_master['id']);
                                    $factor = $factor_div['df_factor'];
                                    $row1['ne_total'] = $row1['ne_total'] * $factor;
                                    $acumulado['total'] = round($acumulado['total'] * $factor_div['df_factor'], 2);
                                }
                                $acumulado_total = ($acumulado['total']) ?? 0;

                                $acumulado_t += $acumulado_total;
                                $pendiente += $row1['ne_total'] - $acumulado_total;

                                //$factura_monto += $row1['ne_total'] * $factor;
                                 $factura_monto += round($pendiente, 2);
                            }
                        }

                        if (is_countable($orden) && count($orden)) {

                            foreach ($orden as $row1) {
                                $acumulado = $newingreso->obtenerAcumulado($row1['n_id'], 12);

                                $orden_msj .= ' ORDENV' . $row1['n_correlativo'] . '/ ';

                                $factor = 1;
                                $factura_conteo += 1;
                                $newPreOrden = new PlanillaPreOrden();
                                if ($div_master['id'] != $row1['n_divid']) {
                                    $factor_div = $newPreOrden->obtenerDivisaAlCambio($row1['n_divid'], $div_master['id']);
                                    $factor = $factor_div['df_factor'];
                                    $row1['n_total'] = $row1['n_total'] * $factor;
                                    $acumulado['total'] = round($acumulado['total'] * $factor_div['df_factor'], 2);
                                }
                                $acumulado_total = ($acumulado['total']) ?? 0;

                                $acumulado_t += $acumulado_total;
                                $pendiente += $row1['n_total'] - $acumulado_total;

                                //$factura_monto += $row1['n_total'] * $factor;
                                 $factura_monto += round($pendiente, 2);
                            }
                        }

                        if ($factura_monto > 0) {
                            $combinacion = $factura_msj . $nota_msj . $orden_msj;
                            $mont = Moneda::moneda($factura_monto, $div_master['locale'], $div_master['symbol'], $div_master['precision']);
                            $msj = str_replace('$documentos', $combinacion, $msj);
                            $msj = str_replace('$monto', $mont, $msj);
                            $msj = str_replace('$total_documentos', $factura_conteo, $msj);

                            try {
                                $mail->isSMTP();
                                $mail->Host       = constant('EMP_CORREO_HOST');
                                $mail->SMTPAuth   = true;
                                $mail->Username   = constant('EMP_CORREO');
                                $mail->Password   = constant('EMP_CORREO_PASSWORD');
                                $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
                                $mail->Port       = constant('EMP_CORREO_PORT');

                                $mail->setFrom($mail->Username);
                                $mail->addAddress($row['cto_email']);
                                $mail->addReplyTo($mail->Username, constant('EMP_NOMBRE'));
                                $mail->isHTML(true);

                                $mail->Subject = utf8_decode($row['msj_titulo']);
                                $mail->Body    = html_entity_decode($msj);

                                $mail->send();
                            } catch (Exception $e) {
                                $error = "No se pudo enviar el mensaje. Error de envío: {$mail->ErrorInfo}.";
                            }

                            $data_envio = [
                                'bitmen_cliente'    => $row['idcliente'],
                                'bitmen_contacto'   => $row['cto_nombre'],
                                'bitmen_telefono'   => $row['cto_tlf'],
                                'bitmen_correo'     => $row['cto_email'],
                                'bitmen_idmsj'      => $row['msj_id'],
                                'bitmen_titulo'     => $row['msj_titulo'],
                                'bitmen_cuerpo'     => $msj,
                                'bitmen_tipo'       => 'EMAIL'
                            ];

                            if ($error == '') {
                                $data_envio['bitmen_estatus'] = 'Enviado';
                                $newSMSContact->editar($row['id'], ['sc_ultimo_envio' => date('Y-m-d')]);
                            } else {
                                $data_envio['bitmen_estatus'] = $error;
                            }

                            $newBitacora->guardar($data_envio, true);

                            $n += 1;
                        }
                    }
                }
            }
        }
    }
}

$error = ($error == '') ? 'Enviado' : ['errors' => [$error]];
Http::json_response($error);
