#!/bin/bash

# arepaEngine CLI


# Genera el código para un modelo
function set_model() {
    filename=`php -r "print ucfirst('$1');"`
    property=$filename
    valores=`php -r "print strtolower('$1');"`
    atributo=$valores
    contenido=`replace ClassName $1 property $property < templates/model`
    contenido=`replace ClassName $1 atributo $atributo < templates/model`
    echo "$contenido" > ../../app/$2/modelo/$filename.php
}


# Genera el código para un controlador
function set_controller() {
    filename=`php -r "print ucfirst('$1');"`
    property=$filename
    valores=`php -r "print strtolower('$1');"`
    atributo=$valores
    contenido=`replace MODULO $2 ARCHIVO $filename ClassName $1 property \
        $property < templates/controller  MODULO $2 ARCHIVO $filename ClassName $1 atributo \
        $atributo < templates/controller`
    echo "$contenido" > ../../app/$2/controlador/$filename'Controlador'.php
}


# Genera el código para una vista
function set_view() {
        echo "" > ../../app/$2/vista/index.php
        echo "" > ../../app/$2/vista/crear.php
        echo "" > ../../app/$2/vista/ver.php
        echo "" > ../../app/$2/vista/editar.php
}

# Crear los archivos models, views y controllers
function create_files() {
        set_model $2 $1
        set_controller $2 $1
        set_view $2 $1
        composer dump-autoload -o
        echo "Listo!"

}
