<?php

namespace Core\Librerias;

final class Redirecciona
{
    private static function redirect($ruta)
    {
        $url = str_replace('index.php', '', $_SERVER['PHP_SELF']);
        header('location:/' . trim($url, '/') . '/' . trim($ruta, '/'));
    }

    public function mensaje($var, $value = null)
    {
        if (is_null($value)) {
            foreach ($var as $clave => $valor) {
                $_SESSION[$clave] = $valor;
            }
        } else {
            $_SESSION[$var] = $value;
        }

        return $this;
    }

    public function atras()
    {
        if (isset($_SERVER['HTTP_REFERER'])) {
            header('Location: ' . $_SERVER['HTTP_REFERER']);
        }
        exit();
    }
}
