<?php

use Core\Librerias\Redirecciona;
use Core\Librerias\Session;
use Core\Librerias\Token;

function ruta_base()
{
    return constant('APP_DIR');
}

function protocolo()
{
    return constant('PROTOCOLO');
}

function token()
{
    return Token::crearToken();
}

function asset(string $asset)
{
    $urlprin = trim(str_replace('index.php', '', $_SERVER['PHP_SELF']), '/');
    echo '/' . $urlprin . '/public/' . $asset;
}

function sucursal()
{
    return constant('APP_DIR').'seleccion';
}

function redireccionar()
{
    return new Redirecciona();
}

function google()
{
    return constant('APP_DIR').'google';
}

function session_mensaje()
{
    if (Session::tiene('tipo') && Session::tiene('mensaje')) {
        echo Session::get('mensaje');
    }
}

function url(string $ruta)
{
    $urlprin = str_replace('index.php', '', $_SERVER['PHP_SELF']);
    echo '/' . trim($urlprin, '/') . '/' . $ruta;
}

function activo_menu($module_id)
{
    $segmento = explode('/', $_SERVER['REQUEST_URI']);
    return ($segmento[2] == $module_id) ? "active" : '';
}

function mascara_correlativo(string $prefifo, string $mascara, int $correlativo): string
{
    return $prefifo . '' . str_pad($correlativo, strlen($mascara), $mascara[0], STR_PAD_LEFT);
}

function isAjax(): bool
{
    return !empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest';
}

function convertir_a_float($num): float
{
    $dotPos = strrpos($num, '.');
    $commaPos = strrpos($num, ',');
    $sep = (($dotPos > $commaPos) && $dotPos) ? $dotPos : ((($commaPos > $dotPos) && $commaPos) ? $commaPos : false);

    if (!$sep) {
        return floatval(preg_replace("/[^0-9]/", "", $num));
    }

    return floatval(preg_replace("/[^0-9]/", "", substr($num, 0, $sep)) . '.' . preg_replace("/[^0-9]/", "", substr($num, $sep + 1, strlen($num))));
}

function float_a_string($val): string
{
    preg_match("#^([\+\-]|)([0-9]*)(\.([0-9]*?)|)(0*)$#", trim($val), $o);
    return $o[1] . sprintf('%d', $o[2]) . ($o[3] != '.' ? $o[3] : '');
}

function eliminar_numero_de_cadena(string $cadena): string
{
    return preg_replace('/[0-9]+/', '', $cadena);
}

function extraer_numero_de_cadena(string $cadena): int
{
    return intval(preg_replace('/[^0-9]+/', '', $cadena), 10);
}

function valida_email($email): bool
{
    $result = (false !== filter_var($email, FILTER_VALIDATE_EMAIL));
    if ($result) {
        list($user, $domain) = explode('@', $email);
        $result = checkdnsrr($domain, 'MX');
    }
    return $result;
}

function validateDate($date, $format = 'Y-m-d H:i:s'): bool
{
    $d = DateTime::createFromFormat($format, $date);
    return $d && $d->format($format) == $date;
}
