<?php

namespace Core\Helpers;

use NumberFormatter;

final class Moneda
{
    public static function moneda(float $monto, string $div_locale, string $div_simbolo, int $decimal = 2): string
    {
        $a = new NumberFormatter("$div_locale", NumberFormatter::DECIMAL);
        $a->setAttribute(NumberFormatter::MIN_FRACTION_DIGITS, $decimal);
        $a->setAttribute(NumberFormatter::MAX_FRACTION_DIGITS, $decimal);
        return $div_simbolo . ' ' . $a->format($monto);
    }

    public static function decimal(float $monto, string $div_locale, int $decimal = 2): string
    {
        $a = new NumberFormatter("$div_locale", NumberFormatter::DECIMAL);
        $a->setAttribute(NumberFormatter::MIN_FRACTION_DIGITS, $decimal);
        $a->setAttribute(NumberFormatter::MAX_FRACTION_DIGITS, $decimal);
        return $a->format($monto);
    }

    public static function Predeterminada()
    {
        $data_divisa = $GLOBALS['newDBIni']->consultar("SELECT * FROM app_divisas WHERE div_predeterminado = 1")->row();
        $divisa = [];
        if ($data_divisa) {
            $divisa = [
                'id' => $data_divisa['div_id'],
                'divisa' => $data_divisa['div_nombre'],
                'locale' => $data_divisa['div_locale'],
                'symbol' => $data_divisa['div_simbolo'],
                'currency' => $data_divisa['div_currency'],
                'precision' => $data_divisa['div_decimal'],
                'decimal' => $data_divisa['div_partedecimal'],
                'thousands' => $data_divisa['div_partedecimal'] == '.' ? ',' : '.'
            ];
        }
        return $divisa;
    }

    public static function facturarPredeterminada()
    {
        $data_divisa = $GLOBALS['newDBIni']->consultar("SELECT * FROM app_divisas WHERE div_facturar = 1")->row();
        $divisa = [];
        if ($data_divisa) {
            $divisa = [
                'id' => $data_divisa['div_id'],
                'divisa' => $data_divisa['div_nombre'],
                'locale' => $data_divisa['div_locale'],
                'symbol' => $data_divisa['div_simbolo'],
                'currency' => $data_divisa['div_currency'],
                'precision' => $data_divisa['div_decimal'],
                'decimal' => $data_divisa['div_partedecimal'],
                'thousands' => $data_divisa['div_partedecimal'] == '.' ? ',' : '.'
            ];
        }
        return $divisa;
    }

    public static function obtenerDivisa(int $id_divisa)
    {
        $data_divisa = $GLOBALS['newDBIni']->consultar("SELECT * FROM app_divisas WHERE div_id = $id_divisa")->row();
        $divisa = [];
        if ($data_divisa) {
            $divisa = [
                'id' => $data_divisa['div_id'],
                'divisa' => $data_divisa['div_nombre'],
                'locale' => $data_divisa['div_locale'],
                'symbol' => $data_divisa['div_simbolo'],
                'currency' => $data_divisa['div_currency'],
                'precision' => $data_divisa['div_decimal'],
                'decimal' => $data_divisa['div_partedecimal'],
                'thousands' => $data_divisa['div_partedecimal'] == '.' ? ',' : '.'
            ];
        }
        return $divisa;
    }

    public static function obtenerDivisas()
    {
        $data_divisa = $GLOBALS['newDBIni']->consultar("SELECT * FROM app_divisas WHERE div_status = 1")->all();
        $divisa = [];
        if (is_countable($data_divisa) && count($data_divisa)) {
            foreach ($data_divisa as $row) {
                $divisa[] = [
                    'id' => $row['div_id'],
                    'divisa' => $row['div_nombre'],
                    'predeterminada' => $row['div_predeterminado'] == 1 ? true : false,
                    'locale' => $row['div_locale'],
                    'symbol' => $row['div_simbolo'],
                    'currency' => $row['div_currency'],
                    'precision' => $row['div_decimal'],
                    'decimal' => $row['div_partedecimal'],
                    'thousands' => $row['div_partedecimal'] == '.' ? ',' : '.'
                ];
            }
        }
        return $divisa;
    }

    public static function obtenerFactor(int $id_div_master, int $id_div_deseada)
    {
        return $GLOBALS['newDBIni']->consultar("SELECT * FROM app_divisas_factor WHERE df_divid_master=$id_div_master and df_divid=$id_div_deseada")->row();
    }
}
