<?php

namespace App\Modelos;

use Core\Database;

class Woocommerce extends Database
{
    public function obtenerProducto($id_producto)
    {
        return $this->consultar("SELECT * 
        FROM app_productos p
        WHERE p.pro_id = $id_producto")->row();
    }

    public function obtenerProductoImagenes($id_producto)
    {
        return $this->consultar("SELECT * FROM app_productos_imagen WHERE pi_proid = $id_producto")->all();
    }

    public function obtenerCategoriasProducto($id_producto)
    {
        return $this->consultar("SELECT * FROM app_productos_categorias apc 
        LEFT JOIN app_categorias ac ON ac.cat_id = apc.pc_catid 
        WHERE apc.pc_proid = $id_producto")->all();
    }

    public function obtenerDivisas()
    {
        return $this->consultar('SELECT * FROM app_divisas WHERE div_status = 1')->all();
    }

    public function obtenerSeries()
    {
        return $this->consultar('SELECT * FROM app_series')->all();
    }

    public function actualizarCorrelativo(int $id_serie, $id_documento, int $correlartivo)
    {
        return $this->consultar("UPDATE app_correlativos SET cor_correlativo = $correlartivo WHERE cor_serid = $id_serie AND cor_docid=$id_documento")->run();
    }

    public function obtenerSerie($id_serie)
    {
        return $this->consultar("SELECT * FROM app_series WHERE ser_id=$id_serie")->row();
    }

    public function obtenerDivisa(int $id_divisa)
    {
        return $this->consultar("SELECT * FROM app_divisas WHERE div_id=$id_divisa")->row();
    }

    public function chuequearCorrelativo(int $id_serie, int $id_documento)
    {
        return $this->consultar("SELECT * FROM app_correlativos WHERE cor_serid = $id_serie AND cor_docid = $id_documento")->row();
    }
}
