<?php
namespace App\Controladores;
use Core\Controller;
use App\Modelos\Cliente;
use App\Modelos\EmpleadoAlmacen;
use App\Modelos\Pedidos;
use App\Modelos\PedidosArticulos;
use App\Modelos\Woocommerce;
use Core\Librerias\Http;
use Automattic\WooCommerce\Client;
use Automattic\WooCommerce\HttpClient\HttpClientException;
use Core\Helpers\Moneda;
use Core\Librerias\Module;
use Core\Vista;

final class WoocommerceControlador extends Controller
{
    private $woocommerce;
    private $woocommerce_model;
    private $array_errors = [];

    public function __construct()
    {
        parent::__construct();
        $this->module = new Module('woocommerce');
        $this->woocommerce_model = new Woocommerce();
        if (defined('WCURL') && defined('WCKEY') && defined('WCSECRECT') && defined('WCIMG')) {
            $this->woocommerce = new Client(
                constant('WCURL'),
                constant('WCKEY'),
                constant('WCSECRECT'),
                [
                    'wp_api'    => true,
                    'version'   => 'wc/v3',
                    'timeout'   => 30
                ]
            );
        } else {
            Http::notFound();
        }
    }

    public function index()
    {
        $empleado_alamcen = new EmpleadoAlmacen();
        return Vista::view('woocommerce/index', [
            'almacenes' => $empleado_alamcen->obtenerAlmacenes($_SESSION['user_data']['emp_id']),
            'divisas' => $this->woocommerce_model->obtenerDivisas(),
            'series' => $this->woocommerce_model->obtenerSeries()
        ]);
    }

    public function obtenerClientes()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'GET' && isAjax()) {

            try {
                Http::json_response([
                    'clientes' => $this->woocommerce->get('customers', ['per_page' => 100])
                ]);
            } catch (HttpClientException $e) {
                $this->array_errors[] = $e->getMessage();
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function obtenerProductos()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'GET' && isAjax()) {

            try {
                Http::json_response([
                    'divisa' => Moneda::Predeterminada(),
                    'productos' => $this->woocommerce->get('products', array('per_page' => 100000))
                ]);
            } catch (HttpClientException $e) {
                $this->array_errors[] = $e->getMessage();
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function obtenerPedidos()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'GET' && isAjax()) {

            $estatus = filter_input(INPUT_GET, 'estatus', FILTER_SANITIZE_STRING);

            try {
                Http::json_response([
                    'divisa' => Moneda::Predeterminada(),
                    'pedidos' => $this->woocommerce->get('orders', ['per_page' => 100, 'status' =>'on-hold'])
                ]);
            } catch (HttpClientException $e) {
                $this->array_errors[] = $e->getMessage();
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function publicarProducto()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'GET' && isAjax()) {

            $id = filter_input(INPUT_GET, 'id', FILTER_SANITIZE_STRING);

            if (!empty($id)) {

                try {

                    $producto = $this->woocommerce->get('products/' . $id);

                    if ($producto->status == 'publish') {
                        $status = 'private';
                    } elseif ($producto->status == 'private') {
                        $status = 'publish';
                    } else {
                        $status = 'publish';
                    }

                    $this->woocommerce->put('products/' . $id, ['status' => $status]);

                    Http::json_response(true);
                } catch (HttpClientException $e) {
                    $this->array_errors[] = $e->getMessage();
                }
            } else {
                Http::json_response(false);
            }
        }
    }

    public function sincronizarPedido($id)
    {
        if ($_SERVER['REQUEST_METHOD'] == 'GET' && isAjax()) {

            $id = filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT);

            if (!empty($id)) {

                try {
                    $producto = $this->woocommerce->get('products/' . $id);

                    if (is_null($producto->sku) || $producto->sku == '') {
                        $this->array_errors[] = 'Lo siento el producto ' . $producto->name . ' no tiene id(sku) definido';
                    } else {

                        $data_pro = $this->woocommerce_model->obtenerProducto($producto->sku);

                        if (!$data_pro) {
                            $this->array_errors[] = 'Lo siento el producto que intenta sincronizar no se encuentra en nuesatra base de datos.';
                        } else {

                            $categorias_pro = $this->woocommerce_model->obtenerCategoriasProducto($data_pro['pro_id']);
                            $productoImagen = $this->woocommerce_model->obtenerProductoImagenes($data_pro['pro_id']);

                            $data_form = [
                                'slug'          => $data_pro['pro_descripcion'],
                                'sku'           => $data_pro['pro_id'],
                                'name'          => $data_pro['pro_descripcion'],
                                'type'          => 'simple',
                                'price'         => $data_pro['pro_precio'],
                                'regular_price' => $data_pro['pro_precio']
                                
                            ];
                            //'description'   => $data_pro['pro_observaciones'],
                            if (defined('WCDESCRIPTION') && constant('WCDESCRIPTION') == 0) {
                                //$data_form['short_description'] = $data_pro['pro_observaciones'];
                            }

                            if ($categorias_pro) {
                                foreach ($categorias_pro as $row) {
                                    $data_form['categories'][] = [
                                        'id' => $row['pc_catid']
                                    ];
                                }
                            }

                            if ($productoImagen) {
                                $i = 0;
                                foreach ($productoImagen as $item) {
                                    $i++;
                                    $img = constant('WCIMG') . $item['pi_imagen'];
                                    $data_form['images'][] = [
                                        "src" => $img,
                                        "position" => $i
                                    ];
                                }
                            }

                            $this->woocommerce->put('products/' . $id, $data_form);
                            Http::json_response(true);
                        }
                    }
                    Http::json_response($producto);
                } catch (HttpClientException $e) {
                    $this->array_errors[] = $e->getMessage();
                }

                Http::json_response(['errors' => $this->array_errors]);
            } else {
                Http::json_response(false);
            }
        }
    }

    public function convertirADocumentoPedido()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isAjax()) {

            $pedido_model   = new Pedidos();
            $cliente_model  = new Cliente();

            $id         = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
            $fecha      = filter_input(INPUT_POST, 'fecha');
            $id_serie   = filter_input(INPUT_POST, 'serie', FILTER_SANITIZE_NUMBER_INT);
            $id_divisa  = filter_input(INPUT_POST, 'divisa', FILTER_SANITIZE_NUMBER_INT);
            $id_almacen = filter_input(INPUT_POST, 'almacen', FILTER_SANITIZE_NUMBER_INT);

            if (empty($id))
                $this->array_errors[] = 'El campo ID es obligatorio.';
            if (empty($fecha))
                $this->array_errors[] = 'El campo fecha es obligatorio.';
            if (empty($id_serie))
                $this->array_errors[] = 'El campo Serie es obligatorio.';
            if (empty($id_divisa))
                $this->array_errors[] = 'El campo Divisa es obligatorio.';
            if (empty($id_almacen))
                $this->array_errors[] = 'El campo Almacen es obligatorio.';

            if (empty($this->array_errors)) {

                if (!validateDate($fecha, 'Y-m-d'))
                    $this->array_errors[] = 'Fecha incorrecta';

                if (empty($this->array_errors)) {

                    $serie = $this->woocommerce_model->obtenerSerie($id_serie);
                    $divisa = $this->woocommerce_model->obtenerDivisa($id_divisa);

                    if ($serie && $divisa) {

                        $correlativo = $this->woocommerce_model->chuequearCorrelativo($serie['ser_id'], 4); // PEDIDOS

                        if (!$correlativo)
                            $this->array_errors[] = "No existe correlativo entre la se serie $serie[ser_descripcion] y el documento Pedidos por favor dirijase a Modulo Configuración -> correlativos";

                        if (empty($this->array_errors)) {

                            try {

                                $cantidad_articulos = 0;

                                $pedido = $this->woocommerce->get('orders/' . $id);

                                foreach ($pedido->line_items as $row) {

                                    if (is_null($row->sku) || $row->sku == '') {
                                        $this->array_errors[] = 'Ls siento el producto ' . $row->name . ' no tiene id(sku) definido';
                                    } else {
                                        $data_pro = $this->woocommerce_model->obtenerProducto($row->sku);

                                        if (!$data_pro) {
                                            $this->array_errors[] = 'Ls siento el producto ' . $row->name . ' no ha sido encontrado';
                                        }
                                    }

                                    $cantidad_articulos += $row->quantity;
                                }

                                if (empty($this->array_errors)) {

                                    $total_costo_servicio = 0;
                                    $total_procosto = 0;

                                    $dni = str_replace('.', '', "{$pedido->billing->company}");
                                    $dni = str_replace(',', '', $dni);

                                    $data_cliente = $cliente_model->obtenerClienteDNI($dni);

                                    if (!$data_cliente) {

                                        if (strtolower($pedido->billing->company[0]) == 'v') {
                                            $cli_tipodocid = 2;
                                        } elseif (strtolower($pedido->billing->company[0]) != 'v') {
                                            if (is_numeric($pedido->billing->company[0])) {
                                                $cli_tipodocid = 2;
                                            } else {
                                                $cli_tipodocid = 3;
                                            }
                                        }

                                        $data_form = [
                                            'cli_tipodocid'      => $cli_tipodocid,
                                            'cli_dni'            => $dni,
                                            'cli_razon_social'   => $pedido->billing->first_name . ' ' . $pedido->billing->last_name,
                                            'cli_email'          => $pedido->billing->email,
                                            'cli_telefono'       => $pedido->billing->phone,
                                            'cli_direccion'      => $pedido->billing->address_1,
                                            'cli_paisid'         => 231, //$pedido['billing']['country']
                                            'cli_estado'         => $pedido->billing->state,
                                            'cli_ciudad'         => $pedido->billing->city,
                                            'cli_codpostal'      => $pedido->billing->postcode,
                                            'cli_contribuyente'  => 1,
                                            'cli_fecha_reg'      => date('Y-m-d H:i:s'),
                                            'cli_natural'        => 1
                                        ];

                                        $id_cliente = $cliente_model->guardar($data_form);

                                        $data_cliente = $data_form;
                                    } else {
                                        $id_cliente = $data_cliente['cli_id'];
                                    }
                                    
                                    $total_factura=0;

                                    foreach ($pedido->line_items as $row) {

                                        $data_producto = $this->woocommerce_model->obtenerProducto($row->sku);

                                        $preciot = 0;
                                        $descuento_producto=0.00;
                                
                                        $modulo=new Module();
                                
                                        $tarifas_clientes =  $this->woocommerce_model->consultar("SELECT * FROM app_clientes WHERE cli_id={$id_cliente}")->row();
                                        $permiso_tarifa = $modulo->has_module_action_permission('facturacion', 'agregar_tarifa', $_SESSION['user_data']['emp_id']);
                                
                                        if ($tarifas_clientes && $permiso_tarifa) {
                                            $tarifas = $this->woocommerce_model->consultar("SELECT * FROM app_tarifas WHERE tar_id={$tarifas_clientes['cli_gruptarid']}")->row();
                                            $tarifa_producto = $this->woocommerce_model->consultar("SELECT * FROM app_productos_tarifas WHERE pt_proid={$data_producto['pro_id']} AND pt_tarid={$tarifas_clientes['cli_gruptarid']}")->row();
                                
                                            if ($tarifa_producto) {
                                                if ($tarifa_producto['pt_tarprecio'] > 0) {
                                                    $preciot = $tarifa_producto['pt_tarprecio'];
                                                } else {
                                                    $preciot = $row->price;
                                                    $descuento_producto = $tarifas['tar_valorx'];
                                                }
                                            } else {
                                                $preciot =  $row->price;
                                            }
                                        } else {
                                            $preciot =  $row->price;
                                        }

                                        $total_factura+= $preciot * $row->quantity;
                                    }


                                    $id_factura = $pedido_model->guardar([
                                        'pe_articulos_total'    => $cantidad_articulos,
                                        'pe_subtotal'           => $total_factura,
                                        'pe_neto'               => $total_factura,
                                        'pe_iva'                => 0,
                                        'pe_descuento'          => 0,
                                        'pe_total'              => $total_factura,
                                        'pe_divid'              => $divisa['div_id'],
                                        'pe_serid'              => $serie['ser_id'],
                                        'pe_serie'              => $serie['ser_descripcion'],
                                        'pe_empresaid'          => 1,
                                        'pe_empleadoid'         => $_SESSION['user_data']['einfo_id'],
                                        'pe_fecha'              => date('Y-m-d', strtotime($fecha)) . ' ' . date('H:i:s'),
                                        'pe_cliid'              => $id_cliente,
                                        'pe_correlativo'        => $correlativo['cor_correlativo'] + 1,
                                        'pe_env_nombres'        => $pedido->shipping->first_name . ' ' . $pedido->shipping->last_name,
                                        'pe_env_direccion'      => $pedido->shipping->address_1,
                                        'pe_env_pais'           => 231,
                                        'pe_env_estado'         => $pedido->shipping->state,
                                        'pe_env_ciudad'         => $pedido->shipping->city,
                                        'pe_env_codigo_postal'  => $pedido->shipping->postcode,
                                        'pe_estatus'            => 2,
                                        'pe_almid'              => $id_almacen,
                                    ]);

                                    if ($id_factura) {

                                        $this->woocommerce_model->actualizarCorrelativo($serie['ser_id'], 4, ($correlativo['cor_correlativo'] + 1));

                                        $notas_entrega_articulos_model = new PedidosArticulos();

                                        foreach ($pedido->line_items as $row) {

                                            $data_producto = $this->woocommerce_model->obtenerProducto($row->sku);

                                            $preciot = 0;
                                            $descuento_producto=0.00;
                                    
                                            $modulo=new Module();
                                    
                                            $tarifas_clientes =  $this->woocommerce_model->consultar("SELECT * FROM app_clientes WHERE cli_id={$id_cliente}")->row();
                                            $permiso_tarifa = $modulo->has_module_action_permission('facturacion', 'agregar_tarifa', $_SESSION['user_data']['emp_id']);
                                    
                                            if ($tarifas_clientes && $permiso_tarifa) {
                                                $tarifas =  $this->woocommerce_model->consultar("SELECT * FROM app_tarifas WHERE tar_id={$tarifas_clientes['cli_gruptarid']}")->row();
                                                $tarifa_producto =  $this->woocommerce_model->consultar("SELECT * FROM app_productos_tarifas WHERE pt_proid={$data_producto['pro_id']} AND pt_tarid={$tarifas_clientes['cli_gruptarid']}")->row();
                                    
                                                if ($tarifa_producto) {
                                                    if ($tarifa_producto['pt_tarprecio'] > 0) {
                                                        $preciot = $tarifa_producto['pt_tarprecio'];
                                                    } else {
                                                        $preciot =  $row->price;
                                                        $descuento_producto = $tarifas['tar_valorx'];
                                                    }
                                                } else {
                                                    $preciot =  $row->price;
                                                }
                                            } else {
                                                $preciot = $row->price;
                                            }

                                            if ($notas_entrega_articulos_model->guardar([
                                                'peart_peid'                    => $id_factura,
                                                'peart_proid'                   => $data_producto['pro_id'],
                                                'peart_procodigo'               => $data_producto['pro_codigo'],
                                                'peart_propnombre'              => $row->name,
                                                'peart_procosto'                => $data_producto['pro_costo'],
                                                'peart_costo_servicio'          => $preciot,
                                                'peart_proprecio'               => $preciot,
                                                'peart_procantidad'             => $row->quantity,
                                                'peart_prodescuento'            => $descuento_producto ,
                                                'peart_proneto'                 => $preciot,
                                                'peart_idiva'                   => 2,
                                                'peart_almid'                   => $id_almacen,
                                                'peart_proiva'                  => 0,
                                                'peart_ivatotal'                => 0,
                                                'peart_prototal'                => $preciot * $row->quantity,
                                                'peart_descontar_inventario'    => 0
                                            ], true)) {
                                                if ($data_producto['pro_tipo'] == 3) {
                                                    $total_costo_servicio  += $row->price * $row->quantity;
                                                } else {
                                                    $total_procosto += $data_producto['pro_costo'] * $row->quantity;
                                                }
                                            }
                                        }

                                        $pedido_model->editar($id_factura, [
                                            'total_procosto' => $total_procosto,
                                            'total_costo_servicio' => $total_costo_servicio,
                                        ]);

                                        $this->woocommerce->put('orders/' . $id, ['status' => 'completed']);

                                        Http::json_response(ruta_base() . 'pedidoseditar/verFactura/' . $id_factura);
                                    } else {
                                        $this->array_errors[] = "Los siento ocurrio un error al guardar la venta";
                                    }
                                }
                            } catch (HttpClientException $e) {
                                $this->array_errors[] = $e->getMessage();
                            }
                        }
                    }
                }
            }

            Http::json_response([
                'errors' => $this->array_errors
            ]);
        }
    }

    public function guardar()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'GET' && isAjax()) {

            $id_producto = filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT);

            $data_pro = $this->woocommerce_model->obtenerProducto($id_producto);

            if (!$data_pro) {
                $this->array_errors[] = 'Lo siento el producto que intenta guardar no existe.';
            } else {

                try {

                    $chequear_existencia = $this->woocommerce->get('products', ['sku' => $data_pro['pro_id']]);

                    if ($chequear_existencia) {
                        $this->array_errors[] = 'El producto ya existe en woocommerce.';
                    } else {

                        $data_form = [
                            'slug'          => $data_pro['pro_descripcion'],
                            'sku'           => $data_pro['pro_id'],
                            'name'          => $data_pro['pro_descripcion'],
                            'type'          => 'simple',
                            'price'         => $data_pro['pro_precio'],
                            'regular_price' => $data_pro['pro_precio'],
                            
                        ];
                        //'description'   => $data_pro['pro_observaciones'],
                        if (defined('WCDESCRIPTION') && constant('WCDESCRIPTION') == 0) {
                            //$data_form['short_description'] = $data_pro['pro_observaciones'];
                        }

                        $categorias_pro = $this->woocommerce_model->obtenerCategoriasProducto($data_pro['pro_id']);
                        $categorias = [];

                        if ($categorias_pro) {

                            foreach ($categorias_pro as $row) {
                                $categorias[] = [
                                    'id' => $row['cat_wooc']
                                ];
                            }

                            $data_form['categories'] = $categorias;
                        }

                        $productoImagen = $this->woocommerce_model->obtenerProductoImagenes($data_pro['pro_id']);

                        if ($productoImagen) {

                            $i = 0;
                            $all = array();

                            foreach ($productoImagen as $item) {
                                $i++;
                                $img = constant('WCIMG') . $item['pi_imagen'];
                                $all[] = array(
                                    "src" => $img,
                                    "position" => $i
                                );
                            }

                            $data_form['images'] = $all;
                        }

                        $this->woocommerce->post('products', $data_form);
                        Http::json_response(true);
                    }
                } catch (HttpClientException $e) {
                    $this->array_errors[] = $e->getMessage();
                }
            }

            Http::json_response([
                'errors' => $this->array_errors
            ]);
        }
    }

    public function eliminar()
    {
        //$this->woocommerce->delete('products/' . $pro_id, ['force' => true]);
    }

    public function obtenerPedidosn()
    {
        $estatus = 'on-hold';
        $woocomm=[];

        try {
            $woocomm = $this->woocommerce->get('orders', ['per_page' => 100, 'status' => $estatus]);
            if (is_countable($woocomm) && count($woocomm)>0) {
                return count($woocomm);
            }else{
                return 0;
            }
        } catch (HttpClientException $e) {
            return $e->getMessage();
        }
    }

    public function obtener_cantpedidos()
    {
        $estatus = 'on-hold';
        $woocomm=[];

        try {
            $woocomm = $this->woocommerce->get('orders', ['per_page' => 100, 'status' => $estatus]);
            if (is_countable($woocomm) && count($woocomm)>0) {
                return count($woocomm);
            }else{
                return 0;
            }
        } catch (HttpClientException $e) {
            return $e->getMessage();
        }
    }
}
