<?php

namespace App\Controladores;

use App\Modelos\Cliente;
use App\Modelos\Clientedireccionenvios;
use App\Modelos\Facturacion;
use Core\Controller;
use Core\Helpers\Documento;
use Core\Helpers\Moneda;
use Core\Librerias\Http;
use Core\Librerias\Module;
use Core\Vista;

final class VentascajaControlador extends Controller
{
    private $facturacionModel;
    private $array_errors = [];

    public function __construct()
    {
        parent::__construct();
        $this->module   = new Module('ventascaja');
        $this->facturacionModel = new Facturacion();
        $this->divisa_master  = $this->facturacionModel->obtenerDivisaMaster();
    }

    public function index()
    {
        return Vista::view('ventascaja/index', [
            'doc_' => Documento::obtener(12),
            'series' => $this->facturacionModel->consultar("SELECT ser_id, ser_descripcion FROM app_series")->all(),
            'divisas' => $this->facturacionModel->consultar("SELECT div_id, div_nombre FROM app_divisas WHERE div_status = 1")->all(),
            'tipos_de_documentos' => $this->facturacionModel->obtenerTiposdeDocumentos()
        ]);
    }

    public function obtenerDivisaPredeterminada()
    {
        Http::json_response(Moneda::Predeterminada());
    }

    public function obtenerDivisaParaFactura()
    {
        Http::json_response(Moneda::facturarPredeterminada());
    }

    public function obtenerFacturas($anio)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $anio = $this->solicitud->sanitize($_GET['anio'], FILTER_SANITIZE_NUMBER_INT);

            $array_finalizadas  = [];
            $array_anuladas     = [];
            $array_pendientes   = [];

            $f_finalizadas = $this->facturacionModel->obtenerFacturasxempleadoshoy($anio);
            $f_pendientes = $this->facturacionModel->obtenerFacturasPendientesxempleadoshoy($anio);
            $f_anuladas = $this->facturacionModel->obtenerFacturasAnuladasxempleadoshoy($anio);
            $documento = $this->facturacionModel->obtenerDocumento(2);

            if (is_countable($f_pendientes) && count($f_pendientes)) {
                foreach ($f_pendientes as $row) {
                    $acumulado = $this->facturacionModel->obtenerAcumulado($row['fm_id'], 2);
                    $acumulado_total = ($acumulado['total']) ?? 0;
                    $array_pendientes[] = [
                        'id'            => $row['fm_id'],
                        'cliente'       => $row['cli_razon_social'],
                        'uri'           => 'facturacioncajaeditar/verFactura/' . $row['fm_id'],
                        'documento'     => $documento['doc_prefijo'],
                        'correlativo'   => $row['fm_correlativo'],
                        'div_locale'    => $row['div_locale'],
                        'div_simbolo'   => $row['div_simbolo'],
                        'total'         => $row['fm_total'],
                        'fecha'         => $row['fm_fecha'],
                        'acumulado'     => $acumulado_total,
                        'pendiente'     => $row['fm_total'] - $acumulado_total
                    ];
                }
            }

            if (is_countable($f_anuladas) && count($f_anuladas)) {
                foreach ($f_anuladas as $row) {
                    $acumulado = $this->facturacionModel->obtenerAcumulado($row['fm_id'], 2);
                    $acumulado_total = ($acumulado['total']) ?? 0;
                    $array_anuladas[] = [
                        'id'            => $row['fm_id'],
                        'cliente'       => $row['cli_razon_social'],
                        'uri'           => 'facturacioncajaeditar/verFactura/' . $row['fm_id'],
                        'documento'     => $documento['doc_prefijo'],
                        'correlativo'   => $row['fm_correlativo'],
                        'div_locale'    => $row['div_locale'],
                        'div_simbolo'   => $row['div_simbolo'],
                        'total'         => $row['fm_total'],
                        'fecha'         => $row['fm_fecha'],
                        'acumulado'     => $acumulado_total,
                        'pendiente'     => $row['fm_total'] - $acumulado_total
                    ];
                }
            }

            if (is_countable($f_finalizadas) && count($f_finalizadas)) {
                foreach ($f_finalizadas as $row) {
                    $array_finalizadas[] = [
                        'id'            => $row['fm_id'],
                        'cliente'       => $row['cli_razon_social'],
                        'uri'           => 'facturacioncajaeditar/verFactura/' . $row['fm_id'],
                        'documento'     => $documento['doc_prefijo'],
                        'correlativo'   => $row['fm_correlativo'],
                        'div_locale'    => $row['div_locale'],
                        'div_simbolo'   => $row['div_simbolo'],
                        'total'         => $row['fm_total'],
                        'fecha'         => $row['fm_fecha'],
                    ];
                }
            }

            Http::json_response([
                'pagas'         => $array_finalizadas,
                'pendientes'    => $array_pendientes,
                'anuladas'      => $array_anuladas,
                'n_pendientes'  => $this->facturacionModel->obtenerNotasdeEntregaAnualesPendientesTotal(),
                'p_pendientes'  => $this->facturacionModel->obtenerPedidosAnualesPendientesTotal(),
                'pr_pendientes' => $this->facturacionModel->obtenerPresupuestosAnualesPendientesTotal()
            ]);
        }
    }

    public function obtenerNotasdeEntregaAnuales($anio)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $anio = $this->solicitud->sanitize($_GET['anio'], FILTER_SANITIZE_NUMBER_INT);

            $array_finalizadas  = [];
            $array_pendientes   = [];
            $array_anuladas     = [];

            $n_finalizadas = $this->facturacionModel->obtenerNotasdeEntregaxempleadoHoy($anio);
            $n_pendientes = $this->facturacionModel->obtenerNotasdeEntregaPendientesxempleadoHoy($anio);
            $n_anuladas = $this->facturacionModel->obtenerNotasdeEntregaAnuladasxempleadoHoy($anio);
            $documento = $this->facturacionModel->obtenerDocumento(1);

            if (is_countable($n_pendientes) && count($n_pendientes)) {
                foreach ($n_pendientes as $row) {
                    $acumulado = $this->facturacionModel->obtenerAcumulado($row['ne_id'], 1);
                    $acumulado_total = ($acumulado['total']) ?? 0;
                    $array_pendientes[] = [
                        'id'            => $row['ne_id'],
                        'cliente'       => $row['cli_razon_social'],
                        'uri'           => 'notasdeentregacajaeditar/verFactura/' . $row['ne_id'],
                        'documento'     => $documento['doc_prefijo'],
                        'correlativo'   => $row['ne_correlativo'],
                        'div_locale'    => $row['div_locale'],
                        'div_simbolo'   => $row['div_simbolo'],
                        'total'         => $row['ne_total'],
                        'fecha'         => $row['ne_fecha'],
                        'acumulado'     => $acumulado_total,
                        'pendiente'     => $row['ne_total'] - $acumulado_total
                    ];
                }
            }

            if (is_countable($n_anuladas) && count($n_anuladas)) {
                foreach ($n_anuladas as $row) {
                    $acumulado = $this->facturacionModel->obtenerAcumulado($row['ne_id'], 1);
                    $acumulado_total = ($acumulado['total']) ?? 0;
                    $array_anuladas[] = [
                        'id'            => $row['ne_id'],
                        'cliente'       => $row['cli_razon_social'],
                        'uri'           => 'notasdeentregacajaeditar/verFactura/' . $row['ne_id'],
                        'documento'     => $documento['doc_prefijo'],
                        'correlativo'   => $row['ne_correlativo'],
                        'div_locale'    => $row['div_locale'],
                        'div_simbolo'   => $row['div_simbolo'],
                        'total'         => $row['ne_total'],
                        'fecha'         => $row['ne_fecha'],
                        'acumulado'     => $acumulado_total,
                        'pendiente'     => $row['ne_total'] - $acumulado_total
                    ];
                }
            }

            if (is_countable($n_finalizadas) && count($n_finalizadas)) {
                foreach ($n_finalizadas as $row) {
                    $array_finalizadas[] = [
                        'id'            => $row['ne_id'],
                        'cliente'       => $row['cli_razon_social'],
                        'uri'           => 'notasdeentregacajaeditar/verFactura/' . $row['ne_id'],
                        'documento'     => $documento['doc_prefijo'],
                        'correlativo'   => $row['ne_correlativo'],
                        'div_locale'    => $row['div_locale'],
                        'div_simbolo'   => $row['div_simbolo'],
                        'total'         => $row['ne_total'],
                        'fecha'         => $row['ne_fecha']
                    ];
                }
            }

            Http::json_response([
                'pagas'         => $array_finalizadas,
                'pendientes'    => $array_pendientes,
                'anuladas'      => $array_anuladas
            ]);
        }
    }

    public function guardarCliente()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $ruta           = filter_input(INPUT_POST, 'ruta', FILTER_SANITIZE_STRING);
            $cli_tipodoc    = filter_input(INPUT_POST, 'cli_tipodoc', FILTER_SANITIZE_NUMBER_INT);
            $cli_dni        = filter_input(INPUT_POST, 'cli_dni', FILTER_SANITIZE_STRING);
            $razon_social   = filter_input(INPUT_POST, 'cli_razon_social', FILTER_SANITIZE_STRING);
            $cli_telefono   = filter_input(INPUT_POST, 'cli_telefono', FILTER_SANITIZE_STRING);
            $cli_direccion  = filter_input(INPUT_POST, 'cli_direccion', FILTER_SANITIZE_STRING);
            $cli_natural    = ('true' == filter_input(INPUT_POST, 'cli_natural')) ? 1 : 0;

            if (empty($cli_tipodoc))
                $this->array_errors[] = "El campo cedula de identidad es obligatorio.";
            if (empty($cli_dni))
                $this->array_errors[] = "El campo Tipo de documento es obligatorio.";
            if (empty($razon_social))
                $this->array_errors[] = "El campo Razón social es obligatorio.";
            if (empty($cli_telefono))
                $this->array_errors[] = "El campo Telefono es obligatorio.";
            if (empty($cli_direccion))
                $this->array_errors[] = "El campo Direccion es obligatorio.";

            if (empty($this->array_errors)) {

                $cliente_model = new Cliente();

                if (empty($_POST['cli_email'])) {
                    $cli_email = NULL;
                } else {
                    $cli_email = filter_input(INPUT_POST, 'cli_email', FILTER_VALIDATE_EMAIL);
                    if (!$cli_email)
                        $this->array_errors[] = 'Correo invalido';
                    if ($cliente_model->existe('cli_email', $cli_email))
                        $this->array_errors[] = "El correo electronico $cli_email ya se encuentra en uso";
                }

                if ($cliente_model->existe('cli_dni', $cli_dni))
                    $this->array_errors[] = "La cedula de identidad $cli_dni ya se encuentra en uso";
                if ($cliente_model->existe('cli_email', $cli_email))
                    $this->array_errors[] = "El correo electronico $cli_email ya se encuentra en uso";

                //if (valida_email($cli_email) == false)
                //array_push($this->array_errors, "La correo $cli_email no es correcto");
                if (empty($this->array_errors) && empty($this->array_errors)) {
                    $data_id = $cliente_model->guardar([
                        'cli_tipodocid'     => $cli_tipodoc,
                        'cli_dni'           => $cli_dni,
                        'cli_razon_social'  => $razon_social,
                        'cli_email'         => $cli_email,
                        'cli_telefono'      => $cli_telefono,
                        'cli_direccion'     => $cli_direccion,
                        'cli_contribuyente' => 1,
                        'cli_fecha_reg'     => date('Y-m-d H:i:s'),
                        'cli_natural'       => $cli_natural
                    ]);
                    if ($data_id) {

                        $cliente_direccion_envio_model = new Clientedireccionenvios();

                        $cliente_direccion_envio_model->guardar([
                            'cde_cliid'     => $data_id,
                            'cde_direccion' => $cli_direccion
                        ]);

                        $url = ruta_base() . $ruta . "/nuevaFactura/$data_id";
                        Http::json_response($url);
                    } else {
                        Http::json_response(false);
                    }
                }
            }

            $data['errors'] = $this->array_errors;
            Http::json_response($data);
        }
    }

    public function obtenerCierreDelDia()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $list_cierre_de_dia_p = [];
            $list_cierre_de_dia_n = [];
            $total_id_p = [];
            $totales_divisas_p = [];
            $total_id_n = [];
            $totales_divisas_n = [];

            $data_positivo = $this->facturacionModel->obtenerCierreDelDia(0);
            $data_negativo = $this->facturacionModel->obtenerCierreDelDia(1);

            if (is_countable($data_positivo) && count($data_positivo)) {
                foreach ($data_positivo as $row) {
                    $list_cierre_de_dia_p[] = [
                        'metodo' => $row['fab_metodo'],
                        'monto' => Moneda::moneda($row['monto'], $row['div_locale'], $row['div_simbolo']),
                        'banco' => [
                            'codigo' => $row['ban_codigo'],
                            'descripcion' => $row['ban_descripcion'],
                            'alias' => $row['bc_alias'],
                            'tipo' => $row['bc_tipo'],
                            'metodo' => $row['mp_nombre']
                        ]
                    ];

                    if (!in_array($row['div_id'], $total_id_p)) {
                        $totales_divisas_p[$row['div_id']] = [
                            'divisa' => Moneda::obtenerDivisa($row['div_id']),
                            'total' => $row['monto'],
                        ];
                        $total_id_p[] = $row['div_id'];
                    } else {
                        $totales_divisas_p[$row['div_id']]['total'] += $row['monto'];
                    }
                }
            }

            if (is_countable($data_negativo) && count($data_negativo)) {
                foreach ($data_negativo as $row) {
                    $list_cierre_de_dia_n[] = [
                        'metodo' => $row['fab_metodo'],
                        'monto' => Moneda::moneda($row['monto'], $row['div_locale'], $row['div_simbolo']),
                        'banco' => [
                            'codigo' => $row['ban_codigo'],
                            'descripcion' => $row['ban_descripcion'],
                            'alias' => $row['bc_alias'],
                            'tipo' => $row['bc_tipo'],
                            'metodo' => $row['mp_nombre']
                        ]
                    ];

                    if (!in_array($row['div_id'], $total_id_n)) {
                        $totales_divisas_n[$row['div_id']] = [
                            'divisa' => Moneda::obtenerDivisa($row['div_id']),
                            'total' => $row['monto'],
                        ];
                        $total_id_n[] = $row['div_id'];
                    } else {
                        $totales_divisas_n[$row['div_id']]['total'] += $row['monto'];
                    }
                }
            }

            Http::json_response([
                'cierre_positivo' => $list_cierre_de_dia_p,
                'cierre_negativo' =>  $list_cierre_de_dia_n,
                'total_divisas_p' => $totales_divisas_p,
                'total_divisas_n' => $totales_divisas_n,
            ]);
        }
    }
}
