<form>
    <div class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" id="modal_trabajo">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Planilla N° {{planilla.orden}}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="invoice-detail">
                        <div class="invoice-top text-center" style="background-color: rgba(222, 222, 222, 0.4);">
                            <h3 class="title"><strong>Datos de la Orden</strong></h3>
                        </div>
                        <div class="invoice-item">
                            <div class="table-responsive">
                                <table class="table table-striped table-head-bg-primary table-bordered-bd-primary">
                                    <thead>
                                        <tr>
                                            <td><strong>FECHA</strong></td>
                                            <td><strong>CLIENTE</strong></td>
                                            <td><strong>TALLER</strong></td>
                                            <td><strong>MOTOR</strong></td>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>{{planilla.fecha}}</td>
                                            <td>{{planilla.cliente}}</td>
                                            <td>{{planilla.taller}}</td>
                                            <td>{{planilla.motor}}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="invoice-detail">
                        <div class="invoice-top text-center" style="background-color: rgba(232, 179, 21, 0.43);">
                            <h3 class="title"><strong>Servicio</strong></h3>
                            <b class="text-danger">{{descrip}}</b><br><br>
                        </div>
                        <div class="invoice-item">
                            <div class="table-responsive">
                                <table class="table table-striped table-head-bg-primary table-bordered-bd-primary">
                                    <thead>
                                        <tr>
                                            <td width="6%"><strong></strong></td>
                                            <td width="30%"><strong>SERVICIO</strong></td>
                                            <td width="8%"><strong>CANTIDAD</strong></td>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr v-for="row in planilla.servicios" :key="row.preserv_id">
                                            <td class="text-center">
                                                <label :for="'check'+row.preserv_id" class="form-check-label">
                                                    <input class="form-check-input" type="checkbox" v-model="row.checked" :id="'serv'+row.preserv_id">
                                                    <span class="form-check-sign"></span>
                                                </label>
                                            </td>
                                            <td>{{row.pro_descripcion}}</td>
                                            <td>{{row.preserv_cantidad}}</td>
                                        </tr>
                                    </tbody>
                                </table>
                                <a href="#" class="btn btn-success btn-round m-2" @click.prevent="modal_varios()">FINALIZAR</a>
                            </div>
                        </div>
                    </div>
                    <div class="invoice-detail">
                        <div class="invoice-top text-center mt-3" style="background-color: rgba(222, 222, 222, 0.4);">
                            <h3 class="title"><strong>Partes Recibidas</strong></h3>
                        </div>
                        <div class="invoice-item">
                            <div class="table-responsive">
                                <table class="table table-sm table-hover table-striped table-head-bg-primary table-bordered-bd-primary">
                                    <thead>
                                        <tr>
                                            <th>Categoría</th>
                                            <th>Parte</th>
                                            <th class="text-center">Cant.</th>
                                            <th class="text-center">Ubic.</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr v-for="row in planilla.partes">
                                            <td>{{ row.categoria }}</td>
                                            <td><span :data-toggle="'tooltip'" :data-original-title="row.observacion" :title="row.observacion">{{ row.parte }}</span> </td>
                                            <td class="text-center" style="width: 10%">{{ row.cantidad }}</td>
                                            <td class="text-center" style="width: 15%">{{ row.ubicacion }}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="invoice-detail">
                        <div class="invoice-top text-center mt-3" style="background-color: rgba(222, 222, 222, 0.4);">
                            <h3 class="title"><strong>Repuestos Recibidos</strong></h3>
                        </div>
                        <div class="invoice-item">
                            <textarea class="form-control" id="respuesto_cliente" rows="4" disabled>{{planilla.observacion_repuestos}}</textarea>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Cerrar</button>
                </div>
            </div>
        </div>
    </div>
</form>