<?php

namespace App\Controladores;

use Core\Controller;
use App\Modelos\Tipodocumentos;
use Core\Vista;

final class TipodocumentosControlador extends Controller
{
    private $tipodocumentos;
    private $array_errors = [];

    public function __construct()
    {
        parent::__construct();
        $this->tipodocumentos = new Tipodocumentos();
    }

    public function index()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            return Vista::viewAJAX('tipodocumentos/index');
        }
    }

    public function obtenerTipoDeDocumentos()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            header('Content-Type: application/json', true);
            echo json_encode($this->tipodocumentos->todos());
            exit;
        }
    }

    public function guardar()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($_SESSION['user_data']['emp_id'] == 1) {

                $tipodoc_codigo         = filter_input(INPUT_POST, 'codigo', FILTER_SANITIZE_STRING);
                $tipodoc_descripcion    = filter_input(INPUT_POST, 'descripcion', FILTER_SANITIZE_STRING);
                $tipodoc_predeterminado = filter_input(INPUT_POST, 'predeterminado', FILTER_SANITIZE_NUMBER_INT) ?? 0;

                if (empty($tipodoc_codigo))
                    $this->array_errors[] = "El campo Codigo es obligatorio.";
                if (empty($tipodoc_descripcion))
                    $this->array_errors[] = "El campo Descripción es obligatorio";

                if (empty($this->array_errors)) {

                    if (empty($_POST['id'])) {
                        if ($this->tipodocumentos->where(['tipodoc_codigo' => $tipodoc_codigo], true))
                            $this->array_errors[] = "La codigo $tipodoc_codigo ya se encuentra en uso";
                    } else {
                        $tipodoc_id = filter_var($_POST['id'], FILTER_SANITIZE_NUMBER_INT);
                        if ($this->tipodocumentos->where(['tipodoc_codigo' => $tipodoc_codigo, 'tipodoc_id!=' => $tipodoc_id], true))
                            $this->array_errors[] = "La codigo $tipodoc_codigo ya se encuentra en uso";
                    }

                    if (empty($this->array_errors)) {
                        if (empty($_POST['id'])) {
                            if ($this->tipodocumentos->guardar([
                                'tipodoc_codigo' => $tipodoc_codigo,
                                'tipodoc_descripcion' => $tipodoc_descripcion,
                                'tipodoc_predeterminado' => $tipodoc_predeterminado
                            ], true)) {
                                if ($tipodoc_predeterminado == 1) {
                                    $this->tipodocumentos->modificarTodosLosPredeterminado($tipodoc_id, 0);
                                }
                                header('Content-Type: application/json', true);
                                echo json_encode(true);
                                exit;
                            }
                        } else {
                            if ($this->tipodocumentos->editar($tipodoc_id, [
                                'tipodoc_codigo' => $tipodoc_codigo,
                                'tipodoc_descripcion' => $tipodoc_descripcion,
                                'tipodoc_predeterminado' => $tipodoc_predeterminado
                            ])) {
                                if ($tipodoc_predeterminado == 1) {
                                    $this->tipodocumentos->modificarTodosLosPredeterminado($tipodoc_id, 0);
                                }
                                header('Content-Type: application/json', true);
                                echo json_encode(true);
                                exit;
                            }
                        }
                    }
                }
            } else {
                $this->array_errors[] = 'Usted no es administrador';
            }

            header('Content-Type: application/json', true);
            echo json_encode(['errors' => $this->array_errors]);
            exit;
        }
    }

    public function modificarEstatus(int $id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id = filter_var($id, FILTER_VALIDATE_INT);

            if ($this->tipodocumentos->existe('tipodoc_id', $id)) {
                $estatus = $this->tipodocumentos->obtener($id);
                header('Content-Type: application/json', true);
                echo json_encode($this->tipodocumentos->editar($id, [
                    'tipodoc_predeterminado' => $estatus->tipodoc_predeterminado == 1 ? 0 : 1
                ]));
                exit;
            } else {
                $this->array_errors[] = 'Acción prohibida';
            }

            header('Content-Type: application/json', true);
            echo json_encode(['errors' => $this->array_errors]);
            exit;
        }
    }

    public function eliminar(int $id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id = filter_var($id, FILTER_VALIDATE_INT);

            if ($this->tipodocumentos->existe('tipodoc_id', $id)) {
                if ($this->tipodocumentos->esUsadoPorClientes($id)) {
                    $this->array_errors[] = "Lo siento el Tipo de Documento ya se encuentra asignado a uno o mas clientes";
                } else {
                    header('Content-Type: application/json', true);
                    echo json_encode($this->tipodocumentos->eliminar($id));
                    exit;
                }
            } else {
                $this->array_errors[] = 'Acción prohibida';
            }

            header('Content-Type: application/json', true);
            echo json_encode(['errors' => $this->array_errors]);
            exit;
        }
    }
}
