<form autocomplete="off" @submit.prevent="guardarEditar" id="modal_form_tarifas">
    <div class="modal fade" id="modal_tarifas" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ titulo }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="codigo">Código</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-hashtag fa-fw"></i>
                                        </span>
                                    </div>
                                    <input type="text" id="codigo" class="form-control" maxlength="6" v-model="dataForm.codigo">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-8">
                            <div class="form-group">
                                <label for="nombre">Nombre</label>
                                <input type="text" id="nombre" class="form-control" v-model="dataForm.nombre">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="aplicar">Fórmula a aplicar</label>
                        <select id="aplicar" class="form-control" v-model="dataForm.aplicar">
                            <option value="" disabled>Seleccione un elemento</option>
                            <option value="pvp" selected="">precio - x% - y</option>
                            <option value="pvpiva" selected="">(precio+iva) - (x% - y)</option>
                            <option value="costo">precio de coste + x% + y</option>
                            <option value="costoiva">(precio de coste+iva) + (x% + y)</option>
                        </select>
                    </div>
                    <div class="form-row">
                        <div class="col-md">
                            <div class="form-group">
                                <label for="valorx">Valor X</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-percentage fa-fw"></i>
                                        </span>
                                    </div>
                                    <input type="number" id="valorx" class="form-control" step="any" v-model="dataForm.valorx">
                                </div>
                            </div>
                        </div>
                        <div class="col-md">
                            <div class="form-group">
                                <label for="valory">Valor Y</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-dollar-sign fa-fw"></i>
                                        </span>
                                    </div>
                                    <input type="number" id="valory" class="form-control" step="any" v-model="dataForm.valory">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row ">
                        <div class="col-md-6">
                            <div class="form-check">
                                <label class="form-check-label">
                                    <input class="form-check-input" type="checkbox" id="mincoste" v-model="dataForm.mincoste">
                                    <span class="form-check-sign">No vender por debajo de coste</span>
                                </label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-check">
                                <label class="form-check-label">
                                    <input class="form-check-input" type="checkbox" id="maxpvp" v-model="dataForm.maxpvp">
                                    <span class="form-check-sign">No vender por encima de PVP</span>
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                {{ row }}
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary  btn-sm" data-dismiss="modal">Cerrar</button>
                    <button v-if="cargando" class="btn btn-sm btn-primary" disabled>
                        <i class="loader loader-info"></i>
                    </button>
                    <button v-else type="submit" class="btn btn-primary btn-sm">{{ accion }}</button>
                </div>
            </div>
        </div>
    </div>
</form>