<div class="container" id="appTarifas" v-cloak>
    <div class="page-inner">
        <div class="page-header">
            <h4 class="page-title">Tarifas</h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="<?= ruta_base() ?>">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?= url('tarifas') ?>">Tarifas</a>
                </li>
            </ul>
            <div class="ml-md-auto" style="display: flex;">
                <div class="dropdown d-inline mr-3 mr-md-2">
                    <button class="btn btn-info btn-border btn-round dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        Acciones
                    </button>
                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton" x-placement="top-start" style="position: absolute; transform: translate3d(0px, -7px, 0px); top: 0px; left: 0px; will-change: transform;">
                        <a class="dropdown-item" href="<?= url('productos') ?>">Productos</a>
                        <a class="dropdown-item" href="<?= url('fabricantes') ?>">Fabricantes</a>
                        <a class="dropdown-item" href="<?= url('proveedores') ?>">Proveedores</a>
                        <a class="dropdown-item" href="<?= url('categorias') ?>">Categorias</a>
                        <a class="dropdown-item" href="<?= url('tarifas') ?>">Tarifas</a>
                        <a class="dropdown-item" href="<?= url('almacenes') ?>">Almacenes</a>
                    </div>
                </div>
                <a href="#" class="btn btn-info btn-border btn-round" @click.prevent="modalTarifas"> <span class="fa fa-plus"></span> Nueva tarifa</a>
            </div>
        </div>
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th class="text-left">#</th>
                                <th class="text-left">Código</th>
                                <th class="text-left">Nombre</th>
                                <th>Formula</th>
                                <th>Valor x</th>
                                <th>Valor y</th>
                                <th title="Visible en producto">Visible en Pro.</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="row in tarifas">
                                <td class="text-left">{{ row.tar_id }}</td>
                                <td class="text-left">{{ row.tar_codigo }}</a></td>
                                <td class="text-left">{{ row.tar_nombre }}</td>
                                <td>{{ row.tar_aplicar }}</td>
                                <td>{{ row.tar_valorx }}</td>
                                <td>{{ row.tar_valory }}</td>
                                <td>
                                    <div class="form-button-action">
                                        <button type="button" title="Editar" class="btn btn-link btn-primary" @click="visible(row.tar_id, 'estatus'+row.tar_id,row.tar_visible)">
                                            <i :class="row.tar_visible == 1 ? 'fa fa-eye' : 'fa fa-eye-slash'" :id="'estatus'+row.tar_id"></i>
                                        </button>
                                    </div>
                                </td>
                                <td>
                                    <div class="form-button-action">
                                        <button type="button" title="Editar" class="btn btn-link btn-primary" @click="ver(row.tar_id, row.tar_codigo, row.tar_aplicar, row.tar_maxpvp, row.tar_mincoste, row.tar_nombre, row.tar_valorx, row.tar_valory)">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                        <button type="button" title="Eliminar" class="btn btn-link btn-danger" @click="eliminar(row.tar_id, row.tar_nombre)">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <?php include 'modaleditarguardar.php' ?>
</div>
<script src="<?= ruta_base() ?>public/assetsvuejs/tarifas/tarifas.js"></script>
