<?php

namespace App\Controladores;

use App\Modelos\Sucursal;
use Core\Controller;
use Core\Librerias\Http;
use Core\Vista;

final class SucursalesControlador extends Controller
{
    private $sucursal;
    private $array_errors = [];

    public function __construct()
    {
        parent::__construct();
        $this->sucursal = new Sucursal();
    }

    public function index()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            return Vista::viewAJAX('sucursales/index');
        }
    }

    public function obtenerSucursales()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            Http::json_response($this->sucursal->todos());
        }
    }

    public function guardar()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($_SESSION['user_data']['emp_id'] == 1) {

                $su_id              = filter_input(INPUT_POST, 'idsu', FILTER_SANITIZE_STRING);
                $su_nombre          = filter_input(INPUT_POST, 'nsu', FILTER_SANITIZE_STRING);
                $su_direccion       = filter_input(INPUT_POST, 'dsu', FILTER_SANITIZE_STRING);
                $su_telefono        = filter_input(INPUT_POST, 'tsu', FILTER_SANITIZE_STRING);
                $su_email           = filter_input(INPUT_POST, 'csu', FILTER_SANITIZE_EMAIL);
                $su_timezone        = filter_input(INPUT_POST, 'zsu', FILTER_SANITIZE_NUMBER_INT);
                $su_empresa_dni     = filter_input(INPUT_POST, 'dnisu', FILTER_SANITIZE_STRIPPED);
                $su_sitio_web       = filter_input(INPUT_POST, 'swsu', FILTER_SANITIZE_URL);

                if (empty($su_nombre))
                    $this->array_errors[] = "El campo Nombre es requerido";
                if (empty($su_direccion))
                    $this->array_errors[] = "El campo Direccion es requerido";
                if (empty($su_telefono))
                    $this->array_errors[] = "El campo Telefono es requerido";
                if (empty($su_email))
                    $this->array_errors[] = "El campo Email es requerido";
                if (empty($su_timezone))
                    $this->array_errors[] = "El campo Zona es requerido";
                if (empty($su_empresa_dni))
                    $this->array_errors[] = "El campo DNI es requerido";

                if (empty($this->array_errors)) {

                    //if (valida_email($su_email) == false)
                    //array_push($this->array_errors, "El correo $su_email no es correcto");

                    if (empty($su_id)) {

                        if ($this->sucursal->existe('su_nombre', $su_nombre))
                            $this->array_errors[] = "El nombre de la sucursal $su_nombre ya se encuentra en uso.";
                       // if ($this->sucursal->existe('su_telefono', $su_telefono))
                       //     $this->array_errors[] = "El telefono $su_telefono ya se encuentra en uso.";
                      ///  if ($this->sucursal->existe('su_empresa_dni', $su_empresa_dni))
                       //     $this->array_errors[] = "El documento de identidad $su_empresa_dni ya se encuentra en uso.";
                    } else {

                        if ($this->sucursal->comprobarSucursalesDiferente("su_id!=$su_id and su_nombre='$su_nombre'"))
                            $this->array_errors[] = "El nombre de la sucursal $su_nombre ya se encuentra en uso";
                       // if ($this->sucursal->comprobarSucursalesDiferente("su_id!=$su_id and su_telefono='$su_telefono'"))
                       //     $this->array_errors[] = "El telefono $su_telefono ya se encuentra en uso";
                      //  if ($this->sucursal->comprobarSucursalesDiferente("su_id!=$su_id and su_empresa_dni='$su_empresa_dni'"))
                       //     $this->array_errors[] = "El documento de identidad $su_empresa_dni ya se encuentra en uso";
                    }

                    if (empty($this->array_errors)) {

                        $data_form = [
                            'su_nombre'         => $su_nombre,
                            'su_direccion'      => $su_direccion,
                            'su_telefono'       => $su_telefono,
                            'su_email'          => $su_email,
                            'su_timezone'       => $su_timezone,
                            'su_empresa_dni'    => $su_empresa_dni,
                            'su_sitio_web'      => $su_sitio_web,
                        ];

                        if (empty($su_id)) {
                            Http::json_response($this->sucursal->guardar($data_form, true));
                        } else {
                            if ($this->sucursal->existe('su_id', $su_id)) {
                                Http::json_response($this->sucursal->editar($su_id, $data_form));
                            } else {
                                $this->array_errors[] = "Sucursal no encontrada.";
                            }
                        }
                    }
                }

                Http::json_response([
                    'errors' => $this->array_errors
                ]);
            } else {
                Http::json_response([
                    'errors' => ['Usted no es administrador']
                ]);
            }
        }
    }

    public function eliminarSucursal($id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id = filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT);

            if ($this->sucursal->existe('su_id', $id)) {
                if ($this->sucursal->chequerForanea($id)) {
                    $this->array_errors[] = "La sucursal no se puede eliminar ya que se cuentra relacionada con alguna serie.";
                } else {
                    Http::json_response($this->sucursal->eliminar($id));
                }
            } else {
                Http::json_response(false);
            }

            Http::json_response([
                'errors' => $this->array_errors
            ]);
        }
    }
}
