<div class="container" id="appStockTransferencia" v-cloak>
    <div class="page-inner">
        <div class="page-header">
            <h4 class="page-title">Stock</h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="<?= ruta_base() ?>">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?= url('stock/transferencia_stock') ?>">Transferencia de stock</a>
                </li>
            </ul>
            <div class="ml-md-auto py-2 py-md-0">
                <a href="<?= url('productos'); ?>" class="btn btn-primary btn-sm btn-border btn-round mr-2">Productos</a>
            </div>
        </div>
        <form id="form_stock_transferencia" autocomplete="off" @submit.prevent="guardar">
            <div class="card">
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="ptr_almorigid">Almacén de orígen</label>
                                <select id="ptr_almorigid" class="form-control" v-model="dataForm.alm_origen" @change="obtenerProductos">
                                    <option value="">Seleccione un almacen</option>
                                    <?php foreach ($almacenes_origen as $almacen) : ?>
                                        <option value="<?= $almacen['alm_id']; ?>"><?= $almacen['alm_nombre']; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="ptr_almdestid">Almacén de destino</label>
                                <select id="ptr_almdestid" class="form-control" v-model="dataForm.alm_destino">
                                    <option value="">Seleccione un almacen</option>
                                    <?php foreach ($almacenes as $almacen) : ?>
                                        <option value="<?= $almacen['alm_id']; ?>"><?= $almacen['alm_nombre']; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="productos">Productos</label>
                                <v-select id="productos" v-model="dataForm.producto" :options="optionsProductos" :reduce="row => row.pro_id" label="pro_descripcion" />
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="cantidad">Cantidad</label>
                                <input type="number" min="1" id="cantidad" class="form-control" v-model="dataForm.cantidad">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="observaciones">Observaciones</label>
                        <textarea id="observaciones" class="form-control" v-model="dataForm.observaciones"></textarea>
                    </div>
                    <div class="form-row">
                        <div class="col-sm-4">
                            <div class="form-group">
                                <label for="fecha">Fecha</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-calendar-alt fa-fw"></i>
                                        </span>
                                    </div>
                                    <input type="date" id="fecha" value="<?= date('Y-m-d'); ?>" class="form-control" disabled>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group">
                                <label for="hora">Hora</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-clock"></i>
                                        </span>
                                    </div>
                                    <input type="time" id="hora" value="<?= date('H:i'); ?>" class="form-control" disabled>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group">
                                <label for="usuario">Usuario</label>
                                <input type="text" id="usuario" value="<?= $_SESSION['user_data']['einfo_nombres'] . ' ' . $_SESSION['user_data']['einfo_apellidos']; ?>" class="form-control" disabled>
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-12">
                            <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                {{ row }}
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col text-right">
                            <button class="btn btn-sm btn-secondary" type="reset">
                                <i class="fas fa-undo fa-fw" aria-hidden="true"></i>
                                <span class="d-none d-sm-inline-block">Deshacer</span>
                            </button>
                            <button v-if="cargando" class="btn btn-sm btn-primary" disabled>
                                <i class="loader loader-info"></i>
                            </button>
                            <button v-else class="btn btn-sm btn-primary" type="submit">
                                <i class="fas fa-save fa-fw" aria-hidden="true"></i>
                                <span class="d-none d-sm-inline-block">Guardar</span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
        <div class="card card-invoice" v-if="dataForm.ptr_id">
            <div class="card-header">
                <div class="row">
                    <div class="col-sm-6">
                        <h1 class="invoice-title">
                            TRANSFERENCIA DE STOCK
                        </h1>
                    </div>
                    <div class="col-sm-6">
                        <button v-if="cargando" class="pull-right btn btn-warning" disabled>
                            <i class="loader loader-info"></i>
                        </button>
                        <div v-else>
                            <button @click.prevent="procesarTransferencia" class="pull-right btn btn-warning">
                                <i class="fas fa-save fa-fw" aria-hidden="true"></i>
                                <span class="d-none d-sm-inline-block">Guardar</span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="separator-solid"></div>
                <div class="row">
                    <div class="col-md-4 info-invoice">
                        <h5 class="sub">Fecha</h5>
                        <p>{{ transferencia_detalle.ptr_creado }}</p>
                    </div>
                    <div class="col-md-4 info-invoice">
                        <h5 class="sub">Movimiento</h5>
                        <p>#{{ transferencia_detalle.ptr_id }}</p>
                    </div>
                    <div class="col-md-4 info-invoice">
                        <h5 class="sub">Procesado por</h5>
                        <p>
                            {{ transferencia_detalle.einfo_nombres }} {{ transferencia_detalle.einfo_apellidos }}
                            <br>
                        </p>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="invoice-detail">
                            <div class="invoice-top">
                                <h3 class="title"><strong>Listado de productos</strong></h3>
                            </div>
                            <div class="invoice-item">
                                <div class="table-responsive">
                                    <table class="table table-striped">
                                        <thead>
                                            <tr>
                                                <td><strong>N°</strong></td>
                                                <td class="text-left"><strong>Código</strong></td>
                                                <td class="text-center"><strong>Cantidad</strong></td>
                                                <td class="text-left"><strong>Producto</strong></td>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr v-for="row in transferencia_producto_detalle">
                                                <td>{{ row.ptd_id }}</td>
                                                <td>{{ row.pro_codigo }}</td>
                                                <td class="text-center">{{ row.ptd_cantidad }}</td>
                                                <td class="text-left">{{ row.pro_descripcion }}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="separator-solid  mb-3"></div>
                    </div>
                </div>
            </div>
            <div class="card-footer">
                <div class="row">
                    <div class="col-sm-7 col-md-5 mb-3 mb-md-0 transfer-to">
                        <h5 class="sub">Ubicación del producto</h5>
                        <div class="account-transfer">
                            <div>
                                <span>Almacén origen:</span>
                                <span>{{ transferencia_detalle.origen }}</span>
                            </div>
                            <div>
                                <span>Almacén Destino:</span>
                                <span>{{ transferencia_detalle.destino }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-5 col-md-7 transfer-total">
                        <h5 class="sub">Total de productos</h5>
                        <div class="price">{{ transferencia_producto_detalle.length }}</div>
                    </div>
                </div>
                <div class="separator-solid"></div>
                <h6 class="text-uppercase mt-4 mb-3 fw-bold">
                    Observaciones
                </h6>
                <p class="text-muted mb-0">
                    {{ transferencia_detalle.ptr_observacion }}
                </p>
            </div>
        </div>
    </div>
</div>
<script src="<?= asset('assets/vue-select.js') ?>"></script>
<link rel="stylesheet" href="<?= asset('assets/vue-select.css') ?>">
<script src="<?= asset('assetsvuejs/stock/stock_transferencia.js') ?>"></script>
